/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ConverterArchive {
    private static final String TEMPFILE = "gsstemp.zip";
    private String m_izipName;
    private FileOutputStream m_ifStream = null;
    private ZipOutputStream m_izStream = null;
    private InputStream m_riStream = null;
    private ZipFile m_rzipFile = null;

    public void openArchiveforInsert(String string) {
        this.m_izipName = string;
        try {
            this.m_ifStream = new FileOutputStream(this.m_izipName);
            this.m_izStream = new ZipOutputStream(this.m_ifStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeArchiveforInsert() {
        try {
            this.m_izStream.close();
            this.m_ifStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void insertObj(Object object, String string) {
        ZipEntry zipEntry = null;
        ObjectOutputStream objectOutputStream = null;
        zipEntry = new ZipEntry(string);
        try {
            this.m_izStream.putNextEntry(zipEntry);
            objectOutputStream = new ObjectOutputStream(this.m_izStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            this.m_izStream.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object readObj(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        ObjectInputStream objectInputStream = null;
        ZipEntry zipEntry = null;
        Object object = null;
        try {
            fileInputStream = new FileInputStream(string);
            zipInputStream = new ZipInputStream(fileInputStream);
            while (zipInputStream.available() != 0) {
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null || !zipEntry.getName().equals(string2)) continue;
                objectInputStream = new ObjectInputStream(zipInputStream);
                object = objectInputStream.readObject();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException.getMessage());
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
            throw new IOException(streamCorruptedException.getMessage());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        return object;
    }

    public void removeObj(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        ZipEntry zipEntry = null;
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        File file = new File(string);
        if (file.isFile()) {
            try {
                fileInputStream = new FileInputStream(string);
                zipInputStream = new ZipInputStream(fileInputStream);
                fileOutputStream = new FileOutputStream(TEMPFILE);
                zipOutputStream = new ZipOutputStream(fileOutputStream);
                int n = zipInputStream.available();
                while (zipInputStream.available() != 0) {
                    zipEntry = zipInputStream.getNextEntry();
                    if (zipEntry == null || zipEntry.getName().equals(string2)) continue;
                    zipOutputStream.putNextEntry(zipEntry);
                    objectInputStream = new ObjectInputStream(zipInputStream);
                    objectOutputStream = new ObjectOutputStream(zipOutputStream);
                    Object object = objectInputStream.readObject();
                    objectOutputStream.writeObject(object);
                }
                zipOutputStream.close();
                zipInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(fileNotFoundException.getMessage());
            }
            catch (StreamCorruptedException streamCorruptedException) {
                throw new IOException(streamCorruptedException.getMessage());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
            File file2 = new File(TEMPFILE);
            file.delete();
            try {
                if (!file2.renameTo(file)) {
                    throw new IOException("can't write to target file " + string);
                }
            }
            catch (SecurityException securityException) {
                throw new IOException(securityException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException(nullPointerException.getMessage());
            }
        }
        if (string2.endsWith(".glb")) {
            System.out.print(string2 + " has been successfully removed from ");
            System.out.println(string);
        }
    }

    public void insertSingleObj(String string, Object object, String string2) throws IOException {
        block16: {
            FileInputStream fileInputStream = null;
            ZipInputStream zipInputStream = null;
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            ZipEntry zipEntry = null;
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            File file = new File(string);
            if (file.isFile()) {
                try {
                    fileInputStream = new FileInputStream(string);
                    zipInputStream = new ZipInputStream(fileInputStream);
                    fileOutputStream = new FileOutputStream(TEMPFILE);
                    zipOutputStream = new ZipOutputStream(fileOutputStream);
                    int n = zipInputStream.available();
                    while (zipInputStream.available() != 0) {
                        zipEntry = zipInputStream.getNextEntry();
                        if (zipEntry == null || zipEntry.getName().equals(string2)) continue;
                        zipOutputStream.putNextEntry(zipEntry);
                        objectInputStream = new ObjectInputStream(zipInputStream);
                        objectOutputStream = new ObjectOutputStream(zipOutputStream);
                        Object object2 = objectInputStream.readObject();
                        objectOutputStream.writeObject(object2);
                    }
                    zipEntry = new ZipEntry(string2);
                    zipOutputStream.putNextEntry(zipEntry);
                    objectOutputStream = new ObjectOutputStream(zipOutputStream);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                    zipInputStream.close();
                    zipOutputStream.close();
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException(fileNotFoundException.getMessage());
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    throw new IOException(streamCorruptedException.getMessage());
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException.getMessage());
                }
                File file2 = new File(TEMPFILE);
                try {
                    if (!this.copyFile(file2, file)) {
                        throw new IOException("can't write to target file " + string);
                    }
                    break block16;
                }
                catch (SecurityException securityException) {
                    throw new IOException(securityException.getMessage());
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException(nullPointerException.getMessage());
                }
            }
            try {
                fileOutputStream = new FileOutputStream(string);
                zipOutputStream = new ZipOutputStream(fileOutputStream);
                zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                objectOutputStream = new ObjectOutputStream(zipOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(fileNotFoundException.getMessage());
            }
            catch (StreamCorruptedException streamCorruptedException) {
                throw new IOException(streamCorruptedException.getMessage());
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        if (string2.endsWith(".glb")) {
            System.out.print(string2 + " has been successfully stored in ");
            System.out.println(string);
        }
    }

    public boolean copyFile(File file, File file2) {
        if (!file.canRead() || !file2.canWrite()) {
            return false;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[2048];
            int n = bufferedInputStream.read(byArray, 0, byArray.length);
            while (n != -1) {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, byArray.length);
            }
            bufferedOutputStream.flush();
            bufferedInputStream.close();
            bufferedOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void insertObjtoFile(String string, String string2, Object object) throws IOException {
        File file = new File(string);
        File file2 = new File(string + string2);
        if (!file.isDirectory()) {
            throw new IOException("directory " + string + " doesn't exist");
        }
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (SecurityException securityException) {
                throw new IOException("file exist, can't overwrite file.");
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("file can't be created.");
        }
        System.out.print(string2 + " has been successfully stored in ");
        System.out.println(string);
    }

    public void openArchiveforRead() {
        try {
            this.m_rzipFile = new ZipFile(this.m_izipName);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    public void closeArchiveforRead() {
        try {
            this.m_rzipFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }
}

