/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.i18n.util.builder.NLTParser;
import oracle.i18n.util.builder.NLTParserException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CharSetParser
extends NLTParser {
    private static final Map m_cache = new HashMap();
    private static final Map m_cacheCharacterData = new HashMap();
    private final String m_file;

    private CharSetParser(String string) throws NLTParserException {
        super(string);
        this.m_file = string;
        this.topNode = CharSetParser.findNode(this.topNode, "CHARACTER_SET");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern CHARACTER_SET not found!");
        }
    }

    public static synchronized CharSetParser getInstance(String string) throws NLTParserException {
        CharSetParser charSetParser = (CharSetParser)m_cache.get(string);
        if (charSetParser != null) {
            return charSetParser;
        }
        charSetParser = new CharSetParser(string);
        m_cache.put(string, charSetParser);
        return charSetParser;
    }

    private static synchronized Vector getCharacterDataFromCache(CharSetParser charSetParser) throws NLTParserException {
        Vector vector = (Vector)m_cacheCharacterData.get(charSetParser.m_file);
        if (vector != null) {
            return vector;
        }
        vector = charSetParser.getPBlockVector("character_data");
        m_cacheCharacterData.put(charSetParser.m_file, vector);
        return vector;
    }

    public static synchronized void cleanCache() {
        m_cache.clear();
        m_cacheCharacterData.clear();
    }

    public String getVERSION() {
        return this.getStringValue("VERSION");
    }

    public String getName() {
        return this.getStringValue("Name");
    }

    public String getId() {
        return this.getStringValue("Id");
    }

    public String getIsoCharset() {
        return this.getStringValue("iso_charset");
    }

    public String getFlags() {
        return this.getStringValue("flags");
    }

    public Vector getCharacterData() throws NLTParserException {
        return CharSetParser.getCharacterDataFromCache(this);
    }

    public Vector getReplacementChars() throws NLTParserException {
        return this.getPBlockVector("replacement_chars");
    }

    public boolean haveExtraUnicodeMapping() {
        Node node = CharSetParser.findNode(this.topNode, "replacement_chars");
        return node != null;
    }

    public Vector getLowerCase() throws NLTParserException {
        return this.getPBlockVector("lowercase");
    }

    public Vector getUpperCase() throws NLTParserException {
        return this.getPBlockVector("uppercase");
    }

    public Vector getClassification() throws NLTParserException {
        return this.getPBlockVector("classification");
    }

    public Vector getExtendedClassification() throws NLTParserException {
        return this.getPBlockVector("extended_classification");
    }

    public Vector getUnicodeProperty() throws NLTParserException {
        return this.getPBlockVector("Unicode_property");
    }

    public Vector getDisplayWidth() throws NLTParserException {
        return this.getPBlockVector("display_width");
    }

    public Vector getCombiningClass() throws NLTParserException {
        return this.getPBlockVector("canonical_combining_class");
    }

    public String getDefaultReplacementChar() {
        return this.getStringValue("default_replacement_char");
    }

    public String getDefaultMultibyteReplacementChar() {
        return this.getStringValue("default_multibyte_replacement_char");
    }

    public Vector getDecomposition() throws NLTParserException {
        return this.getPBlockVector("decomposition");
    }

    public String getBaseCharSet() {
        return this.getStringValue("base_char_set");
    }

    public Vector[] getLigature() throws NLTParserException {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        Node node = CharSetParser.findNode(this.topNode, "ligature");
        if (node == null) {
            return vectorArray;
        }
        NodeList[] nodeListArray = new NodeList[]{CharSetParser.findNodes(node, "first"), CharSetParser.findNodes(node, "second"), CharSetParser.findNodes(node, "char")};
        int n = nodeListArray[0].getLength();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < n; ++j) {
                Node node2 = nodeListArray[i].item(j).getFirstChild();
                String string = node2.getNodeValue();
                string = "00" + string.substring(2);
                vectorArray[i].addElement(string);
            }
        }
        return vectorArray;
    }

    public Vector[] getShapetable() throws NLTParserException {
        int n;
        Vector[] vectorArray = new Vector[4];
        for (n = 0; n < 4; ++n) {
            vectorArray[n] = new Vector();
        }
        Node node = CharSetParser.findNode(this.topNode, "shape_table");
        if (node == null) {
            return vectorArray;
        }
        Node[] nodeArray = new Node[]{CharSetParser.findNode(node, "initial"), CharSetParser.findNode(node, "medial"), CharSetParser.findNode(node, "final"), CharSetParser.findNode(node, "stand_alone")};
        for (int i = 0; i < 4; ++i) {
            NodeList nodeList = CharSetParser.findNodes(nodeArray[i], "char");
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = nodeList.item(n).getFirstChild();
                String string = "00" + node2.getNodeValue().substring(2);
                vectorArray[i].addElement(string);
            }
        }
        return vectorArray;
    }
}

