/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.i18n.text.OraBoot;
import oracle.i18n.util.builder.BootBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.LanguageParser;
import oracle.i18n.util.builder.LinguisticParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.TerritoryParser;

public class CharDataTypeParser {
    private static Map charSetMetaData = new HashMap();
    private static final int m_cntCharsetMaxCharLen;
    static final String MAX_CHAR_LEN = "MAX_CHAR_LEN";
    static final String CHARSET_TYPE = "CHARSET_TYPE";
    static final String FLAGS = "FLAGS";
    static final String ASCII = "ASCII";
    static final String EBCDIC = "EBCDIC";
    static final String DISPLAY = "DISPLAY";
    static final String SHIFT = "SHIFT";
    static final String FIXED = "FIXED";
    static final String[] SHIFT_CHARSETS;
    private long HIGHBYTEMASK = -65536L;
    private int MAXLEADCODE = 4;
    private char[] LeadCode = new char[this.MAXLEADCODE];
    private int maxByte;
    private boolean isEBCDICBASED;
    private boolean isASCIIBASED;
    private boolean isFIXEDWIDTH;
    private boolean isSHIFT;
    private boolean isUNICODE;
    private boolean isSPECIALRANGE;
    public int baseCharID;
    public int typeID;

    public CharDataTypeParser() {
    }

    public CharDataTypeParser(String string) throws NLTParserException {
        String string2;
        this.maxByte = 0;
        this.isEBCDICBASED = false;
        this.isASCIIBASED = false;
        this.isFIXEDWIDTH = false;
        this.isSHIFT = false;
        this.isUNICODE = false;
        this.isSPECIALRANGE = false;
        this.typeID = -1;
        this.baseCharID = -1;
        for (int i = 0; i < this.MAXLEADCODE; ++i) {
            this.LeadCode[i] = '\u0000';
        }
        CharSetParser charSetParser = CharSetParser.getInstance(string);
        String string3 = charSetParser.getName().toUpperCase(Locale.US);
        String string4 = charSetParser.getId();
        if (string3.endsWith("ZHS16GBK")) {
            this.typeID = 13;
            return;
        }
        if (string3.endsWith("GB18030")) {
            this.typeID = 9;
            return;
        }
        if (string3.equals("ISO2022-JP-OUTLOOK")) {
            this.typeID = 11;
            return;
        }
        if (string3.equals("ISO2022-JP-OUTLOOK-HWKANA")) {
            this.typeID = 12;
            return;
        }
        if (string3.equals("AL16UTF16")) {
            this.typeID = 10;
            return;
        }
        String string5 = charSetParser.getBaseCharSet();
        CharSetParser charSetParser2 = null;
        boolean bl = true;
        if (string5 != null) {
            this.baseCharID = Integer.parseInt(string5);
            charSetParser2 = charSetParser;
            string2 = BootBuilder.formatFileName("lx2", string5);
            try {
                charSetParser = CharSetParser.getInstance(string2 + ".nlt");
            }
            catch (Exception exception) {
                bl = false;
                charSetParser = charSetParser2;
                charSetParser2 = null;
            }
        } else {
            this.baseCharID = -1;
        }
        this.maxByte = this.getMaxCharLength(charSetParser, charSetParser2);
        string2 = null;
        if (bl) {
            string2 = charSetParser.getFlags();
        } else {
            string2 = this.getBaseCharFlags(string5);
            this.maxByte = Math.max(this.maxByte, this.getBaseCharMaxByte(string5));
        }
        if (string2 != null) {
            if ((string2 = string2.toUpperCase(Locale.US)).indexOf(ASCII) != -1) {
                this.isASCIIBASED = true;
            } else if (string2.indexOf(EBCDIC) != -1) {
                this.isEBCDICBASED = true;
            }
            if (string2.indexOf(FIXED) != -1) {
                this.isFIXEDWIDTH = true;
            }
            if (string2.indexOf(SHIFT) != -1) {
                this.isSHIFT = true;
            }
        }
        CharDataTypeParser.registerIdtoMaxCharLen(string4, Integer.toString(this.maxByte | (this.isFIXEDWIDTH ? 256 : 0)));
        CharDataTypeParser.registerIdtoFlags(string4, string2);
        switch (this.maxByte) {
            case 1: {
                this.typeID = 0;
                return;
            }
            case 2: {
                this.typeID = this.isSHIFT ? 7 : (this.isFIXEDWIDTH ? 6 : (this.isSPECIALRANGE ? 4 : 1));
                return;
            }
            case 3: {
                if (!this.isFIXEDWIDTH) {
                    this.typeID = 2;
                }
                return;
            }
            case 4: {
                this.typeID = this.isFIXEDWIDTH ? 3 : 5;
                return;
            }
        }
        throw new NLTParserException("Ginstall can not support character sets with characters longer than 4 bytes");
    }

    private String getBaseCharFlags(String string) {
        OraBoot oraBoot = OraBoot.getInstance();
        if (oraBoot == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < SHIFT_CHARSETS.length; ++i) {
            if (!SHIFT_CHARSETS[i].equals(string)) continue;
            stringBuffer.append(SHIFT);
            stringBuffer.append(";");
        }
        List list = oraBoot.getCharSetIsAscii();
        if (oraBoot.getCharSetIsAscii().contains(oraBoot.getCharSetName(string))) {
            stringBuffer.append(ASCII);
            stringBuffer.append(";");
        } else if (oraBoot.getCharSetIsEbcdic().contains(oraBoot.getCharSetName(string))) {
            stringBuffer.append(EBCDIC);
            stringBuffer.append(";");
        } else if (oraBoot.getCharSetIsFixed().contains(oraBoot.getCharSetName(string))) {
            stringBuffer.append(FIXED);
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    private int getBaseCharMaxByte(String string) {
        OraBoot oraBoot = OraBoot.getInstance();
        if (oraBoot == null) {
            return 0;
        }
        String string2 = oraBoot.getCharsetMaxCharLen(string);
        return Integer.parseInt(string2);
    }

    public Properties getMetadata(String string) throws NLTParserException {
        File file = new File(string);
        String string2 = file.getName().toUpperCase(Locale.US);
        Properties properties = null;
        if (string2.startsWith("LX2")) {
            properties = this.getCharsetMetadata(string);
        } else if (string2.startsWith("LX0")) {
            properties = this.getLanguageMetadata(string);
        } else if (string2.startsWith("LX3")) {
            properties = this.getLinguisticMetadata(string);
        } else if (string2.startsWith("LX1")) {
            properties = this.getTerritoryMetadata(string);
        }
        return properties;
    }

    private Properties getLinguisticMetadata(String string) throws NLTParserException {
        Properties properties = new Properties();
        LinguisticParser linguisticParser = new LinguisticParser(string);
        properties.setProperty(linguisticParser.getId(), linguisticParser.getName());
        return properties;
    }

    private Properties getTerritoryMetadata(String string) throws NLTParserException {
        Properties properties = new Properties();
        TerritoryParser territoryParser = new TerritoryParser(string);
        properties.setProperty(territoryParser.getId(), territoryParser.getName());
        return properties;
    }

    private Properties getLanguageMetadata(String string) throws NLTParserException {
        Properties properties = new Properties();
        LanguageParser languageParser = new LanguageParser(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(languageParser.getName());
        stringBuffer.append(";");
        stringBuffer.append(languageParser.getISOAbbreviation());
        stringBuffer.append(";");
        stringBuffer.append(languageParser.getDefaultTerritoryId());
        stringBuffer.append(";");
        stringBuffer.append(this.formatLangMetadata(languageParser.getCommonCharsets()));
        stringBuffer.append(";");
        stringBuffer.append(this.formatLangMetadata(languageParser.getCommonCharsetsWin()));
        stringBuffer.append(";");
        stringBuffer.append(this.formatLangMetadata(languageParser.getCommonLinguisticSorts()));
        properties.put(languageParser.getId(), stringBuffer.toString());
        return properties;
    }

    private String formatLangMetadata(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private Properties getCharsetMetadata(String string) throws NLTParserException {
        int n = 0;
        int n2 = 0;
        CharSetParser charSetParser = CharSetParser.getInstance(string);
        String string2 = charSetParser.getName().toUpperCase(Locale.US);
        String string3 = charSetParser.getId();
        n = this.getMaxCharLength(charSetParser, null);
        String string4 = charSetParser.getFlags();
        if (string4 != null) {
            if ((string4 = string4.toUpperCase(Locale.US)).indexOf(ASCII) != -1) {
                n2 = 16;
            } else if (string4.indexOf(EBCDIC) != -1) {
                n2 = 1;
            }
            if (string4.indexOf(FIXED) != -1) {
                n2 = 256;
                n = 0x100 | n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(";");
        stringBuffer.append(n);
        stringBuffer.append(";");
        stringBuffer.append(n2);
        Properties properties = new Properties();
        properties.setProperty(string3, stringBuffer.toString());
        return properties;
    }

    private int getMaxCharLength(CharSetParser charSetParser, CharSetParser charSetParser2) throws NLTParserException {
        int n;
        int n2;
        Vector vector = charSetParser.getCharacterData();
        if (charSetParser2 != null) {
            Vector vector2 = charSetParser2.getCharacterData();
            int n3 = vector2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                Object e = vector2.elementAt(n2);
                Object[] objectArray = (Object[])e;
                n = ((int[])objectArray[0])[0];
                int n5 = vector.size();
                boolean bl = false;
                for (n4 = 0; n4 < n5; ++n4) {
                    Object[] objectArray2 = (Object[])vector.elementAt(n4);
                    int n6 = ((int[])objectArray2[0])[0];
                    if (n != n6) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector.remove(n4);
                    vector.add(n4, e);
                    continue;
                }
                vector.add(e);
            }
        }
        n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            int n7 = ((int[])objectArray[0])[0];
            char c = (char)(((long)n7 & this.HIGHBYTEMASK) >> 16);
            if (n7 > 65535) {
                for (n = 0; n < this.MAXLEADCODE; ++n) {
                    if (this.LeadCode[n] == '\u0000') {
                        this.LeadCode[n] = c;
                        break;
                    }
                    if (this.LeadCode[n] == c) break;
                }
                if (n >= this.MAXLEADCODE) {
                    throw new NLTParserException("Ginstall can not support character sets with more than 4 lead codes.");
                }
            }
            if (((long)n7 & 0xFFFFFFFFL) > 0xFFFFFFL) {
                this.maxByte = Math.max(this.maxByte, 4);
                continue;
            }
            if (n7 > 65535) {
                this.maxByte = Math.max(this.maxByte, 3);
                continue;
            }
            if (n7 > 255) {
                this.maxByte = Math.max(this.maxByte, 2);
                continue;
            }
            this.maxByte = Math.max(this.maxByte, 1);
            if (n7 <= 127) continue;
            this.isSPECIALRANGE = true;
        }
        return this.maxByte;
    }

    static final int addKnownMaxCharLen(Map map) {
        int n = 0;
        map.put("870", "3");
        ++n;
        map.put("871", "3");
        ++n;
        map.put("872", "4");
        ++n;
        map.put("873", "4");
        ++n;
        map.put("2000", Integer.toString(258));
        ++n;
        map.put("854", Integer.toString(260));
        return ++n;
    }

    static final void addKnownFlags(Map map) {
        map.put("871", "ASCII_BASED");
        map.put("872", "EBCDIC_BASED");
        map.put("873", "ASCII_BASED");
        map.put("2000", "UNICODE,FIXED_WIDTH");
        map.put("854", "ASCII_BASED");
        map.put("852", "ASCII_BASED");
    }

    static synchronized void registerIdtoFlags(String string, String string2) {
        Map map = (Map)charSetMetaData.get(FLAGS);
        map.put(string, string2 != null ? string2.toUpperCase(Locale.US) : null);
    }

    static synchronized void registerIdtoMaxCharLen(String string, String string2) {
        Map map = (Map)charSetMetaData.get(MAX_CHAR_LEN);
        map.put(string, string2);
    }

    static synchronized Map readCharSetMetaData(String string) {
        Map map = (Map)charSetMetaData.get(MAX_CHAR_LEN);
        if (map.size() == m_cntCharsetMaxCharLen) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                charSetMetaData = (Map)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage());
            }
        }
        return charSetMetaData;
    }

    static synchronized void writeCharSetMetaData(String string) {
        Map map = (Map)charSetMetaData.get(MAX_CHAR_LEN);
        if (map.size() > m_cntCharsetMaxCharLen) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(charSetMetaData);
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage());
            }
        }
    }

    static {
        SHIFT_CHARSETS = new String[]{"833", "835", "842", "853", "864", "996", "998"};
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        m_cntCharsetMaxCharLen = CharDataTypeParser.addKnownMaxCharLen(hashMap);
        CharDataTypeParser.addKnownFlags(hashMap2);
        charSetMetaData.put(MAX_CHAR_LEN, hashMap);
        charSetMetaData.put(FLAGS, hashMap2);
    }
}

