/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;

public class CharConvLCBuilder
extends CharConvBuilder {
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    static final int m_l1BlockSize = 256;
    final long m_maxCharValue;
    final CharacterConverterLC m_charConvLCObj;

    protected CharConvLCBuilder(CharacterConverter characterConverter, long l) {
        super(characterConverter);
        this.m_charConvLCObj = (CharacterConverterLC)this.m_charConvObj;
        this.m_maxCharValue = l;
    }

    void buildGLB(CharacterConverter characterConverter, String string, String string2, String string3, boolean bl) throws IOException, NLTParserException {
        CharSetParser charSetParser = CharSetParser.getInstance(string3);
        String string4 = charSetParser.getName();
        this.m_charConvLCObj.m_oracleId = Integer.parseInt(charSetParser.getId());
        this.m_charConvLCObj.m_ucsCharReplacement = 65533;
        this.setReplacementCharacters(charSetParser);
        this.validateIdName(string4, this.m_charConvLCObj.m_oracleId);
        boolean bl2 = charSetParser.haveExtraUnicodeMapping();
        String string5 = CharConvLCBuilder.formatCharConvClassName(this.m_charConvLCObj.m_oracleId);
        this.resetReplacementCharacters(characterConverter);
        this.setUcsChar(charSetParser, characterConverter);
        this.setExtraUnicodeMapping(charSetParser, characterConverter);
        this.setDisplayWidthTable(charSetParser);
        this.writeGLBFile(string, string2, string5, bl);
    }

    private void setDisplayWidthTable(CharSetParser charSetParser) throws NLTParserException, IOException {
        Object object;
        int n;
        Object[] objectArray;
        Vector vector = charSetParser.getDisplayWidth();
        if (vector == null || vector.size() == 0) {
            return;
        }
        char[] cArray = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        Vector[] vectorArray = new Vector[cArray.length];
        int n2 = 0;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            objectArray = (Object[])vector.elementAt(i);
            n = ((int[])objectArray[0])[0];
            object = ((int[])objectArray[1])[0];
            n2 = this.addMappingPair(n, (int)object, vectorArray, cArray, n2);
        }
        Object[] objectArray2 = this.buildTwoLevelMapping(vectorArray, cArray, n2, false);
        this.m_charConvLCObj.m_displayWidthLevel1 = (char[])objectArray2[0];
        objectArray = (int[])objectArray2[1];
        this.m_charConvLCObj.m_displayWidthLevel2 = new byte[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            this.m_charConvLCObj.m_displayWidthLevel2[n] = object == -1 ? -1 : (byte)objectArray[n];
        }
        this.m_charConvLCObj.m_displayWidthLeadingCode = new char[n2][2];
        this.setLCTable(n2, cArray, 256, this.m_charConvLCObj.m_displayWidthLeadingCode);
    }

    protected void setReplacementCharacters(CharSetParser charSetParser) throws NLTParserException {
        String string = charSetParser.getDefaultReplacementChar();
        if (string != null) {
            this.m_charConvLCObj.m_1ByteOraCharReplacement = (char)this.validateReturnReplacementChar(string, 255L);
        }
        if ((string = charSetParser.getDefaultMultibyteReplacementChar()) != null) {
            this.m_charConvLCObj.m_2ByteOraCharReplacement = (char)this.validateReturnReplacementChar(string, this.m_maxCharValue);
        }
    }

    protected void resetReplacementCharacters(CharacterConverter characterConverter) {
        if (characterConverter != null) {
            if (this.m_charConvLCObj.m_1ByteOraCharReplacement == '\u0000') {
                this.m_charConvLCObj.m_1ByteOraCharReplacement = characterConverter.getOraChar1ByteRep();
            }
            if (this.m_charConvLCObj.m_2ByteOraCharReplacement == '\u0000') {
                this.m_charConvLCObj.m_2ByteOraCharReplacement = characterConverter.getOraChar2ByteRep();
            }
        }
        if (this.m_charConvLCObj.m_1ByteOraCharReplacement == '\u0000') {
            this.m_charConvLCObj.m_1ByteOraCharReplacement = (char)63;
        }
        if (this.m_charConvLCObj.m_2ByteOraCharReplacement == '\u0000') {
            this.m_charConvLCObj.m_2ByteOraCharReplacement = this.m_charConvLCObj.m_1ByteOraCharReplacement;
        }
    }

    protected void setUcsChar(CharSetParser charSetParser, CharacterConverter characterConverter) throws NLTParserException, IOException {
        int n;
        Vector vector;
        char[] cArray = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        Vector[] vectorArray = new Vector[cArray.length];
        int n2 = 0;
        if (characterConverter != null) {
            vector = new Vector(65535, 28671);
            characterConverter.extractCodepoints(vector);
            for (n = 0; n < vector.size(); ++n) {
                int[] nArray = (int[])vector.elementAt(n);
                n2 = this.setUcsCharPair(nArray[0], nArray[1], vectorArray, cArray, n2);
            }
        }
        vector = charSetParser.getCharacterData();
        int n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            Object[] objectArray = (Object[])vector.elementAt(n);
            int n4 = ((int[])objectArray[0])[0];
            int n5 = ((int[])objectArray[1])[0];
            n2 = this.setUcsCharPair(n4, n5, vectorArray, cArray, n2);
        }
        this.finishUcsChar(vectorArray, cArray, n2);
    }

    private int setUcsCharPair(int n, int n2, Vector[] vectorArray, char[] cArray, int n3) throws NLTParserException, IOException {
        if ((n2 = (int)CharConvLCBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return n3;
        }
        return this.addMappingPair(n, n2, vectorArray, cArray, n3);
    }

    private int addMappingPair(int n, int n2, Vector[] vectorArray, char[] cArray, int n3) throws NLTParserException {
        Vector<int[]> vector;
        int n4;
        int n5 = n >> 16 & 0xFFFF;
        int n6 = -1;
        for (n4 = 0; n4 < n3; ++n4) {
            if (n5 != cArray[n4]) continue;
            n6 = n4;
            break;
        }
        if (n6 == -1) {
            if (n4 < cArray.length) {
                cArray[n4] = (char)n5;
                n6 = n4;
                n3 = n4 + 1;
            } else {
                throw new NLTParserException("too many leading codes: " + Integer.toHexString(n5));
            }
        }
        if ((vector = vectorArray[n4]) == null) {
            vectorArray[n4] = vector = new Vector<int[]>();
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
        return n3;
    }

    private void finishUcsChar(Vector[] vectorArray, char[] cArray, int n) {
        Object[] objectArray = this.buildTwoLevelMapping(vectorArray, cArray, n, true);
        this.m_charConvLCObj.m_ucsCharLevel1 = (char[])objectArray[0];
        this.m_charConvLCObj.m_ucsCharLevel2 = (int[])objectArray[1];
        this.m_charConvLCObj.m_ucsCharLeadingCode = new char[n][2];
        this.setLCTable(n, cArray, 256, this.m_charConvLCObj.m_ucsCharLeadingCode);
        this.setDuplicateMapping((Map)objectArray[2]);
    }

    private Object[] buildTwoLevelMapping(Vector[] vectorArray, char[] cArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        Vector vector;
        int n8;
        int n9;
        int n10;
        int n11 = 8;
        int n12 = 8;
        int n13 = (1 << n11) - 1;
        int n14 = (1 << n12) - 1;
        int n15 = 256 * n;
        char[] cArray2 = new char[n15];
        char[][] cArray3 = new char[n15][2];
        for (n10 = 0; n10 < n15; ++n10) {
            cArray2[n10] = 65535;
            cArray3[n10][0] = (char)n14;
            cArray3[n10][1] = '\u0000';
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap hashMap2 = new HashMap();
        for (n9 = 0; n9 < n; ++n9) {
            n8 = 256 * n9;
            vector = vectorArray[n9];
            n7 = vector.size();
            for (n10 = 0; n10 < n7; ++n10) {
                nArray = (int[])vector.elementAt(n10);
                n6 = nArray[1];
                if (n6 == -1) continue;
                n5 = nArray[0];
                if (bl) {
                    if (hashMap.get(new Integer(n6)) == null) {
                        hashMap.put(new Integer(n6), new Integer(n5));
                    } else {
                        hashMap2.put(new Integer(n6), hashMap.get(new Integer(n6)));
                    }
                }
                n4 = (n5 >> n12 & n13) + n8;
                cArray2[n4] = '\u0001';
                n3 = n5 & n14;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 <= cArray3[n4][1]) continue;
                cArray3[n4][1] = (char)n3;
            }
        }
        int n16 = n2 = n14 + 1;
        int n17 = 0;
        for (n10 = 0; n10 < n15; ++n10) {
            if (cArray2[n10] == '\uffff') continue;
            int n18 = cArray3[n10][0];
            cArray2[n10] = (char)(n16 - (n17 < n18 ? n17 : n18));
            n16 = cArray2[n10] + n2;
            n17 = n2 - cArray3[n10][1] - 1;
        }
        int[] nArray2 = new int[n16];
        for (n10 = 0; n10 < n16; ++n10) {
            nArray2[n10] = -1;
        }
        for (n9 = 0; n9 < n; ++n9) {
            n8 = 256 * n9;
            vector = vectorArray[n9];
            n7 = vector.size();
            for (n10 = 0; n10 < n7; ++n10) {
                nArray = (int[])vector.elementAt(n10);
                n6 = nArray[1];
                if (n6 == -1) continue;
                n5 = nArray[0];
                n4 = (n5 >> n12 & n13) + n8;
                n3 = n5 & n14;
                int n19 = cArray2[n4] + n3;
                nArray2[n19] = n6;
            }
        }
        if (bl) {
            return new Object[]{cArray2, nArray2, hashMap2};
        }
        return new Object[]{cArray2, nArray2};
    }

    void setLCTable(int n, char[] cArray, int n2, char[][] cArray2) {
        for (int i = 0; i < n; ++i) {
            cArray2[i][0] = cArray[i];
            cArray2[i][1] = (char)(i * n2);
        }
    }
}

