/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.builder.BootBuilder;
import oracle.i18n.util.builder.CharConv12ByteBuilder;
import oracle.i18n.util.builder.CharConv1ByteBuilder;
import oracle.i18n.util.builder.CharConv2ByteFixedBuilder;
import oracle.i18n.util.builder.CharConvGB18030Builder;
import oracle.i18n.util.builder.CharConvGBKBuilder;
import oracle.i18n.util.builder.CharConvJAEUCBuilder;
import oracle.i18n.util.builder.CharConvLCFixedBuilder;
import oracle.i18n.util.builder.CharConvMSOLISO2022JPFWBuilder;
import oracle.i18n.util.builder.CharConvMSOLISO2022JPHWBuilder;
import oracle.i18n.util.builder.CharConvSJISBuilder;
import oracle.i18n.util.builder.CharConvShiftBuilder;
import oracle.i18n.util.builder.CharConvZHTEUCBuilder;
import oracle.i18n.util.builder.CharDataTypeParser;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.UnicodePropertyBuilder;

public class CharConvBuilder {
    public static final String CHARCONVNAME = "lx2";
    public static final int ORACHARMASK = 255;
    public static final int UCSCHARWIDTH = 16;
    public static final int ORACHARWIDTH = 16;
    public static final int BYTEWIDTH = 8;
    public static final int HIBYTEMASK = 65280;
    public static final int LOWBYTEMASK = 255;
    public static final int INVALID_ORA_CHAR = -1;
    public static final int DEFAULT_UCS_REPLACEMENT = 65533;
    static final String FILE_CHARSET_META = "charSetMetaData.tmp";
    protected CharacterConverter m_charConvObj;

    private CharConvBuilder() {
    }

    protected CharConvBuilder(CharacterConverter characterConverter) {
        this.m_charConvObj = characterConverter;
    }

    public static void buildGLB(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, NLTParserException {
        CharDataTypeParser charDataTypeParser = new CharDataTypeParser(string3);
        int n = charDataTypeParser.baseCharID;
        int n2 = charDataTypeParser.typeID;
        CharacterConverter characterConverter = null;
        if (n >= 0) {
            characterConverter = CharacterConverterOGS.getInstance((int)n);
        }
        if (bl2) {
            if (n2 == 0 && CharConvBuilder.isExist("oracle.i18n.util.builder.CharConv1ByteBuilderJDBC")) {
                try {
                    Class<?> clazz = Class.forName("oracle.i18n.util.builder.CharConv1ByteBuilderJDBC");
                    Object obj = clazz.getConstructors()[0].newInstance(new Object[0]);
                    Method method = clazz.getMethod("buildGLB", CharacterConverter.class, String.class, String.class, String.class, Boolean.class);
                    method.invoke(obj, characterConverter, string, string2, string3, new Boolean(bl));
                }
                catch (Exception exception) {
                    System.err.println("CharConv1ByteBuilderJDBC cannot be found");
                    return;
                }
            } else {
                System.err.println("The format type of this character set is not supported for JDBC standalone: " + string3);
                return;
            }
            return;
        }
        switch (n2) {
            case 13: {
                CharConvGBKBuilder charConvGBKBuilder = new CharConvGBKBuilder();
                charConvGBKBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvGBKBuilder " + string3);
                break;
            }
            case 0: {
                CharConv1ByteBuilder charConv1ByteBuilder = new CharConv1ByteBuilder();
                charConv1ByteBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConv1ByteBuilder " + string3);
                break;
            }
            case 1: {
                CharConv12ByteBuilder charConv12ByteBuilder = new CharConv12ByteBuilder();
                charConv12ByteBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConv12ByteBuilder " + string3);
                break;
            }
            case 4: {
                CharConvSJISBuilder charConvSJISBuilder = new CharConvSJISBuilder();
                charConvSJISBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvSJISBuilder " + string3);
                break;
            }
            case 6: {
                CharConv2ByteFixedBuilder charConv2ByteFixedBuilder = new CharConv2ByteFixedBuilder();
                charConv2ByteFixedBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConv2ByteFixedBuilder " + string3);
                break;
            }
            case 7: {
                CharConvShiftBuilder charConvShiftBuilder = new CharConvShiftBuilder();
                charConvShiftBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvShiftBuilder " + string3);
                break;
            }
            case 2: {
                CharConvJAEUCBuilder charConvJAEUCBuilder = new CharConvJAEUCBuilder();
                charConvJAEUCBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvJAEUCBuilder " + string3);
                break;
            }
            case 3: {
                CharConvLCFixedBuilder charConvLCFixedBuilder = new CharConvLCFixedBuilder();
                charConvLCFixedBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvLCFixedBuilder " + string3);
                break;
            }
            case 5: {
                CharConvZHTEUCBuilder charConvZHTEUCBuilder = new CharConvZHTEUCBuilder();
                charConvZHTEUCBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvZHTEUCBuilder " + string3);
                break;
            }
            case 9: {
                CharConvGB18030Builder charConvGB18030Builder = new CharConvGB18030Builder();
                charConvGB18030Builder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvGB18030Builder " + string3);
                break;
            }
            case 11: {
                CharConvMSOLISO2022JPFWBuilder charConvMSOLISO2022JPFWBuilder = new CharConvMSOLISO2022JPFWBuilder();
                charConvMSOLISO2022JPFWBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvMSOLISO2022JPFWBuilder " + string3);
                break;
            }
            case 12: {
                CharConvMSOLISO2022JPHWBuilder charConvMSOLISO2022JPHWBuilder = new CharConvMSOLISO2022JPHWBuilder();
                charConvMSOLISO2022JPHWBuilder.buildGLB(characterConverter, string, string2, string3, bl);
                System.out.println("CharConvMSOLISO2022JPHWBuilder " + string3);
                break;
            }
            case 10: {
                UnicodePropertyBuilder.buildGLB(string, string2, string3, bl);
                System.out.println("UnicodePropertyBuilder " + string3);
                break;
            }
            default: {
                System.err.println("The format type of this character set is not supported: " + string3);
            }
        }
        CharSetParser.cleanCache();
    }

    public static Map readCharSetMetaData() {
        return CharDataTypeParser.readCharSetMetaData(FILE_CHARSET_META);
    }

    public static void writeCharSetMetaData() {
        CharDataTypeParser.writeCharSetMetaData(FILE_CHARSET_META);
    }

    protected void writeGLBFile(String string, String string2, String string3, boolean bl) throws IOException {
        BootBuilder.writeGLBFile(string, string2, string3, bl, this.m_charConvObj);
    }

    protected void validateIdName(String string, int n) throws NLTParserException {
        if (string == null || n == 0) {
            throw new NLTParserException("Either character set name or id is null. Make sure the NLT file is valid.");
        }
    }

    protected int validateReturnReplacementChar(String string, long l) throws NLTParserException {
        long l2 = CharConvBuilder.stringToInt(string);
        if ((l2 & 0xFFFFFFFFL) > l) {
            throw new NLTParserException("ReplacementChar too big");
        }
        return (int)(l2 & l);
    }

    public static String formatCharConvClassName(int n) {
        return BootBuilder.formatFileName(CHARCONVNAME, Integer.toString(n));
    }

    static final long convertUTF32toUTF16(long l) {
        return l;
    }

    static int stringToInt(String string) throws NLTParserException {
        try {
            BigInteger bigInteger = null;
            bigInteger = string.length() > 2 && (string.substring(0, 2).equals("0x") || string.substring(0, 2).equals("0X") || string.substring(0, 2).equals("\\x")) ? new BigInteger(string.substring(2), 16) : new BigInteger(string);
            return bigInteger.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new NLTParserException("Bad number format");
        }
    }

    protected void setDuplicateMapping(Map map) {
        this.m_charConvObj.extraUnicodeToOracleMapping = new int[map.size()][2];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.m_charConvObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.m_charConvObj.extraUnicodeToOracleMapping[n][1] = (Integer)map.get(k);
            ++n;
        }
    }

    protected void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverter characterConverter) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverter != null) {
            characterConverter.extractExtraMappings(vector2);
        }
        if (this.m_charConvObj.extraUnicodeToOracleMapping != null) {
            this.m_charConvObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])vector.elementAt(i);
                int n2 = ((int[])objectArray[0])[0];
                int n3 = ((int[])objectArray[1])[0];
                CharConvBuilder.setExtraUnicodeMappingPair(n2, n3, vector2);
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private static void setExtraUnicodeMappingPair(int n, int n2, Vector vector) {
        int[] nArray = new int[]{n = (int)CharConvBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int[] nArray = null;
        int n = vector.size();
        this.m_charConvObj.extraUnicodeToOracleMapping = new int[n][2];
        for (int i = 0; i < n; ++i) {
            nArray = (int[])vector.elementAt(i);
            this.m_charConvObj.extraUnicodeToOracleMapping[i][0] = nArray[0];
            this.m_charConvObj.extraUnicodeToOracleMapping[i][1] = nArray[1];
        }
    }

    private static final boolean isExist(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

