/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;

public class CharConv12ByteBuilder
extends CharConvBuilder {
    static final int MAXCHARVALUE = 65535;
    protected CharacterConverter12Byte m_charConv12Obj;

    public CharConv12ByteBuilder() {
        super((CharacterConverter)new CharacterConverter12Byte());
        this.m_charConv12Obj = (CharacterConverter12Byte)this.m_charConvObj;
    }

    protected CharConv12ByteBuilder(CharacterConverter12Byte characterConverter12Byte) {
        super((CharacterConverter)characterConverter12Byte);
        this.m_charConv12Obj = (CharacterConverter12Byte)this.m_charConvObj;
    }

    void buildGLB(CharacterConverter characterConverter, String string, String string2, String string3, boolean bl) throws IOException, NLTParserException {
        CharSetParser charSetParser = CharSetParser.getInstance(string3);
        String string4 = charSetParser.getName();
        this.m_charConv12Obj.m_oracleId = Integer.parseInt(charSetParser.getId());
        this.m_charConv12Obj.m_ucsCharReplacement = 65533;
        String string5 = charSetParser.getDefaultReplacementChar();
        if (string5 != null) {
            this.m_charConv12Obj.m_1ByteOraCharReplacement = (char)this.validateReturnReplacementChar(string5, 255L);
        }
        if ((string5 = charSetParser.getDefaultMultibyteReplacementChar()) != null) {
            this.m_charConv12Obj.m_2ByteOraCharReplacement = (char)this.validateReturnReplacementChar(string5, 65535L);
        }
        this.validateIdName(string4, this.m_charConv12Obj.m_oracleId);
        boolean bl2 = charSetParser.haveExtraUnicodeMapping();
        String string6 = CharConv12ByteBuilder.formatCharConvClassName(this.m_charConv12Obj.m_oracleId);
        if (characterConverter != null) {
            if (this.m_charConv12Obj.m_1ByteOraCharReplacement == '\u0000') {
                this.m_charConv12Obj.m_1ByteOraCharReplacement = characterConverter.getOraChar1ByteRep();
            }
            if (this.m_charConv12Obj.m_2ByteOraCharReplacement == '\u0000') {
                this.m_charConv12Obj.m_2ByteOraCharReplacement = characterConverter.getOraChar2ByteRep();
            }
        }
        if (this.m_charConv12Obj.m_1ByteOraCharReplacement == '\u0000') {
            this.m_charConv12Obj.m_1ByteOraCharReplacement = (char)63;
        }
        if (this.m_charConv12Obj.m_2ByteOraCharReplacement == '\u0000') {
            this.m_charConv12Obj.m_2ByteOraCharReplacement = this.m_charConv12Obj.m_1ByteOraCharReplacement;
        }
        this.setUcsChar(charSetParser, characterConverter);
        this.setExtraUnicodeMapping(charSetParser, characterConverter);
        this.setDisplayWidthTable(charSetParser);
        this.writeGLBFile(string, string2, string6, bl);
    }

    private void setDisplayWidthTable(CharSetParser charSetParser) throws NLTParserException, IOException {
        Object object;
        int n;
        Object[] objectArray;
        Vector vector = charSetParser.getDisplayWidth();
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n2 = vector.size();
        Vector<int[]> vector2 = new Vector<int[]>();
        for (int i = 0; i < n2; ++i) {
            objectArray = (Object[])vector.elementAt(i);
            n = ((int[])objectArray[0])[0];
            object = ((int[])objectArray[1])[0];
            int[] nArray = new int[]{n, object};
            vector2.addElement(nArray);
        }
        Object[] objectArray2 = this.buildTwoLevelMapping(vector2, false);
        this.m_charConv12Obj.m_displayWidthLevel1 = (char[])objectArray2[0];
        objectArray = (int[])objectArray2[1];
        this.m_charConv12Obj.m_displayWidthLevel2 = new byte[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            this.m_charConv12Obj.m_displayWidthLevel2[n] = object == -1 ? -1 : (byte)objectArray[n];
        }
    }

    private void setUcsChar(CharSetParser charSetParser, CharacterConverter characterConverter) throws NLTParserException, IOException {
        int n;
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverter != null) {
            vector = new Vector(65535, 28671);
            characterConverter.extractCodepoints(vector);
            for (n = 0; n < vector.size(); ++n) {
                int[] nArray = (int[])vector.elementAt(n);
                this.setUcsCharPair(nArray[0], nArray[1], vector2);
            }
        }
        vector = charSetParser.getCharacterData();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            Object[] objectArray = (Object[])vector.elementAt(n);
            int n3 = ((int[])objectArray[0])[0];
            int n4 = ((int[])objectArray[1])[0];
            this.setUcsCharPair(n3, n4, vector2);
        }
        this.finishUcsChar(vector2);
    }

    private void setUcsCharPair(int n, int n2, Vector vector) throws IOException {
        if (n > 65535) {
            System.err.println("***** Error: source code point " + Integer.toHexString(n) + " is too big for 1-2 byte converter");
            return;
        }
        if ((n2 = (int)CharConv12ByteBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
    }

    private void finishUcsChar(Vector vector) {
        Object[] objectArray = this.buildTwoLevelMapping(vector, true);
        this.m_charConv12Obj.m_ucsCharLevel1 = (char[])objectArray[0];
        this.m_charConv12Obj.m_ucsCharLevel2 = (int[])objectArray[1];
        this.setDuplicateMapping((Map)objectArray[2]);
    }

    private Object[] buildTwoLevelMapping(Vector vector, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7 = 8;
        int n8 = 8;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        int n11 = 1 << n7;
        char[] cArray = new char[n11];
        char[][] cArray2 = new char[n11][2];
        for (n6 = 0; n6 < n11; ++n6) {
            cArray[n6] = 65535;
            cArray2[n6][0] = (char)n10;
            cArray2[n6][1] = '\u0000';
        }
        int n12 = vector.size();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap hashMap2 = new HashMap();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])vector.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            if (bl) {
                if (hashMap.get(new Integer(n5)) == null) {
                    hashMap.put(new Integer(n5), new Integer(n4));
                } else {
                    hashMap2.put(new Integer(n5), hashMap.get(new Integer(n5)));
                }
            }
            n3 = n4 >>> n8 & n9;
            cArray[n3] = '\u0001';
            n2 = n4 & n10;
            if (n2 < cArray2[n3][0]) {
                cArray2[n3][0] = (char)n2;
            }
            if (n2 <= cArray2[n3][1]) continue;
            cArray2[n3][1] = (char)n2;
        }
        int n13 = n = n10 + 1;
        int n14 = 0;
        for (n6 = 0; n6 < n11; ++n6) {
            if (cArray[n6] == '\uffff') continue;
            int n15 = cArray2[n6][0];
            cArray[n6] = (char)(n13 - (n14 < n15 ? n14 : n15));
            n13 = cArray[n6] + n;
            n14 = n - cArray2[n6][1] - 1;
        }
        int[] nArray2 = new int[n13];
        for (n6 = 0; n6 < n13; ++n6) {
            nArray2[n6] = -1;
        }
        n12 = vector.size();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])vector.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            n3 = n4 >>> n8 & n9;
            n2 = n4 & n10;
            int n16 = cArray[n3] + n2;
            nArray2[n16] = n5;
        }
        if (bl) {
            return new Object[]{cArray, nArray2, hashMap2};
        }
        return new Object[]{cArray, nArray2};
    }
}

