/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.i18n.util.Sort;
import oracle.i18n.util.builder.BootBuilder;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.NLTSchemaParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BootParser
extends NLTSchemaParser {
    public BootParser(String string) throws NLTParserException {
        super(string);
        this.topNode = BootParser.findNode((Node)this.doc, "NLSBOOT");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern NLSBOOT not found!");
        }
    }

    public String getVERSION() {
        return this.getStringValue("VERSION");
    }

    public String[] getAvailableItems(String string) throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, string);
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node = nodeList.item(i);
            String string3 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("support");
            String string4 = namedNodeMap.getNamedItem("id").getNodeValue();
            int n2 = Integer.parseInt(string4);
            if ("LINGUISTIC_DEFINITION".equals(string) && n2 >= 12288 || node != null && ((string2 = node.getNodeValue()).contains("conversion_only") || string2.contains("deprecated") || string2.contains("internal_use"))) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        Object[] objectArray = arrayList.toArray(new String[0]);
        Sort.quickSort((Object[])objectArray);
        return objectArray;
    }

    public HashMap getLanguage() throws NLTParserException {
        return this.getLocaleItem("LANGUAGE", "lx0");
    }

    public HashMap getTerritory() throws NLTParserException {
        return this.getLocaleItem("TERRITORY", "lx1");
    }

    public HashMap getCharacterSet() throws NLTParserException {
        return this.getLocaleItem("CHARACTER_SET", null);
    }

    public HashMap getLinguistic() throws NLTParserException {
        return this.getLocaleItem("LINGUISTIC_DEFINITION", "lx3");
    }

    public HashMap getTable() throws NLTParserException {
        return this.getLocaleItem("TABLE", "lx4");
    }

    private HashMap getLocaleItem(String string, String string2) {
        NodeList nodeList = BootParser.findNodes(this.topNode, string);
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string3 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string4 = node.getNodeValue();
            int n2 = Integer.parseInt(string4);
            int n3 = 0;
            int n4 = -1;
            while ((n4 = string3.indexOf(44, n3)) != -1) {
                if (!"LINGUISTIC_DEFINITION".equals(string) || n2 < 12288) {
                    hashMap.put(string3.substring(n3, n4), !"CHARACTER_SET".equals(string) ? BootBuilder.formatFileName(string2, string4) : string4);
                }
                n3 = n4 + 1;
            }
            hashMap.put(string3.substring(n3), !"CHARACTER_SET".equals(string) ? BootBuilder.formatFileName(string2, string4) : string4);
            if (!"TERRITORY".equals(string) || (node = namedNodeMap.getNamedItem("language")) == null) continue;
            String string5 = node.getNodeValue();
            n3 = 0;
            int n5 = 1;
            String string6 = null;
            int n6 = 0;
            while ((n6 = string5.indexOf(44, n3)) != -1) {
                string6 = string5.substring(n3, n6);
                hashMap.put(string6 + "_" + string3, BootBuilder.formatFileName(string2, string4, n5++));
                n3 = n6 + 1;
            }
            string6 = string5.substring(n3);
            hashMap.put(string6 + "_" + string3, BootBuilder.formatFileName(string2, string4, n5));
        }
        return hashMap;
    }

    private HashMap getIdtoObject(String string) throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, string);
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string3 = node.getNodeValue();
            int n2 = Integer.parseInt(string3);
            int n3 = 0;
            if ("LINGUISTIC_DEFINITION".equals(string) && n2 >= 12288) continue;
            n3 = string2.indexOf(44);
            if (n3 != -1) {
                hashMap.put(string3, string2.substring(0, n3));
                continue;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public HashMap getIdtoLanguage() throws NLTParserException {
        return this.getIdtoObject("LANGUAGE");
    }

    public HashMap getIdtoTerritory() throws NLTParserException {
        return this.getIdtoObject("TERRITORY");
    }

    public HashMap getIdtoCharacterSet() throws NLTParserException {
        return this.getIdtoObject("CHARACTER_SET");
    }

    public HashMap getIdtoLinguistic() throws NLTParserException {
        return this.getIdtoObject("LINGUISTIC_DEFINITION");
    }

    public HashMap getIdtoTable() throws NLTParserException {
        return this.getIdtoObject("TABLE");
    }
}

