/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.Sort;
import oracle.i18n.util.builder.BootParser;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.ConverterArchive;
import oracle.i18n.util.builder.LanguageParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.OraBootSetter;

public class BootBuilder {
    private static final String BOOT_GLB = "lx0boot";
    private static final String HEXPREFIX = "0000";

    protected BootBuilder() {
    }

    public static void buildGLB(String string, String string2, String string3, boolean bl) throws IOException, NLTParserException {
        OraBootSetter oraBootSetter = new OraBootSetter();
        BootParser bootParser = new BootParser(string3);
        oraBootSetter.setLanguage(bootParser.getLanguage());
        oraBootSetter.setTerritory(bootParser.getTerritory());
        oraBootSetter.setLinguistic(bootParser.getLinguistic());
        oraBootSetter.setCharSet(bootParser.getCharacterSet());
        oraBootSetter.setAvailableLanguages(bootParser.getAvailableItems("LANGUAGE"));
        oraBootSetter.setAvailableTerritories(bootParser.getAvailableItems("TERRITORY"));
        oraBootSetter.setAvailableCharSets(bootParser.getAvailableItems("CHARACTER_SET"));
        oraBootSetter.setAvailableLinguisticSorts(bootParser.getAvailableItems("LINGUISTIC_DEFINITION"));
        oraBootSetter.setTable(bootParser.getTable());
        oraBootSetter.setIdtoLanguage(bootParser.getIdtoLanguage());
        oraBootSetter.setIdtoTerritory(bootParser.getIdtoTerritory());
        oraBootSetter.setIdtoCharSet(bootParser.getIdtoCharacterSet());
        oraBootSetter.setIdtoLinguistic(bootParser.getIdtoLinguistic());
        oraBootSetter.setIdtoTable(bootParser.getIdtoTable());
        BootBuilder.buildOraShortToOraLangMap(oraBootSetter);
        BootBuilder.buildCharSetMaxCharLenMap(oraBootSetter);
        BootBuilder.buildCharSetFlags(oraBootSetter);
        BootBuilder.writeGLBFile(string, string2, BOOT_GLB, bl, oraBootSetter);
    }

    public static void writeGLBFile(String string, String string2, String string3, boolean bl, Object object) throws IOException {
        ConverterArchive converterArchive = new ConverterArchive();
        if (bl) {
            converterArchive.insertObjtoFile(string, string3 + ".glb", object);
        } else {
            String string4 = GDKOracleMetaData.getDataPath();
            String string5 = string4.startsWith("/") ? string4.substring(1) : string4;
            converterArchive.insertSingleObj(string2, object, string5 + string3 + ".glb");
        }
    }

    static String formatFileName(String string, String string2) {
        return BootBuilder.formatFileName(string, string2, -1);
    }

    static String formatFileName(String string, String string2, int n) {
        String string3 = Integer.toHexString(Integer.parseInt(string2));
        String string4 = n != -1 ? Integer.toHexString(n) : "";
        String string5 = HEXPREFIX.substring(0, HEXPREFIX.length() - string3.length()) + string3 + string4;
        return string + string5;
    }

    private static void buildOraShortToOraLangMap(OraBootSetter oraBootSetter) throws IOException, NLTParserException {
        BootParser bootParser = new BootParser("lx0boot.nlt");
        HashMap hashMap = bootParser.getLanguage();
        Object[] objectArray = new String[hashMap.size()];
        hashMap.keySet().toArray(objectArray);
        Sort.quickSort((Object[])objectArray);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>();
        HashMap<Object, String> hashMap4 = new HashMap<Object, String>();
        HashMap<Object, String> hashMap5 = new HashMap<Object, String>();
        HashMap hashMap6 = new HashMap();
        HashMap hashMap7 = new HashMap();
        oraBootSetter.setOraShortToOraLangMap(hashMap2);
        oraBootSetter.setOraLangToOraShortMap(hashMap3);
        oraBootSetter.setTerrIdFromLang(hashMap4);
        oraBootSetter.setLingFromLang(hashMap5);
        oraBootSetter.setLocalCharsetsUnix(hashMap6);
        oraBootSetter.setLocalCharsetsWin(hashMap7);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = new String(hashMap.get(((String)objectArray[i]).toUpperCase(Locale.US)) + ".nlt");
            LanguageParser languageParser = new LanguageParser(string);
            String string2 = languageParser.getISOAbbreviation();
            if (!hashMap2.containsKey(string2)) {
                hashMap2.put(string2, objectArray[i]);
            }
            if (!hashMap3.containsKey(objectArray[i])) {
                hashMap3.put(objectArray[i], string2);
            }
            hashMap4.put(objectArray[i], languageParser.getDefaultTerritoryId());
            String[] stringArray = languageParser.getCommonLinguisticSorts();
            if (stringArray != null && stringArray.length > 0) {
                hashMap5.put(objectArray[i], stringArray[0]);
            }
            String[] stringArray2 = languageParser.getCommonCharsets();
            ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList.add(stringArray2[j]);
            }
            hashMap6.put(objectArray[i], arrayList);
            stringArray2 = languageParser.getCommonCharsetsWin();
            ArrayList<String> arrayList2 = new ArrayList<String>(stringArray2.length);
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList2.add(stringArray2[j]);
            }
            hashMap7.put(objectArray[i], arrayList2);
        }
    }

    private static void buildCharSetMaxCharLenMap(OraBootSetter oraBootSetter) throws IOException, NLTParserException {
        Map map = CharConvBuilder.readCharSetMetaData();
        Map map2 = (Map)map.get("MAX_CHAR_LEN");
        String[] stringArray = oraBootSetter.availableCharacterSets();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = oraBootSetter.getCharSetId(stringArray[i]);
            if (map2.get(string) != null) continue;
            map2.put(string, "2");
        }
        oraBootSetter.setCharSetMaxLen(map2);
    }

    private static void buildCharSetFlags(OraBootSetter oraBootSetter) throws IOException, NLTParserException {
        Map map = CharConvBuilder.readCharSetMetaData();
        Map map2 = (Map)map.get("FLAGS");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (String string : map2.keySet()) {
            String string2;
            String string3 = (String)map2.get(string);
            if (string3 == null || (string2 = oraBootSetter.getCharSetName(string)) == null) continue;
            if (string3.indexOf("ASCII") >= 0) {
                arrayList.add(string2);
            } else if (string3.indexOf("EBCDIC") >= 0) {
                arrayList2.add(string2);
            }
            if (string3.indexOf("FIXED") >= 0) {
                arrayList4.add(string2);
                continue;
            }
            if (string3.indexOf("DISPLAY") != -1) continue;
            arrayList3.add(string2);
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        Collections.sort(arrayList4);
        Collections.sort(arrayList3);
        oraBootSetter.setCharSetFlags(arrayList, arrayList2, arrayList4, arrayList3);
    }
}

