/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.i18n.lcsd.CmgIState;
import oracle.i18n.lcsd.CmgModel;
import oracle.i18n.lcsd.UniChrMG;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.NLTParser;

class ProfileParser {
    private static final String NAME = GDKOracleMetaData.getDataPath() + "lx70001.nlb";
    private static final int UCHR_MAX = 256;
    private InputStream file;

    ProfileParser(String string) throws FileNotFoundException, IOException {
        URL uRL;
        URL uRL2 = uRL = string != null ? NLTParser.createURL(string) : this.getClass().getResource(NAME);
        if (uRL == null) {
            throw new FileNotFoundException(string + " not found");
        }
        this.file = uRL.openStream();
    }

    ProfileParser() throws FileNotFoundException, IOException {
        this(null);
    }

    String readHeader() throws IOException {
        byte[] byArray = new byte[13];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return new String(byArray, "ascii");
    }

    int getint() throws IOException {
        byte[] byArray = new byte[4];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    byte getbyte() throws IOException {
        int n = this.file.read();
        if (n == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (byte)n;
    }

    char getchar() throws IOException {
        int n = this.file.read();
        if (n == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (char)n;
    }

    short getshort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    float getfloat() throws IOException {
        byte[] byArray = new byte[4];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return Float.intBitsToFloat(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24);
    }

    byte[] getbyteArray(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return byArray;
    }

    char[] getcharArray(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        char[] cArray = new char[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return cArray;
    }

    int[] getintArray(int n) throws IOException {
        byte[] byArray = new byte[n * 4];
        int[] nArray = new int[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
            n2 += 4;
        }
        return nArray;
    }

    short[] getshortArray(int n) throws IOException {
        byte[] byArray = new byte[n * 2];
        short[] sArray = new short[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
            n2 += 2;
        }
        return sArray;
    }

    float[] getfloatArray(int n) throws IOException {
        byte[] byArray = new byte[n * 4];
        float[] fArray = new float[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.intBitsToFloat(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24);
            n2 += 4;
        }
        return fArray;
    }

    CmgModel[] getCmgModelArray(int n) throws IOException {
        CmgModel[] cmgModelArray = new CmgModel[n];
        for (int i = 0; i < n; ++i) {
            cmgModelArray[i] = new CmgModel();
            this.getint();
            cmgModelArray[i].norm_lprob = this.getfloat();
            cmgModelArray[i].lpmin = this.getfloat();
            cmgModelArray[i].grad = this.getfloat();
            cmgModelArray[i].fact_id = this.getint();
        }
        return cmgModelArray;
    }

    CmgIState[] getCmgIStateArray(int n) throws IOException {
        CmgIState[] cmgIStateArray = new CmgIState[n];
        for (int i = 0; i < n; ++i) {
            cmgIStateArray[i] = new CmgIState();
            int n2 = this.getint();
            int n3 = this.getint();
            n3 = (n3 >>> 24) + ((n3 & 0xFFFFFF) << 8);
            cmgIStateArray[i].nb_chrs = n3 & 0xFF;
            cmgIStateArray[i].so_offset = n3 >>> 8;
            if (n3 >>> 8 != 0) {
                cmgIStateArray[i].chrs = n2;
                continue;
            }
            cmgIStateArray[i].dnxts = n2 / 4;
        }
        return cmgIStateArray;
    }

    void getCmgLStateArray(int n, int[] nArray, byte[] byArray) throws IOException {
        for (int i = 0; i < n; ++i) {
            int n2 = this.getint();
            n2 = (n2 >>> 24) + ((n2 & 0xFFFFFF) << 8);
            nArray[i] = n2 >>> 8;
            byArray[i] = (byte)(n2 & 0xFF);
        }
    }

    void getLmgMPElemArray(int n, byte[] byArray, byte[] byArray2) throws IOException {
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.getbyte();
            byArray2[i] = this.getbyte();
        }
    }

    UniChrMG getUniChrMG() throws IOException {
        UniChrMG uniChrMG = new UniChrMG();
        uniChrMG.nb_models = this.getint();
        uniChrMG.nb_facts = this.getint();
        uniChrMG.uch_lps_buff_size = this.getint();
        uniChrMG.models_normlp = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.models_lpmin = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.models_grad = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.uch_lps_buff_model_no = new byte[uniChrMG.uch_lps_buff_size];
        uniChrMG.uch_lps_buff_lprob = new byte[uniChrMG.uch_lps_buff_size];
        this.getLmgMPElemArray(uniChrMG.uch_lps_buff_size, uniChrMG.uch_lps_buff_model_no, uniChrMG.uch_lps_buff_lprob);
        uniChrMG.uch_lps = this.getintArray(256);
        for (int i = 0; i < 256; ++i) {
            uniChrMG.uch_lps[i] = (uniChrMG.uch_lps[i] >>> 22) + ((uniChrMG.uch_lps[i] & 0x3FFFFF) << 10);
        }
        return uniChrMG;
    }
}

