/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import oracle.i18n.lcsd.MGFact;
import oracle.i18n.lcsd.ProfileData;
import oracle.i18n.lcsd.ProfileParser;
import oracle.i18n.util.builder.BootBuilder;

public class ProfileBuilder {
    private static final boolean DEBUG = false;
    private static final int MODELS_MAX = 256;

    public static void buildGLB(String string, String string2, String string3, boolean bl) throws IOException {
        ProfileData profileData = ProfileBuilder.readNLBFile(string3);
        if (profileData != null) {
            String string4 = string3.substring(0, string3.lastIndexOf("."));
            BootBuilder.writeGLBFile(string, string2, string4, bl, profileData);
        }
    }

    private static ProfileData readNLBFile(String string) throws FileNotFoundException, IOException {
        int n;
        ProfileParser profileParser = string == null ? new ProfileParser() : new ProfileParser(string);
        ProfileData profileData = new ProfileData();
        String string2 = profileParser.readHeader();
        profileData.nb_models = profileParser.getint();
        profileData.nb_istates = profileParser.getint();
        profileData.min_for_direct = profileParser.getint();
        int n2 = profileParser.getint();
        int n3 = profileParser.getint();
        int n4 = profileParser.getint();
        int n5 = profileParser.getint();
        int n6 = profileParser.getint();
        int n7 = profileParser.getint();
        profileData.nb_facts = profileParser.getint();
        int n8 = profileParser.getint();
        int n9 = profileParser.getint();
        int n10 = profileParser.getint();
        int n11 = profileParser.getint();
        profileData.preprocessbitmap = n8 | n9 << 1 | n10 << 2 | n11 << 3;
        profileData.models = profileParser.getCmgModelArray(profileData.nb_models);
        for (int i = 0; i < profileData.nb_models; ++i) {
            n = profileParser.getint();
            profileData.models[i].name = profileParser.getcharArray(n);
        }
        profileData.istates = profileParser.getCmgIStateArray(n2);
        profileData.istates_chrs = profileParser.getbyteArray(n3);
        profileData.istates_dnxts = profileParser.getintArray(n4);
        profileData.lstates_vals_offs = new int[n5];
        profileData.lstates_nb_vals = new byte[n5];
        profileParser.getCmgLStateArray(n5, profileData.lstates_vals_offs, profileData.lstates_nb_vals);
        profileData.lstates_model_no = new byte[n6];
        profileData.lstates_lprob = new byte[n6];
        profileParser.getLmgMPElemArray(n6, profileData.lstates_model_no, profileData.lstates_lprob);
        profileData.def_so = profileParser.getshortArray(n7);
        profileData.umg = profileParser.getUniChrMG();
        int[] nArray = new int[profileData.nb_models];
        for (int i = 0; i < profileData.nb_models; ++i) {
            n = profileData.models[i].fact_id;
            if (n != -1) {
                n -= profileData.nb_models;
            }
            nArray[i] = n;
        }
        profileData.facts = ProfileBuilder.buildMGfact(nArray, profileData.nb_models);
        profileData.supportedCharset = ProfileBuilder.cache_supportedCharset(profileData);
        return profileData;
    }

    private static MGFact buildMGfact(int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = -1;
        MGFact mGFact = new MGFact();
        mGFact.nb_models = n;
        mGFact.model_fact = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            mGFact.model_fact[n3] = nArray[n3];
            n4 = Math.max(n4, nArray[n3]);
        }
        mGFact.nb_facts = n4 + 1;
        mGFact.fact_nb_models = new int[mGFact.nb_facts];
        for (n2 = 0; n2 < mGFact.nb_facts; ++n2) {
            mGFact.fact_nb_models[n2] = 0;
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = mGFact.model_fact[n3];
            if (n2 == -1) continue;
            int n5 = n2;
            mGFact.fact_nb_models[n5] = mGFact.fact_nb_models[n5] + 1;
        }
        for (n2 = 0; n2 < mGFact.nb_facts; ++n2) {
            mGFact.fact_nb_models[n2] = 0;
        }
        mGFact.fact_models = new int[256][256];
        for (n3 = 0; n3 < n; ++n3) {
            n2 = mGFact.model_fact[n3];
            if (n2 == -1) continue;
            mGFact.fact_models[n2][mGFact.fact_nb_models[n2]] = n3;
            int n6 = n2;
            mGFact.fact_nb_models[n6] = mGFact.fact_nb_models[n6] + 1;
        }
        return mGFact;
    }

    static Set cache_supportedCharset(ProfileData profileData) {
        int n = profileData.nb_models;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = String.valueOf(profileData.models[i].name);
            String string2 = string.substring(3);
            hashSet.add(string2);
        }
        hashSet.add("AL32UTF8");
        hashSet.add("US7ASCII");
        hashSet.add("WE8ISO8859P1");
        hashSet.add("WE8ISO8859P15");
        hashSet.add("EE8MSWIN1250");
        hashSet.add("TR8MSWIN1254");
        hashSet.add("IW8MSWIN1255");
        hashSet.add("KO16MSWIN949");
        hashSet.add("ZHS16GBK");
        return hashSet;
    }
}

