/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import oracle.i18n.lcsd.ProfileBuilder;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.BootBuilder;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharDataTypeParser;
import oracle.i18n.util.builder.CharsetMetaBuilder;
import oracle.i18n.util.builder.ConverterArchive;
import oracle.i18n.util.builder.LanguageBuilder;
import oracle.i18n.util.builder.LinguisticBuilder;
import oracle.i18n.util.builder.MapTableBuilder;
import oracle.i18n.util.builder.SortedCommonLocalesBuilder;
import oracle.i18n.util.builder.SortedLanguagesBuilder;
import oracle.i18n.util.builder.SortedTerritoriesBuilder;
import oracle.i18n.util.builder.TerritoryBuilder;

public final class Ginstall {
    public static final String ARCHIVENAME = "gdk_custom.jar";
    private static final String M_FILE_SEPARATOR = System.getProperty("file.separator");
    static String m_outputDir = "";
    private static final char ADD = 'a';
    private static final char REMOVE = 'r';
    private static final char UPDATE = 'u';
    private static final char DIR = 'd';

    public static void main(String[] stringArray) throws Exception {
        int n = Ginstall.parseParameters(stringArray);
        char c = stringArray[0].charAt(1);
        for (int i = n; n != -1 && i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = Ginstall.getBaseName(string);
            if (c == 'a' || c == 'u' || c == 'd') {
                if (string2.endsWith("BOOT.NLT")) {
                    BootBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.startsWith("LX0")) {
                    LanguageBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.startsWith("LX1")) {
                    TerritoryBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.startsWith("LX2")) {
                    CharConvBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory(), false);
                } else if (string2.startsWith("LX3")) {
                    LinguisticBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.startsWith("LX4")) {
                    MapTableBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.equals("LX70001.NLB")) {
                    ProfileBuilder.buildGLB(m_outputDir, ARCHIVENAME, string, Ginstall.isDirectory());
                } else if (string2.equals("SORTEDCOMMONLOCALES.NLB")) {
                    SortedCommonLocalesBuilder.buildGLB(m_outputDir, "", "", Ginstall.isDirectory());
                } else if (string2.equals("SORTEDLANGUAGES.NLB")) {
                    SortedLanguagesBuilder.buildGLB(m_outputDir, "", "", Ginstall.isDirectory());
                } else if (string2.equals("SORTEDTERRITORIES.NLB")) {
                    SortedTerritoriesBuilder.buildGLB(m_outputDir, "", "", Ginstall.isDirectory());
                } else if (string2.equals("CHARSETMETA")) {
                    CharsetMetaBuilder.buildGLB(m_outputDir, "", "", Ginstall.isDirectory());
                } else {
                    System.err.println("The file you entered is not recognized");
                }
            } else if (stringArray[0].charAt(1) == 'r') {
                ConverterArchive converterArchive = new ConverterArchive();
                converterArchive.removeObj(ARCHIVENAME, Ginstall.getEntryName(string));
            }
            if (c == 'd') continue;
            Ginstall.updateMetadata(stringArray[0], string);
        }
        if (c == 'd') {
            CharConvBuilder.writeCharSetMetaData();
        }
    }

    private static void updateMetadata(String string, String string2) throws Exception {
        ConverterArchive converterArchive = new ConverterArchive();
        String string3 = Ginstall.getIdFromFilename(string2);
        Properties properties = (Properties)converterArchive.readObj(ARCHIVENAME, Ginstall.getMetaFileName(string2));
        Properties properties2 = properties = properties == null ? new Properties() : properties;
        if (string.charAt(1) == 'r') {
            properties.remove(string3);
        } else if (string.charAt(1) == 'a' || string.charAt(1) == 'u') {
            CharDataTypeParser charDataTypeParser = new CharDataTypeParser();
            Properties properties3 = charDataTypeParser.getMetadata(string2);
            properties.setProperty(string3, properties3.getProperty(string3));
        }
        converterArchive.insertSingleObj(ARCHIVENAME, properties, Ginstall.getMetaFileName(string2));
    }

    public static String getIdFromFilename(String string) {
        String string2 = new File(string).getName();
        string2 = string2.substring(3, string2.length() - 4);
        String string3 = Integer.valueOf(string2, 16).toString();
        return string3;
    }

    private static String getEntryName(String string) {
        String string2 = GDKOracleMetaData.getDataPath();
        String string3 = string2.startsWith("/") ? string2.substring(1) : string2;
        return string3 + string.substring(0, string.length() - 3) + "glb";
    }

    private static String getMetaFileName(String string) {
        String string2 = Ginstall.getBaseName(string);
        String string3 = null;
        if (string2.startsWith("LX2")) {
            string3 = "charsetMeta.properties";
        } else if (string2.startsWith("LX0")) {
            string3 = "langMeta.properties";
        } else if (string2.startsWith("LX3")) {
            string3 = "lingMeta.properties";
        } else if (string2.startsWith("LX1")) {
            string3 = "territoryMeta.properties";
        }
        return string3;
    }

    static boolean isDirectory() {
        return !"".equals(m_outputDir);
    }

    static int parseParameters(String[] stringArray) throws Exception {
        int n;
        block4: for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            switch (stringArray[n].charAt(1)) {
                case 'd': {
                    File file;
                    m_outputDir = stringArray[n].substring(2);
                    if (!m_outputDir.endsWith(M_FILE_SEPARATOR)) {
                        m_outputDir = m_outputDir + M_FILE_SEPARATOR;
                    }
                    if ((file = new File(m_outputDir)).isDirectory()) continue block4;
                    throw new RuntimeException("directory " + m_outputDir + " doesn't exist");
                }
                case 'a': 
                case 'r': 
                case 'u': {
                    continue block4;
                }
                default: {
                    Ginstall.printUsage();
                    return -1;
                }
            }
        }
        if (n >= stringArray.length || n == 0) {
            Ginstall.printUsage();
            return -1;
        }
        return n;
    }

    static String getBaseName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        return string.substring(++n).toUpperCase(Locale.US);
    }

    private static final void printUsage() {
        System.err.println("Usage: Ginstall -option <NLT file> ...");
        System.err.println("option can be : \n -d : indicates the directory where the output file is written to");
        System.err.println("      Do not specify 'd' for user-defined charset, a jar file gdk_custom.jar");
        System.err.println("      will be written to the current directory");
        System.err.println(" -a | -add : to add the nlt file");
        System.err.println(" -u | -update : to update the nlt file");
        System.err.println(" -r | -remove : to update the nlt file");
    }
}

