/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;

public class GenUCMFiles {
    public static final HashSet<String> s_nltExclude = new HashSet<String>(){
        {
            this.add("lx2031e.nlt");
            this.add("lx203e1.nlt");
            this.add("lx203e2.nlt");
            this.add("lx203e3.nlt");
            this.add("lx203e4.nlt");
            this.add("lx203e5.nlt");
            this.add("lx203e6.nlt");
            this.add("lx203e9.nlt");
            this.add("lx20366.nlt");
            this.add("lx20367.nlt");
            this.add("lx20368.nlt");
            this.add("lx20369.nlt");
            this.add("lx20726.nlt");
            this.add("lx20728.nlt");
            this.add("lx20729.nlt");
            this.add("lx20730.nlt");
            this.add("lx20732.nlt");
            this.add("lx2073a.nlt");
            this.add("lx2073c.nlt");
            this.add("lx2073d.nlt");
            this.add("lx20744.nlt");
            this.add("lx20747.nlt");
            this.add("lx20748.nlt");
            this.add("lx20749.nlt");
            this.add("lx207d0.nlt");
            this.add("lx20356.nlt");
        }
    };
    private static final HashSet<String> s_statefulCharsets = new HashSet<String>(){
        {
            this.add("ja16dbcs");
            this.add("ja16ebcdic930");
            this.add("ko16dbcs");
            this.add("zhs16dbcs");
            this.add("zht16dbcs");
        }
    };
    private static final String s_ja16eucCommonHeader = "<mb_cur_max>              3\n<mb_cur_min>              1\n<uconv_class>             \"MBCS\"\n<icu:charsetFamily>       \"ASCII\"\n<subchar>                 \\xSUBCHAR_HOLDER\n\n<icu:state>               0-8d, 8e:2, 8f:3, 90-9f, a1-fe:1\n<icu:state>               a1-fe\n<icu:state>               a1-e4\n<icu:state>               a1-fe:1, a1:4, a3-a5:4, a8:4, ac-af:4, ee-f2:4\n<icu:state>               a1-fe.u";
    private static final String s_ja16eucHeader = "<code_set_name>           \"ja16euc\"\n<mb_cur_max>              3\n<mb_cur_min>              1\n<uconv_class>             \"MBCS\"\n<icu:charsetFamily>       \"ASCII\"\n<subchar>                 \\xSUBCHAR_HOLDER\n\n<icu:state>               0-8d, 8e:2, 8f:3, 90-9f, a1-fe:1\n<icu:state>               a1-fe\n<icu:state>               a1-e4\n<icu:state>               a1-fe:1, a1:4, a3-a5:4, a8:4, ac-af:4, ee-f2:4\n<icu:state>               a1-fe.u";
    private static final String s_ja16euctildeHeader = "<code_set_name>           \"ja16euctilde\"\n<mb_cur_max>              3\n<mb_cur_min>              1\n<uconv_class>             \"MBCS\"\n<icu:charsetFamily>       \"ASCII\"\n<subchar>                 \\xSUBCHAR_HOLDER\n\n<icu:state>               0-8d, 8e:2, 8f:3, 90-9f, a1-fe:1\n<icu:state>               a1-fe\n<icu:state>               a1-e4\n<icu:state>               a1-fe:1, a1:4, a3-a5:4, a8:4, ac-af:4, ee-f2:4\n<icu:state>               a1-fe.u";
    private static final String s_ja16eucyenHeader = "<code_set_name>           \"ja16eucyen\"\n<mb_cur_max>              3\n<mb_cur_min>              1\n<uconv_class>             \"MBCS\"\n<icu:charsetFamily>       \"ASCII\"\n<subchar>                 \\xSUBCHAR_HOLDER\n\n<icu:state>               0-8d, 8e:2, 8f:3, 90-9f, a1-fe:1\n<icu:state>               a1-fe\n<icu:state>               a1-e4\n<icu:state>               a1-fe:1, a1:4, a3-a5:4, a8:4, ac-af:4, ee-f2:4\n<icu:state>               a1-fe.u";
    private static final String s_ja16sjisCommonHeader = "<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n<icu:state>                   0-80, 81-9f:1, a0-df, e0-fc:1, fd-ff\n<icu:state>                   40-7e, 80-fc";
    private static final String s_ja16sjisHeader = "<code_set_name>               \"ja16sjis\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n<icu:state>                   0-80, 81-9f:1, a0-df, e0-fc:1, fd-ff\n<icu:state>                   40-7e, 80-fc";
    private static final String s_ja16sjistildeHeader = "<code_set_name>               \"ja16sjistilde\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n<icu:state>                   0-80, 81-9f:1, a0-df, e0-fc:1, fd-ff\n<icu:state>                   40-7e, 80-fc";
    private static final String s_ja16sjisyenHeader = "<code_set_name>               \"ja16sjisyen\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n<icu:state>                   0-80, 81-9f:1, a0-df, e0-fc:1, fd-ff\n<icu:state>                   40-7e, 80-fc";
    private static final String s_ja16macsjisHeader = "<code_set_name>               \"ja16macsjis\"\n<subchar>                     \\x3f\n\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n<icu:state>                   0-80, 81-9f:1, a0-df, e0-fc:1, fd-ff\n<icu:state>                   40-7e, 80-fc";
    private static final String s_ko16kscCommonHeader = "<mb_cur_max>                    2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1, ff\n<icu:state>                   30-7e, 80-fe";
    private static final String s_ko16ksc5601Header = "<code_set_name>               \"ko16ksc5601\"\n<mb_cur_max>                    2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1, ff\n<icu:state>                   30-7e, 80-fe";
    private static final String s_ko16ksccsHeader = "<code_set_name>               \"ko16ksccs\"\n<mb_cur_max>                    2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1, ff\n<icu:state>                   30-7e, 80-fe";
    private static final String s_ko16mswin949Header = "<code_set_name>               \"ko16mswin949\"\n<mb_cur_max>                    2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1, ff\n<icu:state>                   30-7e, 80-fe";
    private static final String s_zhs16gbkHeader = "<code_set_name>               \"zhs16gbk\"\n<mb_cur_max>                    2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1, ff\n<icu:state>                   30-7e, 80-fe";
    private static final String s_zh231280CommonHeader = "<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-9f, a1-fe:1\n<icu:state>                   a1-fe";
    private static final String s_zhs16cgb231280Header = "<code_set_name>               \"zhs16cgb231280\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-9f, a1-fe:1\n<icu:state>                   a1-fe";
    private static final String s_zhs16maccgb231280Header = "<code_set_name>               \"zhs16maccgb231280\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-9f, a1-fe:1\n<icu:state>                   a1-fe";
    private static final String s_zht16big5Header = "<code_set_name>               \"zht16big5\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                    \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, a1-f9:1, fa-ff.i\n<icu:state>                   0-3f.i, 40-fe, ff.i";
    private static final String s_zht16hkscsCommonHeader = "<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1\n<icu:state>                   40-7e.p, 80-fe.p";
    private static final String s_zht16hkscsHeader = "<code_set_name>               \"zht16hkscs\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1\n<icu:state>                   40-7e.p, 80-fe.p";
    private static final String s_zht16mswin950Header = "<code_set_name>               \"zht16mswin950\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1\n<icu:state>                   40-7e.p, 80-fe.p";
    private static final String s_zht16hkscs31Header = "<code_set_name>               \"zht16hkscs31\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-80, 81-fe:1\n<icu:state>                   40-7e.p, 80-fe.p";
    private static final String s_zht32eucHeader = "<code_set_name>               \"zht32euc\"\n<mb_cur_max>                  4\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n# 0: Initial state, single bytes and lead bytes\n<icu:state>                   0-8d, 8e:2, 90-9f, a1-fe:1, aa-c1:4, c3:4, fe:4\n# 1: Trail byte state with mappings\n<icu:state>                   a1-fe\n# 2: Second of four bytes, follows lead byte 8e\n<icu:state>                   a1:3, a2:7, a3-ab:3, ac:6, ad:5, ae:7, af-b0:3\n# (unreachable/optimized away)\n# <icu:state>                 a1-fe:1\n# 3: Third of four bytes, 8e xx .. .. for most xx in a1-b0; all-unassigned\n<icu:state>                   a1-fe:4\n# 4: All-unassigned trail byte state\n<icu:state>                   a1-fe.u\n# 5: 8e ad .. .. with some mappings\n<icu:state>                   a1-a4:1, a5-fe:4\n# 6: 8e ac .. .. with some mappings\n<icu:state>                   a1-e2:1, e3-fe:4\n# 7: 8e a2 .. .. with some mappings\n<icu:state>                   a1-f2:1, f3-fe:4";
    private static final String s_ja16vmsHeader = "<code_set_name>               \"ja16vms\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, a1-fe:1\n<icu:state>                   a1-fe";
    private static final String s_ja16dbcsCommonHeader = "<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_zhtccdcCommonHeader = "<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, a1-fd:1\n<icu:state>                   21-fe, 80-a0.i\n";
    private static final String s_zht32sopsHeader = "<code_set_name>               \"zht32sops\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, a1-fd:1\n<icu:state>                   21-fe, 80-a0.i\n";
    private static final String s_zht16ccdcHeader = "<code_set_name>               \"zht16ccdc\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, a1-fd:1\n<icu:state>                   21-fe, 80-a0.i\n";
    private static final String s_zht32trisHeader = "<code_set_name>               \"zht32tris\"\n<mb_cur_max>                  4\n<mb_cur_min>                  1\n<uconv_class>                 \"MBCS\"\n<icu:charsetFamily>           \"ASCII\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-7f, 8e:1\n<icu:state>                   a1-ae:2\n<icu:state>                   a1-fe:3\n<icu:state>                   a1-fe\n";
    private static final String s_ja16dbcsHeader = "<code_set_name>               \"ja16dbcs\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_ja16ebcdic930Header = "<code_set_name>               \"ja16ebcdic930\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_ko16dbcsHeader = "<code_set_name>               \"ko16dbcs\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_zhs16dbcsHeader = "<code_set_name>               \"zhs16dbcs\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_zht16dbcsHeader = "<code_set_name>               \"zht16dbcs\"\n<mb_cur_max>                  2\n<mb_cur_min>                  1\n<uconv_class>                 \"EBCDIC_STATEFUL\"\n<icu:charsetFamily>           \"EBCDIC\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n<icu:state>                   0-ff, e:1.s, f:0.s\n<icu:state>                   initial, 0-3f:4, e:1.s, f:0.s, 40:3, 41-fe:2, ff:4, b3-b7:5\n<icu:state>                   0-39:1.i, 40-fe:1., ff:1.i\n<icu:state>                   0-ff:1.i, 40:1.\n<icu:state>                   0-ff:1.i\n<icu:state>                   0-40:1.i, 41-fe:1.p, ff:1.i";
    private static final String s_singleByteCommonHeader = "<mb_cur_max>                  1\n<mb_cur_min>                  1\n<uconv_class>                 \"SBCS\"\n<icu:charsetFamily>           \"CHARSET_FAMILY_HOLDER\"\n<subchar>                     \\xSUBCHAR_HOLDER\n\n";
    private static final HashMap<String, String> ucmHeaders = new HashMap<String, String>(){
        {
            this.put("ja16euc", GenUCMFiles.s_ja16eucHeader);
            this.put("ja16euctilde", GenUCMFiles.s_ja16euctildeHeader);
            this.put("ja16eucyen", GenUCMFiles.s_ja16eucyenHeader);
            this.put("ja16sjis", GenUCMFiles.s_ja16sjisHeader);
            this.put("ja16sjistilde", GenUCMFiles.s_ja16sjistildeHeader);
            this.put("ja16sjisyen", GenUCMFiles.s_ja16sjisyenHeader);
            this.put("ja16macsjis", GenUCMFiles.s_ja16macsjisHeader);
            this.put("ko16ksc5601", GenUCMFiles.s_ko16ksc5601Header);
            this.put("zht16big5", GenUCMFiles.s_zht16big5Header);
            this.put("zht16hkscs", GenUCMFiles.s_zht16hkscsHeader);
            this.put("zht32euc", GenUCMFiles.s_zht32eucHeader);
            this.put("ja16vms", GenUCMFiles.s_ja16vmsHeader);
            this.put("ja16dbcs", GenUCMFiles.s_ja16dbcsHeader);
            this.put("ja16ebcdic930", GenUCMFiles.s_ja16ebcdic930Header);
            this.put("ko16dbcs", GenUCMFiles.s_ko16dbcsHeader);
            this.put("ko16ksccs", GenUCMFiles.s_ko16ksccsHeader);
            this.put("ko16mswin949", GenUCMFiles.s_ko16mswin949Header);
            this.put("zhs16cgb231280", GenUCMFiles.s_zhs16cgb231280Header);
            this.put("zhs16maccgb231280", GenUCMFiles.s_zhs16maccgb231280Header);
            this.put("zhs16gbk", GenUCMFiles.s_zhs16gbkHeader);
            this.put("zhs16dbcs", GenUCMFiles.s_zhs16dbcsHeader);
            this.put("zht32sops", GenUCMFiles.s_zht32sopsHeader);
            this.put("zht32tris", GenUCMFiles.s_zht32trisHeader);
            this.put("zht16dbcs", GenUCMFiles.s_zht16dbcsHeader);
            this.put("zht16ccdc", GenUCMFiles.s_zht16ccdcHeader);
            this.put("zht16mswin950", GenUCMFiles.s_zht16mswin950Header);
            this.put("zht16hkscs31", GenUCMFiles.s_zht16hkscs31Header);
        }
    };

    private static String getSingleByteHeader(CharSetParser charSetParser, String string) {
        String string2 = "<code_set_name>               \"" + string + "\"\n" + s_singleByteCommonHeader;
        String string3 = charSetParser.getFlags().toUpperCase();
        String string4 = "ASCII";
        if (string3.contains("EBCDIC")) {
            string4 = "EBCDIC";
        }
        string2 = string2.replace("CHARSET_FAMILY_HOLDER", string4);
        return string2;
    }

    private static String substituteReplacementChar(CharSetParser charSetParser, String string) {
        String string2 = charSetParser.getDefaultReplacementChar().substring(2);
        String string3 = string.replace("SUBCHAR_HOLDER", string2);
        return string3;
    }

    private static String getBytesAsString(int n) {
        String string = null;
        if (((long)n & 0xFFFFFFFFL) > 0xFFFFFFL) {
            int n2 = n >> 24 & 0xFF;
            int n3 = n >> 16 & 0xFF;
            int n4 = n >> 8 & 0xFF;
            int n5 = n & 0xFF;
            string = "\\x" + Integer.toHexString(n2).toUpperCase() + "\\x" + Integer.toHexString(n3).toUpperCase() + "\\x" + Integer.toHexString(n4).toUpperCase() + "\\x" + Integer.toHexString(n5).toUpperCase();
        } else if (n > 65535) {
            int n6 = n >> 16 & 0xFF;
            int n7 = n >> 8 & 0xFF;
            int n8 = n & 0xFF;
            string = "\\x" + Integer.toHexString(n6).toUpperCase() + "\\x" + Integer.toHexString(n7).toUpperCase() + "\\x" + Integer.toHexString(n8).toUpperCase();
        } else if (n > 255) {
            int n9 = n >> 8;
            int n10 = n & 0xFF;
            string = "\\x" + Integer.toHexString(n9).toUpperCase() + "\\x" + Integer.toHexString(n10).toUpperCase();
        } else {
            String string2 = Integer.toHexString(n).toUpperCase();
            string = string2.length() == 1 ? "\\x0" + string2 : "\\x" + string2;
        }
        return string;
    }

    private static String formatUnicodePoint(int n) {
        int n2;
        String string = Integer.toHexString(n).toUpperCase();
        BigInteger bigInteger = new BigInteger(string, 16);
        long l = bigInteger.longValue();
        if ((l & 0xFFFFFFFFL) > 65535L) {
            int n3 = (int)l >> 16 & 0xFFFF;
            n2 = (int)l & 0xFFFF;
            l = (n3 - 55296) * 1024 + (n2 - 56320) + 65536;
        }
        string = Integer.toHexString((int)l).toUpperCase();
        String string2 = "";
        n2 = 4 - string.length();
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + "0";
        }
        string2 = string2 + string;
        return string2;
    }

    private static void processDuplicates(String[] stringArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].length() == 0) continue;
            String string = stringArray[i].substring(2, stringArray[i].indexOf(">"));
            for (int j = i + 1; j < n; ++j) {
                String string2;
                if (stringArray[j].length() == 0 || !string.equals(string2 = stringArray[j].substring(2, stringArray[j].indexOf(">")))) continue;
                stringArray[j] = stringArray[j].replace("|0", "|3");
            }
            String string3 = stringArray[i].substring(stringArray[i].indexOf(">") + 1, stringArray[i].indexOf("|") - 1).trim();
            for (int j = i + 1; j < n; ++j) {
                String string4;
                if (stringArray[j].length() == 0 || !string3.equals(string4 = stringArray[j].substring(stringArray[j].indexOf(">") + 1, stringArray[j].indexOf("|") - 1).trim())) continue;
                stringArray[j] = stringArray[j].substring(0, stringArray[i].indexOf("|")) + "|1";
            }
        }
    }

    private static boolean findDuplicate(String[] stringArray, int n, int n2, String string) {
        for (int i = n; i < n2; ++i) {
            int n3;
            String string2;
            String string3;
            if (stringArray[i].length() == 0 || !(string3 = stringArray[i].substring(2, stringArray[i].indexOf(">"))).equals(string) || !(string2 = stringArray[i].substring((n3 = stringArray[i].indexOf("|")) + 1)).equals("0") && !string2.equals("1")) continue;
            return true;
        }
        return false;
    }

    private static String[] filterNltFiles() {
        File file = new File(".");
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                Pattern pattern = Pattern.compile("lx20.*\\.nlt");
                Matcher matcher = pattern.matcher(string);
                return matcher.find() && !s_nltExclude.contains(string);
            }
        };
        return file.list(filenameFilter);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        String string = null;
        String string2 = System.getProperty("OUTPUTDIR");
        if (string2 == null || string2.length() == 0) {
            System.out.println("GenUCMFiles must be invoked with -DOUTPUTDIR=<target directory for generated ucm files>.");
            return;
        }
        System.out.println("Generating ucm files into " + string2 + " directory:");
        Set<String> set = ucmHeaders.keySet();
        for (String string3 : stringArray2 = GenUCMFiles.filterNltFiles()) {
            try {
                String string4;
                int n;
                int n2;
                Object[] objectArray;
                Object e;
                int n3;
                Vector vector;
                Object object;
                CharSetParser charSetParser;
                System.out.println("Compiling: " + string3);
                CharSetParser charSetParser2 = charSetParser = CharSetParser.getInstance(string3);
                String string5 = charSetParser.getName().toLowerCase();
                PrintWriter printWriter = new PrintWriter(string2 + string5 + ".ucm", "ISO-8859-1");
                String string6 = charSetParser.getBaseCharSet();
                if (string6 != null) {
                    object = CharConvBuilder.formatCharConvClassName(new Integer(string6)) + ".nlt";
                    charSetParser2 = CharSetParser.getInstance((String)object);
                }
                string = set.contains(string5) ? ucmHeaders.get(string5) : GenUCMFiles.getSingleByteHeader(charSetParser2, string5);
                string = GenUCMFiles.substituteReplacementChar(charSetParser2, string);
                printWriter.print(string);
                object = charSetParser.getCharacterData();
                if (string6 != null) {
                    vector = charSetParser2.getCharacterData();
                    ((Vector)object).addAll(vector);
                }
                vector = charSetParser.getReplacementChars();
                int n4 = ((Vector)object).size();
                int n5 = vector == null ? 0 : vector.size();
                Object[] objectArray2 = new String[n4 + n5];
                for (n3 = 0; n3 < n4; ++n3) {
                    e = ((Vector)object).elementAt(n3);
                    objectArray = (Object[])e;
                    n2 = ((int[])objectArray[0])[0];
                    n = ((int[])objectArray[1])[0];
                    if (s_statefulCharsets.contains(string5) && (n2 == 14 || n2 == 15)) {
                        objectArray2[n3] = "";
                        continue;
                    }
                    string4 = GenUCMFiles.formatUnicodePoint(n);
                    String string7 = "0";
                    objectArray2[n3] = "<U" + string4 + "> " + GenUCMFiles.getBytesAsString(n2) + " |" + string7;
                }
                GenUCMFiles.processDuplicates((String[])objectArray2, n4);
                if (vector != null) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        e = vector.elementAt(n3);
                        objectArray = (Object[])e;
                        n2 = ((int[])objectArray[0])[0];
                        n = ((int[])objectArray[1])[0];
                        string4 = GenUCMFiles.formatUnicodePoint(n2);
                        boolean bl = GenUCMFiles.findDuplicate((String[])objectArray2, 0, n3 + n4, string4);
                        objectArray2[n3 + n4] = bl ? "" : "<U" + string4 + "> " + GenUCMFiles.getBytesAsString(n) + " |1";
                    }
                }
                Arrays.sort(objectArray2);
                printWriter.println("\n\n#\nCHARMAP\n#_____________");
                for (Object object2 : objectArray2) {
                    if (((String)object2).length() <= 0) continue;
                    printWriter.println((String)object2);
                }
                printWriter.println("#_____________\nEND CHARMAP\n#");
                printWriter.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
        System.out.println("Done.");
    }
}

