/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oio.oioc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.ewt.UIManager;
import oracle.ewt.alert.Alert;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixHelpDetails;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oio.oioc.BGImagePainter;
import oracle.sysman.oio.oioc.ButtonPanel;

public class OiocOneClickInstaller
extends BufferedFrame
implements ActionListener,
ItemListener {
    private static final int LEFT_MARGIN = 15;
    private static final int RIGHT_MARGIN = 15;
    private static final int UPPER_MARGIN = 40;
    private static final int LOWER_MARGIN = 20;
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private static final int TITLE_SIZE = 20;
    private static final int SUBTITLE_SIZE = 16;
    private static final int RADIO_SIZE = 14;
    private static final int NOTE_SIZE = 11;
    private static final int DEFAULT_SIZE = 12;
    private static final String DEFAULT_FONT_NAME = OiixResourceBundle.getFont();
    private LWCheckbox m_cbStarterDB = null;
    private LWTextField m_tfLocation = null;
    private LWTextField m_tfDBName = null;
    private LWPasswordField m_pfSysPasswd = null;
    private LWPasswordField m_pfConfSysPasswd = null;
    private PushButton m_nextButton = null;
    private PushButton m_cancelButton = null;
    private PushButton m_helpButton = null;
    private PushButton m_browseButton = null;
    private ComboBox m_cbUnixGroups = null;
    private ComboBox m_cbInstallTypes = null;
    private LWContainer m_mainPanel = new LWContainer();
    private LWContainer m_centerPanel = new LWContainer();
    private LWContainer m_northPanel = new LWContainer();
    private LWContainer m_southPanel = new LWContainer();
    private LWCheckbox m_cbBasic = null;
    private LWCheckbox m_cbAdvanced = null;
    private LWCheckboxGroup m_cbgModes = null;
    private static Properties m_props = null;
    private static String[] _args;
    private static String s_shiphomeLocation;
    private static String s_startLocation;
    private boolean m_bSetUnixGroup = false;
    private List m_oUnixGroups = null;
    private List m_oInstallTypes = null;
    private List m_oRespFiles = null;
    private List m_oVarsList = null;
    private String m_sInstall = null;
    private String m_sCmdLineOH = null;
    private boolean m_bAlterUI;
    private boolean m_bNoBackGround;
    private static boolean s_debug;
    private static Image _image;
    private BGImagePainter _bgPainter;
    private static String BACKGROUND_IMAGE;
    private static String BACKGROUND_IMAGE10G;
    public static int DONE_CLICKED;
    public static int ADVANCE_CLICKED;
    public static int NOT_DONE;
    private static int m_nStatus;
    private OiifmDirectoryDlg m_oDirDlg = null;
    private OiipgFileSystem m_oFS = new OiipgFileSystem();
    private boolean m_bHelpAdded = false;

    public OiocOneClickInstaller() {
        super("");
    }

    public void createFrameElements() {
        this.init();
        this.setupListeners();
    }

    private void init() {
        int iWidth = 560;
        int iHeight = 490;
        this.loadProperties();
        this.setResizable(false);
        if (this.m_sInstall.equalsIgnoreCase("10G")) {
            iWidth = 647;
            iHeight = 505;
        }
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int x = maxWidth / 2 - iWidth / 2;
        int y = maxHeight / 2 - iHeight / 2;
        this.setBounds(x, y, iWidth, iHeight);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackgroundImage(this.m_sInstall);
        this.setFont(new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)0), 12));
        this.setForeground(Color.black);
        this.m_mainPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(40, 15, 20, 15));
        this.m_northPanel = this.getTitlePanel();
        this.createCenterPanel();
        this.createSouthPanel();
        this.m_mainPanel.add((Component)this.m_northPanel, (Object)"North");
        this.m_mainPanel.add((Component)this.m_centerPanel, (Object)"Center");
        this.m_mainPanel.add((Component)this.m_southPanel, (Object)"South");
        this.add((Component)this.m_mainPanel, "Center");
        if (!this.m_bNoBackGround) {
            this.setFill((Painter)this._bgPainter);
        }
        String sTitle = "UI_TITLE_9I";
        String sInstall = m_props.getProperty("install");
        sTitle = sInstall == null || !sInstall.trim().equalsIgnoreCase("10G") ? "UI_TITLE_9I" : "UI_TITLE_10G";
        this.setTitle(OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)sTitle));
        this.validate();
        OiifmMnemonicOps.processMnemonic((Container)this.m_mainPanel);
        this.pack();
        this.m_nextButton.requestFocus();
        this.setSize(iWidth, iHeight);
    }

    private LWContainer getTitlePanel() {
        LWContainer titlePanel = new LWContainer();
        titlePanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        String sMainLabel = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_MAIN_LABEL");
        String sSubLabel = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_SUB_LABEL");
        LWLabel titleLabel = new LWLabel(sMainLabel);
        titleLabel.setForeground(Color.black);
        titleLabel.setFont(new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)1), 20));
        titlePanel.add((Component)titleLabel, (Object)"North");
        LWContainer tmpPanel = new LWContainer();
        tmpPanel.setLayout((LayoutManager)new BorderLayout(5, 0));
        titlePanel.add((Component)tmpPanel, (Object)"Center");
        LWContainer subtitlePanel = new LWContainer();
        subtitlePanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        tmpPanel.add((Component)subtitlePanel, (Object)"South");
        LWLabel subtitleLabel = new LWLabel(sSubLabel);
        subtitleLabel.setForeground(Color.black);
        subtitleLabel.setFont(new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)0), 16));
        subtitlePanel.add((Component)subtitleLabel, (Object)"Center");
        LWContainer mainPanel = new LWContainer();
        mainPanel.setLayout((LayoutManager)new BorderLayout(10, 25));
        tmpPanel.add((Component)mainPanel, (Object)"Center");
        return titlePanel;
    }

    private void loadProperties() {
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(s_startLocation + "/" + "oneclick.properties");
            m_props = new Properties();
            m_props.load(iStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {}
        }
        this.setListProps();
        String sInstall = m_props.getProperty("install");
        if (sInstall == null || !sInstall.trim().equalsIgnoreCase("10G")) {
            this.m_sInstall = "9i";
        } else {
            this.m_sInstall = "10G";
            this.m_bAlterUI = true;
        }
    }

    public void setUnixGroups(boolean bRequired, List oUnixGroups) {
        this.m_bSetUnixGroup = bRequired;
        this.m_oUnixGroups = oUnixGroups;
    }

    private void setListProps() {
        String sDelim = "{\"},";
        List oInstallTypes = this.getListFromString(m_props.getProperty("installtypes"), sDelim);
        List oInstallTypesSize = this.getListFromString(m_props.getProperty("installtypesize"), sDelim);
        int nSize = oInstallTypes.size();
        this.m_oInstallTypes = new ArrayList(nSize);
        for (int i = 0; i < nSize; ++i) {
            String sInstallType;
            String sRes = (String)oInstallTypes.get(i);
            String sSize = null;
            if (oInstallTypesSize.size() == nSize) {
                sSize = (String)oInstallTypesSize.get(i);
            }
            if (sSize != null) {
                Object[] args = new String[]{sSize};
                sInstallType = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)sRes, (Object[])args);
            } else {
                sInstallType = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)sRes);
            }
            this.m_oInstallTypes.add(sInstallType);
        }
        this.m_oRespFiles = this.getListFromString(m_props.getProperty("respfiles"), sDelim);
        this.m_oVarsList = this.getListFromString(m_props.getProperty("varslist"), sDelim);
    }

    private List getListFromString(String sStr, String sDelim) {
        ArrayList<String> oRet = new ArrayList<String>();
        if (sStr == null) {
            return oRet;
        }
        StringTokenizer st = new StringTokenizer(sStr, sDelim);
        while (st.hasMoreTokens()) {
            oRet.add(st.nextToken());
        }
        return oRet;
    }

    private void setupListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OiocOneClickInstaller.this.closeDialog();
            }
        });
    }

    private void addComponent(LWComponent src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints((Component)src, gbc);
        dest.add((Component)src);
    }

    private void createCenterPanel() {
        Insets oDefaultc2Insets;
        Insets oDefaultInsets = new Insets(0, 0, 5, 5);
        String sHomeBase = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_HOMEBASE");
        String sInstallType = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_INSTYPE");
        String sDBName = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_DBNAME");
        String sStartDBSize = m_props.getProperty("STARTERDB_SIZE");
        Object[] args = new String[]{sStartDBSize};
        String sStartDB = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_SDB", (Object[])args);
        String sPasswd = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_PASSWORD");
        String sConfPasswd = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_CONF_PASSWORD");
        String sUnixGroup = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_UNIX_GROUP");
        String sBasicInstall = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BASIC");
        String sAdvanceInstall = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_ADVANCE");
        String sBrowse = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BROWSE");
        String sPasswdDesc = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_LBL_PSWD_TEXT");
        String sAdvanceDesc = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_LBL_ADV_TEXT");
        Font font_radio = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)0), 14);
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        LWContainer panel1 = new LWContainer();
        panel1.setLayout((LayoutManager)gridbag0);
        GridBagLayout gridbag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        LWComponent subpanel0 = new LWComponent();
        subpanel0.setLayout((LayoutManager)gridbag1);
        this.m_cbgModes = new LWCheckboxGroup();
        this.m_cbBasic = new LWCheckbox(sBasicInstall, true, this.m_cbgModes);
        this.m_cbBasic.setFont(font_radio);
        this.m_cbBasic.setForeground(Color.black);
        LWContainer centerPanel = new LWContainer();
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = oDefaultc2Insets = new Insets(5, 25, 5, 5);
        c2.anchor = 18;
        c2.fill = 2;
        c2.weightx = 0.01;
        c2.weighty = 0.01;
        c2.gridwidth = 1;
        centerPanel.setLayout((LayoutManager)gridbag2);
        LWLabel lblLocation = new LWLabel(sHomeBase);
        lblLocation.setForeground(Color.black);
        gridbag2.setConstraints((Component)lblLocation, c2);
        centerPanel.add((Component)lblLocation);
        String sOHLoc = this.getHomeLoc();
        this.m_tfLocation = new LWTextField(sOHLoc);
        this.pack();
        this.m_tfLocation.requestFocus();
        lblLocation.setLabelFor((Component)this.m_tfLocation);
        c2.insets = oDefaultInsets;
        c2.weightx = 0.98;
        c2.gridwidth = -1;
        gridbag2.setConstraints((Component)this.m_tfLocation, c2);
        centerPanel.add((Component)this.m_tfLocation);
        this.m_browseButton = new PushButton(sBrowse);
        this.m_browseButton.addActionListener((ActionListener)this);
        this.m_browseButton.setRightmost(true);
        c2.insets = oDefaultInsets;
        c2.weightx = 0.01;
        c2.gridwidth = 0;
        gridbag2.setConstraints((Component)this.m_browseButton, c2);
        centerPanel.add((Component)this.m_browseButton);
        c2.weightx = 0.01;
        c2.weighty = 0.01;
        c2.gridwidth = 1;
        LWLabel lblInstallTypes = new LWLabel(sInstallType);
        lblInstallTypes.setForeground(Color.black);
        c2.insets = oDefaultc2Insets;
        c2.weightx = 0.01;
        c2.weighty = 0.01;
        c2.gridwidth = 1;
        gridbag2.setConstraints((Component)lblInstallTypes, c2);
        centerPanel.add((Component)lblInstallTypes);
        this.m_cbInstallTypes = new ComboBox(false);
        lblInstallTypes.setLabelFor((Component)this.m_cbInstallTypes);
        this.m_cbInstallTypes.setItems(this.getStringArray(this.m_oInstallTypes));
        c2.insets = oDefaultInsets;
        c2.weightx = 0.98;
        c2.gridwidth = -1;
        gridbag2.setConstraints((Component)this.m_cbInstallTypes, c2);
        centerPanel.add((Component)this.m_cbInstallTypes);
        c2.weightx = 0.01;
        c2.gridwidth = 0;
        LWContainer spacer = new LWContainer((LayoutManager)new BorderLayout());
        gridbag2.setConstraints((Component)spacer, c2);
        centerPanel.add((Component)spacer);
        if (this.m_bSetUnixGroup) {
            LWLabel lblUnixGroup = new LWLabel(sUnixGroup);
            lblUnixGroup.setForeground(Color.black);
            c2.insets = oDefaultc2Insets;
            c2.weightx = 0.01;
            c2.weighty = 0.01;
            c2.gridwidth = 1;
            gridbag2.setConstraints((Component)lblUnixGroup, c2);
            centerPanel.add((Component)lblUnixGroup);
            this.m_cbUnixGroups = new ComboBox(true);
            this.m_cbUnixGroups.setItems(this.getStringArray(this.m_oUnixGroups));
            lblUnixGroup.setLabelFor((Component)this.m_cbUnixGroups);
            c2.insets = oDefaultInsets;
            c2.weightx = 0.98;
            c2.gridwidth = -1;
            gridbag2.setConstraints((Component)this.m_cbUnixGroups, c2);
            centerPanel.add((Component)this.m_cbUnixGroups);
            c2.weightx = 0.01;
            c2.gridwidth = 0;
            LWContainer spacer2 = new LWContainer((LayoutManager)new BorderLayout());
            gridbag2.setConstraints((Component)spacer2, c2);
            centerPanel.add((Component)spacer2);
        }
        this.m_cbStarterDB = new LWCheckbox(sStartDB, true);
        Font font_plain = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)0), 12);
        this.m_cbStarterDB.setFont(font_plain);
        this.m_cbStarterDB.setForeground(Color.black);
        c2.insets = oDefaultc2Insets;
        c2.weightx = 0.01;
        c2.weighty = 0.01;
        c2.gridwidth = 0;
        gridbag2.setConstraints((Component)this.m_cbStarterDB, c2);
        centerPanel.add((Component)this.m_cbStarterDB);
        LWContainer panel3 = new LWContainer();
        GridBagLayout gridbag4 = new GridBagLayout();
        GridBagConstraints c4 = new GridBagConstraints();
        Insets oDefaultc4Insets = new Insets(0, 25, 5, 5);
        panel3.setLayout((LayoutManager)gridbag4);
        c4.insets = oDefaultc4Insets;
        c4.anchor = 13;
        c4.fill = 2;
        c4.weightx = 0.02;
        c4.weighty = 0.02;
        c4.gridwidth = 1;
        LWLabel lblDBName = new LWLabel(sDBName);
        lblDBName.setForeground(Color.black);
        gridbag4.setConstraints((Component)lblDBName, c4);
        panel3.add((Component)lblDBName);
        this.m_tfDBName = new LWTextField(m_props.getProperty("dbname"));
        lblDBName.setLabelFor((Component)this.m_tfDBName);
        c4.insets = oDefaultInsets;
        c4.weightx = 0.98;
        c4.weighty = 0.98;
        c4.gridwidth = 0;
        gridbag4.setConstraints((Component)this.m_tfDBName, c4);
        panel3.add((Component)this.m_tfDBName);
        c4.insets = oDefaultc4Insets;
        c4.anchor = 13;
        c4.fill = 2;
        c4.weightx = 0.02;
        c4.weighty = 0.02;
        c4.gridwidth = 1;
        LWLabel lblSysPasswd = new LWLabel(sPasswd);
        lblSysPasswd.setForeground(Color.black);
        gridbag4.setConstraints((Component)lblSysPasswd, c4);
        panel3.add((Component)lblSysPasswd);
        LWContainer panel4 = new LWContainer();
        panel4.setLayout((LayoutManager)new GridLayout(1, 3, 5, 5));
        this.m_pfSysPasswd = new LWPasswordField("");
        lblSysPasswd.setLabelFor((Component)this.m_pfSysPasswd);
        panel4.add((Component)this.m_pfSysPasswd);
        LWLabel lblConfSysPasswd = new LWLabel(sConfPasswd);
        lblConfSysPasswd.setForeground(Color.black);
        LWContainer pnlConSysPasswd = new LWContainer();
        pnlConSysPasswd.setLayout((LayoutManager)new BorderLayout());
        pnlConSysPasswd.add((Component)lblConfSysPasswd, (Object)"East");
        panel4.add((Component)pnlConSysPasswd);
        this.m_pfConfSysPasswd = new LWPasswordField("");
        lblConfSysPasswd.setLabelFor((Component)this.m_pfConfSysPasswd);
        panel4.add((Component)this.m_pfConfSysPasswd);
        c4.insets = oDefaultInsets;
        c4.weightx = 0.98;
        c4.weighty = 0.98;
        c4.gridwidth = 0;
        gridbag4.setConstraints((Component)panel4, c4);
        panel3.add((Component)panel4);
        c4.insets = oDefaultc4Insets;
        c4.anchor = 13;
        c4.fill = 2;
        c4.weightx = 0.02;
        c4.weighty = 0.02;
        c4.gridwidth = 1;
        LWContainer spacer3 = new LWContainer((LayoutManager)new BorderLayout());
        gridbag4.setConstraints((Component)spacer3, c4);
        panel3.add((Component)spacer3);
        MultiLineLabel mllPasswd = new MultiLineLabel(WordWrapper.getTextWrapper(), sPasswdDesc);
        font_plain = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle((int)0), 11);
        mllPasswd.setFont(font_plain);
        mllPasswd.setForeground(Color.black);
        c4.insets = oDefaultInsets;
        c4.weightx = 0.98;
        c4.weighty = 0.98;
        c4.gridwidth = 0;
        gridbag4.setConstraints((Component)mllPasswd, c4);
        panel3.add((Component)mllPasswd);
        this.addComponent((LWComponent)panel3, (Container)centerPanel, gridbag2, c2, 2, 17, 0, 4, 0, 1, 1.0, 1.0, new Insets(0, 15, 5, 5));
        GroupBoxContainer gbPanel = new GroupBoxContainer((Component)this.m_cbBasic, (Component)centerPanel);
        gbPanel.setBorderPainter(UIManager.createGroupBoxPainter((String)this.m_cbBasic.getLabel()));
        this.addComponent((LWComponent)gbPanel, (Container)panel1, gridbag0, c0, 2, 17, 0, 0, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        LWContainer panel2 = new LWContainer();
        GridBagLayout gridbag3 = new GridBagLayout();
        GridBagConstraints c3 = new GridBagConstraints();
        panel2.setLayout((LayoutManager)new BorderLayout(0, 0));
        LWContainer advMainPanel = new LWContainer();
        advMainPanel.setLayout((LayoutManager)new BorderLayout(4, 0));
        this.m_cbAdvanced = new LWCheckbox(sAdvanceInstall, false, this.m_cbgModes);
        this.m_cbAdvanced.setFont(font_radio);
        this.m_cbAdvanced.setForeground(Color.black);
        advMainPanel.add((Component)this.m_cbAdvanced, (Object)"Center");
        advMainPanel.add((Component)new LWContainer(), (Object)"West");
        MultiLineLabel mllAdv = new MultiLineLabel(WordWrapper.getTextWrapper(), sAdvanceDesc);
        mllAdv.setPreferredAspectRatio(0.0f);
        mllAdv.setForeground(Color.black);
        LWContainer mllAdvMainPanel = new LWContainer();
        mllAdvMainPanel.setLayout((LayoutManager)new BorderLayout(20, 0));
        mllAdvMainPanel.add((Component)mllAdv, (Object)"Center");
        mllAdvMainPanel.add((Component)new LWContainer(), (Object)"West");
        panel2.add((Component)advMainPanel, (Object)"North");
        panel2.add((Component)mllAdvMainPanel, (Object)"Center");
        LWContainer tmpCenterPanel = new LWContainer();
        tmpCenterPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        tmpCenterPanel.add((Component)panel1, (Object)"North");
        LWContainer tmpCenterPanel2 = new LWContainer();
        tmpCenterPanel2.setLayout((LayoutManager)new BorderLayout(0, 0));
        tmpCenterPanel2.add((Component)panel2, (Object)"Center");
        tmpCenterPanel.add((Component)tmpCenterPanel2, (Object)"Center");
        this.m_centerPanel = tmpCenterPanel;
        this.m_cbStarterDB.setState(true);
        this.starterDBChecked(true);
        this.m_cbStarterDB.addItemListener((ItemListener)this);
        this.m_cbBasic.addItemListener((ItemListener)this);
        this.m_cbAdvanced.addItemListener((ItemListener)this);
        this.validate();
    }

    private String[] getStringArray(List oList) {
        int nSize = oList.size();
        String[] sArray = new String[nSize];
        for (int i = 0; i < nSize; ++i) {
            sArray[i] = (String)oList.get(i);
        }
        return sArray;
    }

    private void createSouthPanel() {
        String sHelp = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BTN_HELP");
        String sNext = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BTN_NEXT");
        String sCancel = OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BTN_CANCEL");
        this.m_helpButton = new PushButton("    " + sHelp + "    ");
        this.m_helpButton.setRightmost(true);
        this.m_helpButton.setLeftmost(true);
        this.m_nextButton = new PushButton("    " + sNext + "    ");
        this.m_nextButton.setLeftmost(true);
        this.m_nextButton.setRightmost(true);
        this.m_cancelButton = new PushButton("    " + sCancel + "    ");
        this.m_cancelButton.setRightmost(true);
        this.m_cancelButton.setLeftmost(true);
        ButtonPanel bPanel = new ButtonPanel(this.m_helpButton, this.m_nextButton, this.m_cancelButton);
        bPanel.createPanelElements();
        this.m_southPanel.setLayout((LayoutManager)new GridLayout(1, 1, 5, 5));
        this.m_southPanel.add((Component)((Object)bPanel));
        this.m_helpButton.addActionListener((ActionListener)this);
        this.m_nextButton.addActionListener((ActionListener)this);
        this.m_cancelButton.addActionListener((ActionListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.m_cbStarterDB) {
            this.starterDBChecked(this.m_cbStarterDB.getState());
        } else if (evt.getSource() == this.m_cbBasic) {
            this.enableBasicInstall(this.m_cbBasic.getState());
        } else if (evt.getSource() == this.m_cbAdvanced) {
            this.enableBasicInstall(this.m_cbBasic.getState());
        }
    }

    void enableBasicInstall(boolean bEnable) {
        this.m_tfLocation.setEnabled(bEnable);
        if (this.m_cbUnixGroups != null) {
            this.m_cbUnixGroups.setEnabled(bEnable);
        }
        this.m_cbInstallTypes.setEnabled(bEnable);
        this.m_browseButton.setEnabled(bEnable);
        this.m_cbStarterDB.setEnabled(bEnable);
        this.starterDBChecked(bEnable && this.m_cbStarterDB.getState());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.m_nextButton) {
            OiixHelp.dispose();
            this.m_bHelpAdded = false;
            if (this.m_cbBasic.getState()) {
                this.doneClicked();
            } else {
                this.advancedClicked();
            }
        } else if (evt.getSource() == this.m_cancelButton) {
            this.closeDialog();
        } else if (evt.getSource() == this.m_browseButton) {
            this.onBrowse();
        } else if (evt.getSource() == this.m_helpButton) {
            this.onHelp();
        }
    }

    private void onHelp() {
        if (!this.m_bHelpAdded) {
            OiixHelp.addInstHelp();
            this.m_bHelpAdded = true;
        }
        String sHelpID = m_props.getProperty("helpid", "OiocOneClick");
        OiixHelpDetails helpDetails = new OiixHelpDetails(sHelpID);
        OiixHelp.displayHelp((OiixHelpDetails)helpDetails);
    }

    private void onBrowse() {
        if (this.m_oDirDlg != null && this.m_oDirDlg.isVisible()) {
            this.m_oDirDlg.toFront();
        } else {
            File chosenDir;
            String selItem;
            this.m_oDirDlg = new OiifmDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_BROWSE_CHOOSE"));
            this.m_oDirDlg.setCreateAllowed(true);
            this.m_oDirDlg.setCenterOver((Component)((Object)this));
            DirectoryDrive[] volumes = this.m_oFS.getDirectoryDrives();
            if (volumes != null) {
                this.m_oDirDlg.setDrives(volumes);
            }
            selItem = null != (selItem = this.m_tfLocation.getText()) ? selItem.trim() : "";
            File curDir = null;
            if (0 < selItem.length()) {
                curDir = new File(selItem);
                if (curDir.exists()) {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath((String)selItem);
                        curDir = new File(sFileName);
                    }
                    catch (IOException ie) {
                        curDir = null;
                        ie.printStackTrace();
                    }
                } else {
                    curDir = null;
                }
            }
            if (null == curDir) {
                curDir = new File(System.getProperty("user.home"));
            }
            if ((chosenDir = this.m_oDirDlg.runDialog(curDir)) != null) {
                String dirStr = chosenDir.getAbsolutePath();
                this.m_tfLocation.setText(dirStr);
            }
            this.m_oDirDlg = null;
        }
    }

    private void starterDBChecked(boolean isSelected) {
        this.m_tfDBName.setEnabled(isSelected);
        this.m_pfSysPasswd.setEnabled(isSelected);
        this.m_pfConfSysPasswd.setEnabled(isSelected);
    }

    private String getDefaultHomeLoc() {
        String sHomePath = m_props.getProperty("homepath");
        if (sHomePath == null) {
            return "OraHome";
        }
        return sHomePath;
    }

    private String getHomeLoc() {
        String sOHLoc = OiixEnvironmentOps.getEnv((String)"ORACLE_HOME");
        if (sOHLoc == null || sOHLoc.length() == 0) {
            String sDefOHLoc = this.getDefaultHomeLoc();
            sOHLoc = this.m_oFS.getDefHomeLocation(sDefOHLoc);
            int idx = this.getRunningCount(sOHLoc);
            sOHLoc = sOHLoc + "_" + idx;
        }
        return sOHLoc;
    }

    private String concatPath(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        s1 = s1.replace('\\', File.separatorChar);
        if (!(s1 = s1.replace('/', File.separatorChar)).endsWith(File.separator)) {
            s1 = s1 + File.separator;
        }
        String sPath = s1 + s2;
        sPath = sPath.replace('\\', File.separatorChar);
        sPath = sPath.replace('/', File.separatorChar);
        return sPath;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
        OiicExitOps.getExitOps().exit();
    }

    private void doneClicked() {
        if (!this.validateFields(true)) {
            return;
        }
        try {
            this.setVisible(false);
            this.setStatus(DONE_CLICKED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void advancedClicked() {
        if (!this.validateFields(false)) {
            return;
        }
        System.out.println(OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"STATUS_ADV_MESG"));
        try {
            this.setVisible(false);
            this.setStatus(ADVANCE_CLICKED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean validateFields(boolean bDone) {
        boolean bRet = true;
        bRet = this.validateOracleBase();
        if (!bRet) {
            return false;
        }
        bRet = this.validateStarterDB(bDone);
        if (bDone && bRet) {
            bRet = this.validatePassword(bDone);
        }
        return bRet;
    }

    private boolean validateOracleBase() {
        String sBase = this.m_tfLocation.getText();
        if (sBase == null || sBase.trim().length() == 0) {
            this.showErrorMessage("VAL_ORACLEBASE_EMPTY");
            return false;
        }
        return true;
    }

    private boolean validateStarterDB(boolean bDone) {
        String sDB = this.m_tfDBName.getText();
        if ((sDB == null || sDB.trim().length() == 0) && this.m_cbStarterDB.getState()) {
            this.showErrorMessage("VAL_SDB_EMPTY");
            return false;
        }
        return true;
    }

    private boolean validatePassword(boolean bDisplayError) {
        boolean bRet = true;
        if (this.m_cbStarterDB.getState()) {
            String pwd = this.m_pfSysPasswd.getText();
            String confPwd = this.m_pfConfSysPasswd.getText();
            if (pwd == null || confPwd == null || pwd.trim().length() == 0 || confPwd.trim().length() == 0) {
                if (bDisplayError) {
                    this.showErrorMessage("VAL_PSWDS_EMPTY");
                }
                return false;
            }
            if (!pwd.trim().equals(confPwd.trim())) {
                if (bDisplayError) {
                    this.showErrorMessage("VAL_PSWDS_MISMATCH");
                }
                return false;
            }
        }
        return bRet;
    }

    private void showErrorMessage(String msgID) {
        Alert alert = new Alert((Frame)((Object)this), OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)msgID), 1, 1);
        alert.setTitle(OiixResourceBundle.getString((String)"oracle.sysman.oio.oior.OiorOneClickRes", (String)"UI_ERROR_TITLE"));
        alert.runAlert();
    }

    private String[] getCommandArray(boolean bAdvanced) {
        int i;
        String sDelim;
        List oCmdLineArgs;
        Object sSID = null;
        boolean bStarterDBSelected = this.m_cbStarterDB.getState();
        ArrayList<String> v = new ArrayList<String>();
        String sVar = null;
        OiocOneClickInstaller.debug("Starter DB state :" + this.m_cbStarterDB.getState());
        String sAddnCmdLine = null;
        if (!bAdvanced) {
            String loc = this.m_tfLocation.getText();
            if (loc == null || loc.trim().length() == 0) {
                loc = m_props.getProperty("homebase");
            }
            System.setProperty("oracle.installer.splash", "true");
            String sSplashImage = m_props.getProperty("splashimage");
            if (sSplashImage != null && sSplashImage.length() > 0) {
                System.setProperty("oracle.installer.splashimage", sSplashImage);
            }
            v.add("ORACLE_HOME=" + this.m_tfLocation.getText());
            v.add("FROM_LOCATION=" + s_shiphomeLocation);
            sAddnCmdLine = m_props.getProperty("OUI_CMD_LIST_BASIC");
            if (this.m_cbStarterDB.getState()) {
                String db = this.m_tfDBName.getText();
                if (db == null || db.trim().length() == 0) {
                    db = m_props.getProperty("dbname");
                }
                sVar = m_props.getProperty("VAR_DBSID");
                v.add(sVar + "=" + "\"" + this.getSid(db) + "\"");
                sVar = m_props.getProperty("VAR_STARTDB");
                String sVarValue = m_props.getProperty("VAR_STARTDB_TRUE");
                v.add(sVar + "=" + sVarValue);
                sVar = m_props.getProperty("VAR_GLOBALDB");
                v.add(sVar + "=" + "\"" + db + "\"");
                sVar = m_props.getProperty("VAR_PASSWD");
                v.add(sVar + "=" + "\"" + this.m_pfSysPasswd.getText() + "\"");
                sVar = m_props.getProperty("VAR_CONF_PASSWD");
                v.add(sVar + "=" + "\"" + this.m_pfConfSysPasswd.getText() + "\"");
                if (this.m_cbUnixGroups != null) {
                    String sGroup = this.m_cbUnixGroups.getSelectedItem();
                    sVar = m_props.getProperty("VAR_DBAGROUP");
                    v.add(sVar + "=" + sGroup);
                    sVar = m_props.getProperty("VAR_OPERGROUP");
                    v.add(sVar + "=" + sGroup);
                }
            } else {
                sVar = m_props.getProperty("VAR_STARTDB");
                String sVarValue = m_props.getProperty("VAR_STARTDB_FALSE");
                v.add(sVar + "=" + sVarValue);
            }
            String sResp = (String)this.m_oRespFiles.get(this.m_cbInstallTypes.getSelectedIndex());
            v.add("-responseFile");
            v.add(s_startLocation + "/" + "response" + "/" + sResp);
            int nSize = this.m_oVarsList.size();
            for (int n = 0; n < nSize; ++n) {
                sVar = (String)this.m_oVarsList.get(n);
                String sVal = m_props.getProperty(sVar);
                v.add(sVar + "=" + sVal);
            }
        } else {
            sAddnCmdLine = m_props.getProperty("OUI_CMD_LIST_ADVANCED");
        }
        if (sAddnCmdLine != null && (oCmdLineArgs = this.getListFromString(sAddnCmdLine, sDelim = "{\"},")) != null) {
            Iterator iter = oCmdLineArgs.iterator();
            while (iter.hasNext()) {
                v.add((String)iter.next());
            }
        }
        int n = 0;
        ArrayList<String> vOUIArgs = new ArrayList<String>(5);
        boolean bOUIClassFound = false;
        for (n = 0; n < _args.length; ++n) {
            boolean bArgOUIClass;
            if (_args[n].equalsIgnoreCase("oracle.sysman.oii.oiic.OiicInstaller")) {
                bOUIClassFound = true;
                bArgOUIClass = true;
            } else {
                bArgOUIClass = false;
            }
            if (!bOUIClassFound || bArgOUIClass) continue;
            vOUIArgs.add(_args[n]);
        }
        int argsLen = vOUIArgs.size() + v.size();
        String[] sArgs = new String[argsLen];
        n = 0;
        OiocOneClickInstaller.debug("Adding args :" + argsLen);
        for (i = 0; i < vOUIArgs.size(); ++i) {
            sArgs[n++] = (String)vOUIArgs.get(i);
            OiocOneClickInstaller.debug((String)vOUIArgs.get(i));
        }
        for (i = 0; i < v.size(); ++i) {
            sArgs[n++] = (String)v.get(i);
            OiocOneClickInstaller.debug((String)v.get(i));
        }
        return sArgs;
    }

    private static void debug(String sMsg) {
        if (s_debug) {
            System.out.println(sMsg);
        }
    }

    void setCmdLineOH(String sCmdLineOH) {
        this.m_sCmdLineOH = sCmdLineOH;
    }

    private void setBackgroundImage(String sInstall) {
        String imageLoc = BACKGROUND_IMAGE;
        imageLoc = sInstall.equalsIgnoreCase("9i") ? BACKGROUND_IMAGE : BACKGROUND_IMAGE10G;
        _image = OiifmImage.getImageFromAbsolutePath((String)imageLoc, (boolean)false);
        MediaTracker tracker = new MediaTracker((Component)((Object)this));
        tracker.addImage(_image, 0);
        tracker.checkAll(true);
        try {
            tracker.waitForID(0, 3500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._bgPainter = new BGImagePainter(_image, this);
    }

    public int runInstaller() {
        int retCode = 0;
        retCode = this.getStatus() == DONE_CLICKED ? OiicInstaller.getOiicInstallerInstance().runInstaller(this.getCommandArray(false)) : OiicInstaller.getOiicInstallerInstance().runInstaller(this.getCommandArray(true));
        return retCode;
    }

    public void setStatus(int nStatus) {
        m_nStatus = nStatus;
    }

    public int getStatus() {
        return m_nStatus;
    }

    public void setFrameVisible() {
        this.setStatus(NOT_DONE);
        this.setVisible(true);
    }

    public void setNoBackGround(boolean NoBackGround) {
        this.m_bNoBackGround = NoBackGround;
    }

    private int getRunningCount(String sNewHome) {
        int idx = 1;
        boolean bPathExists = true;
        while (bPathExists) {
            String sPath = sNewHome + "_" + idx;
            bPathExists = new File(sPath).exists();
            if (!bPathExists) continue;
            ++idx;
        }
        return idx;
    }

    private String getSid(String sDBName) {
        int idx = sDBName.indexOf(46);
        int len = idx != -1 ? idx : sDBName.length();
        return sDBName.substring(0, Math.min(8, len));
    }

    public static void main(String[] args) {
        int length = args.length;
        boolean bUnixGroups = false;
        boolean bNoBackGround = false;
        String sOH = null;
        String sUnixGroups = "";
        ArrayList<String> oUnixGroups = new ArrayList<String>();
        OiocOneClickInstaller.debug("-----------------------------------------------------");
        OiocOneClickInstaller.debug("Args Length :" + length);
        for (int i = 0; i < length; ++i) {
            OiocOneClickInstaller.debug(args[i]);
            if (args[i].equalsIgnoreCase("-sourceLoc")) {
                s_shiphomeLocation = args[i + 1];
                continue;
            }
            if (args[i].startsWith("UnixGroups")) {
                bUnixGroups = true;
                sUnixGroups = args[i];
                continue;
            }
            if (args[i].startsWith("ORACLE_HOME_NAME=")) {
                sOH = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                s_debug = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-nobackground")) continue;
            bNoBackGround = true;
        }
        OiocOneClickInstaller.debug("-----------------------------------------------------");
        Properties javaprops = System.getProperties();
        s_startLocation = javaprops.getProperty("oracle.installer.startup_location");
        _args = args;
        OiocOneClickInstaller d = new OiocOneClickInstaller();
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OiicExitOps.getExitOps().exit();
            }
        });
        d.setNoBackGround(bNoBackGround);
        if (bUnixGroups) {
            StringTokenizer st = new StringTokenizer(sUnixGroups.substring(sUnixGroups.indexOf(61) + 1), "\",{}");
            while (st.hasMoreTokens()) {
                oUnixGroups.add(st.nextToken());
            }
            if (oUnixGroups.size() > 0) {
                d.setUnixGroups(true, oUnixGroups);
            }
        }
        if (sOH != null) {
            String sCmdLineOH = null;
            int nEq = sOH.indexOf("=");
            sCmdLineOH = sOH.substring(nEq + 1);
            OiocOneClickInstaller.debug("ORACLE_HOME = " + sCmdLineOH);
            d.setCmdLineOH(sCmdLineOH);
        }
        d.createFrameElements();
        d.show();
        while (true) {
            if (d.getStatus() < DONE_CLICKED) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception sCmdLineOH) {}
                continue;
            }
            int retCode = d.runInstaller();
            if (retCode == -2 || retCode == -3 || retCode == -4 || retCode == -5) {
                d.setFrameVisible();
                continue;
            }
            OiocOneClickInstaller.debug("Exit from oneclick");
            d.setVisible(false);
            d.dispose();
            OiicExitOps.getExitOps().exit();
        }
    }

    static {
        s_shiphomeLocation = "";
        s_startLocation = "";
        s_debug = false;
        _image = null;
        BACKGROUND_IMAGE = "oneclickbg.gif";
        BACKGROUND_IMAGE10G = "bg.jpg";
        DONE_CLICKED = 1;
        ADVANCE_CLICKED = 2;
        NOT_DONE = 0;
        m_nStatus = 0;
    }
}

