/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.text.SortedCommonLocales;
import oracle.i18n.text.SortedLanguages;
import oracle.i18n.text.SortedTerritories;
import oracle.i18n.util.OraLocaleInfo;
import oracle.i18n.util.OraResourceBundle;

public class OraDisplayLocaleInfo {
    public static final int SHORT = 3;
    public static final int LONG = 1;
    public static final int DEFAULT = 2;
    public static final int SORT_LOCALE = 0;
    public static final int SORT_LANGUAGE = 1;
    public static final int SORT_TERRITORY = 2;
    private static int m_initv = 1;
    private static final Map m_cache = new HashMap(m_initv);
    private final Map tz_cache = Collections.synchronizedMap(new HashMap(150));
    private static final String M_C_LANGUAGE_RESB = "oracle.i18n.util.message.LanguageTranslations";
    private static final String M_C_TERRITORY_RESB = "oracle.i18n.util.message.TerritoryTranslations";
    private static final String M_C_LANG_TERRIT_RESB = "oracle.i18n.util.message.LanguageTerritoryTranslations";
    private static final String M_C_TIMEZONE_RESB = "oracle.i18n.util.message.TimeZoneTranslations";
    private static final String M_C_LINGUISTIC_SORT_RESB = "oracle.i18n.util.message.LinguisticSortTranslations";
    private static final String M_C_CHARACTER_SET_RESB = "oracle.i18n.util.message.CharacterSetTranslations";
    private static final String M_C_CURRENCY_RESB = "oracle.i18n.util.message.CurrencyTranslations";
    private static final OraDisplayLocaleInfo m_english_odli = new OraDisplayLocaleInfo(new Locale("en", ""), null);
    private static final Map m_ccl;
    private static final Map m_alang;
    private static final Map m_aterr;
    private static final Set m_comDLSet;
    private static final OraMapTable COMMON_LOCALES;
    private final ResourceBundle m_language_resb;
    private final ResourceBundle m_territory_resb;
    private final ResourceBundle m_lang_territ_resb;
    private final Locale m_locale;
    private final Locale m_defLocale;

    private OraDisplayLocaleInfo(Locale locale, Locale locale2) {
        this.m_locale = locale;
        this.m_defLocale = locale2;
        this.m_language_resb = OraResourceBundle.getBundle((String)M_C_LANGUAGE_RESB, (Locale)locale, (Locale)locale2, (ClassLoader)this.getClass().getClassLoader());
        this.m_territory_resb = OraResourceBundle.getBundle((String)M_C_TERRITORY_RESB, (Locale)locale, (Locale)locale2, (ClassLoader)this.getClass().getClassLoader());
        this.m_lang_territ_resb = OraResourceBundle.getBundle((String)M_C_LANG_TERRIT_RESB, (Locale)locale, (Locale)locale2, (ClassLoader)this.getClass().getClassLoader());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public static OraDisplayLocaleInfo getInstance(Locale locale) {
        return OraDisplayLocaleInfo.getInstance(locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraDisplayLocaleInfo getInstance(Locale locale, Locale locale2) {
        OraDisplayLocaleInfo oraDisplayLocaleInfo = null;
        Map map = m_cache;
        synchronized (map) {
            oraDisplayLocaleInfo = (OraDisplayLocaleInfo)m_cache.get(locale);
            if (oraDisplayLocaleInfo == null) {
                oraDisplayLocaleInfo = new OraDisplayLocaleInfo(locale, locale2);
                m_cache.put(locale, oraDisplayLocaleInfo);
            }
        }
        return oraDisplayLocaleInfo;
    }

    public String getDisplayLocale(Locale locale) {
        return this.getDisplayLocale(locale.getLanguage(), locale.getCountry());
    }

    public String getDisplayLocale(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                String string3 = this.m_lang_territ_resb.getString(string.toLowerCase());
                String string4 = this.m_territory_resb.getString(string2.toUpperCase());
                Object[] objectArray = new Object[]{string4};
                return MessageFormat.format(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                return string + " (" + string2 + ")";
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            return this.getDisplayLanguage(locale.getLanguage());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(String string) {
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(Locale locale) {
        try {
            return this.getDisplayCountry(locale.getCountry());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(String string) {
        try {
            return this.m_territory_resb.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayTerritory(String string) {
        return this.getDisplayCountry(string);
    }

    public String getDisplayTimeZone(TimeZone timeZone) {
        return this.getDisplayTimeZone(2, timeZone != null ? timeZone.getID() : "");
    }

    public String getDisplayTimeZone(String string) {
        String string2 = (String)this.tz_cache.get(string);
        if (string2 == null) {
            string2 = this.getDisplayTimeZone(2, string);
            this.tz_cache.put(string, string2);
        }
        return string2;
    }

    public String getDisplayTimeZone(int n, TimeZone timeZone) {
        return this.getDisplayTimeZone(n, timeZone != null ? timeZone.getID() : "");
    }

    public String getDisplayTimeZone(int n, String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle((String)M_C_TIMEZONE_RESB, (Locale)this.m_locale, (Locale)this.m_defLocale, (ClassLoader)this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            int n2 = TimeZone.getTimeZone(string).getRawOffset() / 1000;
            String string2 = " ";
            if (n2 > 0) {
                string2 = "+";
            } else if (n2 < 0) {
                n2 *= -1;
                string2 = "-";
            }
            int n3 = n2 / 3600;
            String string3 = "0" + new Integer(n3).toString();
            String string4 = "0" + new Integer((n2 - n3 * 3600) / 60).toString();
            return "(UTC" + string2 + string3.substring(0, 2) + ":" + string4.substring(0, 2) + ")";
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLinguisticSort(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle((String)M_C_LINGUISTIC_SORT_RESB, (Locale)this.m_locale, (Locale)this.m_defLocale, (ClassLoader)this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCharacterSet(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle((String)M_C_CHARACTER_SET_RESB, (Locale)this.m_locale, (Locale)this.m_defLocale, (ClassLoader)this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCurrency(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle((String)M_C_CURRENCY_RESB, (Locale)this.m_locale, (Locale)this.m_defLocale, (ClassLoader)this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static synchronized List getCommonLocales(Locale locale) {
        Object object;
        Object[] objectArray;
        ArrayList<Object> arrayList = (ArrayList<Object>)m_ccl.get(locale);
        if (arrayList != null) {
            return arrayList;
        }
        String string = locale.toString();
        String string2 = null;
        if (m_comDLSet.isEmpty()) {
            objectArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_DISPLAY_LOCALES");
            for (int i = 0; i < objectArray.length; ++i) {
                m_comDLSet.add(objectArray[i]);
            }
        }
        objectArray = null;
        string2 = OraDisplayLocaleInfo.matchCommonDisplayLocales(string, m_comDLSet);
        if (string2 != null) {
            object = SortedCommonLocales.getInstance(string2);
            objectArray = ((SortedCommonLocales)object).getSortedCommonLocales();
        } else {
            object = OraLocaleInfo.getCommonLocales();
            objectArray = new Locale[((Locale[])object).length];
            OraDisplayLocaleInfo oraDisplayLocaleInfo = OraDisplayLocaleInfo.getInstance(locale);
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
            String[] stringArray = oraLocaleInfo.getLocalLinguisticSorts();
            OraCollator oraCollator = stringArray.length == 0 ? OraCollator.getInstance((Locale)locale) : OraCollator.getInstance((String)stringArray[0]);
            System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
            OraDisplayLocaleInfo.sortByDisplay(objectArray, 0, 0, objectArray.length - 1, oraDisplayLocaleInfo, oraCollator);
        }
        arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        m_ccl.put(locale, arrayList);
        return arrayList;
    }

    public static synchronized String[][] getAvailableLanguages(Locale locale) {
        Object object;
        String[] stringArray;
        String[][] stringArray2 = (String[][])m_alang.get(locale);
        if (stringArray2 != null) {
            return stringArray2;
        }
        String string = locale.toString();
        String string2 = null;
        if (m_comDLSet.isEmpty()) {
            stringArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_DISPLAY_LOCALES");
            for (int i = 0; i < stringArray.length; ++i) {
                m_comDLSet.add(stringArray[i]);
            }
        }
        stringArray = null;
        OraDisplayLocaleInfo oraDisplayLocaleInfo = OraDisplayLocaleInfo.getInstance(locale);
        string2 = OraDisplayLocaleInfo.matchCommonDisplayLocales(string, m_comDLSet);
        if (string2 != null) {
            object = SortedLanguages.getInstance(string2);
            stringArray = ((SortedLanguages)object).getSortedLanguages();
        } else {
            object = OraLocaleInfo.getAvailableLanguages();
            stringArray = new String[((String[])object).length];
            System.arraycopy(object, 0, stringArray, 0, ((Object)object).length);
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
            String[] stringArray3 = oraLocaleInfo.getLocalLinguisticSorts();
            OraCollator oraCollator = stringArray3.length == 0 ? OraCollator.getInstance((Locale)locale) : OraCollator.getInstance((String)stringArray3[0]);
            OraDisplayLocaleInfo.sortByDisplay(stringArray, 1, 0, stringArray.length - 1, oraDisplayLocaleInfo, oraCollator);
        }
        stringArray2 = new String[2][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[0][i] = stringArray[i];
            stringArray2[1][i] = oraDisplayLocaleInfo.getDisplayLanguage(stringArray[i]);
        }
        m_alang.put(locale, stringArray2);
        return stringArray2;
    }

    public static synchronized String[][] getAvailableTerritories(Locale locale) {
        Object object;
        String[] stringArray;
        String[][] stringArray2 = (String[][])m_aterr.get(locale);
        if (stringArray2 != null) {
            return stringArray2;
        }
        String string = locale.toString();
        String string2 = null;
        if (m_comDLSet.isEmpty()) {
            stringArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_DISPLAY_LOCALES");
            for (int i = 0; i < stringArray.length; ++i) {
                m_comDLSet.add(stringArray[i]);
            }
        }
        stringArray = null;
        OraDisplayLocaleInfo oraDisplayLocaleInfo = OraDisplayLocaleInfo.getInstance(locale);
        string2 = OraDisplayLocaleInfo.matchCommonDisplayLocales(string, m_comDLSet);
        if (string2 != null) {
            object = SortedTerritories.getInstance(string2);
            stringArray = ((SortedTerritories)object).getSortedTerritories();
        } else {
            object = OraLocaleInfo.getAvailableTerritories();
            stringArray = new String[((String[])object).length];
            System.arraycopy(object, 0, stringArray, 0, ((Object)object).length);
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
            String[] stringArray3 = oraLocaleInfo.getLocalLinguisticSorts();
            OraCollator oraCollator = stringArray3.length == 0 ? OraCollator.getInstance((Locale)locale) : OraCollator.getInstance((String)stringArray3[0]);
            OraDisplayLocaleInfo.sortByDisplay(stringArray, 2, 0, stringArray.length - 1, oraDisplayLocaleInfo, oraCollator);
        }
        stringArray2 = new String[2][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[0][i] = stringArray[i];
            stringArray2[1][i] = oraDisplayLocaleInfo.getDisplayTerritory(stringArray[i]);
        }
        m_aterr.put(locale, stringArray2);
        return stringArray2;
    }

    public static void sortByDisplay(Object[] objectArray, int n, int n2, int n3, OraDisplayLocaleInfo oraDisplayLocaleInfo, OraCollator oraCollator) {
        int n4 = n2;
        int n5 = n3;
        Object object = null;
        if (n == 0) {
            String string = oraDisplayLocaleInfo.getDisplayLocale((Locale)objectArray[(n2 + n3) / 2]);
            while (true) {
                if (oraCollator.compare(oraDisplayLocaleInfo.getDisplayLocale((Locale)objectArray[n4]), string) < 0) {
                    ++n4;
                    continue;
                }
                while (oraCollator.compare(string, oraDisplayLocaleInfo.getDisplayLocale((Locale)objectArray[n5])) < 0) {
                    --n5;
                }
                if (n4 < n5) {
                    object = objectArray[n4];
                    objectArray[n4] = objectArray[n5];
                    objectArray[n5] = object;
                    ++n4;
                    --n5;
                    continue;
                }
                break;
            }
        } else if (n == 1) {
            String string = oraDisplayLocaleInfo.getDisplayLanguage((String)objectArray[(n2 + n3) / 2]);
            while (true) {
                if (oraCollator.compare(oraDisplayLocaleInfo.getDisplayLanguage((String)objectArray[n4]), string) < 0) {
                    ++n4;
                    continue;
                }
                while (oraCollator.compare(string, oraDisplayLocaleInfo.getDisplayLanguage((String)objectArray[n5])) < 0) {
                    --n5;
                }
                if (n4 < n5) {
                    object = objectArray[n4];
                    objectArray[n4] = objectArray[n5];
                    objectArray[n5] = object;
                    ++n4;
                    --n5;
                    continue;
                }
                break;
            }
        } else if (n == 2) {
            String string = oraDisplayLocaleInfo.getDisplayTerritory((String)objectArray[(n2 + n3) / 2]);
            while (true) {
                if (oraCollator.compare(oraDisplayLocaleInfo.getDisplayTerritory((String)objectArray[n4]), string) < 0) {
                    ++n4;
                    continue;
                }
                while (oraCollator.compare(string, oraDisplayLocaleInfo.getDisplayTerritory((String)objectArray[n5])) < 0) {
                    --n5;
                }
                if (n4 < n5) {
                    object = objectArray[n4];
                    objectArray[n4] = objectArray[n5];
                    objectArray[n5] = object;
                    ++n4;
                    --n5;
                    continue;
                }
                break;
            }
        } else {
            return;
        }
        if (n2 < n4 - 1) {
            OraDisplayLocaleInfo.sortByDisplay(objectArray, n, n2, n4 - 1, oraDisplayLocaleInfo, oraCollator);
        }
        if (n5 + 1 < n3) {
            OraDisplayLocaleInfo.sortByDisplay(objectArray, n, n5 + 1, n3, oraDisplayLocaleInfo, oraCollator);
        }
    }

    private static String matchCommonDisplayLocales(String string, Set set) {
        if (string.equals("zh_SG") || string.equals("zh")) {
            string = "zh_CN";
        } else if (string.equals("zh_MA") || string.equals("zh_HK")) {
            string = "zh_TW";
        }
        String string2 = string.substring(0, 2);
        if (set.contains(string)) {
            return string;
        }
        if (set.contains(string2)) {
            return string2;
        }
        return null;
    }

    static {
        m_cache.put(Locale.ENGLISH, m_english_odli);
        m_ccl = new HashMap();
        m_alang = new HashMap();
        m_aterr = new HashMap();
        m_comDLSet = new HashSet();
        COMMON_LOCALES = OraMapTable.getInstance((int)1);
    }
}

