/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import oracle.i18n.net.MimeUtility;

public class URLEncoder {
    private static BitSet dontNeedEncoding;
    private static BitSet dontNeedEncodingURL;
    private static final int caseDiff = 32;
    private static final int maxBytesPerChar = 10;

    private URLEncoder() {
    }

    public static String encode(String string) {
        return URLEncoder.encode(string, true);
    }

    public static String encode(String string, boolean bl) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, bl, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public static String encode(String string, boolean bl, String string2) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[10];
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2;
            int n2 = cArray[i];
            if (dontNeedEncoding.get(n2) || !bl && dontNeedEncodingURL.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            if (URLEncoder.isHiSurrogate((char)n2) && i + 1 < n) {
                byArray2 = MimeUtility.getBytes(new String(new char[]{(char)n2, cArray[i + 1]}), string2);
                ++i;
            } else {
                byArray2 = MimeUtility.getBytes(new String(new char[]{(char)n2}), string2);
            }
            for (int j = 0; j < byArray2.length; ++j) {
                stringBuffer.append('%');
                char c = Character.forDigit(byArray2[j] >> 4 & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(byArray2[j] & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    static boolean isHiSurrogate(char c) {
        return (char)(c & 0xFC00) == '\ud800';
    }

    static {
        int n;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncodingURL = new BitSet(256);
        dontNeedEncodingURL.set(59);
        dontNeedEncodingURL.set(47);
        dontNeedEncodingURL.set(63);
        dontNeedEncodingURL.set(64);
        dontNeedEncodingURL.set(38);
        dontNeedEncodingURL.set(61);
        dontNeedEncodingURL.set(43);
        dontNeedEncodingURL.set(36);
        dontNeedEncodingURL.set(44);
        dontNeedEncodingURL.set(58);
    }
}

