/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.i18n.net.GDKMessage;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.LocaleMapper;

public class MimeUtility {
    static final byte BYTE_ERROR = -1;
    private static final byte M_C_BYTE_NULL = 0;
    private static final byte M_C_BYTE_HT = 9;
    private static final byte M_C_BYTE_LF = 10;
    private static final byte M_C_BYTE_CR = 13;
    private static final byte M_C_BYTE_SP = 32;
    private static final byte M_C_BYTE_PLUS = 43;
    private static final byte M_C_BYTE_SLASH = 47;
    private static final byte M_C_BYTE_ZERO = 48;
    private static final byte M_C_BYTE_NINE = 57;
    private static final byte M_C_BYTE_EQUAL = 61;
    private static final byte M_C_BYTE_GT = 62;
    private static final byte M_C_BYTE_QUESTION = 63;
    private static final byte M_C_BYTE_ATMARK = 64;
    private static final byte M_C_BYTE_CAP_A = 65;
    private static final byte M_C_BYTE_CAP_F = 70;
    private static final byte M_C_BYTE_CAP_Z = 90;
    private static final byte M_C_BYTE_LOWLINE = 95;
    private static final byte M_C_BYTE_A = 97;
    private static final byte M_C_BYTE_F = 102;
    private static final byte M_C_BYTE_Z = 122;
    private static final byte M_C_BYTE_TILDE = 126;
    private static final byte M_C_BYTE_ESC = 27;
    private static final byte[] M_C_HEX2VAL_TBL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int resw = "=??b??=".length();
    private static final int M_C_MAX_BASE64_WIDTH = 64;
    private static final int M_C_MAX_QP_WIDTH = 75;
    private static final byte[] M_C_BASE64_MAPPING = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] M_C_QP_MAPPING = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int AL16UTF16_CHARSET = 2000;
    private static final int AL16UTF16LE_CHARSET = 2002;
    private static final int UNICODE_1_CHARSET = 870;
    private static final int UNICODE_2_CHARSET = 871;
    private static final int AL32UTF8_CHARSET = 873;
    private static final int ISO_2022_JP_CHARSET = 9999;
    private static String m_defaultJavaCharset;
    private static String m_defaultMIMECharset;
    private static boolean m_decodeTextStrict;
    private static boolean m_foldEncodedWords;
    private static Hashtable m_mapMimeToJava;
    private static Hashtable m_mapJavaToMime;
    private static final int PURE_ASCII = 0;
    private static final int MORE_ASCII = 1;
    private static final int MORE_NONASCII = 2;
    private static final char[] base64_array;
    private static String SPECIALWORD;
    private static String SPECIALTEXT;
    private static final char[] hex_array;

    private MimeUtility() {
    }

    static byte hex2val(byte by) {
        return by > 0 ? M_C_HEX2VAL_TBL[by] : (byte)-1;
    }

    private static String getIANACharset(String string) throws UnsupportedEncodingException {
        String string2 = null;
        String string3 = null;
        string2 = LocaleMapper.getIANACharacterSet((int)1, (String)string);
        if (string2 == null) {
            string3 = LocaleMapper.getOraCharacterSet((int)2, (String)string);
            if (string3 == null) {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
            string2 = string;
        } else {
            string3 = string;
        }
        return string2.toLowerCase(Locale.US);
    }

    public static String encodeHeader(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 - resw - string4.length() : 75 - resw - string4.length();
        String string6 = MimeUtility.encodeBody(string, string4, string5, n);
        StringBuffer stringBuffer = new StringBuffer(string6.length() + resw + string4.length());
        String string7 = "=?" + string4 + "?" + string5 + "?";
        StringTokenizer stringTokenizer = new StringTokenizer(string6, "\r\n");
        int n2 = stringTokenizer.countTokens();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string7);
            String string8 = stringTokenizer.nextToken();
            stringBuffer.append(string8);
            stringBuffer.append("?=");
            if (i >= n2 - 1) continue;
            stringBuffer.append("\r\n ");
        }
        return stringBuffer.toString();
    }

    static String encodeBody(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 : 75;
        return MimeUtility.encodeBody(string, string4, string5, n);
    }

    private static String encodeBody(String string, String string2, String string3, int n) throws UnsupportedEncodingException {
        String string4 = null;
        string4 = string3 == "B" ? MimeUtility.encodeBodyBase64(string, string2, n) : MimeUtility.encodeBodyQP(string, string2, n);
        return string4;
    }

    private static byte base64_byte1(byte by) {
        return (byte)(by >>> 2 & 0x3F);
    }

    private static byte base64_byte2(byte by, byte by2) {
        return (byte)((by << 4 | by2 >>> 4 & 0xF) & 0x3F);
    }

    private static byte base64_byte3(byte by, byte by2) {
        return (byte)((by << 2 | by2 >>> 6 & 3) & 0x3F);
    }

    private static byte base64_byte4(byte by) {
        return (byte)(by & 0x3F);
    }

    private static String encodeBodyBase64(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 4 / 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 + 2 < byArray.length) {
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], byArray[n7 + 2])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte4(byArray[n7 + 2])]);
                n7 += 3;
            }
            switch (byArray.length - n7) {
                case 0: {
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], (byte)0)]);
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(61);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], (byte)0)]);
                    byteArrayOutputStream.write(61);
                }
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    private static String encodeBodyQP(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 < byArray.length) {
                if ((n6 = byArray[n7++] & 0xFF) == 13 && n7 < byArray.length && byArray[n7] == 10) {
                    byteArrayOutputStream.write(13);
                    byteArrayOutputStream.write(byArray[n7++]);
                    continue;
                }
                if (n6 == 63 || n6 == 95 || n6 == 61 || n6 <= 32 || n6 > 126) {
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 >>> 4]);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 & 0xF]);
                    continue;
                }
                byteArrayOutputStream.write(n6);
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    public static String decodeHeader(String string) throws UnsupportedEncodingException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n \t");
        String string2 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("=?")) {
                    return string;
                }
                int n = ((String)object).indexOf(63, 2);
                string2 = ((String)object).substring(2, n);
                String string3 = ((String)object).substring(n + 1, n + 2);
                String string4 = ((String)object).substring(n + 3, ((String)object).indexOf(63, n + 3));
                byteArrayOutputStream.write(MimeUtility.decodeBodyArray(string4, string3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            object = byteArrayOutputStream.toByteArray();
            return MimeUtility.toString((byte[])object, 0, ((Object)object).length, string2);
        }
        return "";
    }

    static String decodeBody(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        if (string5 == "B") {
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(MimeUtility.decodeBodyBase64(stringTokenizer.nextToken(), string4));
            }
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(MimeUtility.decodeBodyQP(stringTokenizer.nextToken(), string4));
            }
        }
        return stringBuffer.toString();
    }

    private static byte[] decodeBodyArray(String string, String string2) throws UnsupportedEncodingException {
        String string3;
        String string4 = string3 = string2.equalsIgnoreCase("B") ? "B" : "Q";
        if (string3 == "B") {
            return MimeUtility.decodeBodyArrayBase64(string);
        }
        return MimeUtility.decodeBodyArrayQP(string);
    }

    private static String decodeBodyQP(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayQP(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayQP(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("iso-8859-1");
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block10: while (n4 < n) {
            byte by = byArray[n4++];
            switch (by) {
                case 61: {
                    if (n4 >= n) continue block10;
                    by = byArray[n4++];
                    switch (by) {
                        case 0: {
                            --n4;
                            break;
                        }
                        case 10: 
                        case 13: {
                            byte by2;
                            n2 = n3;
                            if (n4 >= n || (by2 = byArray[n4]) != 13 && by2 != 10) continue block10;
                            ++n4;
                            break;
                        }
                        default: {
                            byte by3;
                            if (n4 >= n || (by = MimeUtility.hex2val(by)) == -1 || (by3 = MimeUtility.hex2val(byArray[n4++])) == -1) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5204));
                            }
                            byArray2[n3++] = (byte)(by3 + (by << 4));
                            n2 = n3;
                            break;
                        }
                    }
                    continue block10;
                }
                case 32: {
                    byArray2[n3++] = by;
                    break;
                }
                case 95: {
                    byArray2[n3++] = 32;
                    break;
                }
                case 13: {
                    n3 = n2;
                    byArray2[n3++] = by;
                    n2 = n3;
                    break;
                }
                default: {
                    byArray2[n3++] = by;
                    n2 = n3;
                }
            }
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static String decodeBodyBase64(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayBase64(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayBase64(String string) throws UnsupportedEncodingException {
        int n;
        byte[] byArray = string.getBytes("iso-8859-1");
        int n2 = n = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            byte by = 0;
            if (byArray[n4] == 61) break;
            if (byArray[n4] >= 65 && byArray[n4] <= 90) {
                by = (byte)(byArray[n4] - 65);
            } else if (byArray[n4] >= 97 && byArray[n4] <= 122) {
                by = (byte)(byArray[n4] - 97 + 26);
            } else if (byArray[n4] >= 48 && byArray[n4] <= 57) {
                by = (byte)(byArray[n4] - 48 + 52);
            } else if (byArray[n4] == 43) {
                by = (byte)62;
            } else if (byArray[n4] == 47) {
                by = (byte)63;
            } else {
                by = (byte)64;
                if (byArray[n4] == 10 || byArray[n4] == 13) {
                    --n5;
                }
            }
            if (by < 64) {
                switch (n5 & 3) {
                    case 0: {
                        byArray2[n3] = (byte)(by << 2);
                        break;
                    }
                    case 1: {
                        int n6 = n3++;
                        byArray2[n6] = (byte)(byArray2[n6] | (byte)(by >>> 4));
                        byArray2[n3] = (byte)((by & 0xF) << 4);
                        break;
                    }
                    case 2: {
                        int n7 = n3++;
                        byArray2[n7] = (byte)(byArray2[n7] | (byte)((by & 0x3C) >>> 2));
                        byArray2[n3] = (byte)((by & 3) << 6);
                        break;
                    }
                    default: {
                        int n8 = n3++;
                        byArray2[n8] = (byte)(byArray2[n8] | by);
                    }
                }
            }
            ++n4;
            ++n5;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    static byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        String string3 = MimeUtility.getOraCharacterSet(string2);
        String string4 = OraBoot.getInstance().getCharSetId(string3);
        if (string4 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        int n = Integer.parseInt(string4);
        switch (n) {
            case 870: 
            case 871: {
                return string.getBytes("UTF-8");
            }
            case 873: {
                return string.getBytes("UTF-8");
            }
            case 9999: {
                return string.getBytes("X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
            }
        }
        CharacterConverter characterConverter = CharacterConverterOGS.getInstance((int)n);
        if (characterConverter == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        return characterConverter.toOracleStringWithReplacement(string);
    }

    static String toString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        String string2 = MimeUtility.getOraCharacterSet(string);
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        int n3 = Integer.parseInt(string3);
        switch (n3) {
            case 870: 
            case 871: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 873: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 9999: {
                return new String(byArray, n, n2, "X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
        }
        CharacterConverter characterConverter = CharacterConverterOGS.getInstance((int)n3);
        if (characterConverter == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        return characterConverter.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    static String getOraCharacterSet(String string) {
        String string2 = LocaleMapper.getOraCharacterSet((int)2, (String)string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String mimeCharset(String string) {
        String string2 = LocaleMapper.getIANACharacterSet((int)3, (String)string.toUpperCase());
        return string2 == null ? string : string2;
    }

    public static String javaCharset(String string) {
        String string2 = LocaleMapper.getOraCharacterSet((int)2, (String)string.toUpperCase());
        return string2 == null ? string : "X-ORACLE-" + string2;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (m_defaultJavaCharset != null) {
                return m_defaultJavaCharset;
            }
            String string = null;
            try {
                string = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                m_defaultJavaCharset = MimeUtility.javaCharset(string);
                return m_defaultJavaCharset;
            }
            try {
                m_defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
            }
            catch (SecurityException securityException) {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                m_defaultJavaCharset = inputStreamReader.getEncoding();
                if (m_defaultJavaCharset != null && m_defaultJavaCharset.length() != 0) break block6;
                m_defaultJavaCharset = "8859_1";
            }
        }
        return m_defaultJavaCharset;
    }

    private static final String getDefaultMIMECharset() {
        if (m_defaultMIMECharset != null) {
            return m_defaultMIMECharset;
        }
        try {
            m_defaultMIMECharset = System.getProperty("mail.mime.charset");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return m_defaultMIMECharset == null ? MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset()) : m_defaultMIMECharset;
    }

    public static final String decodeWord(String string, String string2) throws UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new UnsupportedEncodingException();
        }
        String string3 = string2 == null ? MimeUtility.getDefaultJavaCharset() : (string2.toUpperCase().equals("ISO-2022-JP") ? LocaleMapper.getJavaCharacterSet((int)2, (String)string2) : MimeUtility.javaCharset(string2));
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new UnsupportedEncodingException();
        }
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf("?=", n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string5 = string.substring(n, n2);
        try {
            byte[] byArray = MimeUtility.decodeBodyArray(string5, string4);
            String string6 = new String(byArray, string3);
            if (n2 + 2 < string.length()) {
                String string7 = string.substring(n2 + 2);
                if (!m_decodeTextStrict) {
                    string7 = MimeUtility.decodeNestedWords(string7);
                }
                string6 = string6 + string7;
            }
            return string6;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException();
        }
    }

    public static final String decodeWord(String string) throws UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new UnsupportedEncodingException();
        }
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new UnsupportedEncodingException();
        }
        String string2 = MimeUtility.javaCharset(string.substring(n, n2));
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string4 = string.substring(n, n2);
        try {
            byte[] byArray = MimeUtility.decodeBodyArray(string4, string3);
            String string5 = new String(byArray, string2);
            if (n2 + 2 < string.length()) {
                String string6 = string.substring(n2 + 2);
                if (!m_decodeTextStrict) {
                    string6 = MimeUtility.decodeNestedWords(string6);
                }
                string5 = string5 + string6;
            }
            return string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException();
        }
    }

    private static final boolean isLinearWhiteSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            byte by = (byte)string.charAt(i);
            if (by == 32 || by == 9 || by == 10 || by == 13) continue;
            return false;
        }
        return true;
    }

    private static final String decodeNestedWords(String string) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("=?", n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            int n3 = string.indexOf("?", n);
            n3 = string.indexOf("?", n3 + 1);
            n3 = string.indexOf("?", n3 + 1);
            n3 = string.indexOf("?", n3 + 1);
            if (n3 < 0) break;
            String string2 = string.substring(n, n3 + 2);
            try {
                string2 = MimeUtility.decodeWord(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string2);
            n2 = n3 + 2;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private static final String decodeNestedWords(String string, String string2) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("=?", n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            int n3 = string.indexOf("?=", n);
            if (n3 < 0) break;
            String string3 = string.substring(n, n3 + 2);
            try {
                string3 = MimeUtility.decodeWord(string3, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string3);
            n2 = n3 + 2;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static final String encodeText(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(string, null, null, m_foldEncodedWords);
    }

    public static final String encodeText(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false, bl);
    }

    public static final String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false, m_foldEncodedWords);
    }

    private static final int getEndOfEncodedWord(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != '?' || ++n3 != 4) continue;
            return i;
        }
        return -1;
    }

    public static final String decodeText(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        String string2 = MimeUtility.normalizeText(string);
        if (string2.indexOf("=?") == -1) {
            return string2;
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < string2.length()) {
            String string3;
            block8: {
                n = string2.indexOf("=?", n2);
                if (n < 0) {
                    stringBuffer.append(string2.substring(n2, string2.length()));
                    return stringBuffer.toString();
                }
                if (!MimeUtility.isLinearWhiteSpace(string2.substring(n2, n))) {
                    stringBuffer.append(string2.substring(n2, n));
                }
                if ((n2 = MimeUtility.getEndOfEncodedWord(string2, n)) < 0) {
                    stringBuffer.append(string2.substring(n, string2.length()));
                    return stringBuffer.toString();
                }
                String string4 = string2.substring(n, n2 += 2);
                try {
                    string3 = MimeUtility.decodeWord(string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string3 = string4;
                    if (m_decodeTextStrict) break block8;
                    string3 = MimeUtility.decodeNestedWords(string3);
                }
            }
            stringBuffer.append(string3);
            n = n2;
        }
        return stringBuffer.toString();
    }

    public static final String decodeText(String string, String string2) throws UnsupportedEncodingException {
        String string3 = MimeUtility.normalizeText(string);
        if (string3.indexOf("=?") == -1) {
            return string3;
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < string3.length()) {
            String string4;
            block7: {
                n = string3.indexOf("=?", n2);
                if (n < 0) {
                    stringBuffer.append(string3.substring(n2, string3.length()));
                    return stringBuffer.toString();
                }
                if (!MimeUtility.isLinearWhiteSpace(string3.substring(n2, n))) {
                    stringBuffer.append(string3.substring(n2, n));
                }
                if ((n2 = MimeUtility.getEndOfEncodedWord(string3, n)) < 0) {
                    stringBuffer.append(string3.substring(n, string3.length()));
                    return stringBuffer.toString();
                }
                String string5 = string3.substring(n, n2 += 2);
                try {
                    string4 = MimeUtility.decodeWord(string5, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string4 = string5;
                    if (m_decodeTextStrict) break block7;
                    string4 = MimeUtility.decodeNestedWords(string4, string2);
                }
            }
            stringBuffer.append(string4);
            n = n2;
        }
        return stringBuffer.toString();
    }

    public static final String encodeWord(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, null, null);
    }

    public static String encodeWord(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, true, m_foldEncodedWords);
    }

    private static final String encodeWord(String string, String string2, String string3, boolean bl, boolean bl2) throws UnsupportedEncodingException {
        String string4;
        boolean bl3;
        if (string == null) {
            return null;
        }
        int n = MimeUtility.asciiScan(string);
        if (n == 0) {
            return string;
        }
        if (string3 == null) {
            String string5 = string3 = n != 2 ? "Q" : "B";
        }
        if (string3.equalsIgnoreCase("B")) {
            bl3 = true;
        } else if (string3.equalsIgnoreCase("Q")) {
            bl3 = false;
        } else {
            throw new UnsupportedEncodingException("Invalid content transfer encoding: " + string3);
        }
        if (string2 == null) {
            string4 = MimeUtility.getDefaultJavaCharset();
            string2 = MimeUtility.getDefaultMIMECharset();
        } else {
            string4 = string2.toUpperCase().equals("ISO-2022-JP") ? LocaleMapper.getJavaCharacterSet((int)2, (String)string2) : MimeUtility.javaCharset(string2);
            if (string2.toUpperCase().indexOf("X-ORACLE-ISO2022-JP") != -1) {
                string2 = "ISO-2022-JP";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 75 - string2.length() - 7;
        String string6 = "=?" + string2 + "?" + string3 + "?";
        MimeUtility.doEncode(string, bl3, string4, n2, string6, true, bl, stringBuffer, bl2);
        return stringBuffer.toString();
    }

    private static final int asciiScan(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (MimeUtility.isAscii(string.charAt(i))) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n3 == 0) {
            return 0;
        }
        if (n2 > n3) {
            return 1;
        }
        return 2;
    }

    private static final boolean isAscii(int n) {
        return n < 127 && n >= 32 || n == 13 || n == 10 || n == 9;
    }

    private static final void doEncode(String string, boolean bl, String string2, int n, String string3, boolean bl2, boolean bl3, StringBuffer stringBuffer, boolean bl4) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n2 = bl ? (byArray.length + 2) / 3 * 4 : MimeUtility.QencodedLength(byArray, bl3);
        int n3 = string.length();
        if (n2 > n && n3 > 1) {
            MimeUtility.doEncode(string.substring(0, n3 / 2), bl, string2, n, string3, bl2, bl3, stringBuffer, bl4);
            MimeUtility.doEncode(string.substring(n3 / 2, n3), bl, string2, n, string3, false, bl3, stringBuffer, bl4);
        } else {
            byte[] byArray2 = new byte[]{};
            try {
                byArray2 = bl ? MimeUtility.encodeWordBase64(byArray) : MimeUtility.encodeWordQP(byArray, bl3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl2) {
                if (bl4) {
                    stringBuffer.append("\r\n ");
                } else {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append(string3);
            int n4 = byArray2.length;
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append((char)byArray2[i]);
            }
            stringBuffer.append("?=");
        }
    }

    private static byte[] encodeWordBase64(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        if (byArray.length == 0) {
            return byArray;
        }
        for (int i = byArray.length; i > 0; i -= 3) {
            byte by;
            byte by2;
            byte by3;
            if (i == 1) {
                by3 = byArray[n++];
                by2 = 0;
                by = 0;
                byArray2[n2++] = (byte)base64_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)base64_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = 61;
                byArray2[n2++] = 61;
                continue;
            }
            if (i == 2) {
                by3 = byArray[n++];
                by2 = byArray[n++];
                by = 0;
                byArray2[n2++] = (byte)base64_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)base64_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = (byte)base64_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                byArray2[n2++] = 61;
                continue;
            }
            by3 = byArray[n++];
            by2 = byArray[n++];
            by = byArray[n++];
            byArray2[n2++] = (byte)base64_array[by3 >>> 2 & 0x3F];
            byArray2[n2++] = (byte)base64_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            byArray2[n2++] = (byte)base64_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
            byArray2[n2++] = (byte)base64_array[by & 0x3F];
        }
        return byArray2;
    }

    private static int QencodedLength(byte[] byArray, boolean bl) {
        int n = 0;
        String string = bl ? SPECIALWORD : SPECIALTEXT;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 < 32 || n2 >= 127 || string.indexOf(n2) != 0) {
                n += 3;
                continue;
            }
            ++n;
        }
        return n;
    }

    private static void encodeWordQP_output(int n, boolean bl, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (bl) {
            byteArrayOutputStream.write(61);
            byteArrayOutputStream.write(hex_array[n >> 4]);
            byteArrayOutputStream.write(hex_array[n & 0xF]);
        } else {
            byteArrayOutputStream.write(n);
        }
    }

    private static byte[] encodeWordQP(byte[] byArray, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = bl ? SPECIALWORD : SPECIALTEXT;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n == 32) {
                MimeUtility.encodeWordQP_output(95, false, byteArrayOutputStream);
                continue;
            }
            if (n < 32 || n >= 127 || string.indexOf(n) >= 0) {
                MimeUtility.encodeWordQP_output(n, true, byteArrayOutputStream);
                continue;
            }
            MimeUtility.encodeWordQP_output(n, false, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static final String normalizeText(String string) {
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String();
        int n2 = 0;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            for (n = 0; n < string.length(); ++n) {
                if (string.length() - 1 - n >= 2 && string.charAt(n) == '=' && string.charAt(n + 1) == '?' && !bl2) {
                    int n3 = string.indexOf(63, n + 2);
                    int n4 = string.indexOf(63, n3 + 1);
                    int n5 = string.indexOf(63, n4 + 1);
                    String string6 = string.substring(n + 2, n3).toUpperCase();
                    String string7 = string.substring(n3 + 1, n4).toUpperCase();
                    if (bl3 && !string2.equals("")) {
                        stringBuffer.append(string2);
                    }
                    bl3 = false;
                    string2 = "";
                    if (!string3.equals("")) {
                        if (string3.equals(string6) && string4.equals(string7) && string7.equals("Q")) {
                            stringBuffer.append(string.substring(n4 + 1, n5));
                            n = n5 + 1;
                            continue;
                        }
                        if (!string5.equals("")) {
                            stringBuffer.append(string5);
                            string5 = "";
                        }
                    }
                    string3 = string6;
                    string4 = string7;
                    bl2 = true;
                    n2 = 0;
                } else if (string.length() - 1 - n >= 2 && string.charAt(n) == '?' && string.charAt(n + 1) == '=' && n2 >= 3) {
                    bl2 = false;
                    n2 = 0;
                    string5 = string5 + string.charAt(n);
                    string5 = string5 + string.charAt(++n);
                    continue;
                }
                if (!bl2) {
                    if (string.charAt(n) != '\r' && string.charAt(n) != '\n') {
                        if (!(bl3 || string.charAt(n) != ' ' && string.charAt(n) != '\t')) {
                            string2 = string2 + string.charAt(n);
                        } else {
                            bl3 = true;
                            string3 = "";
                            string4 = "";
                            if (!string5.equals("")) {
                                stringBuffer.append(string5);
                                string5 = "";
                            }
                            if (!string2.equals("")) {
                                stringBuffer.append(string2);
                                string2 = "";
                            }
                            stringBuffer.append(string.charAt(n));
                        }
                    }
                } else if (string.charAt(n) != '\r' && string.charAt(n) != '\n' && string.charAt(n) != '\t') {
                    stringBuffer.append(string.charAt(n));
                }
                if (string.charAt(n) != '?' || !bl2) continue;
                ++n2;
            }
            if (!string5.equals("")) {
                stringBuffer.append(string5);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    static {
        m_decodeTextStrict = true;
        m_foldEncodedWords = false;
        m_mapMimeToJava = new Hashtable(40);
        m_mapJavaToMime = new Hashtable(10);
        try {
            String string = System.getProperty("mail.mime.decodetext.strict");
            m_decodeTextStrict = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.foldencodedwords");
            m_foldEncodedWords = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        m_mapJavaToMime.put("8859_1", "ISO-8859-1");
        m_mapJavaToMime.put("iso8859_1", "ISO-8859-1");
        m_mapJavaToMime.put("iso8859-1", "ISO-8859-1");
        m_mapJavaToMime.put("8859_2", "ISO-8859-2");
        m_mapJavaToMime.put("iso8859_2", "ISO-8859-2");
        m_mapJavaToMime.put("iso8859-2", "ISO-8859-2");
        m_mapJavaToMime.put("8859_3", "ISO-8859-3");
        m_mapJavaToMime.put("iso8859_3", "ISO-8859-3");
        m_mapJavaToMime.put("iso8859-3", "ISO-8859-3");
        m_mapJavaToMime.put("8859_4", "ISO-8859-4");
        m_mapJavaToMime.put("iso8859_4", "ISO-8859-4");
        m_mapJavaToMime.put("iso8859-4", "ISO-8859-4");
        m_mapJavaToMime.put("8859_5", "ISO-8859-5");
        m_mapJavaToMime.put("iso8859_5", "ISO-8859-5");
        m_mapJavaToMime.put("iso8859-5", "ISO-8859-5");
        m_mapJavaToMime.put("8859_6", "ISO-8859-6");
        m_mapJavaToMime.put("iso8859_6", "ISO-8859-6");
        m_mapJavaToMime.put("iso8859-6", "ISO-8859-6");
        m_mapJavaToMime.put("8859_7", "ISO-8859-7");
        m_mapJavaToMime.put("iso8859_7", "ISO-8859-7");
        m_mapJavaToMime.put("iso8859-7", "ISO-8859-7");
        m_mapJavaToMime.put("8859_8", "ISO-8859-8");
        m_mapJavaToMime.put("iso8859_8", "ISO-8859-8");
        m_mapJavaToMime.put("iso8859-8", "ISO-8859-8");
        m_mapJavaToMime.put("8859_9", "ISO-8859-9");
        m_mapJavaToMime.put("iso8859_9", "ISO-8859-9");
        m_mapJavaToMime.put("iso8859-9", "ISO-8859-9");
        m_mapJavaToMime.put("sjis", "Shift_JIS");
        m_mapJavaToMime.put("ms932", "Shift_JIS");
        m_mapJavaToMime.put("jis", "ISO-java-JP");
        m_mapJavaToMime.put("iso2022jp", "ISO-2022-JP");
        m_mapJavaToMime.put("euc_jp", "euc-jp");
        m_mapJavaToMime.put("koi8_r", "koi8-r");
        m_mapJavaToMime.put("euc_cn", "euc-cn");
        m_mapJavaToMime.put("euc_tw", "euc-tw");
        m_mapJavaToMime.put("euc_kr", "euc-kr");
        m_mapJavaToMime.put("x-oracle-iso2022-jp", "ISO-2022-JP");
        m_mapJavaToMime.put("x-oracle-iso2022-jp-outlook", "ISO-2022-JP");
        m_mapJavaToMime.put("x-oracle-iso2022-jp-outlook-hwkana", "ISO-2022-JP");
        m_mapJavaToMime.put("iso8859_8", "ISO-8859-8-I");
        m_mapJavaToMime.put("iso-8859-8", "ISO-8859-8-I");
        m_mapMimeToJava.put("iso-2022-cn", "ISO2022CN");
        m_mapMimeToJava.put("iso-2022-kr", "ISO2022KR");
        m_mapMimeToJava.put("utf-8", "UTF8");
        m_mapMimeToJava.put("utf8", "UTF8");
        m_mapMimeToJava.put("ja_jp.iso2022-7", "ISO2022JP");
        m_mapMimeToJava.put("ja_jp.eucjp", "EUCJIS");
        m_mapMimeToJava.put("euc-kr", "KSC5601");
        m_mapMimeToJava.put("euckr", "KSC5601");
        m_mapMimeToJava.put("us-ascii", "ISO-8859-1");
        m_mapMimeToJava.put("x-us-ascii", "ISO-8859-1");
        m_mapMimeToJava.put("x-gbk", "GBK");
        m_mapMimeToJava.put("iso-8859-8-i", "ISO-8859-8");
        base64_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        SPECIALWORD = "=_?\"[\\]#$(),.:;%&'<>@^`{|}~";
        SPECIALTEXT = "=_?";
        hex_array = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

