/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class UserAndGroupFixes {
    public static final String SEPARATOR = " ";
    public static final String GROUP_STRING = "GROUP";
    public static final String USERS_STRING = "USERS";
    public static final String USERS_GROUPS = "USERS_GROUPS";
    public static final String ADD_USER_TO_GROUP = "ADD_USER_TO_GROUP";
    public static final String CHANGE_PRIMARY_GROUP = "CHANGE_PRIMARY_GROUP";
    public static final String USERS_PRIMARY_GROUP = "USERS_PRIMARY_GROUP";
    public static final String CREATE_GROUPS = "CREATE_GROUPS";
    public static final String CREATE_USERS = "CREATE_USERS";
    public static final String EQUALS = "=";
    public static final String APOSTROPHE = "\"";
    public static final String COMMA = ",";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String REMOVE_USER_FROM_GROUP_ENABLE = "REMOVE_USER_FROM_GROUP_ENABLE";
    public static final String REMOVE_USER = "REMOVE_USER";
    public static final String REMOVE_FROM_GROUP = "REMOVE_FROM_GROUP";

    public static OipcfFixUpResult createGroups(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return UserAndGroupFixes.createUsersOrGroups(re, refhost, res, outfiles, CREATE_GROUPS, GROUP_STRING);
    }

    public static OipcfFixUpResult createUsers(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return UserAndGroupFixes.createUsersOrGroups(re, refhost, res, outfiles, CREATE_USERS, USERS_STRING);
    }

    public static OipcfFixUpResult createUsersOrGroups(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles, String enableFileString, String responseFileString) {
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult;
        }
        ArrayList<String> oGroupsList = new ArrayList<String>();
        Iterator iter = null;
        if (res != null) {
            iter = res.getResultDetails();
        } else {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult;
        }
        while (iter.hasNext()) {
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            int nResult = oResultDetails.getResult();
            if (nResult != 7) continue;
            String sExpectedGroup = (String)oResultDetails.getExpectedData();
            if (sExpectedGroup == null) {
                OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            oGroupsList.add(sExpectedGroup);
        }
        try {
            UserAndGroupFixes.instantiateResponseFile(sResponseFile, oGroupsList, responseFileString);
            UserAndGroupFixes.instantiateEnableFile(sEnableFile, enableFileString);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    public static OipcfFixUpResult changePrimaryGroupForUsers(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return UserAndGroupFixes.allocateGroupsToUsers(re, refhost, res, outfiles, CHANGE_PRIMARY_GROUP, USERS_PRIMARY_GROUP);
    }

    public static OipcfFixUpResult addUserToGroups(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return UserAndGroupFixes.allocateGroupsToUsers(re, refhost, res, outfiles, ADD_USER_TO_GROUP, USERS_GROUPS);
    }

    public static OipcfFixUpResult allocateGroupsToUsers(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles, String enableString, String responseString) {
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult;
        }
        Iterator iter = null;
        if (res == null) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult;
        }
        iter = res.getResultDetails();
        String sExpectedValue = null;
        String sUserName = null;
        String sGroupName = null;
        ArrayList oUserGroupList = new ArrayList();
        while (iter.hasNext()) {
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            sExpectedValue = (String)oResultDetails.getExpectedData();
            if (sExpectedValue == null) {
                OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            int nIndexOfComma = sExpectedValue.indexOf(COMMA);
            sUserName = sExpectedValue.substring(0, nIndexOfComma);
            int nIndexOfEquals = sUserName.indexOf(EQUALS);
            sUserName = sUserName.substring(nIndexOfEquals + 1);
            sGroupName = sExpectedValue.substring(nIndexOfComma + 1);
            nIndexOfEquals = sGroupName.indexOf(EQUALS);
            sGroupName = sGroupName.substring(nIndexOfEquals + 1);
            UserAndGroupFixes.addToList(sUserName, sGroupName, oUserGroupList);
        }
        try {
            UserAndGroupFixes.instantiateResponseFile(sResponseFile, oUserGroupList, responseString);
            UserAndGroupFixes.instantiateEnableFile(sEnableFile, enableString);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateResponseFile(String sResponseFile, List contentsList, String sFeature) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        String sValue = "";
        for (int i = 0; i < contentsList.size(); ++i) {
            sValue = sValue + contentsList.get(i);
            sValue = sValue + SEPARATOR;
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(sFeature)) continue;
            line = sFeature + EQUALS + APOSTROPHE + sValue + APOSTROPHE;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = sFeature + EQUALS + APOSTROPHE + sValue + APOSTROPHE;
            fileContentsList.add(line);
        }
        try {
            UserAndGroupFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateEnableFile(String sEnableFile, String sFeature) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(sFeature)) continue;
            line = sFeature + EQUALS + ENABLE_STRING;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = sFeature + EQUALS + ENABLE_STRING;
            fileContentsList.add(line);
        }
        try {
            UserAndGroupFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }

    private static void addToList(String userName, String groupName, List userGroupList) {
        String sUserNameInList = null;
        String sUserGroups = null;
        String finalString = null;
        boolean bCheck = false;
        for (int i = 0; i < userGroupList.size(); ++i) {
            sUserGroups = (String)userGroupList.get(i);
            int indexOfColon = sUserGroups.indexOf(":");
            if (indexOfColon == -1 || !(sUserNameInList = sUserGroups.substring(0, indexOfColon)).equals(userName)) continue;
            finalString = sUserGroups + COMMA + groupName;
            userGroupList.set(i, finalString);
            bCheck = true;
        }
        if (!bCheck) {
            finalString = userName + ":" + groupName;
            userGroupList.add(finalString);
        }
    }

    public static OipcfFixUpResult removeUserFromGroup(String enableFile, String responseFile, String user, String group) {
        ArrayList<String> outfiles = new ArrayList<String>();
        outfiles.add(enableFile);
        outfiles.add(responseFile);
        try {
            UserAndGroupFixes.instantiateEnableFile(enableFile, REMOVE_USER_FROM_GROUP_ENABLE);
            UserAndGroupFixes.instantiateResponseFileStringValue(responseFile, user, REMOVE_USER);
            UserAndGroupFixes.instantiateResponseFileStringValue(responseFile, group, REMOVE_FROM_GROUP);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateResponseFileStringValue(String sResponseFile, String data, String sFeature) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(sFeature)) continue;
            line = sFeature + EQUALS + APOSTROPHE + data + APOSTROPHE;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = sFeature + EQUALS + APOSTROPHE + data + APOSTROPHE;
            fileContentsList.add(line);
        }
        try {
            UserAndGroupFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }
}

