/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class ShellLimitFixes {
    public static final String EQUALS = "=";
    public static final String APOSTROPHE = "\"";
    public static final int[] RECOMMENDED_LIMITS = new int[]{0, 0, 0, 0, 0, 0};
    public static final String SET_SHELL_LIMITS = "SET_SHELL_LIMITS";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String ULIMIT_ERROR_HARDLIMIT_PROCESS = "Maxproc HardLimit Value ";
    public static final String ULIMIT_ERROR_HARDLIMIT_FILES = "Descriptor HardLimit Value ";
    public static final String ULIMIT_ERROR_HARDLIMIT_STACK = "Stack HardLimit Value ";
    public static final String ULIMIT_ERROR_SOFTLIMIT_PROCESS = "Maxproc SoftLimit Value ";
    public static final String ULIMIT_ERROR_SOFTLIMIT_FILES = "Descriptor SoftLimit Value ";
    public static final String ULIMIT_ERROR_SOFTLIMIT_STACK = "Stack SoftLimit Value ";
    public static final String LIMIT_ERROR_PROCESS = "Limit on maximum number of processes for a single user: ";
    public static final String LIMIT_ERROR_FILES = "Limit on maximum number of open file descriptors: ";
    public static final String MAX_PROCESSES_HARDLIMIT = "MAX_PROCESSES_HARDLIMIT";
    public static final String MAX_PROCESSES_SOFTLIMIT = "MAX_PROCESSES_SOFTLIMIT";
    public static final String FILE_OPEN_MAX_HARDLIMIT = "FILE_OPEN_MAX_HARDLIMIT";
    public static final String FILE_OPEN_MAX_SOFTLIMIT = "FILE_OPEN_MAX_SOFTLIMIT";
    public static final String MAX_STACK_HARDLIMIT = "MAX_STACK_HARDLIMIT";
    public static final String MAX_STACK_SOFTLIMIT = "MAX_STACK_SOFTLIMIT";
    public static final String FAILED = "FAILED";
    public static final String UNITKB = "KB";
    public static final String UNITMB = "MB";
    public static final String ATMOST = "ATMOST";
    public static final String[] ULIMIT_PROPERTY = new String[]{"Maxproc HardLimit Value ", "Descriptor HardLimit Value ", "Stack HardLimit Value ", "Maxproc SoftLimit Value ", "Descriptor SoftLimit Value ", "Stack SoftLimit Value "};
    public static final String[] LIMIT_PROPERTY = new String[]{"Limit on maximum number of processes for a single user: ", "Limit on maximum number of open file descriptors: "};
    public static final String[] SHELL_PROPERTY = new String[]{"MAX_PROCESSES_HARDLIMIT", "FILE_OPEN_MAX_HARDLIMIT", "MAX_STACK_HARDLIMIT", "MAX_PROCESSES_SOFTLIMIT", "FILE_OPEN_MAX_SOFTLIMIT", "MAX_STACK_SOFTLIMIT"};

    public static OipcfFixUpResult fixShellLimits(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult;
        }
        Iterator iter = null;
        if (res == null) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult;
        }
        iter = res.getResultDetails();
        String sActualData = null;
        String sExpectedData = null;
        int index = -1;
        int exindex = -1;
        int nextIndex = -1;
        int exnextIndex = -1;
        ArrayList<String> listOfValues = new ArrayList<String>();
        String sValue = null;
        String exsValue = null;
        int iValue = 0;
        int exiValue = 0;
        int multifactor = 1000;
        while (iter.hasNext()) {
            int i;
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            sActualData = (String)oResultDetails.getActualData();
            if (sActualData == null) {
                OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            sExpectedData = (String)oResultDetails.getExpectedData();
            if (sExpectedData == null) {
                OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            boolean isAtmost = false;
            for (i = 0; i < ULIMIT_PROPERTY.length; ++i) {
                exindex = sExpectedData.indexOf(ULIMIT_PROPERTY[i]);
                if (exindex == -1) continue;
                exnextIndex = sExpectedData.indexOf("\n", exindex + 1);
                exsValue = exnextIndex == -1 ? sExpectedData.substring(exindex + ULIMIT_PROPERTY[i].length(), sExpectedData.length()) : sExpectedData.substring(exindex + ULIMIT_PROPERTY[i].length(), nextIndex);
                int kbindex = -1;
                int mbindex = -1;
                int atmostindex = -1;
                kbindex = exsValue.indexOf(UNITKB);
                mbindex = exsValue.indexOf(UNITMB);
                if (kbindex != -1 || mbindex != -1) {
                    exsValue = exsValue.replaceAll(UNITKB, "");
                    atmostindex = (exsValue = exsValue.replaceAll(UNITMB, "")).indexOf(ATMOST);
                    if (atmostindex != -1) {
                        isAtmost = true;
                        exsValue = exsValue.replaceAll(ATMOST, "");
                    }
                    exsValue = exsValue.trim();
                }
                exiValue = Integer.parseInt(exsValue);
                if (mbindex != -1) {
                    exiValue *= multifactor;
                }
                ShellLimitFixes.RECOMMENDED_LIMITS[i] = exiValue;
            }
            for (i = 0; i < ULIMIT_PROPERTY.length; ++i) {
                index = sActualData.indexOf(ULIMIT_PROPERTY[i]);
                if (index == -1) continue;
                nextIndex = sActualData.indexOf("\n", index + 1);
                sValue = nextIndex == -1 ? sActualData.substring(index + ULIMIT_PROPERTY[i].length(), sActualData.length()) : sActualData.substring(index + ULIMIT_PROPERTY[i].length(), nextIndex);
                sValue = sValue.replaceAll(UNITKB, "");
                int mbindex = -1;
                mbindex = sValue.indexOf(UNITMB);
                sValue = sValue.replaceAll(UNITMB, "");
                sValue = sValue.trim();
                iValue = Integer.parseInt(sValue);
                if (mbindex != -1) {
                    iValue *= multifactor;
                }
                if (!isAtmost && iValue < RECOMMENDED_LIMITS[i]) {
                    listOfValues.add(SHELL_PROPERTY[i] + EQUALS + APOSTROPHE + RECOMMENDED_LIMITS[i] + APOSTROPHE);
                }
                if (!isAtmost || iValue <= RECOMMENDED_LIMITS[i]) continue;
                listOfValues.add(SHELL_PROPERTY[i] + EQUALS + APOSTROPHE + RECOMMENDED_LIMITS[i] + APOSTROPHE);
            }
        }
        String username = System.getProperty("user.name");
        listOfValues.add("INSTALL_USER=\"" + username + APOSTROPHE);
        try {
            ShellLimitFixes.instantiateEnableFile(sEnableFile);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        try {
            ShellLimitFixes.instantiateResponseFile(sResponseFile, listOfValues);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateEnableFile(String sEnableFile) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(SET_SHELL_LIMITS)) continue;
            line = "SET_SHELL_LIMITS=\"true\"";
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = "SET_SHELL_LIMITS=\"true\"";
            fileContentsList.add(line);
        }
        try {
            ShellLimitFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateResponseFile(String sResponseFile, List paramValueList) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        ArrayList<String> oAbsentParamList = new ArrayList<String>();
        for (int i = 0; i < paramValueList.size(); ++i) {
            boolean bCheck = false;
            String sResultString = (String)paramValueList.get(i);
            String sCompareString = sResultString.substring(0, sResultString.indexOf(EQUALS));
            for (int j = 0; j < fileContentsList.size(); ++j) {
                line = (String)fileContentsList.get(j);
                if (!line.startsWith(sCompareString)) continue;
                line = sResultString;
                fileContentsList.set(j, line);
                bCheck = true;
                break;
            }
            if (bCheck) continue;
            oAbsentParamList.add(sResultString);
        }
        fileContentsList.addAll(oAbsentParamList);
        try {
            ShellLimitFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

