/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class InventoryFixes {
    public static final String CENTRAL_INVENTORY = "CENTRAL_INVENTORY";
    public static final String ENABLE_INVENTORY_PERMS = "SET_INVENTORY_PERMISSIONS";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String EQUALS = "=";

    public static OipcfFixUpResult enableFixForInventoryWritability(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.PASSED);
        if (res != null) {
            if (res.getComputedResult() == 7) {
                String sResponseFile = (String)outfiles.get(0);
                String sEnableFile = (String)outfiles.get(1);
                if (sResponseFile == null || !new File(sResponseFile).exists()) {
                    oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
                } else if (sEnableFile == null || !new File(sEnableFile).exists()) {
                    oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
                } else {
                    Iterator iter = null;
                    iter = res.getResultDetails();
                    OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
                    String sExpectedData = (String)oResultDetails.getExpectedData();
                    if (sExpectedData == null) {
                        oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                        return oFixUpResult;
                    }
                    try {
                        InventoryFixes.instantiateEnableFile(sEnableFile);
                    }
                    catch (IOException e) {
                        oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
                        return oFixUpResult;
                    }
                    try {
                        InventoryFixes.instantiateResponseFile(sResponseFile, sExpectedData);
                    }
                    catch (IOException e) {
                        oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
                        return oFixUpResult;
                    }
                }
            }
        } else {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
        }
        return oFixUpResult;
    }

    private static void instantiateEnableFile(String sEnableFile) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(ENABLE_INVENTORY_PERMS)) continue;
            line = "SET_INVENTORY_PERMISSIONS=\"true\"";
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = "SET_INVENTORY_PERMISSIONS=\"true\"";
            fileContentsList.add(line);
        }
        try {
            InventoryFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateResponseFile(String sResponseFile, String sExpectedData) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(CENTRAL_INVENTORY)) continue;
            line = "CENTRAL_INVENTORY=" + sExpectedData;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = "CENTRAL_INVENTORY=" + sExpectedData;
            fileContentsList.add(line);
        }
        try {
            InventoryFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

