/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;

public class GeneralHelper {
    public static final Class[] ARG_HTTP_SERVLET_REQUEST_CLASS = new Class[]{HttpServletRequest.class};
    public static final String LOCALE_STR = "locale";
    public static final String LANGUAGE_STR = "language";
    public static final String TERRITORY_STR = "territory";
    public static final String CHARSET_STR = "charset";
    public static final String TIMEZONE_STR = "timezone";
    public static final String ISO_CURRENCY_STR = "iso-currency";
    public static final String LINGUISTIC_SORT_STR = "linguistic-sort";
    public static final String DATE_FORMAT_STR = "date-format";
    public static final String LONG_DATE_FORMAT_STR = "long-date-format";
    public static final String TIME_FORMAT_STR = "time-format";
    public static final String DATE_TIME_FORMAT_STR = "date-time-format";
    public static final String LONG_DATE_TIME_FORMAT_STR = "long-date-time-format";
    public static final String NUMBER_FORMAT_STR = "number-format";
    public static final String CURRENCY_FORMAT_STR = "currency-format";
    public static final String WRITING_DIRECTION_STR = "writing-direction";
    public static final String COMMAND_STR = "command";
    public static final String LOCALE_SOURCE_STR = "locale-source";
    public static final char LOCALE_DELIMITER = '#';
    public static final String AUTO_CHARSET = "AUTO-CHARSET";

    private GeneralHelper() {
    }

    public static Object callStaticMethod(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        try {
            return clazz.getMethod(string, classArray).invoke((Object)classArray, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException().getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage());
        }
    }

    static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '\uffffffd1') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException(malformedURLException2.getMessage());
            }
        }
        return uRL;
    }

    public static String getIANACharacterSetFromCs(String string) throws UnsupportedEncodingException {
        String string2 = string.toUpperCase(Locale.US);
        if (!string2.equals(AUTO_CHARSET)) {
            String string3 = LocaleMapper.getIANACharacterSet((int)1, (String)string2);
            if (string3 == null) {
                String string4 = LocaleMapper.getOraCharacterSet((int)2, (String)string2);
                if (string4 == null) {
                    throw new UnsupportedEncodingException(GDKMessage.getMessage(5210, (Object)string2));
                }
            } else {
                string2 = string3;
            }
        }
        return string2;
    }
}

