/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.util.Vector;
import oracle.net.nl.NLException;
import oracle.net.nl.UninitializedObjectException;

public final class NVTokens {
    public static final int TKN_NONE = 0;
    public static final int TKN_LPAREN = 1;
    public static final int TKN_RPAREN = 2;
    public static final int TKN_COMMA = 3;
    public static final int TKN_EQUAL = 4;
    public static final int TKN_LITERAL = 8;
    public static final int TKN_EOS = 9;
    private static final char TKN_LPAREN_VALUE = '(';
    private static final char TKN_RPAREN_VALUE = ')';
    private static final char TKN_COMMA_VALUE = ',';
    private static final char TKN_EQUAL_VALUE = '=';
    private static final char TKN_BKSLASH_VALUE = '\\';
    private static final char TKN_DQUOTE_VALUE = '\"';
    private static final char TKN_SQUOTE_VALUE = '\'';
    private static final char TKN_EOS_VALUE = '%';
    private static final char TKN_SPC_VALUE = ' ';
    private static final char TKN_TAB_VALUE = '\t';
    private static final char TKN_LF_VALUE = '\n';
    private static final char TKN_CR_VALUE = '\r';
    private Vector _tkType = null;
    private Vector _tkValue = null;
    private int _numTokens = 0;
    private int _tkPos = 0;

    private static boolean _isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static String _trimWhiteSpace(String string) {
        int n;
        int n2 = string.length();
        int n3 = n2;
        for (n = 0; n < n2 && NVTokens._isWhiteSpace(string.charAt(n)); ++n) {
        }
        while (n < n3 && NVTokens._isWhiteSpace(string.charAt(n3 - 1))) {
            --n3;
        }
        return string.substring(n, n3);
    }

    public boolean parseTokens(String string) {
        this._numTokens = 0;
        this._tkPos = 0;
        this._tkType = new Vector(25, 25);
        this._tkValue = new Vector(25, 25);
        int n = string.length();
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        block6: while (n2 < n) {
            while (n2 < n && NVTokens._isWhiteSpace(cArray[n2])) {
                ++n2;
            }
            if (n2 >= n) continue;
            switch (cArray[n2]) {
                case '(': {
                    bl = false;
                    this._addToken(1, '(');
                    ++n2;
                    continue block6;
                }
                case '=': {
                    bl = true;
                    this._addToken(4, '=');
                    ++n2;
                    continue block6;
                }
                case ')': {
                    bl = false;
                    this._addToken(2, ')');
                    ++n2;
                    continue block6;
                }
                case ',': {
                    bl = false;
                    this._addToken(3, ',');
                    ++n2;
                    continue block6;
                }
            }
            int n3 = n2;
            int n4 = -1;
            boolean bl2 = false;
            char c = '\"';
            if (cArray[n2] == '\'' || cArray[n2] == '\"') {
                bl2 = true;
                c = cArray[n2];
                ++n2;
            }
            while (n2 < n) {
                if (cArray[n2] == '\\') {
                    n2 += 2;
                    continue;
                }
                if (bl2) {
                    if (cArray[n2] == c) {
                        n4 = ++n2;
                        break;
                    }
                } else if (cArray[n2] == '(' || cArray[n2] == ')' || cArray[n2] == ',' && !bl || cArray[n2] == '=' && !bl) {
                    n4 = n2;
                    break;
                }
                ++n2;
            }
            if (n4 == -1) {
                n4 = n2;
            }
            this._addToken(8, NVTokens._trimWhiteSpace(string.substring(n3, n4)));
        }
        this._addToken(9, '%');
        return true;
    }

    public int getToken() throws NLException {
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos < this._numTokens) {
            return (Integer)this._tkType.elementAt(this._tkPos);
        }
        throw new NLException("NoLiterals-04610", "");
    }

    public int popToken() throws UninitializedObjectException, NLException {
        int n = 0;
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        n = (Integer)this._tkType.elementAt(this._tkPos++);
        return n;
    }

    public String getLiteral() throws NLException {
        String string = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        string = (String)this._tkValue.elementAt(this._tkPos);
        return string;
    }

    public String popLiteral() throws NLException {
        String string = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        string = (String)this._tkValue.elementAt(this._tkPos++);
        return string;
    }

    public void eatToken() {
        if (this._tkPos < this._numTokens) {
            ++this._tkPos;
        }
    }

    public String toString() {
        if (this._tkType == null) {
            return "*NO TOKENS*";
        }
        String string = "Tokens";
        for (int i = 0; i < this._numTokens; ++i) {
            string = string + " : " + this._tkValue.elementAt(i);
        }
        return string;
    }

    public void println() {
        System.out.println(this.toString());
    }

    private void _addToken(int n, char c) {
        this._addToken(n, String.valueOf(c));
    }

    private void _addToken(int n, String string) {
        this._tkType.addElement(new Integer(n));
        this._tkValue.addElement(string);
        ++this._numTokens;
    }
}

