/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ldap;

import oracle.net.common.OracleJNI;
import oracle.net.ldap.NNFLException;
import oracle.net.ldap.NNFLUpdateParam;

public class NNFLWrapper {
    byte[] pCtx;
    byte[] pGbl;
    byte[] pRes;
    public String currDN = null;
    public String adminCtx;
    public String currAttr = null;
    public String[] currVals = null;
    public byte[][] currBinVals = null;
    public int numVals = 0;
    public String[] directoryServers;
    public String userDN;
    public String versionString;
    public String[] matchingSchemaVersions;
    public static final int NNFL_DIRTYPE_OID = 1;
    public static final int NNFL_DIRTYPE_AD = 2;
    public static final int NNFL_DIRTYPE_NETSCAPE = 4;
    public static final int NNFL_DIRTYPE_NDS = 8;
    public static final int NNFL_DIRTYPE_UNKNOWN = 4096;
    public static final int NNFL_AUTH_NONE = 0;
    public static final int NNFL_AUTH_SIMPLE = 1;
    public static final int NNFL_AUTH_KRBV4 = 2;
    public static final int NNFL_AUTH_KRBV41 = 3;
    public static final int NNFL_AUTH_KRBV42 = 4;
    public static final int NNFL_AUTH_SSL_NOAUTH = 5;
    public static final int NNFL_AUTH_SSL_ONEWAY = 6;
    public static final int NNFL_AUTH_SSL_TWOWAY = 7;
    public static final int NNFL_AUTH_NATIVE = 8;
    public static final int NNFL_OPT_SIZELIMIT = 3;
    public static final int NNFL_OPT_TIMELIMIT = 4;
    public static final int NNFL_SCOPE_BASE = 0;
    public static final int NNFL_SCOPE_ONELEVEL = 1;
    public static final int NNFL_SCOPE_SUBTREE = 2;
    public static final int NNFLUNE_CREATE = 0;
    public static final int NNFLUNE_ADD = 1;
    public static final int NNFLUNE_DELETE = 2;
    public static final int NNFLUNE_REPLACE = 3;

    public NNFLWrapper() {
        this.native_init();
    }

    public void finalize() {
        this.unbind();
        this.native_deinit();
    }

    public static void reloadParams() {
        NNFLWrapper nNFLWrapper = new NNFLWrapper();
        nNFLWrapper.native_reloadParams();
        nNFLWrapper = null;
    }

    public int setAuthInfo(int n, String[] stringArray) {
        int n2 = this.native_nnflsai(n, stringArray);
        return n2;
    }

    public int readNamedEntry(String string) {
        int n = this.native_nnflrne(string);
        return n;
    }

    public int getDirServerType() {
        int n = this.native_nnflgdt();
        return n;
    }

    public int getBaseAdminCtx() {
        int n = this.native_nnflgba();
        return n;
    }

    public int setBaseAdminCtx(String string) {
        int n = this.native_nnflsba(string);
        if (n != -1) {
            this.adminCtx = string;
        }
        return n;
    }

    public String[] getDirectoryServers() {
        int n = this.native_nnflgds();
        if (n == 0) {
            return this.directoryServers;
        }
        return null;
    }

    public String getNativeDN() {
        int n = this.native_nnflgndn();
        if (n == 0) {
            return this.userDN;
        }
        return null;
    }

    public String getSSLDN(String string, String string2) {
        int n = this.native_nnflgsdn(string, string2);
        if (n == 0) {
            return this.userDN;
        }
        return null;
    }

    public boolean verifySchemaVersion(String string, String string2) {
        int n = this.native_nnflverc(string, string2);
        return n == 0;
    }

    public int openBindConn(String string, int n, String string2, String string3, int n2, int[] nArray) {
        int n3 = this.native_nnflobc(string == null ? "" : string, n, string2 == null ? "" : string2, string3 == null ? "" : string3, n2, nArray);
        return n3;
    }

    public int setOptions(int n, int n2) {
        int n3 = this.native_nnflsop(n, n2);
        return n3;
    }

    public String getContextVersion(String string) throws NNFLException {
        int n = this.native_nnflgctxver(string);
        if (n != 0) {
            throw new NNFLException(n);
        }
        return this.versionString;
    }

    public String getProductSchemaVersion(String string) throws NNFLException {
        int n = this.native_nnflgschver(string);
        if (n != 0) {
            throw new NNFLException(n);
        }
        return this.versionString;
    }

    public int queryByFilter(String string, int n, String string2, String[] stringArray, boolean bl) {
        int n2 = this.native_nnflqbf(string, n, string2, stringArray, bl);
        return n2;
    }

    public int unbind() {
        return this.native_nnfldlc();
    }

    public int nameToX500(String string, boolean bl, boolean bl2, boolean bl3) {
        int n = this.native_nnfln2x(string, bl, bl2, bl3);
        return n;
    }

    public int discConn() {
        return this.native_nnfldlc();
    }

    public int closeConn() {
        int n = this.native_nnflcls();
        return n;
    }

    public int getNextEntry() {
        int n = this.native_nnflgne();
        return n;
    }

    public int getAttrValues(String string) {
        int n = this.native_nnflgav(string);
        return n;
    }

    public int getAttrBinValues(String string) {
        int n = this.native_nnflgab(string);
        return n;
    }

    public int getAttrValues() {
        int n = this.native_nnflgav(null);
        return n;
    }

    public int freeResultMemory() {
        int n = this.native_nnflfrm();
        return n;
    }

    public int deleteNamedEntry(String string) {
        int n = this.isNullPtr(this.pCtx) ? this.native_nnfldel(string) : this.native_nnfldne(string);
        return n;
    }

    public int renameEntry(String string, String string2) {
        int n = this.isNullPtr(this.pCtx) ? this.native_nnflrnm(string, string2) : this.native_nnflree(string, string2);
        return n;
    }

    public int updateEntry(String string, NNFLUpdateParam[] nNFLUpdateParamArray, int n) {
        return this.updateEntry(string, "top", nNFLUpdateParamArray, n);
    }

    public int updateEntry(String string, String string2, NNFLUpdateParam[] nNFLUpdateParamArray, int n) {
        int n2 = this.native_nnflune(string, string2, nNFLUpdateParamArray, n);
        return n2;
    }

    private boolean isNullPtr(byte[] byArray) {
        if (byArray == null) {
            return true;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    private native int native_init();

    private native int native_deinit();

    private native void native_reloadParams();

    private native int native_nnflsai(int var1, String[] var2);

    private native int native_nnflrne(String var1);

    private native int native_nnflrnm(String var1, String var2);

    private native int native_nnfldel(String var1);

    private native int native_nnflgndn();

    private native int native_nnflgsdn(String var1, String var2);

    private native int native_nnflverc(String var1, String var2);

    private native int native_nnflgds();

    private native int native_nnflgdt();

    private native int native_nnflgba();

    private native int native_nnflsba(String var1);

    private native int native_nnfldlc();

    private native int native_test(String[] var1, byte[][] var2);

    private native int native_nnflobc(String var1, int var2, String var3, String var4, int var5, int[] var6);

    private native int native_nnflcls();

    private native int native_nnflqbf(String var1, int var2, String var3, String[] var4, boolean var5);

    private native int native_nnflgne();

    private native int native_nnflgav(String var1);

    private native int native_nnflgab(String var1);

    private native int native_nnflree(String var1, String var2);

    private native int native_nnflune(String var1, String var2, NNFLUpdateParam[] var3, int var4);

    private native int native_nnfldne(String var1);

    private native int native_nnflfrm();

    private native int native_nnfln2x(String var1, boolean var2, boolean var3, boolean var4);

    private native int native_nnflres();

    private native int native_nnflaba();

    private native int native_nnflsop(int var1, int var2);

    private native int native_nnflgctxver(String var1);

    private native int native_nnflgschver(String var1);

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2;
        String string;
        int n2;
        String[] stringArray3 = new String[]{"objectClass", "cn"};
        System.out.println("instantiating NNFLWrapper 8.2 ...");
        NNFLWrapper nNFLWrapper = new NNFLWrapper();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        if (bl14) {
            n2 = nNFLWrapper.getDirServerType();
            string = n2 == 1 ? "OID" : (n2 == 2 ? "AD" : (n2 == 4 ? "NETSCAPE" : (n2 == 8 ? "NDS" : "UNKNOWN")));
            System.out.println("Directory Type is:" + string);
        }
        if (bl18) {
            System.out.println("trying to get the native DN...");
            String string2 = nNFLWrapper.getNativeDN();
            if (string2 != null) {
                System.out.println("      native DN is: " + string2);
            } else {
                System.out.println(" unable to determine native DN");
            }
        }
        if (bl19) {
            System.out.println(" Trying to get the SSL DNs...");
            System.out.println("   The following three should succeed ");
            String string3 = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/ldapserver1", "welcome1");
            string = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/ldapserver2", "welcome1");
            stringArray2 = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/ldapserver3", "welcome1");
            System.out.println("          ssl_dn1: " + string3);
            System.out.println("          ssl_dn2: " + string);
            System.out.println("          ssl_dn3: " + (String)stringArray2);
            System.out.println("   The following three should fail ");
            string3 = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/ldapserver1", "welcome3");
            string = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/", "welcome1");
            stringArray2 = nNFLWrapper.getSSLDN("file:/vobs/rdbms/test/tkzg/data/ldap/", "welcome1");
            System.out.println("          ssl_dn1: " + string3);
            System.out.println("          ssl_dn2: " + string);
            System.out.println("          ssl_dn3: " + (String)stringArray2);
        }
        if (bl17) {
            String[] stringArray4 = nNFLWrapper.getDirectoryServers();
            System.out.println("Getting directory servers");
            for (int i = 0; i < stringArray4.length; ++i) {
                System.out.println("Server #" + i + " " + stringArray4[i]);
            }
        }
        if (bl15) {
            n2 = nNFLWrapper.getBaseAdminCtx();
            System.out.println("Base admin context is:" + nNFLWrapper.adminCtx);
        }
        if (bl) {
            String[] stringArray5 = new String[]{"cn=orcladmin", "welcome"};
            nNFLWrapper.setAuthInfo(1, stringArray5);
        }
        if (bl2) {
            String string4;
            try {
                System.out.println("\n Trying to get the version of the default context...");
                string4 = nNFLWrapper.getContextVersion(null);
                System.out.println("   Default context version is: " + string4);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno);
            }
            try {
                string4 = "dc=imc,dc=com";
                System.out.println("\n Trying to get the version for the context under: " + string4 + " ...");
                String string5 = nNFLWrapper.getContextVersion(string4);
                System.out.println("   context version for " + string4 + " is: " + string5);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno);
            }
            try {
                string4 = "o=IMC,c=US";
                System.out.println("\n Trying to get the version for the context under: " + string4 + " ...");
                String string6 = nNFLWrapper.getContextVersion(string4);
                System.out.println("   context version for " + string4 + " is: " + string6);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno);
            }
            try {
                string4 = "cn=this_never_exists";
                System.out.println("\n Trying to get the version for the context under: " + string4 + " ...");
                String string7 = nNFLWrapper.getContextVersion(string4);
                System.out.println("   context version for " + string4 + " is: " + string7);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno + " (this is OK!) ");
            }
        }
        if (bl3) {
            String string8;
            try {
                string8 = "BASE";
                System.out.println("\n Trying to get the product schema version for " + string8 + " ...");
                String string9 = nNFLWrapper.getProductSchemaVersion(string8);
                System.out.println("   product schema version for " + string8 + " is: " + string9);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno);
            }
            try {
                string8 = "OracleNoNameProduct";
                System.out.println("\n Trying to get the product schema version for " + string8 + " ...");
                String string10 = nNFLWrapper.getProductSchemaVersion(string8);
                System.out.println("   product schema version for " + string8 + " is: " + string10);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno + " (this is OK!) ");
            }
            try {
                System.out.println("\n Trying to get the product schema version for null ...");
                string8 = nNFLWrapper.getProductSchemaVersion(null);
                System.out.println("   product schema version for null  is: " + string8);
            }
            catch (NNFLException nNFLException) {
                System.out.println("   Got exception: " + nNFLException.errno + " (this is OK!) ");
            }
        }
        if (bl4) {
            if (nNFLWrapper.readNamedEntry("Secret User") == 0) {
                System.out.println("DN: " + nNFLWrapper.currDN);
                while ((n = nNFLWrapper.getAttrValues()) == 0) {
                    for (int i = 0; i < nNFLWrapper.numVals; ++i) {
                        System.out.println("      " + nNFLWrapper.currAttr + "=" + nNFLWrapper.currVals[i]);
                    }
                }
                nNFLWrapper.freeResultMemory();
            } else {
                System.out.println("readNamedEntry failed");
            }
        }
        if (bl8) {
            nNFLWrapper.deleteNamedEntry("cn=blah, o=Oracle Corporation, c=US");
            nNFLWrapper.deleteNamedEntry("cn=blah2, o=Oracle Corporation, c=US");
        }
        if (bl5) {
            nNFLWrapper.renameEntry("cn=Admin2,o=Oracle Corporation,c=US", "cn=admin");
        }
        if (bl6) {
            int[] nArray = new int[]{1, 5, 5, 30};
            nNFLWrapper.openBindConn("yow", 389, "cn=orcladmin", "welcome", 1, nArray);
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[5];
            stringArray2 = new String[]{"val1", "val2", "val3"};
            nNFLUpdateParamArray[0] = new NNFLUpdateParam("cn", "une-test");
            nNFLUpdateParamArray[1] = new NNFLUpdateParam("objectClass", "person");
            nNFLUpdateParamArray[2] = new NNFLUpdateParam("sn", "une test person");
            nNFLUpdateParamArray[3] = new NNFLUpdateParam("seeAlso", stringArray2[0].getBytes());
            nNFLUpdateParamArray[4] = new NNFLUpdateParam("description", stringArray2);
            nNFLUpdateParamArray[4].addNewValue("valhoohaahaa");
            nNFLWrapper.updateEntry("cn=une-test,c=US ", "top", nNFLUpdateParamArray, 0);
            nNFLWrapper.queryByFilter("c=US", 2, "cn=une-test", null, false);
            while ((n = nNFLWrapper.getNextEntry()) == 0) {
                int n3;
                System.out.println("DN: " + nNFLWrapper.currDN);
                while ((n = nNFLWrapper.getAttrValues()) == 0) {
                    for (n3 = 0; n3 < nNFLWrapper.numVals; ++n3) {
                        System.out.println("     " + nNFLWrapper.currAttr + "=" + nNFLWrapper.currVals[n3]);
                    }
                }
                n = nNFLWrapper.getAttrBinValues("uid");
                if (n == 0) {
                    for (n3 = 0; n3 < nNFLWrapper.numVals; ++n3) {
                        System.out.println("     Binary:" + nNFLWrapper.currAttr + "=" + new String(nNFLWrapper.currBinVals[n3]));
                    }
                    continue;
                }
                System.out.println("Had a problem with binary attr get");
            }
        }
        if (bl7) {
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[2];
            String string11 = "une-test binary";
            stringArray2 = "my description in binary";
            nNFLUpdateParamArray[0] = new NNFLUpdateParam("cn", string11.getBytes());
            nNFLUpdateParamArray[1] = new NNFLUpdateParam("description", stringArray2.getBytes());
            nNFLWrapper.updateEntry("cn=une-test,c=US ", "top", nNFLUpdateParamArray, 1);
        }
        if (bl9) {
            int[] nArray = new int[]{1, 5, 5, 30};
            nNFLWrapper.openBindConn("", 9000, "cn=orcladmin", "welcome", 1, nArray);
        }
        if (bl10) {
            nNFLWrapper.deleteNamedEntry("cn=foo, o=Oracle Corporation, c=US");
        }
        if (bl11) {
            nNFLWrapper.queryByFilter("cn=Ashu", 2, "objectclass=*", null, false);
        }
        if (bl12) {
            while ((n = nNFLWrapper.getNextEntry()) == 0) {
                System.out.println("DN: " + nNFLWrapper.currDN);
                while ((n = nNFLWrapper.getAttrValues()) == 0) {
                    for (int i = 0; i < nNFLWrapper.numVals; ++i) {
                        System.out.println("     " + nNFLWrapper.currAttr + "=" + nNFLWrapper.currVals[i]);
                    }
                }
            }
        }
        if (bl13) {
            nNFLWrapper.nameToX500("listener1", true, false, true);
            System.out.println("Modified name is :" + nNFLWrapper.currDN);
        }
        if (bl16) {
            System.out.println("Changing base admin context to: cn=Ashu");
            int n4 = nNFLWrapper.setBaseAdminCtx("cn=Ashu");
            if (n4 < 0) {
                System.out.println("Had a problem changing the base admin context");
                int n5 = nNFLWrapper.getBaseAdminCtx();
                System.out.println("Old base admin context is:" + nNFLWrapper.adminCtx);
            } else {
                int n6 = nNFLWrapper.getBaseAdminCtx();
                System.out.println("New base admin context is:" + nNFLWrapper.adminCtx);
            }
        }
        if (bl13) {
            nNFLWrapper.nameToX500("listener1", true, false, true);
            System.out.println("Modified name is :" + nNFLWrapper.currDN);
        }
        if (bl9) {
            nNFLWrapper.closeConn();
        }
        System.out.println("...done");
    }

    static {
        OracleJNI.loadJniLibrary("nldapj");
    }
}

