/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.config.AddressConfig;
import oracle.net.config.AddressListConfig;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAliasException;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class ServiceAlias {
    public static String NULL_DOMAIN = ".";
    public static final int SERVER_ANY = 0;
    public static final int SERVER_SHARED = 1;
    public static final int SERVER_DEDICATED = 2;
    protected String name = "";
    protected Vector endpoints = new Vector();
    protected String[] endpointNames = new String[0];
    private static final String HTTP_SERVICE_NAME = "MODOSE";
    private static final String HTTP_PRESENTATION_DEFAULT = "(PRESENTATION=http://HRService)";
    private static final String HTTP_SERVER_MODE = "(SERVER=SHARED)";
    protected String descString = null;

    public static boolean exists(Config config, String string) {
        block7: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, false)) {
                        return true;
                    }
                    break block7;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    return false;
                }
            }
            NLParamParser nLParamParser = null;
            try {
                nLParamParser = config.getNlpa(0);
            }
            catch (ConfigException configException) {
                return false;
            }
            if (nLParamParser.getNLPListElement(string) != null) {
                return true;
            }
        }
        return false;
    }

    public static void delete(Config config, String string) throws ServiceAliasException {
        if (ServiceAlias.exists(config, string)) {
            if (config.netConfigUsesLDAP()) {
                try {
                    config.getDS().delete(config, string, false, true);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ServiceAliasException(directoryServiceException);
                }
            }
            try {
                NLParamParser nLParamParser = config.getNlpa(0);
                nLParamParser.removeNLPListElement(string);
                if (nLParamParser.getNLPListSize() > 0) {
                    nLParamParser.saveNLParams();
                } else if (nLParamParser.configuredInFile()) {
                    File file = new File(config.getFilename(0));
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    config.deleteNlpa(0);
                }
            }
            catch (ConfigException configException) {
                throw new ServiceAliasException(configException);
            }
            catch (IOException iOException) {
                throw new ServiceAliasException(iOException);
            }
        }
    }

    public static String[] enumServiceAliases(Config config, String string, boolean bl) throws ServiceAliasException {
        String string2 = "objectclass=orclNetService";
        return ServiceAlias.enumServiceAliases(config, string, bl, string2);
    }

    public static String[] enumServiceAliases(Config config, String string, boolean bl, String string2, String string3) throws ServiceAliasException {
        Object[] objectArray = ServiceAlias.enumServiceAliases(config, string, bl);
        ServiceAlias serviceAlias = null;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                serviceAlias = new ServiceAlias(config, objectArray[i]);
            }
            catch (ServiceAliasException serviceAliasException) {
                if (serviceAliasException.getNestedThrowable() instanceof SOExceptionConfig && ((SOExceptionConfig)serviceAliasException.getNestedThrowable()).errno == 4) continue;
                throw serviceAliasException;
            }
            Vector vector2 = serviceAlias.getEndpoints();
            if (!ServiceAlias.selectByHostname(vector2, string2) || !ServiceAlias.selectBySid(vector2, string3)) continue;
            vector.addElement(objectArray[i]);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] enumByServiceName(Config config, String string) throws ServiceAliasException {
        string = string.toUpperCase();
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = ServiceAlias.enumServiceAliases(config, null, true);
        ServiceAlias serviceAlias = null;
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                serviceAlias = new ServiceAlias(config, objectArray[i]);
            }
            catch (ServiceAliasException serviceAliasException) {
                if (serviceAliasException.getNestedThrowable() instanceof SOExceptionConfig && ((SOExceptionConfig)serviceAliasException.getNestedThrowable()).errno == 4) continue;
                throw serviceAliasException;
            }
            Vector vector2 = serviceAlias.getEndpoints();
            if (!ServiceAlias.selectByServiceName(vector2, string)) continue;
            String string2 = (String)objectArray[i] + "=" + serviceAlias.toString();
            vector.addElement(string2);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] enumDomains(Config config) throws ServiceAliasException {
        Object object;
        int n;
        if (config.netConfigUsesLDAP()) {
            return Config.getSubContexts(null, null, config.oracleContext());
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NLParamParser nLParamParser = null;
        try {
            nLParamParser = config.getNlpa(0);
        }
        catch (ConfigException configException) {
            throw new ServiceAliasException(configException);
        }
        String[] stringArray = nLParamParser.getNLPAllNames();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = stringArray[n].indexOf(".");
                if (n2 == -1) {
                    if (hashtable.get(NULL_DOMAIN) != null) continue;
                    hashtable.put(NULL_DOMAIN, "");
                    continue;
                }
                object = stringArray[n].substring(n2 + 1);
                if (hashtable.get(((String)object).toUpperCase()) != null) continue;
                hashtable.put(((String)object).toUpperCase(), "");
            }
        }
        n = 0;
        String[] stringArray2 = new String[hashtable.size()];
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            stringArray2[n++] = (String)object.nextElement();
        }
        return stringArray2;
    }

    public static void migrateFILESToLDAPSingle(Config config, String string, String string2, boolean bl, boolean bl2) throws ServiceAliasException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            ServiceAlias serviceAlias = new ServiceAlias(config, string);
            config.netConfigUsesLDAP(true);
            if (!ServiceAlias.exists(config, string2) || bl) {
                serviceAlias.setCompiledString(serviceAlias.toString());
                serviceAlias.saveAs(config, true, string2);
            } else if (bl2) {
                throw new ServiceAliasException(3);
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            config.netConfigUsesLDAP(bl3);
            throw serviceAliasException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public static void migrateLDAPToFILESSingle(Config config, String string, String string2, boolean bl, boolean bl2) throws ServiceAliasException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            ServiceAlias serviceAlias = new ServiceAlias(config, string);
            config.netConfigUsesLDAP(false);
            if (!ServiceAlias.exists(config, string2) || bl) {
                serviceAlias.setCompiledString(serviceAlias.toString());
                serviceAlias.saveAs(config, true, string2);
            } else if (bl2) {
                throw new ServiceAliasException(3);
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            config.netConfigUsesLDAP(bl3);
            throw serviceAliasException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public static void migrateFILESToLDAPDomain(Config config, String string, String string2, boolean bl, boolean bl2) throws ServiceAliasException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            String[] stringArray = ServiceAlias.enumServiceAliases(config, string, true);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf(".");
                    String string3 = n == -1 ? stringArray[i] : stringArray[i].substring(0, n);
                    string3 = "cn=" + string3 + ", " + string2;
                    ServiceAlias.migrateFILESToLDAPSingle(config, stringArray[i], string3, bl, bl2);
                }
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            config.netConfigUsesLDAP(bl3);
            throw serviceAliasException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public static void migrateLDAPToFILESDomain(Config config, String string, String string2, boolean bl, boolean bl2) throws ServiceAliasException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            String[] stringArray = ServiceAlias.enumServiceAliases(config, string, true);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = config.getDS().getCN(stringArray[i]);
                    if (!string2.equals(NULL_DOMAIN)) {
                        string3 = string3 + "." + string2;
                    }
                    ServiceAlias.migrateLDAPToFILESSingle(config, stringArray[i], string3, bl, bl2);
                }
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            config.netConfigUsesLDAP(bl3);
            throw serviceAliasException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public static void createSimpleAlias(Config config, boolean bl, String string, String[] stringArray, String string2, String string3, String string4, int n) throws ServiceAliasException {
        if (string3 == null && string4 == null) {
            throw new ServiceAliasException(2);
        }
        String string5 = "(DESCRIPTION=";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string5 + stringArray[i];
            }
        }
        if (string2 != null) {
            string5 = string5 + string2;
        }
        if (string3 != null || string4 != null) {
            if (string3 != null) {
                string5 = string5 + "(CONNECT_DATA=(SERVICE_NAME=" + string3 + ")";
            } else if (string4 != null) {
                string5 = string5 + "(CONNECT_DATA=(SID=" + string4 + ")";
            }
            string5 = n == 2 ? string5 + "(SERVER=DEDICATED))" : (n == 1 ? string5 + "(SERVER=SHARED))" : string5 + ")");
        }
        string5 = string5 + ")";
        ServiceAlias serviceAlias = new ServiceAlias(config, string);
        DescriptionConfig descriptionConfig = null;
        try {
            descriptionConfig = new DescriptionConfig(string5, null);
        }
        catch (SOExceptionConfig sOExceptionConfig) {
            throw new ServiceAliasException(sOExceptionConfig);
        }
        Vector<DescriptionConfig> vector = new Vector<DescriptionConfig>();
        vector.addElement(descriptionConfig);
        serviceAlias.setEndpoints(vector);
        serviceAlias.save(config, bl);
    }

    public static void createSimpleAlias(Config config, boolean bl, String string, String[] stringArray, String string2, String string3, String string4) throws ServiceAliasException {
        ServiceAlias.createSimpleAlias(config, bl, string, stringArray, string2, string3, string4, 0);
    }

    public static void createHttpSimpleAlias(Config config, boolean bl, String string, String[] stringArray, String string2, String string3, String string4) throws ServiceAliasException {
        int n;
        if (string3 == null && string4 == null) {
            throw new ServiceAliasException(2);
        }
        String string5 = "(DESCRIPTION=";
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string5 = string5 + stringArray[n];
            }
        }
        if (string2 != null) {
            string5 = string5 + string2;
        }
        string5 = string5 + "(CONNECT_DATA=(SERVICE_NAME=MODOSE)(SERVER=SHARED)(PRESENTATION=http://HRService))";
        string5 = string5 + ")";
        n = string.indexOf(".");
        string = n == -1 ? "inst1_http" : "inst1_http" + string.substring(n);
        ServiceAlias serviceAlias = new ServiceAlias(config, string);
        DescriptionConfig descriptionConfig = null;
        try {
            descriptionConfig = new DescriptionConfig(string5, null);
        }
        catch (SOExceptionConfig sOExceptionConfig) {
            throw new ServiceAliasException(sOExceptionConfig);
        }
        Vector<DescriptionConfig> vector = new Vector<DescriptionConfig>();
        vector.addElement(descriptionConfig);
        serviceAlias.setEndpoints(vector);
        serviceAlias.save(config, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceAlias(Config config, String string) throws ServiceAliasException {
        NVPair nVPair;
        if (config == null || string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        if (config.netConfigUsesLDAP()) {
            try {
                Object object;
                DirectoryService directoryService = config.getDS();
                Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                String string2 = ((String[])hashtable.get("dn"))[0];
                Object object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    String[] stringArray = (String[])hashtable.get(object);
                    if (((String)object).equalsIgnoreCase("orclNetDescString")) {
                        this.descString = stringArray[0];
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase("orclNetDescName")) continue;
                    this.endpointNames = stringArray;
                    SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                    this.endpoints = schemaObjectConfigFactory.create(config, stringArray, string2, null);
                }
                if (this.endpoints.size() != 0 || this.descString == null) return;
                object2 = new SchemaObjectConfigFactory();
                object = ((SchemaObjectConfigFactory)object2).create(this.descString, "", null);
                this.endpoints.addElement(object);
                return;
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) return;
                throw new ServiceAliasException(directoryServiceException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ServiceAliasException(sOExceptionConfig);
            }
        }
        NLParamParser nLParamParser = null;
        try {
            nLParamParser = config.getNlpa(0);
        }
        catch (ConfigException configException) {
            throw new ServiceAliasException(configException);
        }
        NVPair nVPair2 = nLParamParser.getNLPListElement(string);
        if (nVPair2 == null || (nVPair = nVPair2.getListElement(0)) == null) return;
        try {
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            int[] nArray = new int[]{3, 2};
            SchemaObjectConfig schemaObjectConfig = schemaObjectConfigFactory.create(nVPair, null, nArray);
            this.endpoints.addElement(schemaObjectConfig);
            return;
        }
        catch (SOExceptionConfig sOExceptionConfig) {
            throw new ServiceAliasException(sOExceptionConfig);
        }
    }

    public Enumeration enumEndpoints() {
        return this.endpoints.elements();
    }

    public Vector getEndpoints() {
        return (Vector)this.endpoints.clone();
    }

    public String[] enumEndpointsArray() {
        String[] stringArray = new String[this.endpoints.size()];
        for (int i = 0; i < this.endpoints.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endpoints.elementAt(i);
            stringArray[i] = schemaObjectConfig.toString();
        }
        return stringArray;
    }

    public void setEndpoints(Vector vector) throws ServiceAliasException {
        this.checkEndpoints(vector);
        this.endpoints = vector;
    }

    public void remEndpoints() {
        this.endpoints.removeAllElements();
    }

    public int numOfEndpoints() {
        return this.endpoints.size();
    }

    public String getCompiledString() {
        return this.descString;
    }

    private void setCompiledString(String string) {
        this.descString = string;
    }

    public String toString() {
        if (this.endpoints.size() > 0) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endpoints.elementAt(0);
            return schemaObjectConfig.toString();
        }
        return null;
    }

    public void save(Config config, boolean bl) throws ServiceAliasException {
        boolean bl2;
        boolean bl3 = ServiceAlias.exists(config, this.name);
        boolean bl4 = bl2 = !bl3;
        if (bl3 && !bl) {
            throw new ServiceAliasException(3);
        }
        if (config.netConfigUsesLDAP()) {
            Object object;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            Vector vector = new Vector();
            String[] stringArray = new String[]{};
            String string = directoryService.qualifyObjectName(config, this.name, false);
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector2.addElement(new NNFLUpdateParam("objectclass", this.getObjectClasses(false)));
            if (this.endpoints.size() > 0) {
                vector2.addElement(new NNFLUpdateParam("orclNetDescString", this.toString()));
                stringArray = schemaObjectConfigFactory.getEndpointNames(this.endpoints);
                vector2.addElement(new NNFLUpdateParam("orclNetDescName", stringArray));
            }
            if (bl2 && (object = this.getACL(config)) != null) {
                vector2.addElement(object);
                object = this.getACLAlso(config);
                if (object != null) {
                    vector2.addElement(object);
                }
                bl2 = false;
            }
            object = new NNFLUpdateParam[vector2.size()];
            vector2.copyInto((Object[])object);
            try {
                schemaObjectConfigFactory.deleteEndpoints(config, this.endpointNames, string);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ServiceAliasException(sOExceptionConfig);
            }
            try {
                directoryService.update(config, this.name, false, (NNFLUpdateParam[])object, this.getSupportedAttributes(), false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
            if (bl2) {
                this.initACL(config);
            }
            try {
                schemaObjectConfigFactory.save(config, this.endpoints, string);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ServiceAliasException(sOExceptionConfig);
            }
            this.endpointNames = stringArray;
        } else {
            try {
                NLParamParser nLParamParser = config.getNlpa(0);
                if (this.endpoints.size() > 0) {
                    SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endpoints.elementAt(0);
                    nLParamParser.addNLPListElement(this.name + "=" + schemaObjectConfig.toString());
                    if (nLParamParser.getNLPListSize() > 0) {
                        nLParamParser.saveNLParams();
                    } else if (nLParamParser.configuredInFile()) {
                        File file = new File(config.getFilename(0));
                        if (file.exists()) {
                            file.delete();
                        }
                    } else {
                        config.deleteNlpa(0);
                    }
                }
            }
            catch (ConfigException configException) {
                throw new ServiceAliasException(configException);
            }
            catch (NLException nLException) {
                throw new ServiceAliasException(nLException);
            }
            catch (IOException iOException) {
                throw new ServiceAliasException(iOException);
            }
        }
    }

    public void saveAs(Config config, boolean bl, String string) throws ServiceAliasException {
        this.name = string;
        this.save(config, bl);
    }

    public void bufferedSave(Config config, boolean bl) throws ServiceAliasException {
        boolean bl2;
        boolean bl3 = ServiceAlias.exists(config, this.name);
        boolean bl4 = bl2 = !bl3;
        if (bl3 && !bl) {
            throw new ServiceAliasException(3);
        }
        try {
            NLParamParser nLParamParser = null;
            nLParamParser = config.getNlpa(0);
            if (this.endpoints.size() > 0) {
                SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endpoints.elementAt(0);
                nLParamParser.addNLPListElement(this.name + "=" + schemaObjectConfig.toString());
                if (nLParamParser.getNLPListSize() <= 0) {
                    if (nLParamParser.configuredInFile()) {
                        File file = new File(config.getFilename(0));
                        if (file.exists()) {
                            file.delete();
                        }
                    } else {
                        config.deleteNlpa(0);
                    }
                }
            }
        }
        catch (NLException nLException) {
            throw new ServiceAliasException(nLException);
        }
        catch (ConfigException configException) {
            throw new ServiceAliasException(configException);
        }
    }

    protected static String[] enumServiceAliases(Config config, String string, boolean bl, String string2) throws ServiceAliasException {
        int n;
        if (config.netConfigUsesLDAP()) {
            try {
                DirectoryService directoryService = config.getDS();
                if (string == null) {
                    string = directoryService.getDomainObjectPath(config);
                }
                if (string.equalsIgnoreCase(NULL_DOMAIN)) {
                    throw new ServiceAliasException(2);
                }
                return directoryService.enumDNs(config, string, string2, !bl);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        }
        NLParamParser nLParamParser = null;
        try {
            nLParamParser = config.getNlpa(0);
        }
        catch (ConfigException configException) {
            throw new ServiceAliasException(configException);
        }
        String[] stringArray = nLParamParser.getNLPAllNames();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].toUpperCase();
        }
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return stringArray;
        }
        if (string.equals(NULL_DOMAIN)) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].indexOf(".") != -1) continue;
                vector.addElement(stringArray[n]);
            }
        } else {
            string = string.toUpperCase();
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = stringArray[n].indexOf(".");
                if (n2 == -1) continue;
                String string3 = stringArray[n].substring(n2 + 1);
                if ((!bl || !string3.equals(string)) && (bl || !string3.endsWith(string))) continue;
                vector.addElement(stringArray[n]);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static boolean selectByServiceName(Vector vector, String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.isA() == 3) {
                if (!ServiceAlias.selectByServiceName(((DescriptionListConfig)schemaObjectConfig).children, string)) continue;
                return true;
            }
            if (schemaObjectConfig.isA() != 2) continue;
            DescriptionConfig descriptionConfig = (DescriptionConfig)schemaObjectConfig;
            if (descriptionConfig.serviceName == null || !descriptionConfig.serviceName.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected static boolean selectByHostname(Vector vector, String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.isA() == 0) {
                String string2;
                object = (AddressConfig)schemaObjectConfig;
                if (!((AddressConfig)object).prot.equalsIgnoreCase("TCP") || (string2 = ((AddressConfig)object).getProtocolParam("HOST")) == null || !string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            object = new Vector();
            if (schemaObjectConfig.isA() == 3) {
                object = ((DescriptionListConfig)schemaObjectConfig).children;
            } else if (schemaObjectConfig.isA() == 2) {
                object = ((DescriptionConfig)schemaObjectConfig).children;
            } else if (schemaObjectConfig.isA() == 1) {
                object = ((AddressListConfig)schemaObjectConfig).children;
            }
            if (!ServiceAlias.selectByHostname((Vector)object, string)) continue;
            return true;
        }
        return false;
    }

    protected static boolean selectBySid(Vector vector, String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.isA() == 3) {
                if (!ServiceAlias.selectBySid(((DescriptionListConfig)schemaObjectConfig).children, string)) continue;
                return true;
            }
            if (schemaObjectConfig.isA() != 2) continue;
            DescriptionConfig descriptionConfig = (DescriptionConfig)schemaObjectConfig;
            if (descriptionConfig.SID == null || !descriptionConfig.SID.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectClasses(boolean bl) {
        if (bl) {
            String[] stringArray = new String[]{"top", "orclNetService"};
            return stringArray;
        }
        String[] stringArray = new String[]{"orclNetService"};
        return stringArray;
    }

    protected NNFLUpdateParam getACL(Config config) throws ServiceAliasException {
        return null;
    }

    protected NNFLUpdateParam getACLAlso(Config config) throws ServiceAliasException {
        return null;
    }

    protected void initACL(Config config) throws ServiceAliasException {
    }

    private void checkEndpoints(Vector vector) throws ServiceAliasException {
        DirectoryService directoryService = new DirectoryService();
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.getShared() && directoryService.inSubtree(this.name, schemaObjectConfig.getName())) {
                throw new ServiceAliasException(9);
            }
            if (schemaObjectConfig.isA() == 3) {
                this.checkEndpoints(((DescriptionListConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() == 2) {
                this.checkEndpoints(((DescriptionConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() != 1) continue;
            this.checkEndpoints(((AddressListConfig)schemaObjectConfig).children);
        }
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("orclNetDescString");
        vector.addElement("orclNetDescName");
        return vector;
    }
}

