/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.ldap.NNFLUpdateParam;

public class Service
extends ServiceAlias {
    public String serviceType;
    public String oracleHome;
    public String systemName;
    public String sid;
    public String version;

    public static String[] enumServiceAliases(Config config, String string, boolean bl) throws ServiceAliasException {
        String string2 = "(&(objectclass=orclService)(!(objectclass=orclDBServer)))";
        return Service.enumServiceAliases(config, string, bl, string2);
    }

    public static String[] enumServiceAliases(Config config, String string, boolean bl, String string2, String string3) throws ServiceAliasException {
        Object[] objectArray = Service.enumServiceAliases(config, string, bl);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Service service = new Service(config, objectArray[i]);
            Vector vector2 = service.getEndpoints();
            if (!Service.selectByHostname(vector2, string2) || !Service.selectBySid(vector2, string3)) continue;
            vector.addElement(objectArray[i]);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Service(Config config, String string) throws ServiceAliasException {
        block11: {
            super(config, string);
            this.serviceType = null;
            this.oracleHome = null;
            this.systemName = null;
            this.sid = null;
            this.version = null;
            if (config.netConfigUsesLDAP()) {
                try {
                    DirectoryService directoryService = config.getDS();
                    Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                    String string2 = ((String[])hashtable.get("dn"))[0];
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string3);
                        if (string3.equalsIgnoreCase("orclServiceType")) {
                            this.serviceType = stringArray[0];
                            continue;
                        }
                        if (string3.equalsIgnoreCase("orclOracleHome")) {
                            this.oracleHome = stringArray[0];
                            continue;
                        }
                        if (string3.equalsIgnoreCase("orclSystemName")) {
                            this.systemName = stringArray[0];
                            continue;
                        }
                        if (string3.equalsIgnoreCase("orclSid")) {
                            this.sid = stringArray[0];
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("orclVersion")) continue;
                        this.version = stringArray[0];
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (directoryServiceException.errno == 207) break block11;
                    throw new ServiceAliasException(directoryServiceException);
                }
            }
        }
        if (this.oracleHome == null) {
            this.oracleHome = config.OraHomeDir;
        }
        if (this.systemName == null) {
            this.systemName = config.systemName();
        }
        if (this.serviceType == null) {
            this.serviceType = "DB";
        }
    }

    @Override
    public void save(Config config, boolean bl) throws ServiceAliasException {
        super.save(config, bl);
        if (config.netConfigUsesLDAP()) {
            DirectoryService directoryService = config.getDS();
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            if (this.serviceType != null) {
                vector.addElement(new NNFLUpdateParam("orclServiceType", this.serviceType));
            }
            if (this.oracleHome != null) {
                vector.addElement(new NNFLUpdateParam("orclOracleHome", this.oracleHome));
            }
            if (this.systemName != null) {
                vector.addElement(new NNFLUpdateParam("orclSystemName", this.systemName));
            }
            if (this.sid != null) {
                vector.addElement(new NNFLUpdateParam("orclSid", this.sid));
            }
            if (this.version != null) {
                vector.addElement(new NNFLUpdateParam("orclVersion", this.version));
            }
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            try {
                directoryService.update(config, this.name, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        }
    }

    @Override
    protected String[] getObjectClasses(boolean bl) {
        if (bl) {
            String[] stringArray = new String[]{"top", "orclService"};
            return stringArray;
        }
        String[] stringArray = new String[]{"orclService"};
        return stringArray;
    }

    public void prepareAttributes(Config config, Vector vector) {
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("orclServiceType");
        vector.addElement("orclOracleHome");
        vector.addElement("orclSystemName");
        vector.addElement("orclSid");
        vector.addElement("orclVersion");
        return vector;
    }
}

