/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Vector;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.config.AddressConfig;
import oracle.net.config.AddressListConfig;
import oracle.net.config.Config;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class SchemaObjectConfigFactory
implements SchemaObjectFactoryInterface {
    @Override
    public SchemaObject create(int n) {
        switch (n) {
            case 0: {
                return new AddressConfig();
            }
            case 1: {
                return new AddressListConfig();
            }
            case 2: {
                return new DescriptionConfig();
            }
            case 3: {
                return new DescriptionListConfig();
            }
        }
        return null;
    }

    public SchemaObjectConfig create(String string, String string2, int[] nArray) throws SOExceptionConfig {
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair = null;
        try {
            nVPair = nVFactory.createNVPair(string);
        }
        catch (NLException nLException) {
            throw new SOExceptionConfig(nLException.getMessage());
        }
        return this.create(nVPair, string2, nArray);
    }

    public SchemaObjectConfig create(NVPair nVPair, String string, int[] nArray) throws SOExceptionConfig {
        SchemaObjectConfig schemaObjectConfig = null;
        if (nVPair.getName().equalsIgnoreCase("DESCRIPTION_LIST")) {
            schemaObjectConfig = new DescriptionListConfig(nVPair, string);
        } else if (nVPair.getName().equalsIgnoreCase("DESCRIPTION")) {
            schemaObjectConfig = new DescriptionConfig(nVPair, string);
        } else if (nVPair.getName().equalsIgnoreCase("ADDRESS_LIST")) {
            schemaObjectConfig = new AddressListConfig(nVPair, string);
        } else if (nVPair.getName().equalsIgnoreCase("ADDRESS")) {
            schemaObjectConfig = new AddressConfig(nVPair, string);
        } else {
            throw new SOExceptionConfig(4);
        }
        if (nArray != null) {
            boolean bl = false;
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (schemaObjectConfig.isA() != nArray[i]) continue;
                bl = true;
            }
            if (!bl) {
                throw new SOExceptionConfig(4);
            }
        }
        return schemaObjectConfig;
    }

    public SchemaObjectConfig create(Config config, String string, int[] nArray) throws SOExceptionConfig {
        try {
            int n;
            SchemaObjectConfig schemaObjectConfig = null;
            DirectoryService directoryService = config.getDS();
            String[] stringArray = directoryService.read(config, string, false, "objectclass");
            for (n = 0; n < stringArray.length && schemaObjectConfig == null; ++n) {
                if (stringArray[n].equalsIgnoreCase("orclNetDescriptionList")) {
                    schemaObjectConfig = new DescriptionListConfig(config, string);
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("orclNetDescription")) {
                    schemaObjectConfig = new DescriptionConfig(config, string);
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("orclNetAddressList")) {
                    schemaObjectConfig = new AddressListConfig(config, string);
                    continue;
                }
                if (!stringArray[n].equalsIgnoreCase("orclNetAddress")) continue;
                schemaObjectConfig = new AddressConfig(config, string);
            }
            if (schemaObjectConfig == null) {
                throw new SOExceptionConfig(4);
            }
            if (nArray != null) {
                n = 0;
                for (int i = 0; i < nArray.length && n == 0; ++i) {
                    if (schemaObjectConfig.isA() != nArray[i]) continue;
                    n = 1;
                }
                if (n == 0) {
                    throw new SOExceptionConfig(4);
                }
            }
            return schemaObjectConfig;
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new SOExceptionConfig(directoryServiceException);
        }
    }

    public Vector create(Config config, String[] stringArray, String string, int[] nArray) throws SOExceptionConfig {
        int n;
        SchemaObjectConfig[] schemaObjectConfigArray = new SchemaObjectConfig[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            Integer n2;
            n = stringArray[i].indexOf(":");
            int n3 = stringArray[i].indexOf("=");
            int n4 = stringArray[i].indexOf(",");
            if (n == -1) {
                if (stringArray.length > 1) {
                    throw new SOExceptionConfig(9);
                }
                n2 = new Integer("0");
                string2 = stringArray[i].trim();
            } else {
                n2 = new Integer(stringArray[i].substring(0, n));
                string2 = stringArray[i].substring(n + 1).trim();
            }
            if (n3 != -1 && n4 == -1) {
                string2 = string2 + ", " + string;
            }
            schemaObjectConfigArray[n2.intValue()] = this.create(config, string2, nArray);
        }
        Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
        for (n = 0; n < schemaObjectConfigArray.length; ++n) {
            vector.addElement(schemaObjectConfigArray[n]);
        }
        return vector;
    }

    public String[] getEndpointNames(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            String string = (i >= 100 ? "" : (i >= 10 ? "0" : "00")) + i;
            stringArray[i] = schemaObjectConfig.getShared() ? string + ":" + schemaObjectConfig.getName() : string + ":cn=" + schemaObjectConfig.isA_String() + "_" + i;
        }
        return stringArray;
    }

    public void deleteEndpoints(Config config, String[] stringArray, String string) throws SOExceptionConfig {
        DirectoryService directoryService = config.getDS();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            Integer n;
            int n2 = stringArray[i].indexOf(":");
            int n3 = stringArray[i].indexOf("=");
            int n4 = stringArray[i].indexOf(",");
            if (n2 == -1) {
                if (stringArray.length > 1) {
                    throw new SOExceptionConfig(9);
                }
                n = new Integer("0");
                string2 = stringArray[i].trim();
            } else {
                n = new Integer(stringArray[i].substring(0, n2));
                string2 = stringArray[i].substring(n2 + 1).trim();
            }
            if (n3 == -1 || n4 != -1) continue;
            string2 = string2 + ", " + string;
            try {
                directoryService.delete(config, string2, false, true);
                continue;
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new SOExceptionConfig(directoryServiceException);
            }
        }
    }

    public void save(Config config, Vector vector, String string) throws SOExceptionConfig {
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (!schemaObjectConfig.getShared()) {
                schemaObjectConfig.setName("cn=" + schemaObjectConfig.isA_String() + "_" + i + ", " + string);
            }
            schemaObjectConfig.saveToLDAP(config, true);
        }
    }
}

