/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.Ldif;
import oracle.net.config.OracleContext;

public class RootOracleContext
extends OracleContext {
    public static final String rootOracleContextDN = "cn=OracleContext";

    public RootOracleContext(Config config) throws ConfigException {
        super(config, rootOracleContextDN);
    }

    @Override
    protected Vector getLdifFilesToLoad(String string, String string2) throws ConfigException {
        boolean bl;
        if (Config.trace) {
            Config.out.println("RootOracleContext: getLdifFilesToLoad: (enter)");
        }
        if (string.equals("Create")) {
            bl = true;
        } else if (string.equals("Upgrade")) {
            bl = false;
        } else {
            throw new ConfigException(2);
        }
        if (!(bl || string2 != null && string2 != "")) {
            throw new ConfigException(2);
        }
        String string3 = this.m_config.getDirectoryType();
        if (string3 == null) {
            throw new ConfigException(1);
        }
        String string4 = string3.toLowerCase() + "RootContext";
        string4 = bl ? string4 + "Create" : string4 + "UpgradeFrom" + string2;
        string4 = Ldif.getLdifFileDirectory(this.m_config) + File.separator + string4 + ".lst";
        if (Config.trace) {
            Config.out.println("RootOracleContext: getLdifFilesToLoad: file containing the list of files: " + string4);
        }
        Vector vector = Ldif.getFileList(string4);
        if (Config.trace) {
            Config.out.println("RootOracleContext: getLdifFilesToLoad: (exit)");
        }
        return vector;
    }
}

