/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.common.NetGetEnv;
import oracle.net.config.AuthInfo;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.ParameterSource;
import oracle.net.config.ProfileException;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class Profile
extends ParameterSource {
    private boolean isSysProf = true;
    private String sharedProfileName = " ";
    private Profile sharedProfileObj = null;
    private boolean readSharedProfile = false;
    private Vector authinfo = new Vector();

    public static boolean exists(Config config, boolean bl, String string) {
        block7: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, bl)) {
                        return true;
                    }
                    break block7;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    return false;
                }
            }
            NLParamParser nLParamParser = null;
            try {
                nLParamParser = config.getNlpa(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nLParamParser != null) {
                return true;
            }
        }
        return false;
    }

    public static void delete(Config config, boolean bl, String string) throws ProfileException {
        if (Profile.exists(config, bl, string)) {
            if (config.netConfigUsesLDAP()) {
                try {
                    config.getDS().delete(config, string, bl, true);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ProfileException(directoryServiceException);
                }
            }
            NLParamParser nLParamParser = null;
            try {
                nLParamParser = config.getNlpa(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nLParamParser.configuredInFile()) {
                File file = new File(config.getFilename(2));
                if (!file.delete()) {
                    throw new ProfileException(new IOException());
                }
            } else {
                config.deleteNlpa(2);
            }
        }
    }

    public Profile(Config config) throws ProfileException {
        this(config, true, null, true, true);
    }

    public Profile(Config config, boolean bl, String string) throws ProfileException {
        this(config, bl, string, false, false);
    }

    public Profile(Config config, boolean bl, String string, boolean bl2) throws ProfileException {
        this(config, bl, string, bl2, false);
    }

    public Profile(Config config, boolean bl, String string, boolean bl2, boolean bl3) throws ProfileException {
        super(string);
        this.isSysProf = bl;
        this.readSharedProfile = bl2;
        if (config.netConfigUsesLDAP()) {
            block20: {
                DirectoryService directoryService = config.getDS();
                this.qname = directoryService.qualifyObjectName(config, string, bl);
                if (bl3) {
                    string = NetGetEnv.get("ORANET_PROFILE");
                    if (string == null) {
                        try {
                            string = InetAddress.getLocalHost().getHostName();
                            int n = string.indexOf(".");
                            if (n != -1) {
                                string = string.substring(0, n);
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            string = "";
                        }
                    }
                    this.name = string;
                }
                try {
                    Hashtable hashtable = directoryService.read(config, string, bl, this.getSupportedAttributes());
                    String string2 = ((String[])hashtable.get("dn"))[0];
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object object;
                        int n;
                        String string3 = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string3);
                        if (string3.equalsIgnoreCase("OrclNetShared")) {
                            this.isSysProf = stringArray[0].equalsIgnoreCase("NO");
                            continue;
                        }
                        if (string3.equalsIgnoreCase("OrclSharedProfile")) {
                            this.sharedProfileName = stringArray[0];
                            continue;
                        }
                        if (string3.equalsIgnoreCase("OrclNetParamList")) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                n = stringArray[i].indexOf("=");
                                if (n == -1) continue;
                                object = stringArray[i].substring(0, n).trim();
                                String string4 = stringArray[i].substring(n + 1).trim();
                                this.setParameter((String)object, string4);
                            }
                            continue;
                        }
                        if (string3.equalsIgnoreCase("OrclAuthList")) {
                            for (n = 0; n < stringArray.length; ++n) {
                                object = new AuthInfo(config, stringArray[n] + ", " + string2);
                                this.authinfo.addElement(object);
                            }
                            continue;
                        }
                        if (this.mapping.parameter(string3) == null) continue;
                        this.setParameter(this.mapping.parameter(string3), stringArray[0]);
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (directoryServiceException.errno == 207) break block20;
                    throw new ProfileException(directoryServiceException);
                }
            }
            if (bl2 && this.sharedProfileName.length() > 0) {
                this.sharedProfileObj = new Profile(config, false, this.sharedProfileName, false, false);
                this.mergeSharedProfile();
            }
        } else {
            try {
                this.nlpa = config.getNlpa(2);
            }
            catch (ConfigException configException) {
                throw new ProfileException(configException.errno);
            }
            String[] stringArray = this.nlpa.getNLPAllNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                NVPair nVPair = this.nlpa.getNLPListElement(stringArray[i]);
                this.hashtable.put(stringArray[i], this.rhsToString(nVPair));
            }
        }
    }

    @Override
    public void remParameter(String string) {
        String string2;
        super.remParameter(string);
        if (this.readSharedProfile && this.sharedProfileObj != null && (string2 = this.sharedProfileObj.getParameter(string)) != null) {
            this.setParameter(string, string2);
        }
    }

    public boolean getIsSysProf() {
        return this.isSysProf;
    }

    public Vector getAuthInfo() {
        return this.authinfo;
    }

    public String getSharedProfile() {
        return this.sharedProfileName;
    }

    public void setSharedProfile(Config config, String string) throws ProfileException {
        if (!config.netConfigUsesLDAP()) {
            throw new ProfileException(21);
        }
        if (string == null || string.length() == 0) {
            this.sharedProfileName = "";
            this.splitSharedProfile();
            this.sharedProfileObj = null;
        } else {
            if (!this.isSysProf) {
                throw new ProfileException(13);
            }
            Profile profile = new Profile(config, false, string);
            if (!Profile.exists(config, false, string) || profile.getIsSysProf()) {
                throw new ProfileException(14);
            }
            this.sharedProfileName = string;
            this.splitSharedProfile();
            this.sharedProfileObj = profile;
            this.mergeSharedProfile();
        }
    }

    public void migrateToLDAP(Config config, boolean bl, boolean bl2) throws ProfileException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            String string = this.name;
            this.name = this.name.replace('.', '_');
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(false);
            if (bl2) {
                Profile.delete(config, this.isSysProf, this.name);
            }
        }
        catch (ProfileException profileException) {
            config.netConfigUsesLDAP(bl3);
            throw profileException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public void migrateToFILE(Config config, boolean bl, boolean bl2) throws ProfileException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            String string = this.name;
            this.name = config.getDS().getCN(this.name);
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(true);
            if (bl2) {
                Profile.delete(config, this.isSysProf, this.name);
            }
        }
        catch (ProfileException profileException) {
            config.netConfigUsesLDAP(bl3);
            throw profileException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public void save(Config config, boolean bl) throws ProfileException {
        if (Profile.exists(config, this.isSysProf, this.name) && !bl) {
            throw new ProfileException(3);
        }
        if (config.netConfigUsesLDAP()) {
            Object object;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            Vector<String> vector = new Vector<String>();
            String[] stringArray = new String[]{"OrclProfile"};
            Vector<NNFLUpdateParam> vector2 = new Vector<NNFLUpdateParam>();
            vector2.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector2.addElement(new NNFLUpdateParam("objectclass", stringArray));
            vector2.addElement(new NNFLUpdateParam("OrclNetShared", this.isSysProf ? "NO" : "YES"));
            vector2.addElement(new NNFLUpdateParam("OrclSharedProfile", this.sharedProfileName));
            this.splitSharedProfile();
            Object[] objectArray = this.hashtable.keys();
            while (objectArray.hasMoreElements()) {
                String string = (String)objectArray.nextElement();
                String string2 = (String)this.hashtable.get(string);
                object = this.mapping.attribute(string.toLowerCase());
                if (object == null) {
                    vector.addElement(string + "=" + string2);
                    continue;
                }
                vector2.addElement(new NNFLUpdateParam((String)object, string2));
            }
            this.mergeSharedProfile();
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                vector2.addElement(new NNFLUpdateParam("OrclNetParamList", (String[])objectArray));
            }
            if (this.authinfo.size() > 0) {
                objectArray = new String[this.authinfo.size()];
                for (int i = 0; i < this.authinfo.size(); ++i) {
                    objectArray[i] = "cn=AUTHINFO" + i;
                }
                vector2.addElement(new NNFLUpdateParam("OrclAuthList", (String[])objectArray));
            }
            objectArray = new NNFLUpdateParam[vector2.size()];
            vector2.copyInto(objectArray);
            String string = null;
            try {
                string = directoryService.update(config, this.name, this.isSysProf, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ProfileException(directoryServiceException);
            }
            for (int i = 0; i < this.authinfo.size(); ++i) {
                object = (AuthInfo)this.authinfo.elementAt(i);
                try {
                    ((AuthInfo)object).save(config, "cn=AUTHINFO" + i + ", " + string);
                    continue;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ProfileException(directoryServiceException);
                }
            }
        } else {
            try {
                Object object;
                Object object2;
                if (this.nlpa == null) {
                    this.nlpa = config.getNlpa(2);
                }
                Enumeration enumeration = this.hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    object = (String)this.hashtable.get(object2);
                    this.nlpa.addNLPListElement((String)object2 + "=" + (String)object);
                }
                for (int i = 0; i < this.authinfo.size(); ++i) {
                    object2 = (AuthInfo)this.authinfo.elementAt(i);
                    object = ((AuthInfo)object2).enumParams();
                    while (object.hasMoreElements()) {
                        String string = (String)object.nextElement();
                        String string3 = ((AuthInfo)object2).getParameter(string);
                        this.nlpa.addNLPListElement(string + "=" + string3);
                    }
                }
                config.writeToFile(2);
            }
            catch (ConfigException configException) {
                throw new ProfileException(configException.errno);
            }
            catch (NLException nLException) {
                throw new ProfileException(nLException);
            }
            catch (IOException iOException) {
                throw new ProfileException(iOException);
            }
        }
    }

    public void saveAs(Config config, boolean bl, String string) throws ProfileException {
        this.name = string;
        this.save(config, bl);
    }

    private void mergeSharedProfile() {
        if (this.readSharedProfile && this.sharedProfileObj != null) {
            Enumeration enumeration = this.sharedProfileObj.enumParams();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.sharedProfileObj.getParameter(string);
                if (this.getParameter(string) != null) continue;
                this.setParameter(string, string2);
            }
        }
    }

    private void splitSharedProfile() {
        if (this.readSharedProfile && this.sharedProfileObj != null) {
            Enumeration enumeration = this.sharedProfileObj.enumParams();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.sharedProfileObj.getParameter(string);
                String string3 = this.getParameter(string);
                if (string3 == null || !string3.equalsIgnoreCase(string2)) continue;
                this.remParameter(string);
            }
        }
    }

    @Override
    protected void constructMapping() {
        this.mapping.set("OrclBequeathDetach", "bequeath_detach");
        this.mapping.set("OrclTraceUniqueClient", "trace_unique_client");
        this.mapping.set("OrclUseCman", "use_cman");
        this.mapping.set("OrclUseDedicatedServer", "use_dedicated_server");
        this.mapping.set("OrclNamesctlTraceUnique", "namesctl.trace_unique");
        this.mapping.set("OrclNamesctlNoIniServer", "namesctl.no_initial_server");
        this.mapping.set("OrclNamesctlIntlEncryPd", "namesctl.internal_encrypt_password");
        this.mapping.set("OrclNamesctlInternalUse", "namesctl.internal_use");
        this.mapping.set("OrclNamesctlNoConfirm", "namesctl.noconfirm");
        this.mapping.set("OrclDisableOob", "disable_oob");
        this.mapping.set("OrclDaemonTraceMask", "daemon.trace_mask");
        this.mapping.set("OrclSqlnetExpireTime", "sqlnet.expire_time");
        this.mapping.set("OrclNamesRequestRetries", "names.request_retries");
        this.mapping.set("OrclNamesMsgPoolStSz", "names.message_pool_start_size");
        this.mapping.set("OrclNamesIniRtyTimeout", "names.initial_retry_timeout");
        this.mapping.set("OrclNamesMaxOpenConns", "names.max_open_conns");
        this.mapping.set("OrclNamesNdsNameContext", "names.nds.name_context");
        this.mapping.set("OrclNamesNisMetaMap", "names.nis.meta_map");
        this.mapping.set("OrclDaemonTraceLevel", "daemon.trace_level");
        this.mapping.set("OrclDaemonTraceFile", "daemon.trace_file");
        this.mapping.set("OrclDaemonTraceDirectory", "daemon.trace_directory");
        this.mapping.set("OrclNamesctlTraceLevel", "namesctl.trace_level");
        this.mapping.set("OrclNamesctlTraceFile", "namesctl.trace_file");
        this.mapping.set("OrclNamesctlTraceDir", "namesctl.trace_directory");
        this.mapping.set("OrclNamesctlServerPwd", "namesctl.server_password");
        this.mapping.set("OrclTnspingTraceLevel", "tnsping.trace_level");
        this.mapping.set("OrclTnspingTraceFile", "tnsping.trace_file");
        this.mapping.set("OrclTnspingTraceDirectory", "tnsping.trace_directory");
        this.mapping.set("OrclTraceLevelClient", "trace_level_client");
        this.mapping.set("OrclTraceLevelServer", "trace_level_server");
        this.mapping.set("OrclTraceFileClient", "trace_file_client");
        this.mapping.set("OrclTraceFileServer", "trace_file_server");
        this.mapping.set("OrclTraceDirectoryClient", "trace_directory_client");
        this.mapping.set("OrclTraceDirectoryServer", "trace_directory_server");
        this.mapping.set("OrclTraceFilelenClient", "trace_filelen_client");
        this.mapping.set("OrclTraceFilelenServer", "trace_filelen_server");
        this.mapping.set("OrclTraceTimestampClient", "trace_timestamp_client");
        this.mapping.set("OrclTraceTimestampServer", "trace_timestamp_server");
        this.mapping.set("OrclTraceFilenoClient", "trace_fileno_client");
        this.mapping.set("OrclTraceFilenoServer", "trace_fileno_server");
        this.mapping.set("OrclTracePercentFreeCli", "trace_percent_free_client");
        this.mapping.set("OrclTracePercentFreeSvr", "trace_percent_free_server");
        this.mapping.set("OrclLogFileClient", "log_file_client");
        this.mapping.set("OrclLogFileServer", "log_file_server");
        this.mapping.set("OrclLogLevelClient", "log_level_client");
        this.mapping.set("OrclLogLevelServer", "log_level_server");
        this.mapping.set("OrclLogDirectoryClient", "log_directory_client");
        this.mapping.set("OrclLogDirectoryServer", "log_directory_server");
        this.mapping.set("OrclNamesDcePrefix", "names.dce.prefix");
        this.mapping.set("OrclNamesDefaultDomain", "names.default_domain");
        this.mapping.set("OrclSqlnetCrypCksCli", "sqlnet.crypto_checksum_client");
        this.mapping.set("OrclSqlnetCrypCksSvr", "sqlnet.crypto_checksum_server");
        this.mapping.set("OrclSqlnetCryptoSeed", "sqlnet.crypto_seed");
        this.mapping.set("OrclSqlnetEncryptClient", "sqlnet.encryption_client");
        this.mapping.set("OrclSqlnetEncryptServer", "sqlnet.encryption_server");
        this.mapping.set("OrclSqlnetClientRegistration", "sqlnet.client_reg");
        this.mapping.set("OrclNamesAddresses", "names.addresses");
        this.mapping.set("OrclNamesDirectoryPath", "names.directory_path");
        this.mapping.set("OrclNamesPrfdServers", "names.preferred_servers");
        this.mapping.set("OrclSqlnetCrypCksTyCli", "sqlnet.crypto_checksum_types_client");
        this.mapping.set("OrclSqlnetCrypCksTySvr", "sqlnet.crypto_checksum_types_server");
        this.mapping.set("OrclSqlnetEncrypTyCli", "sqlnet.encryption_types_client");
        this.mapping.set("OrclSqlnetEncrypTySvr", "sqlnet.encryption_types_server");
        this.mapping.set("OrclSqlnetAuthServices", "sqlnet.authentication_services");
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("OrclNetShared");
        vector.addElement("OrclSharedProfile");
        vector.addElement("OrclNetParamList");
        vector.addElement("OrclAuthList");
        Enumeration enumeration = this.mapping.enumAttrs();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector;
    }
}

