/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.net.config.Mapping;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class ParameterSource {
    protected Hashtable hashtable = new Hashtable();
    protected Mapping mapping = new Mapping();
    protected NLParamParser nlpa = null;
    protected String name = null;
    protected String qname = null;

    public ParameterSource(String string) {
        this.name = string;
        this.constructMapping();
    }

    public String getParameter(String string) {
        return (String)this.hashtable.get(string.toUpperCase());
    }

    public void setParameter(String string, String string2) {
        this.hashtable.put(string.toUpperCase(), string2);
    }

    public void remParameter(String string) {
        this.hashtable.remove(string.toUpperCase());
        if (this.nlpa != null) {
            if (this.name != null && this.name.trim().length() > 0) {
                this.nlpa.removeNLPListElement(string + "_" + this.name);
            } else {
                this.nlpa.removeNLPListElement(string);
            }
        }
    }

    public int getCount() {
        return this.hashtable.size();
    }

    public Enumeration enumParams() {
        return this.hashtable.keys();
    }

    public String[] enumParamsArray() {
        int n = 0;
        String[] stringArray = new String[this.getCount()];
        Enumeration enumeration = this.enumParams();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    protected void constructMapping() {
    }

    protected String rhsToString(NVPair nVPair) {
        String string;
        if (nVPair.getRHSType() == NVPair.RHS_ATOM) {
            string = nVPair.getAtom();
        } else {
            string = nVPair.toString();
            int n = string.indexOf("(");
            n = string.indexOf("(", n + 1);
            int n2 = string.lastIndexOf(")");
            n2 = string.lastIndexOf(")", n2 - 1);
            string = string.substring(n, n2 + 1);
        }
        return string;
    }
}

