/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.Ldif;
import oracle.net.config.NTBindingException;
import oracle.net.config.NTSDException;
import oracle.net.config.NTSecurityDescriptor;
import oracle.net.ldap.NNFLUpdateParam;

public class OracleSchema {
    private static final String OracleSchemaVersionRDN = "cn=OracleSchemaVersion";
    private static final String oracleSchemaVersionObjectClass = "orclSchemaVersion";
    private static final String oracleProductVersionAttribute = "orclProductVersion";
    private static final String adConfigurationRDN = "cn=Configuration";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    private static final String listFileExt = ".lst";
    private Config config = null;

    public OracleSchema(Config config) throws ConfigException {
        this.config = config;
    }

    public boolean exists() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: exists: (enter)");
        }
        String string = null;
        String string2 = this.config.getDirectoryType();
        if (string2 == null) {
            throw new ConfigException(1);
        }
        DirectoryService directoryService = this.config.getDS();
        if (string2 != null && string2.equalsIgnoreCase("AD")) {
            try {
                Object object;
                String[] stringArray = null;
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: AD Looking for Oracle Context objects");
                }
                if ((stringArray = directoryService.query(this.config, "", "objectclass=*", adDefaultNamingContext)) == null || stringArray.length < 1) {
                    throw new ConfigException(1);
                }
                String string3 = stringArray[0];
                String[] stringArray2 = directoryService.enumDNs(this.config, string3, "objectclass=orclContext", true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    if (Config.trace) {
                        Config.out.println("OracleSchema: exists: AD Schema exists (exit)");
                    }
                    return true;
                }
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: AD Looking for Oracle Context objectclass");
                }
                if ((stringArray = directoryService.query(this.config, "", "objectclass=*", "subschemaSubentry")) == null || stringArray.length < 1) {
                    throw new ConfigException(1);
                }
                string = stringArray[0];
                if (directoryService.exists(this.config, string, false)) {
                    object = directoryService.query(this.config, string, "objectclass=*", "objectclasses");
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (object[i].toLowerCase().indexOf("orclContext".toLowerCase()) == -1) continue;
                        if (Config.trace) {
                            Config.out.println("OracleSchema: exists: AD Schema exists (exit)");
                        }
                        return true;
                    }
                }
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: AD Creating an entry using Oracle Schema Objectclass");
                }
                object = null;
                try {
                    NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("cn", "OracleTestEntry"), new NNFLUpdateParam("objectclass", "orclContainer")};
                    String string4 = "cn=OracleTestEntry," + string3;
                    object = directoryService.update(this.config, string4, false, nNFLUpdateParamArray, null, false);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (Config.trace) {
                        Config.out.println("OracleSchema: exists: AD Schema doesn't exist (exit)");
                    }
                    return false;
                }
                directoryService.delete(this.config, (String)object, false, true);
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: AD Schema exists (exit)");
                }
                return true;
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
        }
        string = string2 != null && string2.equalsIgnoreCase("OID") ? "cn=subschemasubentry" : (string2 != null && string2.equalsIgnoreCase("NDS") ? "" : (string2 != null && string2.equalsIgnoreCase("NETSCAPE") ? "cn=schema" : "cn=subschemasubentry"));
        try {
            if (string2 != null && string2.equalsIgnoreCase("NDS")) {
                String[] stringArray;
                String string5 = oracleSchemaVersionObjectClass;
                String string6 = "objectclass=" + string5.toLowerCase();
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: NDS Looking for OracleSchemaVersion ObjectClass ");
                }
                if ((stringArray = directoryService.ndsquery(this.config, string, string6, "objectClass")) == null) {
                    if (Config.trace) {
                        Config.out.println("OracleSchema: exists: NDS OracleSchemaVersion doesn't exist - Schema doesn't exist (exit)");
                    }
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].toLowerCase().indexOf(string5.toLowerCase()) == -1) continue;
                    if (Config.trace) {
                        Config.out.println("OracleSchema: exists: NDS Schema exists (exit)");
                    }
                    return true;
                }
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: NDS OracleSchemaVersion not found in Object Classes -Schema doesn't exist (exit)");
                }
                return false;
            }
            if (Config.trace) {
                Config.out.println("OracleSchema: exists: Looking for Oracle Context Objectclass ");
            }
            String[] stringArray = directoryService.query(this.config, string, "objectclass=*", "objectclasses");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toLowerCase().indexOf("orclContext".toLowerCase()) == -1) continue;
                if (Config.trace) {
                    Config.out.println("OracleSchema: exists: Schema exists (exit)");
                }
                return true;
            }
            if (Config.trace) {
                Config.out.println("OracleSchema: exists: Oracle Context not found in Object Classes -Schema doesn't exist (exit)");
            }
            return false;
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: create: (enter)");
        }
        if (!this.exists()) {
            try {
                if (this.config.getDS().isAnonymousUserDN()) {
                    throw new ConfigException(20);
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
            this.createAux();
            Vector vector = this.getLdifFilesToLoad("Create", null);
            Vector vector2 = this.getSubstitutionPairs();
            Ldif.loadFiles(this.config, vector, vector2);
            String string = this.config.getDirectoryType();
            if (string == null) {
                throw new ConfigException(1);
            }
            if (string.equalsIgnoreCase("AD")) {
                try {
                    this.config.getDS().updateSchema(this.config);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
            }
            if (!this.exists()) {
                throw new ConfigException(1);
            }
            if (string.equalsIgnoreCase("AD")) {
                String string2 = "cn=OracleSchemaVersion,cn=configuration,%s_AdDomainDN%";
                String string3 = Ldif.instanciateLine(string2, vector2);
                try {
                    NTSecurityDescriptor.InitializeOracleSchemaVersion(this.config.getNTBinding(), string3);
                    if (Config.trace) {
                        Config.out.println("OracleSchema: create(): Set ACL for " + string3);
                    }
                }
                catch (NTBindingException nTBindingException) {
                    throw new ConfigException(nTBindingException);
                }
                catch (NTSDException nTSDException) {
                    throw new ConfigException(nTSDException);
                }
            }
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: create: (exit)");
        }
    }

    public void createAdDisplaySpecifiers() throws ConfigException {
        String string;
        if (Config.trace) {
            Config.out.println("OracleSchema: createAdDisplaySpecifiers: (enter)");
        }
        if ((string = this.config.getDirectoryType()) == null) {
            throw new ConfigException(1);
        }
        if (string.equalsIgnoreCase("AD")) {
            Vector vector = this.getAdDisplaySpecifierFilesToLoad();
            Vector vector2 = this.getSubstitutionPairs();
            Ldif.loadFiles(this.config, vector, vector2);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: createAdDisplaySpecifiers: (exit)");
        }
    }

    public boolean isUpToDate() throws ConfigException, IOException {
        String string;
        if (Config.trace) {
            Config.out.println("OracleSchema: isUpToDate: (enter)");
        }
        if ((string = this.config.getDirectoryType()) == null) {
            throw new ConfigException(1);
        }
        String string2 = this.getVersionFor("BASE");
        if (string2 == null) {
            throw new ConfigException(1);
        }
        String string3 = Ldif.getRequiredVersion(this.config, "OracleSchema");
        if (string3 == null) {
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: version in directory: >" + string2 + "<");
        }
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: version in version file: >" + string3 + "<");
        }
        boolean bl = false;
        try {
            bl = Integer.parseInt(string2) >= Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: isUpToDate: (exit) returning " + bl);
        }
        return bl;
    }

    public String getVersionFor(String string) throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersionFor: (enter)");
        }
        if (string == null || string == "") {
            throw new ConfigException(2);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersionFor: Product passed: " + string);
        }
        DirectoryService directoryService = this.config.getDS();
        String string2 = null;
        if (this.config.getDirectoryType().equalsIgnoreCase("AD")) {
            if (Config.trace) {
                Config.out.println("OracleSchema: getVersionFor: AD case");
            }
            try {
                String[] stringArray = directoryService.query(this.config, "", "objectclass=*", "namingcontexts");
                if (stringArray == null || stringArray.length < 1) {
                    throw new ConfigException(1);
                }
                int n = 0;
                String string3 = stringArray[0];
                for (n = 0; n < stringArray.length && !(string3 = stringArray[n].toLowerCase()).startsWith("cn=configuration"); ++n) {
                }
                String string4 = "cn=OracleSchemaVersion," + string3;
                String[] stringArray2 = directoryService.read(this.config, "cn=" + string + "," + string4, false, oracleProductVersionAttribute);
                string2 = stringArray2[0];
            }
            catch (Exception exception) {
                throw new ConfigException(exception);
            }
        } else {
            try {
                string2 = directoryService.getProductSchemaVersion(this.config, string);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersionFor: (exit) returning: " + string2);
        }
        return string2;
    }

    public String[][] getVersions() throws ConfigException {
        String[][] stringArray;
        String string;
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersions: (enter)");
        }
        if ((string = this.config.getDirectoryType()) == null) {
            throw new ConfigException(1);
        }
        DirectoryService directoryService = this.config.getDS();
        String string2 = null;
        if (string.equalsIgnoreCase("OID") || string.equalsIgnoreCase("NDS")) {
            string2 = OracleSchemaVersionRDN;
        } else if (string.equalsIgnoreCase("AD")) {
            try {
                stringArray = directoryService.query(this.config, "", "objectclass=*", adDefaultNamingContext);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
            if (stringArray == null || stringArray.length < 1) {
                throw new ConfigException(1);
            }
            string2 = "cn=OracleSchemaVersion,cn=Configuration," + (String)stringArray[0];
        } else {
            throw new ConfigException(15);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersions: schema version search base DN: " + string2);
        }
        stringArray = null;
        try {
            String[] stringArray2 = directoryService.enumDNs(this.config, string2, "objectclass=orclSchemaVersion", false);
            if (Config.trace) {
                Config.out.println("OracleSchema: getVersions: found " + stringArray2.length + " version entries");
            }
            if (stringArray2 != null) {
                int n;
                Vector<String> vector = new Vector<String>(0, 2);
                for (n = 0; n < stringArray2.length; ++n) {
                    String string3 = directoryService.getCN(stringArray2[n]);
                    if (Config.trace) {
                        Config.out.println("OracleSchema: getVersions: getting version for " + string3);
                    }
                    String string4 = this.getVersionFor(string3);
                    if (Config.trace) {
                        Config.out.println("OracleSchema: getVersions: version is " + string4);
                    }
                    if (string3.equalsIgnoreCase("BASE")) {
                        vector.insertElementAt("BASE", 0);
                        vector.insertElementAt(string4, 1);
                        continue;
                    }
                    vector.addElement(string3);
                    vector.addElement(string4);
                }
                if (string.equalsIgnoreCase("AD") && !vector.contains("BASE") && vector.contains("RDBMS")) {
                    vector.insertElementAt("BASE", 0);
                    vector.insertElementAt((String)vector.elementAt(vector.indexOf("RDBMS") + 1), 1);
                }
                n = vector.size();
                stringArray = new String[n / 2][2];
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    stringArray[n3][0] = (String)vector.elementAt(n2++);
                    stringArray[n3++][1] = (String)vector.elementAt(n2++);
                }
            }
            stringArray = new String[0][0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: getVersions: (exit)");
        }
        return stringArray;
    }

    public void upgrade() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: upgrade: (enter)");
        }
        try {
            while (!this.isUpToDate()) {
                try {
                    if (this.config.getDS().isAnonymousUserDN()) {
                        throw new ConfigException(20);
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
                this.createAux();
                String string = this.getVersionFor("BASE");
                Vector vector = this.getLdifFilesToLoad("Upgrade", string);
                Vector vector2 = this.getSubstitutionPairs();
                Ldif.loadFiles(this.config, vector, vector2);
                if (!string.equals(this.getVersionFor("BASE"))) continue;
                if (Config.trace) {
                    Config.out.println("OracleSchema: upgrade: upgrade from version " + string + " failed.");
                }
                throw new ConfigException(1);
            }
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: upgrade: (exit)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createAux() throws ConfigException {
        block4: {
            if (Config.trace) {
                Config.out.println("OracleSchema: createAux: (enter)");
            }
            try {
                Vector vector = this.getLdifFilesToLoad("Aux", null);
                Vector vector2 = this.getSubstitutionPairs();
                Ldif.loadFiles(this.config, vector, vector2);
            }
            catch (ConfigException configException) {
                if (configException.errno == 16) break block4;
                throw new ConfigException(configException.errno);
            }
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: createAux: (exit)");
        }
    }

    private Vector getLdifFilesToLoad(String string, String string2) throws ConfigException {
        boolean bl;
        if (Config.trace) {
            Config.out.println("OracleSchema: getLdifFilesToLoad: (enter)");
        }
        boolean bl2 = false;
        if (string.equals("Aux")) {
            bl2 = true;
            bl = false;
        } else if (string.equals("Create")) {
            bl = true;
        } else if (string.equals("Upgrade")) {
            bl = false;
        } else {
            throw new ConfigException(2);
        }
        if (!(bl || bl2 || string2 != null && string2 != "")) {
            throw new ConfigException(2);
        }
        String string3 = this.config.getDirectoryType();
        if (string3 == null) {
            throw new ConfigException(1);
        }
        String string4 = string3.toLowerCase() + "Schema";
        string4 = bl2 ? string4 + "CreateAux" + listFileExt : (bl ? string4 + "Create" + listFileExt : string4 + "UpgradeFrom" + string2 + listFileExt);
        string4 = Ldif.getLdifFileDirectory(this.config) + File.separator + string4;
        if (Config.trace) {
            Config.out.println("OracleSchema: getLdifFilesToLoad: file containing the list of files: " + string4);
        }
        Vector vector = Ldif.getFileList(string4);
        if (Config.trace) {
            Config.out.println("OracleSchema: getLdifFilesToLoad: (exit)");
        }
        return vector;
    }

    private Vector getAdDisplaySpecifierFilesToLoad() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: getAdDisplaySpecifierFilesToLoad: (enter)");
        }
        String string = Ldif.getLdifFileDirectory(this.config) + File.separator + "adDisplaySpecifiersCreate" + listFileExt;
        System.err.println("OracleSchema.getFilesToLoad(...): files to load filename: ");
        System.err.println("   " + string);
        Vector vector = Ldif.getFileList(string);
        if (Config.trace) {
            Config.out.println("OracleSchema: getAdDisplaySpecifierFilesToLoad: (exit)");
        }
        return vector;
    }

    private Vector getSubstitutionPairs() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleSchema: getSubstitutionPairs: (enter)");
        }
        String[] stringArray = new String[2];
        Vector<String[]> vector = new Vector<String[]>();
        String string = this.config.getDirectoryType();
        if (string == null) {
            throw new ConfigException(1);
        }
        if (this.config.getDirectoryType().equalsIgnoreCase("AD")) {
            String[] stringArray2;
            stringArray[0] = "%s_AdDomainDN%";
            DirectoryService directoryService = this.config.getDS();
            try {
                stringArray2 = directoryService.query(this.config, "", "objectclass=*", adDefaultNamingContext);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
            if (stringArray2 == null || stringArray2.length < 1) {
                throw new ConfigException(1);
            }
            stringArray[1] = stringArray2[0];
            System.out.println("OracleSchema.getSubstitutionPairs(): pair: " + stringArray[0] + " " + stringArray[1]);
            vector.addElement(stringArray);
        }
        if (Config.trace) {
            Config.out.println("OracleSchema: getSubstitutionPairs: (exit)");
        }
        return vector;
    }
}

