/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.Ldif;
import oracle.net.config.NTBinding;
import oracle.net.config.NTBindingException;
import oracle.net.config.NTSDException;
import oracle.net.config.NTSecurityDescriptor;

public class OracleContext {
    public static final String oracleContextCN = "OracleContext";
    public static final String oracleContextRDN = "cn=OracleContext";
    public static final String oracleContextObjClass = "orclContext";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    protected static final String listFileExt = ".lst";
    protected Config m_config = null;
    protected String m_oracleContextDN = null;
    protected DirectoryService m_ds = null;

    public OracleContext(Config config, String string) throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleContext: (enter)");
        }
        this.m_config = config;
        if (Config.trace) {
            Config.out.println("OracleContext: Oracle Context DN passed: " + string);
        }
        this.m_ds = this.m_config.getDS();
        string = string.trim();
        if (Config.trace) {
            Config.out.println("OracleContext: Oracle Context DN trimed: " + string);
        }
        if (!string.toLowerCase().startsWith(oracleContextRDN.toLowerCase()) || string.endsWith(",")) {
            throw new ConfigException(2);
        }
        if (string.toLowerCase().indexOf(oracleContextRDN.toLowerCase(), 3) != -1) {
            throw new ConfigException(2);
        }
        this.m_oracleContextDN = string;
        if (Config.trace) {
            Config.out.println("OracleContext: (exit)");
        }
    }

    public static String[] getOracleContexts(Config config) throws ConfigException {
        String string = config.getDirectoryType();
        String string2 = config.getDirectoryServers(true)[0];
        String[] stringArray = null;
        if (string == null || string2 == null) {
            throw new ConfigException(1);
        }
        try {
            DirectoryService directoryService = config.getDS();
            if (string.equalsIgnoreCase("AD")) {
                String[] stringArray2;
                try {
                    stringArray2 = directoryService.query(config, "", "objectclass=*", adDefaultNamingContext);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
                if (stringArray2 == null || stringArray2.length < 1) {
                    throw new ConfigException(1);
                }
                stringArray = directoryService.enumDNs(config, stringArray2[0], "objectclass=orclContext", true);
            } else {
                stringArray = directoryService.enumDNs(config, "", "objectclass=orclContext", true);
            }
            return stringArray;
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
    }

    public static String[] getOracleContexts(Config config, String string) {
        try {
            DirectoryService directoryService = config.getDS();
            String[] stringArray = directoryService.enumDNs(config, string, "objectclass=orclContext", true);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public String getDN() {
        return this.m_oracleContextDN;
    }

    public boolean exists() throws ConfigException {
        boolean bl = false;
        try {
            bl = this.m_ds.dnExists(this.m_config, this.getDN(), false);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        return bl;
    }

    public static boolean exists(Config config, String string) throws ConfigException {
        DirectoryService directoryService = config.getDS();
        try {
            if (directoryService.dnExists(config, string, false)) {
                return true;
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        return false;
    }

    public void create() throws ConfigException {
        block10: {
            try {
                if (this.exists()) break block10;
                if (this.m_ds.isAnonymousUserDN()) {
                    throw new ConfigException(20);
                }
                Vector vector = this.getLdifFilesToLoad("Create", null);
                Vector vector2 = this.getSubstitutionPairs();
                Ldif.loadFiles(this.m_config, vector, vector2);
                if (this.m_config.getDirectoryType().equalsIgnoreCase("AD")) {
                    try {
                        NTBinding nTBinding = this.m_config.getNTBinding();
                        NTSecurityDescriptor.InitializeContainers(nTBinding, this.getDN());
                    }
                    catch (NTBindingException nTBindingException) {
                        if (Config.trace) {
                            nTBindingException.printStackTrace();
                        }
                        throw new ConfigException(1);
                    }
                    catch (NTSDException nTSDException) {
                        if (Config.trace) {
                            nTSDException.printStackTrace();
                        }
                        throw new ConfigException(1);
                    }
                }
                if (!this.m_config.getDirectoryType().equalsIgnoreCase("AD") && !this.exists()) {
                    throw new ConfigException(1);
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
        }
    }

    public boolean isUpToDate() throws ConfigException, IOException {
        String string;
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: (enter)");
        }
        if ((string = this.getVersion()) == null) {
            throw new ConfigException(1);
        }
        String string2 = Ldif.getRequiredVersion(this.m_config, oracleContextCN);
        if (string2 == null) {
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: version in directory: >" + string + "<");
        }
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: version in version file: >" + string2 + "<");
        }
        boolean bl = false;
        try {
            bl = Integer.parseInt(string) >= Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: isUpToDate: (exit) returning " + bl);
        }
        return bl;
    }

    public String getVersion() throws ConfigException {
        String string;
        if (Config.trace) {
            Config.out.println("OracleContext: getVersion: (enter)");
        }
        try {
            string = this.m_ds.getOracleContextVersion(this.m_config, this.m_oracleContextDN);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: getVersion: (exit) returning " + string);
        }
        return string;
    }

    public String getDBCompatibilityVersion() throws DirectoryServiceException {
        String[] stringArray;
        if (Config.trace) {
            Config.out.println("OracleContext: getDBCompatibilityVersion: (enter)");
        }
        if ((stringArray = this.m_ds.read(this.m_config, "cn=OracleDBSecurity,cn=Products," + this.m_oracleContextDN, false, "orclDBVersionCompatibility")) == null) {
            return null;
        }
        return stringArray[0];
    }

    public void upgrade() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleContext: upgrade: (enter)");
        }
        try {
            while (!this.isUpToDate()) {
                try {
                    if (this.m_ds.isAnonymousUserDN()) {
                        throw new ConfigException(20);
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
                String string = this.getVersion();
                Vector vector = this.getLdifFilesToLoad("Upgrade", string);
                Vector vector2 = this.getSubstitutionPairs();
                Ldif.loadFiles(this.m_config, vector, vector2);
                if (!string.equals(this.getVersion())) continue;
                if (Config.trace) {
                    Config.out.println("OracleContext: upgrade: upgrade of context from version " + string + " failed.");
                }
                throw new ConfigException(1);
            }
        }
        catch (IOException iOException) {
            if (Config.trace) {
                Config.out.println("OracleContext: upgrade: IOException: " + iOException);
            }
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: upgrade: (exit)");
        }
    }

    protected Vector getLdifFilesToLoad(String string, String string2) throws ConfigException {
        boolean bl;
        if (Config.trace) {
            Config.out.println("OracleContext: getLdifFilesToLoad: (enter)");
        }
        if (string.equals("Create")) {
            bl = true;
        } else if (string.equals("Upgrade")) {
            bl = false;
        } else {
            throw new ConfigException(2);
        }
        if (!(bl || string2 != null && string2 != "")) {
            throw new ConfigException(2);
        }
        String string3 = this.m_config.getDirectoryType();
        if (string3 == null) {
            throw new ConfigException(1);
        }
        String string4 = string3.toLowerCase() + "Context";
        string4 = bl ? string4 + "Create" : string4 + "UpgradeFrom" + string2;
        string4 = Ldif.getLdifFileDirectory(this.m_config) + File.separator + string4 + listFileExt;
        if (Config.trace) {
            Config.out.println("OracleContext: getLdifFilesToLoad: file containing the list of files: " + string4);
        }
        Vector vector = Ldif.getFileList(string4);
        if (Config.trace) {
            Config.out.println("OracleContext: getLdifFilesToLoad: (exit)");
        }
        return vector;
    }

    private Vector getSubstitutionPairs() throws ConfigException {
        if (Config.trace) {
            Config.out.println("OracleContext: getSubstitutionPairs: (enter)");
        }
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = new String[]{"%s_OracleContextDN%", this.m_oracleContextDN};
        if (Config.trace) {
            Config.out.println("OracleContext: getSubstitutionPairs: variable: " + stringArray[0] + " value: " + stringArray[1]);
        }
        vector.addElement(stringArray);
        String[] stringArray2 = new String[]{"%s_OracleContextParentDN%", DirectoryService.getParent(this.m_oracleContextDN)};
        if (Config.trace) {
            Config.out.println("OracleContext: getSubstitutionPairs: variable: " + stringArray2[0] + " value: " + stringArray2[1]);
        }
        vector.addElement(stringArray2);
        String string = this.m_ds.getUsername();
        if (string == null) {
            if (Config.trace) {
                Config.out.println("OracleContext: getSubstitutionPairs: Could not get current directory user DN.");
            }
            throw new ConfigException(1);
        }
        String[] stringArray3 = new String[]{"%s_CurrentUserDN%", string};
        if (Config.trace) {
            Config.out.println("OracleContext: getSubstitutionPairs: variable: " + stringArray3[0] + " value: " + stringArray3[1]);
        }
        vector.addElement(stringArray3);
        String string2 = this.m_config.getDirectoryType();
        if (string2 == null) {
            throw new ConfigException(1);
        }
        if (string2.equalsIgnoreCase("AD")) {
            String[] stringArray4;
            try {
                stringArray4 = this.m_ds.query(this.m_config, "", "objectclass=*", adDefaultNamingContext);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
            if (stringArray4 == null || stringArray4.length < 1) {
                throw new ConfigException(1);
            }
            String[] stringArray5 = new String[]{"%s_AdUsersDomainDN%", "CN=Users," + stringArray4[0]};
            if (Config.trace) {
                Config.out.println("OracleContext: getSubstitutionPairs: variable: " + stringArray5[0] + " value: " + stringArray5[1]);
            }
            vector.addElement(stringArray5);
        }
        if (Config.trace) {
            Config.out.println("OracleContext: getSubstitutionPairs: (exit)");
        }
        return vector;
    }
}

