/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Vector;
import oracle.net.common.OracleJNI;
import oracle.net.config.NTAce;
import oracle.net.config.NTBinding;
import oracle.net.config.NTSDException;

public class NTSecurityDescriptor {
    private Vector m_dacl = new Vector();
    private byte[] m_context = null;
    private int m_control = 0;
    private String m_errorMsg = null;
    public static final int DACL_PROTECTED = 4096;
    public static final int ADMIN_DB_SECURITY_ADMINS = 1;
    public static final int ADMIN_DB_ADMINS = 2;
    public static final int ADMIN_DATABASE = 3;
    public static final int ADMIN_ENTERPRISE_DOMAIN = 4;

    public static void InitializeContainers(NTBinding nTBinding, String string) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        String string2 = "CN=Products," + string;
        String string3 = "CN=OracleDBSecurity," + string2;
        String string4 = "CN=OracleDefaultDomain," + string3;
        String string5 = NTSecurityDescriptor.GetGroupDN(string, "OracleNetAdmins");
        String string6 = NTSecurityDescriptor.GetGroupDN(string, "OracleDBSecurityAdmins");
        String string7 = NTSecurityDescriptor.GetGroupDN(string, "OracleDBCreators");
        String[] stringArray = new String[]{"orclNetService", "orclNetDescriptionList", "orclNetDescription", "orclNetAddressList", "orclNetAddress"};
        String string8 = nTSecurityDescriptor.X500ToNT40(string5);
        String string9 = nTSecurityDescriptor.X500ToNT40(string6);
        String string10 = nTSecurityDescriptor.X500ToNT40(string7);
        String string11 = nTSecurityDescriptor.SchemaObjectToGuid("orclDBServer");
        String string12 = nTSecurityDescriptor.SchemaObjectToGuid("orclNetDescString");
        String string13 = nTSecurityDescriptor.SchemaObjectToGuid("orclNetDescName");
        nTSecurityDescriptor.read(string6);
        nTSecurityDescriptor.removeAllAces(true);
        nTSecurityDescriptor.allowInherit(false);
        nTSecurityDescriptor.addAce(983095, 0, 2, 0, null, null, string9);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string7);
        nTSecurityDescriptor.removeAllAces(true);
        nTSecurityDescriptor.allowInherit(false);
        nTSecurityDescriptor.addAce(983095, 0, 2, 0, null, null, string9);
        nTSecurityDescriptor.addAce(131092, 0, 2, 0, null, null, string10);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string5);
        nTSecurityDescriptor.removeAllAces(true);
        nTSecurityDescriptor.allowInherit(false);
        nTSecurityDescriptor.addAce(983095, 0, 2, 0, null, null, string9);
        nTSecurityDescriptor.addAce(983095, 0, 2, 0, null, null, string8);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string4);
        nTSecurityDescriptor.removeAllAces(false);
        nTSecurityDescriptor.addAce(917556, 0, 0, 0, null, null, string10);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string3);
        nTSecurityDescriptor.removeAllAces(true);
        nTSecurityDescriptor.allowInherit(false);
        nTSecurityDescriptor.addAce(524288, 0, 2, 0, null, null, "CREATOR OWNER");
        nTSecurityDescriptor.addAce(983103, 0, 2, 0, null, null, string9);
        nTSecurityDescriptor.addAce(131092, 0, 2, 0, null, null, string10);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string2);
        nTSecurityDescriptor.removeAllAces(false);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.removeAllAces(true);
        nTSecurityDescriptor.allowInherit(false);
        nTSecurityDescriptor.addAce(524288, 0, 2, 0, null, null, "CREATOR OWNER");
        nTSecurityDescriptor.addAce(983103, 0, 2, 0, null, null, string9);
        nTSecurityDescriptor.addAce(131092, 0, 2, 0, null, null, "Everyone");
        nTSecurityDescriptor.addAce(1, 0, 0, 0, null, null, string10);
        for (int i = 0; i < stringArray.length; ++i) {
            String string14 = nTSecurityDescriptor.SchemaObjectToGuid(stringArray[i]);
            nTSecurityDescriptor.addAce(3, 5, 2, 1, string14, null, string8);
            nTSecurityDescriptor.addAce(917556, 5, 10, 2, null, string14, string8);
        }
        nTSecurityDescriptor.addAce(32, 5, 10, 3, string12, string11, string8);
        nTSecurityDescriptor.addAce(32, 5, 10, 3, string13, string11, string8);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static void InitializeDB(NTBinding nTBinding, String string, String string2) throws NTSDException {
        NTSecurityDescriptor.InitializeDB(nTBinding, string, string2, null, null);
    }

    public static void InitializeDB(NTBinding nTBinding, String string, String string2, String string3, String string4) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        String string5 = nTSecurityDescriptor.X500ToNT40(string2);
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.removeAllAces(false);
        nTSecurityDescriptor.addAce(983103, 0, 2, 0, null, null, string5);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static void InitializeED(NTBinding nTBinding, String string) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.removeAllAces(false);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static void InitializeOracleSchemaVersion(NTBinding nTBinding, String string) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.addAce(Integer.MIN_VALUE, 0, 2, 0, null, null, "AUTHENTICATED USERS");
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static void AddDBToED(NTBinding nTBinding, String string, String string2) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        String string3 = nTSecurityDescriptor.GetNTServiceAccount(string2, null, null);
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.addAce(131092, 0, 2, 0, null, null, string3);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static void RemoveDBFromED(NTBinding nTBinding, String string, String string2) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        String string3 = nTSecurityDescriptor.GetNTServiceAccount(string2, null, null);
        nTSecurityDescriptor.read(string);
        nTSecurityDescriptor.remAce(131092, 0, 2, 0, null, null, string3);
        nTSecurityDescriptor.save();
        nTSecurityDescriptor.free();
    }

    public static String[] EnumAdmins(NTBinding nTBinding, int n, String string) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        Object[] objectArray = new String[]{};
        if (n == 1) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBSecurityAdmins");
        }
        if (n == 2) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBCreators");
        }
        if (n == 1 || n == 2) {
            objectArray = nTSecurityDescriptor.enumerateGroup(string);
            if (objectArray == null) {
                throw new NTSDException();
            }
        } else if (n == 3 || n == 4) {
            int n2;
            Vector<String> vector = new Vector<String>();
            nTSecurityDescriptor.read(string);
            Vector vector2 = nTSecurityDescriptor.enumerateDacl();
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                NTAce nTAce = (NTAce)vector2.elementAt(n2);
                if (nTAce.getAccessMask() != 983095 || nTAce.getAceType() != 0 || nTAce.getAceFlags() != 2 || nTAce.getFlags() != 0 || nTAce.getObjectType() != null || nTAce.getInheritedObjectType() != null) continue;
                String string2 = nTAce.getTrustee();
                boolean bl = false;
                for (int i = 0; i < vector.size() && !bl; ++i) {
                    if (!string2.equalsIgnoreCase((String)vector.elementAt(i))) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.addElement(string2);
            }
            nTSecurityDescriptor.free();
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray[n2] = nTSecurityDescriptor.NT40ToX500((String)objectArray[n2]);
            }
        }
        return objectArray;
    }

    public static void AddAdmin(NTBinding nTBinding, int n, String string, String string2) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        if (n == 1) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBSecurityAdmins");
        }
        if (n == 2) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBCreators");
        }
        if (n == 1 || n == 2) {
            nTSecurityDescriptor.addMember(string, string2);
        } else if (n == 3 || n == 4) {
            String string3 = nTSecurityDescriptor.X500ToNT40(string2);
            nTSecurityDescriptor.read(string);
            nTSecurityDescriptor.addAce(983095, 0, 2, 0, null, null, string3);
            nTSecurityDescriptor.save();
            nTSecurityDescriptor.free();
        }
    }

    public static void RemAdmin(NTBinding nTBinding, int n, String string, String string2) throws NTSDException {
        NTSecurityDescriptor nTSecurityDescriptor = new NTSecurityDescriptor(nTBinding);
        if (n == 1) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBSecurityAdmins");
        }
        if (n == 2) {
            string = NTSecurityDescriptor.GetGroupDN(string, "OracleDBCreators");
        }
        if (n == 1 || n == 2) {
            nTSecurityDescriptor.remMember(string, string2);
        } else if (n == 3 || n == 4) {
            String string3 = nTSecurityDescriptor.X500ToNT40(string2);
            nTSecurityDescriptor.read(string);
            nTSecurityDescriptor.remAce(983095, 0, 2, 0, null, null, string3);
            nTSecurityDescriptor.save();
            nTSecurityDescriptor.free();
        }
    }

    public NTSecurityDescriptor(NTBinding nTBinding) throws NTSDException {
        int n = 0;
        n = this.native_init(nTBinding.getContext());
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
    }

    public void read(String string) throws NTSDException {
        int n = 0;
        n = this.native_initsd(string);
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
        n = this.native_getDacl();
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
    }

    public void setControl(int n) {
        this.m_control = n;
    }

    public int getControl() {
        return this.m_control;
    }

    public void allowInherit(boolean bl) {
        this.m_control = bl ? (this.m_control &= 0xFFFFEFFF) : (this.m_control |= 0x1000);
    }

    public Vector enumerateDacl() {
        return this.m_dacl;
    }

    public void addAce(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        NTAce nTAce = new NTAce();
        nTAce.setAccessMask(n);
        nTAce.setAceType(n2);
        nTAce.setAceFlags(n3);
        nTAce.setFlags(n4);
        nTAce.setObjectType(string);
        nTAce.setInheritedObjectType(string2);
        nTAce.setTrustee(string3);
        int n5 = 0;
        if ((n2 & 5) == 0) {
            NTAce nTAce2;
            for (n5 = 0; n5 < this.m_dacl.size() && ((nTAce2 = (NTAce)this.m_dacl.elementAt(n5)).getAceFlags() & 0x10) == 0 && (nTAce2.getAceType() & 0) == 0 && (nTAce2.getAceType() & 5) == 0; ++n5) {
            }
        } else {
            NTAce nTAce3;
            for (n5 = 0; n5 < this.m_dacl.size() && ((nTAce3 = (NTAce)this.m_dacl.elementAt(n5)).getAceFlags() & 0x10) == 0; ++n5) {
            }
        }
        this.m_dacl.insertElementAt(nTAce, n5);
    }

    public void remAce(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        NTAce nTAce = new NTAce();
        nTAce.setAccessMask(n);
        nTAce.setAceType(n2);
        nTAce.setAceFlags(n3);
        nTAce.setFlags(n4);
        nTAce.setObjectType(string);
        nTAce.setInheritedObjectType(string2);
        nTAce.setTrustee(string3);
        for (int i = 0; i < this.m_dacl.size(); ++i) {
            NTAce nTAce2 = (NTAce)this.m_dacl.elementAt(i);
            if (!nTAce2.equals(nTAce)) continue;
            this.m_dacl.removeElementAt(i);
            break;
        }
    }

    public void removeAllAces(boolean bl) {
        if (bl) {
            this.m_dacl.removeAllElements();
        } else {
            boolean bl2 = true;
            while (bl2) {
                bl2 = false;
                for (int i = 0; i < this.m_dacl.size() && !bl2; ++i) {
                    NTAce nTAce = (NTAce)this.m_dacl.elementAt(i);
                    if ((nTAce.getAceFlags() & 0x10) != 0) continue;
                    this.m_dacl.removeElementAt(i);
                    bl2 = true;
                }
            }
        }
    }

    public void save() throws NTSDException {
        int n = 0;
        n = this.native_setDacl();
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
        n = this.native_savesd();
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
    }

    public void free() {
        this.native_freesd();
        this.m_dacl.removeAllElements();
    }

    public void finalize() {
        this.free();
        this.native_free();
    }

    public static String GetGroupDN(String string, String string2) {
        String string3 = "";
        String string4 = "";
        while (!string4.equalsIgnoreCase("DC") && string.length() > 0) {
            int n = string.indexOf("=");
            if (n == -1) {
                return "CN=" + string2;
            }
            string4 = string.substring(0, n).trim();
            n = string.indexOf(",");
            if (n == -1) {
                return "CN=" + string2;
            }
            string3 = string;
            string = string.substring(n + 1).trim();
        }
        if (string.length() == 0) {
            return "CN=" + string2;
        }
        return "CN=" + string2 + ",CN=Users," + string3;
    }

    public String[] enumerateGroup(String string) {
        String[] stringArray = this.native_enumgrp(string);
        return stringArray;
    }

    public void addMember(String string, String string2) throws NTSDException {
        int n = this.native_addmem(string, string2);
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
    }

    public void remMember(String string, String string2) throws NTSDException {
        int n = this.native_remmem(string, string2);
        if (n < 0) {
            throw new NTSDException(n, this.m_errorMsg);
        }
    }

    public String SchemaObjectToGuid(String string) {
        String string2 = this.native_sotg(string);
        return string2;
    }

    public String X500ToNT40(String string) {
        String string2 = this.native_x500tont40(string);
        return string2;
    }

    public String NT40ToX500(String string) {
        String string2 = this.native_nt40tox500(string);
        return string2;
    }

    public String GetNTServiceAccount(String string, String string2, String string3) {
        String string4 = this.native_getntsrvacc(string, string2, string3);
        return string4;
    }

    public void setErrorMsg(String string) {
        this.m_errorMsg = string;
    }

    private native int native_init(byte[] var1);

    private native int native_free();

    private native int native_initsd(String var1);

    private native int native_getDacl();

    private native int native_setDacl();

    private native int native_savesd();

    private native int native_freesd();

    private native String[] native_enumgrp(String var1);

    private native int native_addmem(String var1, String var2);

    private native int native_remmem(String var1, String var2);

    private native String native_sotg(String var1);

    private native String native_x500tont40(String var1);

    private native String native_nt40tox500(String var1);

    private native String native_getntsrvacc(String var1, String var2, String var3);

    static {
        OracleJNI.loadJniLibrary("nad");
    }
}

