/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.config.AddressListConfig;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.ListenerException;
import oracle.net.config.ParameterSource;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class Listener
extends ParameterSource {
    private Vector endPoints = new Vector();
    private Vector sidDescs = new Vector();
    public static String[] listenerParameterList = new String[]{"STARTUP_WAIT_TIME_", "CONNECT_TIMEOUT_", "LOGGING_", "LOG_FILE_", "LOG_DIRECTORY_", "USE_PLUG_AND_PLAY_", "PASSWORDS_", "TRACE_LEVEL_", "TRACE_FILE_", "TRACE_DIRECTORY_", "TRACE_FILELEN_", "TRACE_TIMESTAMP_", "TRACE_FILENO_", "TRACE_PERCENT_FREE_", "ADR_BASE_", "DIAG_ADR_ENABLED_", "SQLNET.DIAG_ADR_ENABLED_", "DIAG_DDE_ENABLED_", "SQLNET.DIAG_DDE_ENABLED_", "DIAG_BUCKET_SIZE_", "REMOTE_REGISTRATION_ADDRESS_"};

    public static boolean exists(Config config, String string) {
        block7: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, true)) {
                        return true;
                    }
                    break block7;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    return false;
                }
            }
            NLParamParser nLParamParser = null;
            try {
                nLParamParser = config.getNlpa(3);
            }
            catch (ConfigException configException) {
                return false;
            }
            if (nLParamParser.getNLPListElement(string) != null) {
                return true;
            }
        }
        return false;
    }

    public static void delete(Config config, String string) throws ListenerException {
        if (Listener.exists(config, string)) {
            if (config.netConfigUsesLDAP()) {
                try {
                    config.getDS().delete(config, string, true, true);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ListenerException(directoryServiceException);
                }
            }
            try {
                NLParamParser nLParamParser = config.getNlpa(3);
                String[] stringArray = nLParamParser.getNLPAllNames();
                block5: for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    if (stringArray[i].equals(string.toUpperCase())) {
                        nLParamParser.removeNLPListElement(stringArray[i]);
                        continue;
                    }
                    for (int j = 0; j < listenerParameterList.length; ++j) {
                        if (!stringArray[i].equals(listenerParameterList[j] + string.toUpperCase())) continue;
                        nLParamParser.removeNLPListElement(stringArray[i]);
                        continue block5;
                    }
                }
                if (nLParamParser.getNLPListSize() > 0) {
                    nLParamParser.saveNLParams();
                } else if (nLParamParser.configuredInFile()) {
                    File file = new File(config.getFilename(3));
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    config.deleteNlpa(3);
                }
            }
            catch (ConfigException configException) {
                throw new ListenerException(configException.errno);
            }
            catch (IOException iOException) {
                throw new ListenerException(iOException);
            }
        }
    }

    public static String[] enumListeners(Config config) {
        if (config.netConfigUsesLDAP()) {
            try {
                DirectoryService directoryService = config.getDS();
                String string = directoryService.getSystemObjectPath(config);
                String string2 = "objectclass=OrclListener";
                String[] stringArray = directoryService.enumDNs(config, string, string2, false);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = directoryService.getCN(stringArray[i]);
                }
                return stringArray;
            }
            catch (DirectoryServiceException directoryServiceException) {
                return null;
            }
        }
        Vector<String> vector = new Vector<String>();
        NLParamParser nLParamParser = null;
        try {
            nLParamParser = config.getNlpa(3);
        }
        catch (ConfigException configException) {
            return null;
        }
        String[] stringArray = nLParamParser.getNLPAllNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                NVPair nVPair = nLParamParser.getNLPListElement(stringArray[i]);
                String string3 = nVPair.getName();
                String string4 = string3.toUpperCase();
                if (string4.startsWith("REMOTE_REGISTRATION_ADDRESS") || nVPair.getRHSType() != NVPair.RHS_LIST || nVPair.getListSize() <= 0 || !(string = nVPair.getListElement(0).getName()).equalsIgnoreCase("DESCRIPTION_LIST") && !string.equalsIgnoreCase("DESCRIPTION") && !string.equalsIgnoreCase("ADDRESS_LIST") && !string.equalsIgnoreCase("ADDRESS")) continue;
                vector.addElement(stringArray[i]);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] enumListeners(Config config, String string) {
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = Listener.enumListeners(config);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Listener listener = new Listener(config, objectArray[i]);
                String[] stringArray = listener.enumSID_DESCs();
                boolean bl = false;
                for (int j = 0; j < stringArray.length && !bl; ++j) {
                    String string2 = Listener.sidFromSidDesc(stringArray[j]);
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                }
                if (!bl) continue;
                vector.addElement(objectArray[i]);
                continue;
            }
            catch (ListenerException listenerException) {
                // empty catch block
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void migrateToLDAP(Config config, String string, boolean bl, boolean bl2) throws ListenerException {
        if (string != null) {
            config.setFilename(3, string);
        }
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            String[] stringArray = Listener.enumListeners(config);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Listener listener = new Listener(config, stringArray[i]);
                    listener.migrateToLDAP(config, bl, bl2);
                }
            }
        }
        catch (ListenerException listenerException) {
            if (string != null) {
                config.setFilename(3, null);
            }
            config.netConfigUsesLDAP(bl3);
            throw listenerException;
        }
        if (string != null) {
            config.setFilename(3, null);
        }
        config.netConfigUsesLDAP(bl3);
    }

    public static void migrateToFILE(Config config, String string, boolean bl, boolean bl2) throws ListenerException {
        if (string != null) {
            config.setFilename(3, string);
        }
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            String[] stringArray = Listener.enumListeners(config);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Listener listener = new Listener(config, stringArray[i]);
                    listener.migrateToFILE(config, bl, bl2);
                }
            }
        }
        catch (ListenerException listenerException) {
            if (string != null) {
                config.setFilename(3, null);
            }
            config.netConfigUsesLDAP(bl3);
            throw listenerException;
        }
        if (string != null) {
            config.setFilename(3, null);
        }
        config.netConfigUsesLDAP(bl3);
    }

    public void migrateToLDAP(Config config, boolean bl, boolean bl2) throws ListenerException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            String string = this.name;
            this.name = this.name.replace('.', '_');
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(false);
            if (bl2) {
                Listener.delete(config, this.name);
            }
        }
        catch (ListenerException listenerException) {
            config.netConfigUsesLDAP(bl3);
            throw listenerException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public void migrateToFILE(Config config, boolean bl, boolean bl2) throws ListenerException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            String string = this.name;
            this.name = config.getDS().getCN(this.name);
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(true);
            if (bl2) {
                Listener.delete(config, this.name);
            }
        }
        catch (ListenerException listenerException) {
            config.netConfigUsesLDAP(bl3);
            throw listenerException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Listener(Config config, String string) throws ListenerException {
        super(string);
        DirectoryService directoryService = config.getDS();
        this.qname = directoryService.qualifyObjectName(config, string, true);
        if (config.netConfigUsesLDAP()) {
            try {
                Hashtable hashtable = directoryService.read(config, string, true, this.getSupportedAttributes());
                String string2 = ((String[])hashtable.get("dn"))[0];
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String[] stringArray = (String[])hashtable.get(string3);
                    if (string3.equalsIgnoreCase("OrclNetEndPointList")) {
                        SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                        this.endPoints = schemaObjectConfigFactory.create(config, stringArray, string2, null);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("OrclSidList")) {
                        this.setSID_DESCs(stringArray);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("OrclNetParamList")) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n = stringArray[i].indexOf("=");
                            if (n == -1) continue;
                            String string4 = stringArray[i].substring(0, n).trim();
                            String string5 = stringArray[i].substring(n + 1).trim();
                            this.setParameter(string4, string5);
                        }
                        continue;
                    }
                    if (this.mapping.parameter(string3) == null) continue;
                    this.setParameter(this.mapping.parameter(string3), stringArray[0]);
                }
                return;
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) return;
                throw new ListenerException(directoryServiceException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ListenerException(sOExceptionConfig);
            }
        }
        try {
            this.nlpa = config.getNlpa(3);
        }
        catch (ConfigException configException) {
            throw new ListenerException(configException.errno);
        }
        String[] stringArray = this.nlpa.getNLPAllNames();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object object;
            if (stringArray[i] == null) continue;
            NVPair nVPair = this.nlpa.getNLPListElement(stringArray[i]);
            if (stringArray[i].equalsIgnoreCase(string)) {
                try {
                    nVPair = nVPair.getListElement(0);
                    SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                    object = schemaObjectConfigFactory.create(nVPair, null, null);
                    this.endPoints.addElement(object);
                    continue;
                }
                catch (SOExceptionConfig sOExceptionConfig) {
                    throw new ListenerException(sOExceptionConfig);
                }
            }
            if (stringArray[i].equalsIgnoreCase("SID_LIST_" + string)) {
                nVPair = nVPair.getListElement(0);
                for (int j = 0; j < nVPair.getListSize(); ++j) {
                    this.sidDescs.addElement(nVPair.getListElement(j).toString());
                }
                continue;
            }
            if (!stringArray[i].toUpperCase().endsWith(string.toUpperCase()) || (n = nVPair.getName().toUpperCase().lastIndexOf(string.toUpperCase())) == -1) continue;
            object = nVPair.getName().substring(0, n - 1);
            this.setParameter((String)object, this.rhsToString(nVPair));
        }
    }

    public Enumeration enumEndpoints() {
        return this.endPoints.elements();
    }

    public String[] enumEndpointsArray() {
        String[] stringArray = new String[this.endPoints.size()];
        for (int i = 0; i < this.endPoints.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endPoints.elementAt(i);
            stringArray[i] = schemaObjectConfig.toString();
        }
        return stringArray;
    }

    public void setEndpoints(Vector vector) throws ListenerException {
        this.checkEndpoints(vector);
        this.endPoints = vector;
    }

    public void remEndpoints() {
        this.endPoints.removeAllElements();
    }

    public int numOfEndpoints() {
        return this.endPoints.size();
    }

    public boolean enableIIOPEndpoint() {
        return this.findIIOP(this.endPoints, false);
    }

    public void enableIIOPEndpoint(boolean bl) throws ListenerException {
        boolean bl2 = this.findIIOP(this.endPoints, !bl);
        if (bl && !bl2) {
            String string = null;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new ListenerException(unknownHostException);
            }
            String string2 = "(DESCRIPTION=(PROTOCOL_STACK=(PRESENTATION=IIOP))(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=900)))";
            DescriptionConfig descriptionConfig = null;
            try {
                descriptionConfig = new DescriptionConfig(string2, null);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ListenerException(sOExceptionConfig);
            }
            if (this.endPoints.size() == 1) {
                SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)this.endPoints.elementAt(0);
                if (schemaObjectConfig.isA() == 3) {
                    DescriptionListConfig descriptionListConfig = (DescriptionListConfig)schemaObjectConfig;
                    descriptionListConfig.children.addElement(descriptionConfig);
                } else {
                    DescriptionListConfig descriptionListConfig = new DescriptionListConfig();
                    descriptionListConfig.children.addElement(schemaObjectConfig);
                    this.endPoints.setElementAt(descriptionListConfig, 0);
                    descriptionListConfig.children.addElement(descriptionConfig);
                }
            } else {
                this.endPoints.addElement(descriptionConfig);
            }
        }
    }

    public String[] enumSID_DESCs() {
        Object[] objectArray = new String[this.sidDescs.size()];
        this.sidDescs.copyInto(objectArray);
        return objectArray;
    }

    public void setSID_DESCs(String[] stringArray) {
        this.sidDescs.removeAllElements();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.sidDescs.addElement(stringArray[i]);
            }
        }
    }

    public void deleteSID_DESCs() {
        this.sidDescs.removeAllElements();
    }

    public void addSidDesc(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = Listener.sidFromSidDesc(string);
        String string3 = Listener.globalDBNameFromSidDesc(string);
        if (bl) {
            for (int i = 0; i < this.sidDescs.size() && !bl2; ++i) {
                String string4 = Listener.sidFromSidDesc((String)this.sidDescs.elementAt(i));
                String string5 = Listener.globalDBNameFromSidDesc((String)this.sidDescs.elementAt(i));
                if (!string2.equalsIgnoreCase(string4)) continue;
                if (string3 != null && string5 != null) {
                    if (!string3.equalsIgnoreCase(string5)) continue;
                    this.sidDescs.setElementAt(string, i);
                    bl2 = true;
                    continue;
                }
                this.sidDescs.setElementAt(string, i);
                bl2 = true;
            }
        }
        if (!bl2) {
            this.sidDescs.addElement(string);
        }
    }

    public void delSidDesc(String string) {
        boolean bl = false;
        for (int i = 0; i < this.sidDescs.size() && !bl; ++i) {
            String string2 = Listener.sidFromSidDesc((String)this.sidDescs.elementAt(i));
            if (!string.equalsIgnoreCase(string2)) continue;
            this.sidDescs.removeElementAt(i);
            bl = true;
        }
    }

    public void save(Config config, boolean bl) throws ListenerException {
        if (Listener.exists(config, this.name) && !bl) {
            throw new ListenerException(3);
        }
        if (config.netConfigUsesLDAP()) {
            String string;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            Vector<String> vector = new Vector<String>();
            String[] stringArray = new String[]{"OrclListener", "applicationProcess"};
            Vector<NNFLUpdateParam> vector2 = new Vector<NNFLUpdateParam>();
            vector2.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector2.addElement(new NNFLUpdateParam("objectclass", stringArray));
            Object[] objectArray = this.hashtable.keys();
            while (objectArray.hasMoreElements()) {
                string = (String)objectArray.nextElement();
                String string2 = (String)this.hashtable.get(string);
                String string3 = this.mapping.attribute(string);
                if (string3 == null) {
                    vector.addElement(string + "=" + string2);
                    continue;
                }
                vector2.addElement(new NNFLUpdateParam(string3, string2));
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                vector2.addElement(new NNFLUpdateParam("OrclNetParamList", (String[])objectArray));
            }
            if (this.endPoints.size() > 0) {
                objectArray = schemaObjectConfigFactory.getEndpointNames(this.endPoints);
                vector2.addElement(new NNFLUpdateParam("OrclNetEndPointList", (String[])objectArray));
            }
            if (this.sidDescs.size() > 0) {
                vector2.addElement(new NNFLUpdateParam("OrclSidList", this.enumSID_DESCs()));
            }
            objectArray = new NNFLUpdateParam[vector2.size()];
            vector2.copyInto(objectArray);
            string = null;
            try {
                string = directoryService.update(config, this.name, true, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ListenerException(directoryServiceException);
            }
            try {
                schemaObjectConfigFactory.save(config, this.endPoints, string);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new ListenerException(sOExceptionConfig);
            }
        }
        try {
            if (this.nlpa == null) {
                this.nlpa = config.getNlpa(3);
            }
            Object object = this.hashtable.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string4 = (String)this.hashtable.get(string);
                this.nlpa.addNLPListElement(string + "_" + this.name + "=" + string4);
            }
            if (this.sidDescs.size() == 0) {
                this.nlpa.removeNLPListElement("SID_LIST_" + this.name);
            } else {
                object = "(SID_LIST=";
                for (int i = 0; i < this.sidDescs.size(); ++i) {
                    object = (String)object + (String)this.sidDescs.elementAt(i);
                }
                object = (String)object + ")";
                this.nlpa.addNLPListElement("SID_LIST_" + this.name + " = " + (String)object);
            }
            if (this.endPoints.size() < 1) {
                this.nlpa.removeNLPListElement(this.name);
            } else {
                object = (SchemaObject)this.endPoints.elementAt(0);
                String string = object.toString();
                if (!string.equals("")) {
                    this.nlpa.addNLPListElement(this.name + " = " + string);
                } else {
                    this.nlpa.removeNLPListElement(this.name);
                }
            }
            if (this.nlpa.getNLPListSize() > 0) {
                this.nlpa.saveNLParams();
            } else if (this.nlpa.configuredInFile()) {
                object = new File(config.getFilename(3));
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
            } else {
                config.deleteNlpa(3);
            }
        }
        catch (ConfigException configException) {
            throw new ListenerException(configException.errno);
        }
        catch (NLException nLException) {
            throw new ListenerException(nLException);
        }
        catch (IOException iOException) {
            throw new ListenerException(iOException);
        }
    }

    public void saveAs(Config config, boolean bl, String string) throws ListenerException {
        this.name = string;
        this.save(config, bl);
    }

    private boolean findIIOP(Vector vector, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig;
            SchemaObjectConfig schemaObjectConfig2 = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig2.isA() == 3) {
                schemaObjectConfig = (DescriptionListConfig)schemaObjectConfig2;
                return this.findIIOP(schemaObjectConfig.children, bl);
            }
            if (schemaObjectConfig2.isA() != 2) continue;
            schemaObjectConfig = (DescriptionConfig)schemaObjectConfig2;
            for (int j = 0; j < ((DescriptionConfig)schemaObjectConfig).protocolStacks.size(); ++j) {
                String string = (String)((DescriptionConfig)schemaObjectConfig).protocolStacks.elementAt(j);
                if (string.toUpperCase().indexOf("IIOP") == -1) continue;
                if (bl) {
                    vector.removeElementAt(i);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void constructMapping() {
        this.mapping.set("OrclStartupWaitTime", "STARTUP_WAIT_TIME");
        this.mapping.set("OrclConnectTimeout", "CONNECT_TIMEOUT");
        this.mapping.set("OrclLogLevel", "LOGGING");
        this.mapping.set("OrclLogFile", "LOG_FILE");
        this.mapping.set("OrclLogDirectory", "LOG_DIRECTORY");
        this.mapping.set("OrclUsePlugAndPlay", "USE_PLUG_AND_PLAY");
        this.mapping.set("OrclTraceLevel", "TRACE_LEVEL");
        this.mapping.set("OrclTraceFile", "TRACE_FILE");
        this.mapping.set("OrclTraceDirectory", "TRACE_DIRECTORY");
        this.mapping.set("OrclPasswords", "PASSWORDS");
        this.mapping.set("OrclTraceFilelen", "TRACE_FILELEN");
        this.mapping.set("OrclTraceTimestamp", "TRACE_TIMESTAMP");
        this.mapping.set("OrclTraceFileno", "TRACE_FILENO");
        this.mapping.set("OrclTracePercentFree", "TRACE_PERCENT_FREE");
    }

    private static String sidFromSidDesc(String string) {
        try {
            NVFactory nVFactory = new NVFactory();
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = nVFactory.createNVPair(string);
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "SID_NAME");
            return nVPair2.getAtom();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (NLException nLException) {
            return null;
        }
    }

    private static String globalDBNameFromSidDesc(String string) {
        try {
            NVFactory nVFactory = new NVFactory();
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = nVFactory.createNVPair(string);
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "GLOBAL_DBNAME");
            return nVPair2.getAtom();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (NLException nLException) {
            return null;
        }
    }

    private void checkEndpoints(Vector vector) throws ListenerException {
        DirectoryService directoryService = new DirectoryService();
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.getShared() && directoryService.inSubtree(this.qname, schemaObjectConfig.getName())) {
                throw new ListenerException(9);
            }
            if (schemaObjectConfig.isA() == 3) {
                this.checkEndpoints(((DescriptionListConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() == 2) {
                this.checkEndpoints(((DescriptionConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() != 1) continue;
            this.checkEndpoints(((AddressListConfig)schemaObjectConfig).children);
        }
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("OrclNetEndPointList");
        vector.addElement("OrclSidList");
        vector.addElement("OrclNetParamList");
        Enumeration enumeration = this.mapping.enumAttrs();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector;
    }
}

