/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;

class Ldif {
    Ldif() {
    }

    private static String getSchemaDirectory(Config config) {
        if (Config.trace) {
            Config.out.println("Ldif.getSchemaDirectory: (enter)");
        }
        String string = config.OraHomeDir + File.separator + "ldap" + File.separator + "schema";
        if (Config.trace) {
            Config.out.println("Ldif.getSchemaDirectory: the directory is: " + string);
        }
        if (Config.trace) {
            Config.out.println("Ldif.getSchemaDirectory: (exit)");
        }
        return string;
    }

    static String getLdifFileDirectory(Config config) {
        if (Config.trace) {
            Config.out.println("Ldif.getLdifFileDirectory: (enter)");
        }
        String string = Ldif.getSchemaDirectory(config) + File.separator + config.getDirectoryType().toLowerCase();
        if (Config.trace) {
            Config.out.println("Ldif.getLdifFileDirectory: the directory is: " + string);
        }
        if (Config.trace) {
            Config.out.println("Ldif.getLdifFileDirectory: (exit)");
        }
        return string;
    }

    static void loadFiles(Config config, Vector vector, Vector vector2) throws ConfigException {
        if (Config.trace) {
            Config.out.println("Ldif.loadFiles: (enter)");
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = Ldif.instanciateFile((String)vector.elementAt(i), vector2);
            if (Config.trace) {
                Config.out.println("Ldif.loadFiles: filename to be loaded: " + string);
            }
            Ldif.loadFile(config, string);
            File file = new File(string);
            file.delete();
        }
        if (Config.trace) {
            Config.out.println("Ldif.loadFiles: (exit)");
        }
    }

    static void loadFile(Config config, String string) throws ConfigException {
        if (Config.trace) {
            Config.out.println("Ldif.loadFile: (enter)");
        }
        String string2 = config.getDirectoryServers(true)[0];
        DirectoryService directoryService = config.getDS();
        Ldif.loadFile(config.OraHomeDir, string2, directoryService.getAuthMethod(), directoryService.getCredentials(), string);
        if (Config.trace) {
            Config.out.println("Ldif.loadFile: (exit)");
        }
    }

    static void loadFile(String string, String string2, int n, String[] stringArray, String string3) throws ConfigException {
        block28: {
            Object object;
            Object object2;
            Object object3;
            String string4;
            Object object4;
            String string5 = null;
            String string6 = null;
            if (string2 == null) {
                throw new ConfigException(2);
            }
            string5 = DirectoryService.getHostFromDSAddr(string2);
            string6 = DirectoryService.getPortFromDSAddr(string2, false);
            String string7 = string + File.separator + "bin" + File.separator + "ldapmodify";
            if (n == 1) {
                object4 = "";
                string4 = "";
                if (stringArray != null && stringArray.length > 1) {
                    if (stringArray[0] != null) {
                        object4 = stringArray[0];
                    }
                    if (stringArray[1] != null) {
                        string4 = stringArray[1];
                    }
                }
                if (((String)(object3 = System.getProperty("os.name"))).startsWith("Windows")) {
                    object4 = "\"" + (String)object4 + "\"";
                    string4 = "\"" + string4 + "\"";
                }
                object2 = new String[]{string7, "-h", string5, "-p", string6, "-D", object4, "-w", string4, "-E", "utf8", "-v", "-f", string3};
                object = object2;
            } else {
                object = n == 8 ? (object4 = new String[]{string7, "-h", string5, "-p", string6, "-Z", "-E", "utf8", "-v", "-f", string3}) : (object4 = new String[]{string7, "-h", string5, "-p", string6, "-E", "utf8", "-v", "-f", string3});
            }
            object4 = string + File.separator + "network" + File.separator + "tools" + File.separator + "ldifLoadCmd.err";
            string4 = string + File.separator + "network" + File.separator + "tools" + File.separator + "ldifLoadCmd.log";
            object3 = null;
            object2 = null;
            try {
                if (new File(string + File.separator + "network" + File.separator + "tools" + File.separator + "adTraceOn").exists()) {
                    object3 = new BufferedWriter(new FileWriter((String)object4, true));
                    object2 = new BufferedWriter(new FileWriter(string4, true));
                }
                if (Ldif.runUtility(object, (BufferedWriter)object2, (BufferedWriter)object3)) break block28;
                String string8 = "";
                for (int i = 0; i < ((String[])object).length; ++i) {
                    string8 = string8 + " " + object[i];
                    if (!object[i].equals("-w")) continue;
                    ++i;
                    string8 = string8 + " <password>";
                }
                try {
                    if (object2 == null) {
                        object2 = new BufferedWriter(new FileWriter(string4));
                    }
                    ((Writer)object2).write("While attempting to load a LDIF file the ldapmodify program returned with failure.\nThe ldapmodify comand line was:\n" + string8);
                    ((BufferedWriter)object2).flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ConfigException(16);
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                throw new ConfigException(exception);
            }
            finally {
                try {
                    if (object3 != null) {
                        ((BufferedWriter)object3).close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (object2 != null) {
                        ((BufferedWriter)object2).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static Vector getFileList(String string) throws ConfigException {
        Vector vector = new Vector();
        Ldif.getFileList(string, vector);
        if (vector.size() < 1) {
            throw new ConfigException(1);
        }
        return vector;
    }

    private static void getFileList(String string, Vector vector) throws ConfigException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                System.out.println("Expected file (" + file + ") does not exist.");
                throw new ConfigException(1);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = file.getParent();
            while (bufferedReader.ready()) {
                String string3 = bufferedReader.readLine().trim();
                if (string3.length() <= 0 || string3.startsWith("#")) continue;
                String string4 = string2 + File.separator + string3;
                if (string4.endsWith(".lst")) {
                    Ldif.getFileList(string4, vector);
                    continue;
                }
                vector.addElement(string4);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    private static String instanciateFile(String string, Vector vector) throws ConfigException {
        String string2;
        try {
            String string3;
            File file = new File(string);
            string2 = file.getParent() + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".") + 1) + "ldif";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = -1;
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray = (String[])vector.elementAt(i);
                    String string4 = stringArray[0];
                    String string5 = stringArray[1];
                    int n2 = 0;
                    while ((n = string3.indexOf(string4, n2)) != -1) {
                        string3 = string3.substring(0, n) + string5 + string3.substring(n + string4.length());
                        n2 = n + string5.length();
                    }
                }
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
        return string2;
    }

    public static String instanciateLine(String string, Vector vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n2 = 0;
            while ((n = string.indexOf(string2, n2)) != -1) {
                string = string.substring(0, n) + string3 + string.substring(n + string2.length());
                n2 = n + string3.length();
            }
        }
        return string;
    }

    static void instanciateFile(String string, String string2, String[] stringArray, String[] stringArray2) throws ConfigException {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = -1;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2 = 0;
                    while ((n = string3.indexOf(stringArray[i], n2)) != -1) {
                        string3 = string3.substring(0, n) + stringArray2[i] + string3.substring(n + stringArray[i].length());
                        n2 = n + stringArray2[i].length();
                    }
                }
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runUtility(String[] stringArray, BufferedWriter bufferedWriter, BufferedWriter bufferedWriter2) {
        int n = 0;
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            bufferedInputStream = new BufferedInputStream(process.getInputStream());
            bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
            new Thread(new StreamReader(bufferedInputStream, bufferedWriter)).start();
            new Thread(new StreamReader(bufferedInputStream2, bufferedWriter2)).start();
            while (true) {
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("Ldif.runUtility(): IOException while running " + stringArray[0] + ": " + iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedInputStream.close();
                bufferedInputStream2.close();
            }
            catch (Throwable throwable) {}
        }
        return n == 0;
    }

    static String getLdifFile(Config config, String string, String string2) throws ConfigException {
        String string3 = string != null && string.equalsIgnoreCase("AD") ? "ad" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("OID") ? "oid" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("NETSCAPE") ? "ns" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("NDS") ? "nds" + string2 + ".ldif" : "oid" + string2 + ".ldif")));
        string3 = config.OraHomeDir + File.separator + "network" + File.separator + "tools" + File.separator + "config" + File.separator + string3;
        return string3;
    }

    static String getSbsFile(Config config, String string, String string2) throws ConfigException {
        String string3 = string != null && string.equalsIgnoreCase("AD") ? "ad" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("OID") ? "oid" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("NETSCAPE") ? "ns" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("NDS") ? "nds" + string2 + ".sbs" : "oid" + string2 + ".sbs")));
        string3 = config.OraHomeDir + File.separator + "network" + File.separator + "tools" + File.separator + "config" + File.separator + string3;
        return string3;
    }

    static String getRequiredVersion(Config config, String string) throws IOException, ConfigException {
        String string2;
        String string3;
        if (Config.trace) {
            Config.out.println("Ldif.getRequiredVersion: (enter)");
        }
        if (Config.trace) {
            Config.out.println("Ldif.getRequiredVersion: Type requested: " + string);
        }
        if ((string3 = config.getDirectoryType()) != null && string3.equalsIgnoreCase("AD")) {
            if (Config.trace) {
                Config.out.println("Ldif.getRequiredVersion: (exit) returning: 90000");
            }
            return "90000";
        }
        if (string.equals("OracleSchema")) {
            string2 = "SchemaVersion";
        } else if (string.equals("OracleContext")) {
            string2 = "ContextVersion";
        } else {
            throw new ConfigException(2);
        }
        String string4 = Ldif.getSchemaDirectory(config) + File.separator + "versions.txt";
        if (Config.trace) {
            Config.out.println("Ldif.getRequiredVersion: Version filename is: " + string4);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
        String string5 = null;
        while (bufferedReader.ready()) {
            String string6;
            String string7 = bufferedReader.readLine();
            if (string7.indexOf(string2) == -1) continue;
            int n = string7.indexOf("=");
            if (n == -1 || (string6 = string7.substring(string7.indexOf("=") + 1).trim()) == "") break;
            string5 = string6;
            break;
        }
        if (string5 == null) {
            Config.out.println("Ldif.getRequiredVersion: Could not parse file (" + string4 + ") for version.");
            throw new ConfigException(1);
        }
        if (Config.trace) {
            Config.out.println("Ldif.getRequiredVersion: found version");
        }
        if (Config.trace) {
            Config.out.println("Ldif.getRequiredVersion: (exit) returning: " + string5);
        }
        return string5;
    }

    static class StreamReader
    implements Runnable {
        private BufferedReader m_reader;
        private BufferedWriter m_writer;

        StreamReader(InputStream inputStream) {
            this.m_reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        StreamReader(InputStream inputStream, BufferedWriter bufferedWriter) {
            this.m_reader = new BufferedReader(new InputStreamReader(inputStream));
            this.m_writer = bufferedWriter;
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.m_reader.readLine()) != null) {
                    if (this.m_writer == null) continue;
                    this.m_writer.write(string, 0, string.length());
                    this.m_writer.newLine();
                    this.m_writer.flush();
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (this.m_reader != null) {
                        this.m_reader.close();
                    }
                }
                catch (Exception exception) {}
                this.m_reader = null;
            }
        }
    }
}

