/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Locale;
import oracle.net.common.NetStrings;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.ldap.NNFLException;
import oracle.net.nl.NLException;

public abstract class GenericConfigException
extends Exception {
    private static NetStrings ns = new NetStrings("oracle.net.config.mesg.NetApiSR", Locale.getDefault());
    public static final int ENONE = 0;
    public static final int EFAILURE = 1;
    public static final int EPARAMETER = 2;
    public static final int EOBJEXISTS = 3;
    public static final int EOBJTYPE = 4;
    public static final int EDSFAILURE = 5;
    public static final int EDSAUTHENTICATION = 6;
    public static final int EDSACCESSCONTROL = 7;
    public static final int ESOFAILURE = 8;
    public static final int ESHAREDCHILD = 9;
    public static final int ENLFAILURE = 10;
    public static final int EIOFAILURE = 11;
    public static final int EINVALIDENTRY = 12;
    public static final int ENOTSYSTEM = 13;
    public static final int ENOTSHARED = 14;
    public static final int EDSTYPE = 15;
    public static final int ELDAPMODIFY = 16;
    public static final int ENOHOMEID = 17;
    public static final int EHOSTNAME = 18;
    public static final int ESYSTEMNAME = 19;
    public static final int EANONUSER = 20;
    public static final int ENOLDAP = 21;
    public static final int EDSPARAMETER = 200;
    public static final int EMEMORY = 201;
    public static final int ECONNECTION = 202;
    public static final int EINITIALIZE = 203;
    public static final int ENOINITIALIZE = 204;
    public static final int EAUTHENTICATION = 205;
    public static final int ETIMEOUT = 206;
    public static final int ENOENTRIES = 207;
    public static final int EBUFFER = 208;
    public static final int EACCESSCONTROL = 209;
    public static final int ENOATTRIBUTE = 210;
    public static final int ENOVALUES = 211;
    public static final int ENOIMPLEMENT = 212;
    public static final String[] MESSAGES = new String[]{"None-TNS-04404", "Gen_TNS-04405", "InvParam_TNS-04406", "ObjExists-TNS-04407", "InvObjType-TNS-04408", "DirSvc-TNS-04409", "DirSvcAuth-TNS-04410", "DirSvcAccess-TNS-04411", "Addr-TNS-04412", "SharObj-TNS-04413", "File-TNS-04414", "FileIO-TNS-04415", "InvEntry-TNS-04416", "NotSysProf-TNS-04417", "NotSharProf-TNS-04418", "InvDirSvcType-TNS-04419", "Ldapmodify-TNS-04420", "HomeId-TNS-04421", "Hostname-TNS-04422", "SystemName-TNS-04423", "AnonUser-TNS-04424", "LdapConfigReq-TNS-04425"};
    public static final String[] DIRECTORY_MESSAGES = new String[]{"InvParam_TNS-04406", "DS-Memory-TNS-04426", "DS-Conn-TNS-04427", "DS-InitFail-TNS-04428", "DS-NotInit-TNS-04429", "DirSvcAuth-TNS-04410", "DS-TimeOut-TNS-04430", "DS-NoEntry-TNS-04431", "DS-Buffer-TNS-04432", "DirSvcAccess-TNS-04411", "DS-NoAttr-TNS-04433", "DS-NoVal-TNS-04434", "DS-NoFunc-TNS-04435"};
    public int errno = 0;
    protected Throwable m_nestedThrowable;
    protected String message = null;

    public GenericConfigException(int n) {
        this.errno = n;
        this.initMessageFromCode(n);
    }

    private void initMessageFromCode(int n) {
        this.message = n < 200 ? ns.getString(MESSAGES[n]) : ns.getString(DIRECTORY_MESSAGES[n - 200]);
    }

    public GenericConfigException(String string) {
        this.message = string;
    }

    public GenericConfigException(Throwable throwable) {
        this.m_nestedThrowable = throwable;
        if (throwable instanceof DirectoryServiceException) {
            DirectoryServiceException directoryServiceException = (DirectoryServiceException)throwable;
            this.errno = directoryServiceException.errno == 205 ? 6 : (directoryServiceException.errno == 209 ? 7 : 5);
        } else if (throwable instanceof NLException) {
            this.errno = 10;
        } else if (throwable instanceof IOException) {
            this.errno = 11;
        } else if (throwable instanceof SOExceptionConfig) {
            this.errno = 8;
        } else if (throwable instanceof UnknownHostException) {
            this.errno = 18;
        } else if (throwable instanceof NNFLException) {
            NNFLException nNFLException = (NNFLException)throwable;
            switch (nNFLException.errno) {
                case 0: {
                    this.errno = 0;
                    break;
                }
                case 2: {
                    this.errno = 200;
                    break;
                }
                case 100: {
                    this.errno = 201;
                    break;
                }
                case 101: {
                    this.errno = 202;
                    break;
                }
                case 102: {
                    this.errno = 203;
                    break;
                }
                case 103: {
                    this.errno = 204;
                    break;
                }
                case 104: {
                    this.errno = 205;
                    break;
                }
                case 105: {
                    this.errno = 206;
                    break;
                }
                case 106: {
                    this.errno = 207;
                    break;
                }
                case 107: {
                    this.errno = 208;
                    break;
                }
                case 108: {
                    this.errno = 209;
                    break;
                }
                case 109: {
                    this.errno = 210;
                    break;
                }
                case 110: {
                    this.errno = 211;
                    break;
                }
                case -1: {
                    this.errno = 212;
                    break;
                }
                default: {
                    this.errno = 1;
                }
            }
        }
        this.initMessageFromCode(this.errno);
    }

    public GenericConfigException(String string, Throwable throwable) {
        this(throwable);
        this.message = this.message + ": " + string;
    }

    public Throwable getNestedThrowable() {
        return this.m_nestedThrowable;
    }

    @Override
    public String getMessage() {
        if (this.m_nestedThrowable != null) {
            if (this.message != null && !this.message.equals("")) {
                String string = this.m_nestedThrowable.toString();
                if (string != null) {
                    return this.message + "\n  caused by: " + string;
                }
                return "\n  " + this.message;
            }
            return this.m_nestedThrowable.getMessage();
        }
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.m_nestedThrowable == null) {
            super.printStackTrace(printStream);
            return;
        }
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            this.m_nestedThrowable.printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.m_nestedThrowable == null) {
            super.printStackTrace(printWriter);
            return;
        }
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            this.m_nestedThrowable.printStackTrace(printWriter);
        }
    }
}

