/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryServiceException;
import oracle.net.ldap.NNFLException;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.ldap.NNFLWrapper;

public class DirectoryService {
    public static final int ENONE = 0;
    public static final int EFAILURE = 1;
    public static final int EAUTHENTICATION = 205;
    public static final int EACCESSCONTROL = 209;
    public static final String OID = "OID";
    public static final String AD = "AD";
    public static final String NDS = "NDS";
    private NNFLWrapper nnflrne = null;
    private NNFLWrapper nnflqbf = null;
    private int authMethod = 1;
    private String[] credentials = new String[]{"", ""};
    private String username = "";
    private static DnParser s_DnParser = new DnParser();
    public static final int RDBMS_ENTERPRISE_DOMAIN = 1;
    private String lastHost = null;
    private Integer lastPort = null;
    private int lastError = 0;

    public static String getParent(String string) {
        try {
            Name name = s_DnParser.parse(string);
            return name.getSuffix(1).toString();
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public static String getHostFromDSAddr(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getPortFromDSAddr(String string, boolean bl) {
        int n = string.indexOf(":");
        if (n == -1) {
            if (bl) {
                return "636";
            }
            return "389";
        }
        int n2 = string.indexOf(":", n + 1);
        if (n2 == -1) {
            if (n + 1 == string.length()) {
                return "389";
            }
            return string.substring(n + 1);
        }
        if (bl) {
            if (n2 + 1 == string.length()) {
                return "636";
            }
            return string.substring(n2 + 1);
        }
        if (string.substring(n + 1).trim().indexOf(":") == 0) {
            return "389";
        }
        return string.substring(n + 1, n2);
    }

    public void reloadParams() {
        NNFLWrapper.reloadParams();
        this.nnflrne = null;
        this.nnflqbf = null;
    }

    public void setAuthInfo(int n, String[] stringArray) {
        this.authMethod = n;
        if (stringArray != null && stringArray.length == 2) {
            this.credentials[0] = stringArray[0] == null ? "" : stringArray[0];
            this.credentials[1] = stringArray[1] == null ? "" : stringArray[1];
        } else {
            this.credentials[0] = "";
            this.credentials[1] = "";
        }
        if (this.nnflrne != null) {
            this.nnflrne.unbind();
        }
        if (this.nnflqbf != null) {
            this.nnflqbf.unbind();
        }
        this.nnflrne = null;
        this.nnflqbf = null;
    }

    public void bind(Config config, int n, String[] stringArray) throws DirectoryServiceException {
        DirectoryServiceException directoryServiceException = null;
        int n2 = this.authMethod;
        String[] stringArray2 = new String[]{this.credentials[0], this.credentials[1]};
        this.setAuthInfo(n, stringArray);
        try {
            this.getNNFLWrapper(config);
        }
        catch (DirectoryServiceException directoryServiceException2) {
            directoryServiceException = directoryServiceException2;
        }
        this.authMethod = n2;
        this.credentials[0] = stringArray2[0];
        this.credentials[1] = stringArray2[1];
        if (directoryServiceException != null) {
            throw directoryServiceException;
        }
    }

    public void unbind(Config config) {
        if (this.nnflqbf != null) {
            this.nnflqbf.unbind();
        }
        if (this.nnflrne != null) {
            this.nnflrne.unbind();
        }
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public String[] getCredentials() {
        return this.credentials;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean available(Config config) {
        try {
            this.getNNFLWrapperQBF(config);
        }
        catch (DirectoryServiceException directoryServiceException) {
            return false;
        }
        return true;
    }

    public boolean configured(Config config) {
        try {
            Config config2 = new Config(config.OraHomeDir, 0, null);
            String string = config2.getDirectoryType();
            if (string != null) {
                return true;
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return false;
    }

    public int getLastError() {
        int n = this.lastError;
        this.lastError = 0;
        return n;
    }

    public void setLastError(int n) {
        this.lastError = n;
    }

    public boolean dnExists(Config config, String string, boolean bl) throws DirectoryServiceException {
        String string2 = config.getCurrentOracleContext();
        String string3 = string2 == null ? this.qualifyObjectName(config, string, bl) : "cn=" + string + "," + string2;
        this.getNNFLWrapper(config);
        int n = this.nnflqbf.queryByFilter(string3, 0, "objectclass=*", null, false);
        if (n == 106) {
            return false;
        }
        if (n != 0) {
            this.throwException(n);
        }
        if ((n = this.nnflqbf.getNextEntry()) == 0) {
            this.nnflqbf.freeResultMemory();
            return true;
        }
        if (n != 106) {
            this.throwException(n);
        }
        return false;
    }

    public boolean exists(Config config, String string, boolean bl) throws DirectoryServiceException {
        String string2 = this.qualifyObjectName(config, string, bl);
        this.getNNFLWrapper(config);
        int n = this.nnflrne.readNamedEntry(string2);
        if (n == 0) {
            this.nnflrne.freeResultMemory();
            return true;
        }
        if (n != 106) {
            this.throwException(n);
        }
        return false;
    }

    String getProductSchemaVersion(Config config, String string) throws DirectoryServiceException {
        if (Config.trace) {
            Config.out.println("DirectoryService: getProductSchemaVersion: (enter)");
        }
        this.getNNFLWrapper(config);
        String string2 = null;
        try {
            string2 = this.nnflrne.getProductSchemaVersion(string);
        }
        catch (NNFLException nNFLException) {
            throw new DirectoryServiceException(nNFLException);
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getProductSchemaVersion: (exit) returning: " + string2);
        }
        return string2;
    }

    String getOracleContextVersion(Config config, String string) throws DirectoryServiceException {
        if (Config.trace) {
            Config.out.println("DirectoryService: getOracleContextVersion: (enter)");
        }
        this.getNNFLWrapper(config);
        String string2 = null;
        String string3 = DirectoryService.getParent(string);
        if (Config.trace) {
            Config.out.println("DirectoryService: getOracleContextVersion: parent DN is " + string3);
        }
        try {
            string2 = this.nnflqbf.getContextVersion(string3);
        }
        catch (NNFLException nNFLException) {
            throw new DirectoryServiceException(nNFLException);
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getOracleContextVersion: (exit) returning: " + string2);
        }
        return string2;
    }

    String getDBCompatibilityVersion(Config config, String string) throws DirectoryServiceException {
        String string2 = this.qualifyObjectName(config, string, false);
        String[] stringArray = this.read(config, "cn=OracleDBSecurity,cn=Products," + string2, false, "orclDBVersionCompatibility");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public void delete(Config config, String string, boolean bl, boolean bl2) throws DirectoryServiceException {
        Object object;
        String string2 = config.getCurrentOracleContext();
        String string3 = string2 == null ? this.qualifyObjectName(config, string, bl) : (((String)(object = string.toLowerCase())).indexOf("oraclecontext") == -1 ? (string.startsWith("cn=") ? string + "," + string2 : "cn=" + string + "," + string2) : string);
        this.getNNFLWrapper(config);
        int n = this.nnflqbf.queryByFilter(string3, 0, "objectclass=*", null, false);
        if (n == 0 && (n = this.nnflqbf.getNextEntry()) == 0) {
            string3 = this.nnflqbf.currDN;
            this.nnflqbf.freeResultMemory();
        } else {
            if (n == 106) {
                return;
            }
            this.throwException(n);
        }
        object = new Vector();
        n = this.nnflqbf.queryByFilter(string3, 1, "objectclass=*", null, false);
        if (n == 0) {
            while (this.nnflqbf.getNextEntry() == 0) {
                ((Vector)object).addElement(this.nnflqbf.currDN);
            }
            this.nnflqbf.freeResultMemory();
        } else {
            this.throwException(n);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this.delete(config, (String)((Vector)object).elementAt(i), false, true);
        }
        if (bl2 && (n = this.nnflqbf.deleteNamedEntry(string3)) != 0) {
            this.throwException(n);
        }
    }

    public String[] enumDNs(Config config, String string, String string2, boolean bl) throws DirectoryServiceException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        this.getNNFLWrapperQBF(config);
        n = bl ? this.nnflqbf.queryByFilter(string, 2, string2, null, false) : this.nnflqbf.queryByFilter(string, 1, string2, null, false);
        if (n != 0) {
            if (n == 106) {
                return new String[0];
            }
            this.throwException(n);
        }
        while ((n = this.nnflqbf.getNextEntry()) == 0) {
            vector.addElement(this.nnflqbf.currDN);
        }
        this.nnflqbf.freeResultMemory();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] read(Config config, String string, boolean bl, String string2) throws DirectoryServiceException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        Hashtable hashtable = this.read(config, string, bl, vector);
        String[] stringArray = (String[])hashtable.get(string2);
        return stringArray;
    }

    public Hashtable read(Config config, String string, boolean bl, Vector vector) throws DirectoryServiceException {
        String string2 = this.qualifyObjectName(config, string, bl);
        this.getNNFLWrapper(config);
        int n = this.nnflrne.readNamedEntry(string2);
        if (n == 0) {
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            String[] stringArray = new String[]{this.nnflrne.currDN};
            hashtable.put("dn", stringArray);
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                n = this.nnflrne.getAttrValues(string3);
                if (n != 0) continue;
                hashtable.put(string3, this.nnflrne.currVals);
            }
            this.nnflrne.freeResultMemory();
            return hashtable;
        }
        this.throwException(n);
        return null;
    }

    public String[] query(Config config, String string, String string2, String string3) throws DirectoryServiceException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        Hashtable hashtable = this.query(config, string, string2, vector);
        String[] stringArray = (String[])hashtable.get(string3);
        return stringArray;
    }

    public String[] ndsquery(Config config, String string, String string2, String string3) throws DirectoryServiceException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        Hashtable hashtable = this.ndsquery(config, string, string2, vector);
        String[] stringArray = (String[])hashtable.get(string3);
        return stringArray;
    }

    public Hashtable ndsquery(Config config, String string, String string2, Vector vector) throws DirectoryServiceException {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = 0;
        this.getNNFLWrapperQBF(config);
        n = this.nnflqbf.queryByFilter(string, 2, string2, null, false);
        if (n != 0) {
            this.throwException(n);
        }
        if ((n = this.nnflqbf.getNextEntry()) != 0) {
            if (n == 106) {
                this.nnflqbf.freeResultMemory();
                return hashtable;
            }
            this.throwException(n);
        }
        String[] stringArray = new String[]{this.nnflqbf.currDN};
        hashtable.put("dn", stringArray);
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            n = this.nnflqbf.getAttrValues(string3);
            if (n == 0) {
                hashtable.put(string3, this.nnflqbf.currVals);
                continue;
            }
            if (n == 109) continue;
            this.throwException(n);
        }
        this.nnflqbf.freeResultMemory();
        return hashtable;
    }

    public Hashtable query(Config config, String string, String string2, Vector vector) throws DirectoryServiceException {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = 0;
        this.getNNFLWrapperQBF(config);
        String[] stringArray = null;
        if (vector != null && vector.size() > 0) {
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
        }
        if ((n = this.nnflqbf.queryByFilter(string, 0, string2, stringArray, false)) != 0) {
            this.throwException(n);
        }
        if ((n = this.nnflqbf.getNextEntry()) != 0) {
            this.throwException(n);
        }
        String[] stringArray2 = new String[]{this.nnflqbf.currDN};
        hashtable.put("dn", stringArray2);
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            n = this.nnflqbf.getAttrValues(string3);
            if (n == 0) {
                hashtable.put(string3, this.nnflqbf.currVals);
                continue;
            }
            if (n == 109 || AD.equalsIgnoreCase(config.getDirectoryType()) && n == 110) continue;
            this.throwException(n);
        }
        this.nnflqbf.freeResultMemory();
        return hashtable;
    }

    public String update(Config config, String string, boolean bl, NNFLUpdateParam[] nNFLUpdateParamArray, Vector vector, boolean bl2) throws DirectoryServiceException {
        return this.update(config, string, bl, nNFLUpdateParamArray, vector, bl2, true);
    }

    protected String update(Config config, String string, boolean bl, NNFLUpdateParam[] nNFLUpdateParamArray, Vector vector, boolean bl2, boolean bl3) throws DirectoryServiceException {
        Object object;
        String string2 = this.qualifyObjectName(config, string, bl);
        this.getNNFLWrapper(config);
        nNFLUpdateParamArray = this.combineValues(nNFLUpdateParamArray);
        int n = this.nnflqbf.queryByFilter(string2, 0, "objectclass=*", null, false);
        if (n == 0 && (n = this.nnflqbf.getNextEntry()) == 0) {
            String string3;
            int n2;
            object = new Vector();
            Vector<NNFLUpdateParam> vector2 = new Vector<NNFLUpdateParam>();
            Vector<NNFLUpdateParam> vector3 = new Vector<NNFLUpdateParam>();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (vector != null) {
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    string3 = (String)vector.elementAt(n2);
                    hashtable.put(string3.toLowerCase(), "");
                }
            }
            for (n2 = 0; n2 < nNFLUpdateParamArray.length; ++n2) {
                if (this.nnflqbf.getAttrValues(nNFLUpdateParamArray[n2].getAttrName()) == 0) {
                    if (!(nNFLUpdateParamArray[n2].getAttrName().equalsIgnoreCase("cn") || nNFLUpdateParamArray[n2].getAttrName().equalsIgnoreCase("objectclass") || this.equalValues(this.nnflqbf.currVals, nNFLUpdateParamArray[n2].getAttrVals()))) {
                        vector2.addElement(nNFLUpdateParamArray[n2]);
                    }
                } else {
                    ((Vector)object).addElement(nNFLUpdateParamArray[n2]);
                }
                hashtable.remove(nNFLUpdateParamArray[n2].getAttrName().toLowerCase());
            }
            Object[] objectArray = hashtable.keys();
            while (objectArray.hasMoreElements()) {
                string3 = (String)objectArray.nextElement();
                if (this.nnflqbf.getAttrValues(string3) != 0) continue;
                String[] stringArray = new String[]{""};
                vector3.addElement(new NNFLUpdateParam(string3, stringArray));
            }
            this.nnflqbf.freeResultMemory();
            if (bl2) {
                this.delete(config, string2, false, false);
            }
            if (((Vector)object).size() > 0) {
                objectArray = new NNFLUpdateParam[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                n = this.nnflqbf.updateEntry(string2, "top", (NNFLUpdateParam[])objectArray, 1);
                if (n != 0) {
                    this.throwException(n);
                }
            }
            if (vector2.size() > 0) {
                objectArray = new NNFLUpdateParam[vector2.size()];
                vector2.copyInto(objectArray);
                n = this.nnflqbf.updateEntry(string2, "top", (NNFLUpdateParam[])objectArray, 3);
                if (n != 0) {
                    this.throwException(n);
                }
            }
            if (vector3.size() > 0) {
                objectArray = new NNFLUpdateParam[vector3.size()];
                vector3.copyInto(objectArray);
                n = this.nnflqbf.updateEntry(string2, "top", (NNFLUpdateParam[])objectArray, 2);
                if (n != 0) {
                    this.throwException(n);
                }
            }
        } else if (n == 106) {
            n = this.nnflqbf.updateEntry(string2, "top", nNFLUpdateParamArray, 0);
            if (n != 0) {
                this.throwException(n);
            }
        } else {
            this.throwException(n);
        }
        object = null;
        if (bl3) {
            n = this.nnflqbf.queryByFilter(string2, 0, "objectclass=*", null, false);
            if (n != 0 || (n = this.nnflqbf.getNextEntry()) != 0) {
                this.throwException(n);
            }
            object = this.nnflqbf.currDN;
            this.nnflqbf.freeResultMemory();
        }
        return object;
    }

    public void updateSchema(Config config) throws DirectoryServiceException {
        this.getNNFLWrapper(config);
        NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("schemaUpdateNow", "1")};
        int n = this.nnflrne.updateEntry("", "top", nNFLUpdateParamArray, 1);
        if (n != 0) {
            this.throwException(n);
        }
    }

    public String getSystemObjectPath(Config config) {
        String string = config.homeID();
        String string2 = config.systemName();
        if (string == null || string2 == null) {
            return null;
        }
        return "cn=" + string + ", " + string2;
    }

    public String getDomainObjectPath(Config config) {
        return config.oracleContext();
    }

    public String qualifyObjectName(Config config, String string, boolean bl) {
        if (bl) {
            if (string.indexOf("=") == -1 && string.indexOf(".") == -1 && string.indexOf("@") == -1) {
                String string2 = this.getSystemObjectPath(config);
                if (string2 == null) {
                    return null;
                }
                return "cn=" + string + ", " + string2;
            }
        } else {
            NNFLWrapper nNFLWrapper = new NNFLWrapper();
            if (nNFLWrapper.nameToX500(string, false, false, true) == 0) {
                return nNFLWrapper.currDN;
            }
        }
        return string;
    }

    public String qualifyRDBMSObjectName(Config config, String string, int n) {
        if (string.indexOf("=") != -1 || string.indexOf(".") != -1 || string.indexOf("@") != -1) {
            return string;
        }
        String string2 = config.oracleContext();
        if (n == 1) {
            return "cn=" + string + ", cn=OracleDBSecurity, cn=Products, " + string2;
        }
        return string;
    }

    public String getCN(String string) {
        return this.getCN(string, true);
    }

    public String getCN(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("=");
        if (n != -1) {
            try {
                String string2 = s_DnParser.parse(string).get(0);
                if (!bl) {
                    return string2;
                }
                int n2 = -1;
                n2 = string2.indexOf(61);
                if (n2 != -1) {
                    return string2.substring(n2 + 1);
                }
                return string2;
            }
            catch (NamingException namingException) {
                return null;
            }
        }
        int n3 = string.indexOf("@");
        if (n3 != -1) {
            int n4 = string.indexOf(".");
            if (n4 != -1) {
                return string.substring(0, n4).trim();
            }
            return string.substring(0, n3).trim();
        }
        int n5 = string.lastIndexOf(".");
        if (n5 != -1) {
            return string.substring(0, n5).trim();
        }
        return string;
    }

    public boolean inSubtree(String string, String string2) {
        NNFLWrapper nNFLWrapper = new NNFLWrapper();
        nNFLWrapper.nameToX500(string, false, false, true);
        string = nNFLWrapper.currDN;
        nNFLWrapper.nameToX500(string2, false, false, true);
        string2 = nNFLWrapper.currDN;
        String[] stringArray = this.explodeDN(string, false);
        String[] stringArray2 = this.explodeDN(string2, false);
        if (stringArray2.length < stringArray.length) {
            return false;
        }
        for (int i = 1; i <= stringArray.length; ++i) {
            if (stringArray[stringArray.length - i].equalsIgnoreCase(stringArray2[stringArray2.length - i])) continue;
            return false;
        }
        return true;
    }

    public String[] explodeDN(String string, boolean bl) {
        String[] stringArray = null;
        try {
            Name name = s_DnParser.parse(string);
            stringArray = new String[name.size()];
            for (int i = 0; i < name.size(); ++i) {
                if (bl) {
                    String string2 = name.get(i);
                    stringArray[i] = string2.substring(string2.indexOf(61) + 1).trim();
                    continue;
                }
                stringArray[i] = name.get(i);
            }
        }
        catch (NamingException namingException) {
            return null;
        }
        return stringArray;
    }

    public String[] getOracleContexts(Config config) throws DirectoryServiceException {
        String[] stringArray = this.enumDNs(config, "", "objectclass=orclContext", true);
        return stringArray;
    }

    public String[] getOracleContexts(Config config, String string) throws DirectoryServiceException {
        String[] stringArray = this.enumDNs(config, string, "objectclass=orclContext", true);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private NNFLWrapper getNNFLWrapperRNE(Config config) throws DirectoryServiceException {
        String string = null;
        if (Config.trace) {
            Config.out.println("DirectoryService: getNNFLWrapperRNE(): (enter)");
        }
        if ((string = config.getDirectoryType()) != null && !string.equalsIgnoreCase(AD) && this.authMethod == 8) {
            this.throwException(101);
        }
        if (this.nnflrne == null) {
            this.nnflrne = new NNFLWrapper();
            int n = this.nnflrne.setAuthInfo(this.authMethod, this.credentials);
            if (n != 0) {
                this.nnflrne.unbind();
                this.nnflrne = null;
                this.throwException(n);
            }
            this.saveUsername(this.nnflrne);
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getNNFLWrapperRNE(): (exit)");
        }
        return this.nnflrne;
    }

    private NNFLWrapper getNNFLWrapperQBF(Config config) throws DirectoryServiceException {
        String[] stringArray;
        boolean bl = false;
        String string = null;
        Integer n = null;
        int[] nArray = new int[]{1, 5, 5, 30};
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        if (Config.trace) {
            Config.out.println("DirectoryService: getNNFLWrapperQBF(): (enter)");
        }
        if ((string3 = config.getDirectoryType()) != null && !string3.equalsIgnoreCase(AD) && this.authMethod == 8) {
            this.throwException(101);
        }
        if (this.authMethod == 5 || this.authMethod == 6 || this.authMethod == 7) {
            bl = true;
        }
        if ((stringArray = config.getDirectoryServers(true)) != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getNNFLWrapperQBF: dsaddr: " + string2);
        }
        if (string2 != null) {
            string = DirectoryService.getHostFromDSAddr(string2);
            if (Config.trace) {
                Config.out.println("DirectoryService: getNNFLWrapperQBF: host: " + string);
            }
            n = new Integer(DirectoryService.getPortFromDSAddr(string2, bl));
            if (Config.trace) {
                Config.out.println("DirectoryService: getNNFLWrapperQBF: port: " + n);
            }
        } else if (string3 != null) {
            string = string3.equalsIgnoreCase(AD) ? "LDAP.TCP" : OID;
            n = bl ? new Integer("636") : new Integer("389");
        } else {
            this.throwException(2);
        }
        if (this.nnflqbf == null) {
            if (Config.trace) {
                Config.out.println("getNNFLWrapperQBF(): new NNFLWrapper");
            }
            this.nnflqbf = new NNFLWrapper();
            bl2 = true;
        } else if (!this.lastHost.equalsIgnoreCase(string) || !this.lastPort.equals(n)) {
            this.nnflqbf.closeConn();
            bl2 = true;
        }
        if (bl2) {
            if (Config.trace) {
                Config.out.println("DirectoryService: getNNFLWrapperQBF(): calling nnflqbf.openBindConn() to " + string + ":" + n + " with " + this.credentials[0] + "/" + this.credentials[1] + " using " + this.authMethod + " authenticating method");
            }
            int n2 = this.nnflqbf.openBindConn(string, n, this.credentials[0], this.credentials[1], this.authMethod, nArray);
            if (Config.trace) {
                Config.out.println("DirectoryService: getNNFLWrapperQBF(): nnflqbf.openBindConn() returns " + n2);
            }
            if (n2 != 0) {
                this.nnflqbf.unbind();
                this.nnflqbf = null;
                this.throwException(n2);
            }
            this.lastHost = string;
            this.lastPort = n;
            this.saveUsername(this.nnflqbf);
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getNNFLWrapperQBF(): (exit)");
        }
        return this.nnflqbf;
    }

    private void throwException(int n) throws DirectoryServiceException {
        NNFLException nNFLException = new NNFLException(n);
        DirectoryServiceException directoryServiceException = new DirectoryServiceException(nNFLException);
        this.lastError = directoryServiceException.errno;
        throw directoryServiceException;
    }

    private void getNNFLWrapper(Config config) throws DirectoryServiceException {
        this.getNNFLWrapperRNE(config);
        this.getNNFLWrapperQBF(config);
        String string = config.namingContext();
        if (string != null) {
            this.nnflqbf.setBaseAdminCtx(string);
            this.nnflrne.setBaseAdminCtx(string);
        }
    }

    private NNFLUpdateParam[] combineValues(NNFLUpdateParam[] nNFLUpdateParamArray) {
        Object[] objectArray;
        Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
        if (nNFLUpdateParamArray == null || nNFLUpdateParamArray.length == 0) {
            return nNFLUpdateParamArray;
        }
        for (int i = 0; i < nNFLUpdateParamArray.length; ++i) {
            int n;
            objectArray = nNFLUpdateParamArray[i].getAttrName();
            for (n = 0; n < vector.size(); ++n) {
                NNFLUpdateParam nNFLUpdateParam = (NNFLUpdateParam)vector.elementAt(n);
                if (!objectArray.equalsIgnoreCase(nNFLUpdateParam.getAttrName())) continue;
                String[] stringArray = nNFLUpdateParamArray[i].getAttrVals();
                for (int j = 0; j < stringArray.length; ++j) {
                    nNFLUpdateParam.addNewValue(stringArray[j]);
                }
                break;
            }
            if (n < vector.size()) continue;
            vector.addElement(nNFLUpdateParamArray[i]);
        }
        objectArray = new NNFLUpdateParam[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean equalValues(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        String[] stringArray3 = new String[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < stringArray3.length && !bl; ++i) {
                if (stringArray3[i] == null || !stringArray[n].equals(stringArray3[i])) continue;
                bl = true;
                stringArray3[i] = null;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void saveUsername(NNFLWrapper nNFLWrapper) {
        if (this.authMethod == 5 || this.authMethod == 1) {
            if (this.credentials != null && this.credentials.length >= 2) {
                this.username = this.credentials[0];
            }
        } else if (this.authMethod == 8) {
            this.username = nNFLWrapper.getNativeDN();
        } else if ((this.authMethod == 6 || this.authMethod == 7) && this.credentials != null && this.credentials.length > 2) {
            this.username = nNFLWrapper.getSSLDN(this.credentials[0], this.credentials[1]);
        }
    }

    boolean isAnonymousUserDN() throws DirectoryServiceException {
        String string = this.getUsername();
        if (string == null) {
            throw new DirectoryServiceException(1);
        }
        return string.equals("");
    }

    private static class DnParser
    implements NameParser {
        private final Properties syntax = new Properties();

        public DnParser() {
            this.syntax.put("jndi.syntax.direction", "left_to_right");
            this.syntax.put("jndi.syntax.separator", ",");
            this.syntax.put("jndi.syntax.ignorecase", "true");
            this.syntax.put("jndi.syntax.escape", "\\");
            this.syntax.put("jndi.syntax.beginquote", "\"");
            this.syntax.put("jndi.syntax.trimblanks", "true");
            this.syntax.put("jndi.syntax.separator.ava", "+");
            this.syntax.put("jndi.syntax.separator.typeval", "=");
        }

        @Override
        public Name parse(String string) throws NamingException {
            return new CompoundName(string, this.syntax);
        }
    }
}

