/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.TNSAddress.Description;
import oracle.net.TNSAddress.SOException;
import oracle.net.config.Config;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class DescriptionConfig
extends Description
implements SchemaObjectConfig {
    public String name = null;
    public String description = null;
    public String version = "v0.0";
    private boolean shared = false;
    private Config m_config = null;

    public static boolean exists(Config config, String string) throws SOExceptionConfig {
        block5: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, false)) {
                        return true;
                    }
                    break block5;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (directoryServiceException.errno != 207) {
                        throw new SOExceptionConfig(directoryServiceException);
                    }
                    break block5;
                }
            }
            throw new SOExceptionConfig(12);
        }
        return false;
    }

    public static void delete(Config config, String string) throws SOExceptionConfig {
        if (config.netConfigUsesLDAP()) {
            try {
                config.getDS().delete(config, string, false, true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new SOExceptionConfig(directoryServiceException);
            }
        } else {
            throw new SOExceptionConfig(12);
        }
    }

    public DescriptionConfig() {
        super(new SchemaObjectConfigFactory());
    }

    public DescriptionConfig(String string, String string2) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string2;
        try {
            this.initFromString(string);
        }
        catch (NLException nLException) {
            throw new SOExceptionConfig(9);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public DescriptionConfig(NVPair nVPair, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        try {
            this.initFromNVPair(nVPair);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public DescriptionConfig(Config config, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        this.initFromLDAP(config, this.name);
    }

    @Override
    public boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(boolean bl) {
        if (bl) {
            if (this.name != null && this.name.length() > 0) {
                this.shared = bl;
            }
        } else {
            this.shared = bl;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void initFromLDAP(Config config, String string) throws SOExceptionConfig {
        block33: {
            try {
                this.init();
                this.name = string;
                DirectoryService directoryService = config.getDS();
                Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                String string2 = ((String[])hashtable.get("dn"))[0];
                boolean bl = false;
                String[] stringArray = (String[])hashtable.get("objectclass");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("orclNetDescription")) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new SOExceptionConfig(4);
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object object2;
                    String string3 = (String)enumeration.nextElement();
                    String[] stringArray2 = (String[])hashtable.get(string3);
                    if (string3.equalsIgnoreCase("orclNetAddrList")) {
                        object2 = new SchemaObjectConfigFactory();
                        object = new int[]{1, 0};
                        this.children = ((SchemaObjectConfigFactory)object2).create(config, stringArray2, string2, (int[])object);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetProtocolStack")) {
                        object2 = "(X=" + stringArray2[0] + ")";
                        object = new NVFactory();
                        NVPair nVPair = null;
                        try {
                            nVPair = ((NVFactory)object).createNVPair((String)object2);
                        }
                        catch (NLException nLException) {
                            throw new SOExceptionConfig(9);
                        }
                        for (int i = 0; i < nVPair.getListSize(); ++i) {
                            this.protocolStacks.addElement(nVPair.getListElement(i).toString());
                        }
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetShared")) {
                        this.shared = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclVersion")) {
                        this.version = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("description")) {
                        this.description = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetSdu")) {
                        this.SDU = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclSid")) {
                        this.SID = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetServer")) {
                        this.server = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetServiceName")) {
                        this.serviceName = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetInstanceName")) {
                        this.instanceName = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetHandlerName")) {
                        this.handlerName = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclOracleHome")) {
                        this.oracleHome = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetConnParamList")) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            this.extraConnInfo.addElement(stringArray2[i]);
                        }
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetAuthenticationType")) {
                        this.authTypes = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetAuthParams")) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            this.authParams.addElement(stringArray2[i]);
                        }
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetSourceRoute")) {
                        this.sourceRoute = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetLoadBalance")) {
                        this.loadBalance = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetFailover")) {
                        this.failover = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetParamList")) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            this.extraInfo.addElement(stringArray2[i]);
                        }
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetSendBufSize")) {
                        this.sendBufSize = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetReceiveBufSize")) {
                        this.receiveBufSize = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetFailoverModeString")) {
                        this.failoverMode = stringArray2[0];
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("orclNetInstanceRole")) continue;
                    this.instanceRole = stringArray2[0];
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) break block33;
                throw new SOExceptionConfig(directoryServiceException);
            }
        }
    }

    @Override
    public void saveToLDAP(Config config, boolean bl) throws SOExceptionConfig {
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        if (this.name == null || this.children.size() == 0) {
            throw new SOExceptionConfig(2);
        }
        if (!bl && DescriptionConfig.exists(config, this.name)) {
            throw new SOExceptionConfig(3);
        }
        try {
            int n;
            Object object;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            String[] stringArray = new String[]{"orclNetDescription"};
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            vector.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            this.m_config = config;
            vector.addElement(new NNFLUpdateParam("objectclass", this.getObjectClasses(false)));
            vector.addElement(new NNFLUpdateParam("orclVersion", this.version));
            if (this.children.size() > 0) {
                object = schemaObjectConfigFactory.getEndpointNames(this.children);
                vector.addElement(new NNFLUpdateParam("orclNetAddrList", (String[])object));
            }
            vector.addElement(new NNFLUpdateParam("orclNetShared", this.shared ? "YES" : "NO"));
            if (this.protocolStacks.size() > 0) {
                object = "";
                for (n = 0; n < this.protocolStacks.size(); ++n) {
                    object = (String)object + (String)this.protocolStacks.elementAt(n);
                }
                vector.addElement(new NNFLUpdateParam("orclNetProtocolStack", (String)object));
            }
            if (this.description != null) {
                vector.addElement(new NNFLUpdateParam("description", this.description));
            }
            if (this.sourceRoute) {
                vector.addElement(new NNFLUpdateParam("orclNetSourceRoute", "YES"));
            }
            if (!this.loadBalance) {
                vector.addElement(new NNFLUpdateParam("orclNetLoadBalance", "NO"));
            }
            if (!this.failover) {
                vector.addElement(new NNFLUpdateParam("orclNetFailover", "NO"));
            }
            if (this.SDU != null) {
                vector.addElement(new NNFLUpdateParam("orclNetSdu", this.SDU));
            }
            if (this.SID != null) {
                vector.addElement(new NNFLUpdateParam("orclSid", this.SID));
            }
            if (this.server != null) {
                vector.addElement(new NNFLUpdateParam("orclNetServer", this.server));
            }
            if (this.serviceName != null) {
                vector.addElement(new NNFLUpdateParam("orclNetServiceName", this.serviceName));
            }
            if (this.instanceName != null) {
                vector.addElement(new NNFLUpdateParam("orclNetInstanceName", this.instanceName));
            }
            if (this.handlerName != null) {
                vector.addElement(new NNFLUpdateParam("orclNetHandlerName", this.handlerName));
            }
            if (this.oracleHome != null) {
                vector.addElement(new NNFLUpdateParam("orclOracleHome", this.oracleHome));
            }
            if (this.extraConnInfo.size() > 0) {
                for (n = this.extraConnInfo.size() - 1; n >= 0; --n) {
                    if (this.isValidNVPair("(" + this.extraConnInfo.elementAt(n) + ")")) continue;
                    this.extraConnInfo.removeElementAt(n);
                }
                if (this.extraConnInfo.size() > 0) {
                    Object[] objectArray = new String[this.extraConnInfo.size()];
                    this.extraConnInfo.copyInto(objectArray);
                    vector.addElement(new NNFLUpdateParam("orclNetConnParamList", (String[])objectArray));
                }
            }
            if (this.extraInfo.size() > 0) {
                for (int i = this.extraInfo.size() - 1; i >= 0; --i) {
                    if (this.isValidNVPair("(" + this.extraInfo.elementAt(i) + ")")) continue;
                    this.extraInfo.removeElementAt(i);
                }
                if (this.extraInfo.size() > 0) {
                    Object[] objectArray = new String[this.extraInfo.size()];
                    this.extraInfo.copyInto(objectArray);
                    vector.addElement(new NNFLUpdateParam("orclNetParamList", (String[])objectArray));
                }
            }
            if (this.authTypes != null) {
                vector.addElement(new NNFLUpdateParam("orclNetAuthenticationType", this.authTypes));
            }
            if (this.authParams.size() > 0) {
                String[] stringArray2 = new String[this.authParams.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)this.authParams.elementAt(i);
                }
                vector.addElement(new NNFLUpdateParam("orclNetAuthParams", stringArray2));
            }
            if (this.sendBufSize != null) {
                vector.addElement(new NNFLUpdateParam("orclNetSendBufSize", this.sendBufSize));
            }
            if (this.receiveBufSize != null) {
                vector.addElement(new NNFLUpdateParam("orclNetReceiveBufSize", this.receiveBufSize));
            }
            if (this.failoverMode != null) {
                vector.addElement(new NNFLUpdateParam("orclNetFailoverModeString", this.failoverMode));
            }
            if (this.instanceRole != null) {
                vector.addElement(new NNFLUpdateParam("orclNetInstanceRole", this.instanceRole));
            }
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            String string = directoryService.update(config, this.name, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), this.shared);
            schemaObjectConfigFactory.save(config, this.children, string);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new SOExceptionConfig(directoryServiceException);
        }
    }

    @Override
    public void deleteFromLDAP(Config config) throws SOExceptionConfig {
        DescriptionConfig.delete(config, this.name);
    }

    @Override
    public void addChild(SchemaObjectConfig schemaObjectConfig) {
        boolean bl = false;
        for (int i = 0; i < this.children.size() && !bl; ++i) {
            if (!this.children.elementAt(i).equals(schemaObjectConfig)) continue;
            bl = true;
        }
        if (!bl) {
            this.children.addElement(schemaObjectConfig);
        }
    }

    @Override
    public void delChild(SchemaObjectConfig schemaObjectConfig) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.elementAt(i).equals(schemaObjectConfig)) continue;
            this.children.removeElementAt(i);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !object.getClass().getName().endsWith("DescriptionConfig")) {
            return false;
        }
        DescriptionConfig descriptionConfig = (DescriptionConfig)object;
        if (this.children.size() != descriptionConfig.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            boolean bl = false;
            for (int j = 0; j < this.children.size() && !bl; ++j) {
                if (!this.children.elementAt(i).equals(descriptionConfig.children.elementAt(j))) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.description = null;
        this.version = "v0.0";
        this.shared = false;
    }

    protected String[] getObjectClasses(boolean bl) {
        if (this.m_config != null && this.m_config.getDirectoryType().equalsIgnoreCase("AD")) {
            if (bl) {
                String[] stringArray = new String[]{"top", "orclNetDescription"};
                return stringArray;
            }
            String[] stringArray = new String[]{"orclNetDescription"};
            return stringArray;
        }
        if (bl) {
            String[] stringArray = new String[]{"top", "orclNetDescription", "orclNetDescriptionAux1"};
            return stringArray;
        }
        String[] stringArray = new String[]{"orclNetDescription", "orclNetDescriptionAux1"};
        return stringArray;
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("orclVersion");
        vector.addElement("description");
        vector.addElement("orclNetAddrList");
        vector.addElement("orclNetShared");
        vector.addElement("orclNetProtocolStack");
        vector.addElement("orclNetSourceRoute");
        vector.addElement("orclNetLoadBalance");
        vector.addElement("orclNetFailover");
        vector.addElement("orclNetSdu");
        vector.addElement("orclSid");
        vector.addElement("orclNetServer");
        vector.addElement("orclNetServiceName");
        vector.addElement("orclNetInstanceName");
        vector.addElement("orclNetHandlerName");
        vector.addElement("orclOracleHome");
        vector.addElement("orclNetConnParamList");
        vector.addElement("orclNetParamList");
        vector.addElement("orclNetAuthenticationType");
        vector.addElement("orclNetAuthParams");
        vector.addElement("orclNetSendBufSize");
        vector.addElement("orclNetReceiveBufSize");
        vector.addElement("orclNetInstanceRole");
        vector.addElement("orclNetFailoverModeString");
        return vector;
    }

    private boolean isValidNVPair(String string) {
        try {
            NVPair nVPair = new NVFactory().createNVPair(string);
            if (nVPair.getRHSType() == NVPair.RHS_LIST) {
                return true;
            }
            if (nVPair.getRHSType() == NVPair.RHS_ATOM) {
                String string2 = nVPair.getAtom();
                return string2 != null && string2 != "";
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

