/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DBRolesException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.NTBinding;
import oracle.net.config.NTBindingException;
import oracle.net.config.NTSDException;
import oracle.net.config.NTSecurityDescriptor;
import oracle.net.config.OracleContext;
import oracle.net.config.Service;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.ldap.NNFLUpdateParam;

public class DatabaseService
extends Service {
    public String globalDBName = null;
    private String m_userPassword = null;
    private boolean m_firstLDAPsave = false;
    private Config m_config = null;
    public static final String ORCL_ACCESS_CONTROL_ITEM = "orclAci";
    public static final String ORCL_ENTRY_ACCESS_CONTROL_ITEM = "orclEntryLevelAci";
    public static final String UNIQUE_MEMBER = "uniquemember";
    public static final String GLOBAL_NAME = "orclDBGlobalName";
    public static final String DBVERSION_81 = "81000";
    public static final String DBVERSION_90 = "90000";
    public static final String DB_SECURITY = "cn=OracleDBSecurity,cn=Products,";
    public static final String DEFAULT_DOMAIN = "cn=OracleDefaultDomain,";
    public static final String DB_OID_AUTH = "orcldboidauthentication";
    public static final String DB_SERVER_ROLE = "orcldbserverrole";
    public static final String USER_PASSWORD = "userPassword";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addDBToSecurityDomain(Config config, String string, String string2) throws ServiceAliasException {
        String string3 = config.getDirectoryType();
        DirectoryService directoryService = config.getDS();
        String string4 = directoryService.qualifyObjectName(config, string, false);
        String string5 = directoryService.qualifyRDBMSObjectName(config, string2, 1);
        if ("OID".equalsIgnoreCase(string3)) {
            try {
                int n;
                int n2;
                String[] stringArray;
                OracleContext oracleContext = null;
                try {
                    oracleContext = new OracleContext(config, config.getDefaultOracleContext(false));
                }
                catch (ConfigException configException) {
                    System.out.println("Invalid OraCtx name");
                }
                String string6 = oracleContext.getDBCompatibilityVersion();
                if (string6 == null || string6.equals(DBVERSION_81)) {
                    try {
                        String[] stringArray2;
                        stringArray = directoryService.read(config, string5, false, "orclDBServerMember");
                        if (stringArray == null) {
                            stringArray = new String[]{};
                        }
                        n2 = 1;
                        for (n = 0; n < stringArray.length && n2 != 0; ++n) {
                            stringArray2 = DatabaseService.removeWhiteSpace(stringArray[n]).toUpperCase();
                            if (stringArray2.indexOf(string4.toUpperCase()) == -1) continue;
                            n2 = 0;
                        }
                        if (n2 != 0) {
                            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[1];
                            stringArray2 = new String[stringArray.length + 1];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray2[i] = stringArray[i];
                            }
                            stringArray2[stringArray.length] = string4;
                            nNFLUpdateParamArray[0] = new NNFLUpdateParam("orclDBServerMember", stringArray2);
                            directoryService.update(config, string5, false, nNFLUpdateParamArray, new Vector(), false);
                        }
                    }
                    catch (DirectoryServiceException directoryServiceException) {
                        throw new ServiceAliasException(directoryServiceException);
                    }
                }
                if ((stringArray = directoryService.read(config, string5, false, UNIQUE_MEMBER)) == null) {
                    stringArray = new String[]{};
                }
                n2 = stringArray.length;
                n = 1;
                for (int i = 0; i < n2 && n != 0; ++i) {
                    String string7 = DatabaseService.removeWhiteSpace(stringArray[i]).toUpperCase();
                    if (string7.indexOf(string4.toUpperCase()) == -1) continue;
                    n = 0;
                }
                if (n == 0) return;
                NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[1];
                String[] stringArray3 = new String[n2 + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, n2);
                stringArray3[n2] = string4;
                nNFLUpdateParamArray[0] = new NNFLUpdateParam(UNIQUE_MEMBER, stringArray3);
                directoryService.update(config, string5, false, nNFLUpdateParamArray, null, false);
                return;
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        }
        if ("NDS".equalsIgnoreCase(string3)) {
            try {
                String string8;
                String[] stringArray;
                String[] stringArray4 = directoryService.read(config, string5, false, "ACL");
                if (stringArray4 == null) {
                    stringArray4 = new String[]{};
                }
                boolean bl = true;
                for (int i = 0; i < stringArray4.length && bl; ++i) {
                    stringArray = DatabaseService.removeWhiteSpace(stringArray4[i]).toUpperCase();
                    if (stringArray.indexOf(string4.toUpperCase()) == -1) continue;
                    bl = false;
                }
                if (!bl) return;
                NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[1];
                stringArray = new String[stringArray4.length + 2];
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray[i] = stringArray4[i];
                }
                stringArray[stringArray4.length + 0] = string8 = "1#subtree#" + string4 + "#[Entry Rights]";
                stringArray[stringArray4.length + 1] = string8 = "3#subtree#" + string4 + "#[All Attributes Rights]";
                nNFLUpdateParamArray[0] = new NNFLUpdateParam("ACL", stringArray);
                directoryService.update(config, string5, false, nNFLUpdateParamArray, new Vector(), false);
                return;
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        } else if (!"AD".equalsIgnoreCase(string3)) return;
    }

    public static String getDBSecurityVersion(Config config) throws DirectoryServiceException {
        String string;
        DirectoryService directoryService;
        String[] stringArray;
        if (Config.trace) {
            Config.out.println("DirectorySercice: getDBSecurityVersion : (enter)");
        }
        if ((stringArray = (directoryService = config.getDS()).read(config, string = DB_SECURITY + config.getDefaultOracleContext(false), false, "orclVersion")) == null) {
            return null;
        }
        if (Config.trace) {
            Config.out.println("DirectoryService: getDBSecurityVersion : (exit) returning: " + stringArray[0]);
        }
        return stringArray[0];
    }

    public static void remDBFrSecurityDomain(Config config, String string, String string2) throws ServiceAliasException {
        String[] stringArray;
        int n;
        String[] stringArray2;
        String string3 = config.getDirectoryType();
        DirectoryService directoryService = config.getDS();
        String string4 = DatabaseService.removeWhiteSpace(directoryService.qualifyObjectName(config, string, false)).toUpperCase();
        String string5 = directoryService.qualifyRDBMSObjectName(config, string2, 1);
        if ("OID".equalsIgnoreCase(string3)) {
            try {
                Object object;
                stringArray2 = directoryService.read(config, string5, false, UNIQUE_MEMBER);
                if (stringArray2 == null) {
                    stringArray2 = new String[]{};
                }
                n = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = DatabaseService.removeWhiteSpace(stringArray2[i]).toUpperCase();
                    if (!((String)object).equals(string4)) continue;
                    n = 1;
                    stringArray = new String[stringArray2.length - 1];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray[j] = j < i ? stringArray2[j] : stringArray2[j + 1];
                    }
                    stringArray2 = stringArray;
                    break;
                }
                if (n != 0) {
                    NNFLUpdateParam[] nNFLUpdateParamArray = null;
                    object = new Vector();
                    ((Vector)object).addElement(UNIQUE_MEMBER);
                    nNFLUpdateParamArray = stringArray2.length > 0 ? new NNFLUpdateParam[]{new NNFLUpdateParam(UNIQUE_MEMBER, stringArray2)} : new NNFLUpdateParam[]{};
                    directoryService.update(config, string5, false, nNFLUpdateParamArray, (Vector)object, false);
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
            try {
                stringArray2 = directoryService.enumDNs(config, string5, "objectclass=orclDBEnterpriseRole", false);
                for (n = 0; n < stringArray2.length; ++n) {
                    Object object;
                    String[] stringArray3 = directoryService.read(config, stringArray2[n], false, DB_SERVER_ROLE);
                    if (stringArray3 == null) {
                        stringArray3 = new String[]{};
                    }
                    boolean bl = false;
                    stringArray = stringArray3;
                    for (int i = 0; i < stringArray3.length; ++i) {
                        object = DatabaseService.removeWhiteSpace(stringArray3[i]).toUpperCase();
                        if (!((String)object).startsWith(string4)) continue;
                        bl = true;
                        String[] stringArray4 = new String[stringArray.length - 1];
                        for (int j = 0; j < stringArray4.length; ++j) {
                            stringArray4[j] = j < i ? stringArray[j] : stringArray[j + 1];
                        }
                        stringArray = stringArray4;
                    }
                    if (!bl) continue;
                    NNFLUpdateParam[] nNFLUpdateParamArray = null;
                    object = new Vector();
                    ((Vector)object).addElement(DB_SERVER_ROLE);
                    nNFLUpdateParamArray = stringArray.length > 0 ? new NNFLUpdateParam[]{new NNFLUpdateParam(DB_SERVER_ROLE, stringArray)} : new NNFLUpdateParam[]{};
                    directoryService.update(config, stringArray2[n], false, nNFLUpdateParamArray, (Vector)object, false);
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new DBRolesException(directoryServiceException);
            }
        }
        if ("AD".equalsIgnoreCase(string3)) {
            // empty if block
        }
        try {
            stringArray2 = directoryService.read(config, string5, false, "orclDBServerMember");
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            n = 0;
            for (int i = 0; i < stringArray2.length && n == 0; ++i) {
                String string6 = DatabaseService.removeWhiteSpace(stringArray2[i]).toUpperCase();
                if (string6.indexOf(string4.toUpperCase()) == -1) continue;
                n = 1;
                stringArray = new String[stringArray2.length - 1];
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray[j] = j < i ? stringArray2[j] : stringArray2[j + 1];
                }
                stringArray2 = stringArray;
            }
            if (n != 0) {
                NNFLUpdateParam[] nNFLUpdateParamArray = null;
                Vector<String> vector = new Vector<String>();
                vector.addElement("orclDBServerMember");
                nNFLUpdateParamArray = stringArray2.length > 0 ? new NNFLUpdateParam[]{new NNFLUpdateParam("orclDBServerMember", stringArray2)} : new NNFLUpdateParam[]{};
                directoryService.update(config, string5, false, nNFLUpdateParamArray, vector, false);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ServiceAliasException(directoryServiceException);
        }
    }

    public static void delete(Config config, String string) throws ServiceAliasException {
        DirectoryService directoryService = config.getDS();
        try {
            String[] stringArray = directoryService.enumDNs(config, DB_SECURITY + config.getDefaultOracleContext(false), "objectclass=orclDBEnterpriseDomain", false);
            for (int i = 0; i < stringArray.length; ++i) {
                DatabaseService.delete(config, string, stringArray[i]);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ServiceAliasException(directoryServiceException);
        }
    }

    public static void delete(Config config, String string, String string2) throws ServiceAliasException {
        ServiceAlias.delete(config, string);
        DatabaseService.remDBFrSecurityDomain(config, string, string2);
    }

    public static String getDefaultDirectoryAuthentication(Config config) throws DirectoryServiceException {
        DirectoryService directoryService = config.getDS();
        String[] stringArray = directoryService.query(config, DB_SECURITY + config.getDefaultOracleContext(false), "objectclass=*", DB_OID_AUTH);
        if (stringArray == null) {
            if (config.getDirectoryType().equalsIgnoreCase("AD")) {
                return "SSL";
            }
            throw new DirectoryServiceException(211);
        }
        return stringArray[0];
    }

    public static String[] enumServiceAliases(Config config, String string, boolean bl) throws ServiceAliasException {
        String string2 = "objectclass=orclDBServer";
        return DatabaseService.enumServiceAliases(config, string, bl, string2);
    }

    public static String[] enumServiceAliases(Config config, String string, boolean bl, String string2, String string3) throws ServiceAliasException {
        Object[] objectArray = DatabaseService.enumServiceAliases(config, string, bl);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            DatabaseService databaseService = new DatabaseService(config, objectArray[i]);
            Vector vector2 = databaseService.getEndpoints();
            if (!DatabaseService.selectByHostname(vector2, string2) || !DatabaseService.selectBySid(vector2, string3)) continue;
            vector.addElement(objectArray[i]);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public DatabaseService(Config config, String string) throws ServiceAliasException {
        super(config, string);
        if (config.netConfigUsesLDAP()) {
            try {
                this.m_config = config;
                DirectoryService directoryService = config.getDS();
                if (!directoryService.exists(config, string, false)) {
                    this.m_firstLDAPsave = true;
                } else {
                    Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                    String string2 = ((String[])hashtable.get("dn"))[0];
                    boolean bl = false;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string3);
                        if (!string3.equalsIgnoreCase(GLOBAL_NAME)) continue;
                        this.globalDBName = stringArray[0];
                        bl = true;
                    }
                    if (!bl) {
                        throw new ServiceAliasException(12);
                    }
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        }
    }

    @Override
    public void save(Config config, boolean bl) throws ServiceAliasException {
        super.save(config, bl);
        if (config.netConfigUsesLDAP()) {
            DirectoryService directoryService = config.getDS();
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            if (this.globalDBName == null) {
                ServiceAlias.delete(config, this.name);
                throw new ServiceAliasException(12);
            }
            vector.addElement(new NNFLUpdateParam(GLOBAL_NAME, this.globalDBName));
            if (!"AD".equalsIgnoreCase(config.getDirectoryType()) && this.m_userPassword != null) {
                vector.addElement(new NNFLUpdateParam(USER_PASSWORD, this.m_userPassword));
            }
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            try {
                directoryService.update(config, this.name, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
            if (!"AD".equalsIgnoreCase(config.getDirectoryType()) && this.m_firstLDAPsave) {
                try {
                    this.createAdditionalEntries(config);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ServiceAliasException(directoryServiceException);
                }
            }
        }
    }

    private void createAdditionalEntries(Config config) throws DirectoryServiceException {
        DirectoryService directoryService = config.getDS();
        String string = directoryService.qualifyObjectName(config, this.name, false);
        DBAdmins dBAdmins = new DBAdmins(config, string);
        dBAdmins.saveInLDAP(config);
        OrclContainer orclContainer = new OrclContainer(config, "OracleDBAgents", string);
        orclContainer.saveInLDAP(config);
        orclContainer = new OrclContainer(config, "OracleDBQueues", string);
        orclContainer.saveInLDAP(config);
        orclContainer = new OrclContainer(config, "OracleDBQueueTables", string);
        orclContainer.saveInLDAP(config);
        orclContainer = new OrclContainer(config, "OracleDBConnections", string);
        orclContainer.saveInLDAP(config);
        orclContainer = new OrclContainer(config, "OracleDBJMSSubscribers", string);
        orclContainer.saveInLDAP(config);
        String string2 = config.getDirectoryType();
        if ("OID".equalsIgnoreCase(string2)) {
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[1];
            String[] stringArray = dBAdmins.addSelfToACL();
            String[] stringArray2 = new String[]{stringArray[0], stringArray[1], "access to entry by self (browse, noadd, nodelete)", "access to attr=(*) by self (read, search, nowrite, compare)"};
            nNFLUpdateParamArray[0] = new NNFLUpdateParam(ORCL_ACCESS_CONTROL_ITEM, stringArray2);
            directoryService.update(config, this.name, false, nNFLUpdateParamArray, null, false);
            NNFLUpdateParam[] nNFLUpdateParamArray2 = new NNFLUpdateParam[1];
            String[] stringArray3 = new String[3];
            String string3 = config.namingContext();
            if (string3 != null && !string3.equals("")) {
                string3 = "," + string3;
            }
            stringArray3[0] = "access to entry by group=\"cn=OracleNetAdmins,cn=OracleContext" + string3 + "\" (add) ";
            stringArray3[1] = "access to entry by * (browse, noadd, nodelete)";
            stringArray3[2] = "access to attr=(objectclass) by * (read, nowrite, search, compare)";
            nNFLUpdateParamArray2[0] = new NNFLUpdateParam(ORCL_ENTRY_ACCESS_CONTROL_ITEM, stringArray3);
            directoryService.update(config, this.name, false, nNFLUpdateParamArray2, null, false);
        }
    }

    public void setUserPassword(String string) {
        this.m_userPassword = string;
    }

    @Override
    public String[] getObjectClasses(boolean bl) {
        if (this.m_config != null && this.m_config.getDirectoryType().equalsIgnoreCase("AD")) {
            if (bl) {
                String[] stringArray = new String[]{"top", "orclService", "orclDBServer"};
                return stringArray;
            }
            String[] stringArray = new String[]{"orclService", "orclDBServer"};
            return stringArray;
        }
        if (bl) {
            String[] stringArray = new String[]{"top", "orclService", "orclDBServer", "orclDBServer_92"};
            return stringArray;
        }
        String[] stringArray = new String[]{"orclService", "orclDBServer", "orclDBServer_92"};
        return stringArray;
    }

    @Override
    public void prepareAttributes(Config config, Vector vector) {
        super.prepareAttributes(config, vector);
        if (this.globalDBName != null) {
            vector.addElement(new NNFLUpdateParam(GLOBAL_NAME, this.globalDBName));
            if (!"AD".equalsIgnoreCase(config.getDirectoryType())) {
                vector.addElement(new NNFLUpdateParam(USER_PASSWORD, this.m_userPassword));
            }
        }
    }

    public Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(GLOBAL_NAME);
        return vector;
    }

    @Override
    protected NNFLUpdateParam getACL(Config config) throws ServiceAliasException {
        DirectoryService directoryService = config.getDS();
        String string = config.getDirectoryType();
        String string2 = directoryService.getUsername();
        if (string2 == null) {
            throw new ServiceAliasException(1);
        }
        if ("OID".equalsIgnoreCase(string)) {
            String[] stringArray = new String[2];
            stringArray[0] = "access to entry ";
            stringArray[0] = stringArray[0] + "by dn=\"" + string2 + "\" (browse, add, delete) ";
            stringArray[1] = "access to attr=(*) ";
            stringArray[1] = stringArray[1] + "by dn=\"" + string2 + "\" (compare, search, read, selfwrite, write) ";
            return new NNFLUpdateParam(ORCL_ACCESS_CONTROL_ITEM, stringArray);
        }
        if ("NDS".equalsIgnoreCase(string)) {
            String string3 = config.namingContext();
            String[] stringArray = new String[]{"7#subtree#" + string2 + "#[Entry Rights]", "15#subtree#" + string2 + "#[All Attributes Rights]", "2#entry#cn=OracleNetAdmins,cn=OracleContext"};
            stringArray[0] = string3.equals("") ? stringArray[0] + "#[Entry Rights]" : stringArray[0] + "," + string3 + "#[Entry Rights]";
            return new NNFLUpdateParam("ACL", stringArray);
        }
        return null;
    }

    @Override
    protected NNFLUpdateParam getACLAlso(Config config) throws ServiceAliasException {
        String string = config.getDirectoryType();
        String string2 = config.namingContext();
        if ("OID".equalsIgnoreCase(string)) {
            if (string2 != null && !string2.equals("")) {
                string2 = "," + string2;
            }
            String string3 = config.getDS().getUsername();
            String[] stringArray = new String[]{"access to entry by dn=\"" + string3 + "\" (add) ", "access to attr=(*) by dn=\"" + string3 + "\" (read, write) "};
            return new NNFLUpdateParam(ORCL_ENTRY_ACCESS_CONTROL_ITEM, stringArray);
        }
        return null;
    }

    @Override
    protected void initACL(Config config) throws ServiceAliasException {
        DirectoryService directoryService = config.getDS();
        String string = config.getDirectoryType();
        String string2 = directoryService.getUsername();
        if (string2 == null) {
            throw new ServiceAliasException(1);
        }
        if ("OID".equalsIgnoreCase(string) || "NDS".equalsIgnoreCase(string)) {
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[]{this.getACL(config), this.getACLAlso(config)};
            try {
                directoryService.update(config, this.name, false, nNFLUpdateParamArray, new Vector(), false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ServiceAliasException(directoryServiceException);
            }
        }
        if ("AD".equalsIgnoreCase(string)) {
            String string3 = directoryService.qualifyObjectName(config, this.name, false);
            try {
                NTBinding nTBinding = config.getNTBinding();
                NTSecurityDescriptor.InitializeDB(nTBinding, string3, string2, this.systemName, this.sid);
            }
            catch (NTBindingException nTBindingException) {
                throw new ServiceAliasException(1);
            }
            catch (NTSDException nTSDException) {
                throw new ServiceAliasException(1);
            }
        }
    }

    private static String removeWhiteSpace(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string3 = string.substring(i, i + 1);
            if (string3.equals(" ") || string3.equals("\t") || string3.equals("\n")) continue;
            string2 = string2 + string3;
        }
        return string2;
    }

    private class OrclContainer {
        public final String ORCLCONTAINER = "orclContainer";
        String m_dn = null;
        String m_name = null;

        public OrclContainer(Config config, String string, String string2) {
            this.m_name = string;
            this.m_dn = new String("cn=" + this.m_name + "," + string2);
        }

        public String[] getObjectClasses(boolean bl) {
            if (bl) {
                String[] stringArray = new String[]{"top", "orclContainer"};
                return stringArray;
            }
            String[] stringArray = new String[]{"orclContainer"};
            return stringArray;
        }

        public void prepareAttributes(Config config, Vector vector) {
            DirectoryService directoryService = config.getDS();
            vector.addElement(new NNFLUpdateParam("cn", this.m_name));
            vector.addElement(new NNFLUpdateParam("objectclass", this.getObjectClasses(false)));
            String string = config.getDirectoryType();
            if ("OID".equalsIgnoreCase(string)) {
                vector.addElement(new NNFLUpdateParam(DatabaseService.ORCL_ACCESS_CONTROL_ITEM, this.addToACL(config, DatabaseService.this.name)));
            }
        }

        public void saveInLDAP(Config config) throws DirectoryServiceException {
            Vector vector = new Vector();
            this.prepareAttributes(config, vector);
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            DirectoryService directoryService = config.getDS();
            directoryService.update(config, this.m_dn, false, (NNFLUpdateParam[])objectArray, null, false);
        }

        String[] addToACL(Config config, String string) {
            DirectoryService directoryService = config.getDS();
            String string2 = directoryService.qualifyObjectName(config, string, false);
            String[] stringArray = new String[2];
            stringArray[0] = "access to entry ";
            stringArray[0] = stringArray[0] + "by dn=\"" + string2 + "\" (browse, add, delete) ";
            stringArray[1] = "access to attr=(*) ";
            stringArray[1] = stringArray[1] + "by dn=\"" + string2 + "\" (compare, search, read, write) ";
            return stringArray;
        }
    }

    private class DBAdmins {
        public final String GROUP_OF_UNIQUE_NAMES = "groupofuniquenames";
        public final String ORCL_PRIVILEGE_GROUP = "orclprivilegegroup";
        public final String GROUP_OWNER = "owner";
        private String m_dn = null;
        private String m_name = "OracleDBAdmins";

        public DBAdmins(Config config, String string) {
            this.m_dn = new String("cn=" + this.m_name + "," + string);
        }

        public String[] getObjectClasses(boolean bl) {
            if (bl) {
                String[] stringArray = new String[]{"top", "groupofuniquenames", "orclprivilegegroup"};
                return stringArray;
            }
            String[] stringArray = new String[]{"groupofuniquenames", "orclprivilegegroup"};
            return stringArray;
        }

        public void prepareAttributes(Config config, Vector vector) throws DirectoryServiceException {
            DirectoryService directoryService = config.getDS();
            vector.addElement(new NNFLUpdateParam("cn", this.m_name));
            vector.addElement(new NNFLUpdateParam("objectclass", this.getObjectClasses(false)));
            String string = directoryService.getUsername();
            if (string == null) {
                throw new DirectoryServiceException(2);
            }
            vector.addElement(new NNFLUpdateParam(DatabaseService.UNIQUE_MEMBER, string));
            vector.addElement(new NNFLUpdateParam("owner", this.m_dn));
        }

        public Vector getSupportedAttributes() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(DatabaseService.UNIQUE_MEMBER);
            return vector;
        }

        public void saveInLDAP(Config config) throws DirectoryServiceException {
            Vector vector = new Vector();
            this.prepareAttributes(config, vector);
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            DirectoryService directoryService = config.getDS();
            directoryService.update(config, this.m_dn, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), false);
            if ("OID".equalsIgnoreCase(config.getDirectoryType())) {
                String[] stringArray = new String[]{"access to entry by * (none)", "access to attr=(*) by * (none)"};
                objectArray = new NNFLUpdateParam[]{new NNFLUpdateParam(DatabaseService.ORCL_ACCESS_CONTROL_ITEM, stringArray)};
                directoryService.update(config, this.m_dn, false, (NNFLUpdateParam[])objectArray, null, false, false);
            }
        }

        public String[] addSelfToACL() {
            String[] stringArray = new String[2];
            stringArray[0] = "access to entry ";
            stringArray[0] = stringArray[0] + "by group=\"" + this.m_dn + "\"(browse, add, delete) ";
            stringArray[1] = "access to attr=(*) ";
            stringArray[1] = stringArray[1] + "by group=\"" + this.m_dn + "\" (compare, search, read, selfwrite, write) ";
            return stringArray;
        }
    }
}

