/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import oracle.ldap.util.discovery.DiscoveryHelper;
import oracle.net.common.NetGetEnv;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.NTBinding;
import oracle.net.config.NTBindingException;
import oracle.net.config.NTSDException;
import oracle.net.config.NTSecurityDescriptor;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.ldap.NNFLWrapper;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class Config {
    public static final int TNSNAMES = 0;
    public static final int CMAN = 1;
    public static final int PROFILE = 2;
    public static final int LISTENER = 3;
    public static final int LDAP = 4;
    public static final int TNSNAMES_FILE = 0;
    public static final int CMAN_FILE = 1;
    public static final int PROFILE_FILE = 2;
    public static final int LISTENER_FILE = 3;
    public static final int LDAP_FILE = 4;
    protected static boolean trace = false;
    protected static PrintWriter out = new PrintWriter(System.out, true);
    public String OraHomeDir = null;
    private DirectoryService ds = new DirectoryService();
    private NTBinding ntbinding = null;
    private ConfigStruct[] m_configs;
    private boolean ldapAvailable = true;
    private String m_currentOracleContext = null;
    private static String DEFAULT_LDAP_PORT = "389";
    private static String LDAP_PORT_SEP = ":";

    public Config(String string, int n, String[] stringArray) throws ConfigException {
        this.initConfig(string, n, stringArray);
        this.m_configs[4].setNlpa(NLParamParser.createEmptyParamParser());
        try {
            this.discoverLdapConfig();
        }
        catch (ConfigException configException) {
            this.ldapAvailable = false;
        }
    }

    public Config(String string, int n, String[] stringArray, Reader reader) throws ConfigException {
        this.initConfig(string, n, stringArray);
        try {
            this.readFromStream(4, reader, (byte)0);
        }
        catch (NLException nLException) {
            throw new ConfigException(nLException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    public Config(String string, int n, String[] stringArray, String string2) throws ConfigException {
        this.initConfig(string, n, stringArray);
        try {
            this.readFromFile(4, string2);
        }
        catch (NLException nLException) {
            throw new ConfigException(nLException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    private void initConfig(String string, int n, String[] stringArray) throws ConfigException {
        String string2;
        this.OraHomeDir = string;
        this.ds.setAuthInfo(n, stringArray);
        try {
            string2 = string + File.separator + "network" + File.separator + "tools" + File.separator + "configTraceOn";
            if (new File(string2).exists()) {
                trace = true;
                out.println("Config: Config(): Trace on.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = this.getNetDir();
        this.m_configs = new ConfigStruct[]{new ConfigStruct("tnsnames.ora", string2, 420), new ConfigStruct("cman.ora", string2, 416), new ConfigStruct("sqlnet.ora", string2, 420), new ConfigStruct("listener.ora", string2, 416), new ConfigStruct("ldap.ora", string2, 420)};
    }

    private void discoverLdapConfig() throws ConfigException {
        if (trace) {
            out.println("Config: discoverLdapConfig: (enter)");
        }
        DiscoveryHelper discoveryHelper = new DiscoveryHelper(3);
        discoveryHelper.setProperty("3", "0");
        HashMap hashMap = new HashMap();
        int n = discoveryHelper.discover(hashMap);
        if (trace) {
            out.println("Config: discoverLdapConfig: discover ret code :" + n);
        }
        if (n != 0) {
            if (trace) {
                out.println("Config: discoverLdapConfig: discovery failed");
            }
            return;
        }
        ArrayList arrayList = (ArrayList)hashMap.get(DiscoveryHelper.DIR_SERVER_TYPE);
        if (trace) {
            out.println("Config: discoverLdapConfig: Directory Type: " + arrayList);
        }
        if (arrayList != null) {
            if (arrayList.size() == 0) {
                throw new ConfigException("LDAP discovery returned no directory type");
            }
        } else {
            throw new ConfigException("LDAP discovery returned no directory type");
        }
        this.setDirectoryType((String)arrayList.get(0));
        arrayList = (ArrayList)hashMap.get(DiscoveryHelper.DEF_ADMIN_CTXT);
        if (trace) {
            out.println("Config: discoverLdapConfig: Admin Context: " + arrayList);
        }
        if (arrayList != null) {
            if (arrayList.size() == 0) {
                if (!this.getDirectoryType().equalsIgnoreCase("AD")) {
                    this.setDirectoryType(null);
                    throw new ConfigException("LDAP discovery returned no default context");
                }
            } else {
                this.setDefaultAdminContext((String)arrayList.get(0));
            }
        } else if (!this.getDirectoryType().equalsIgnoreCase("AD")) {
            this.setDirectoryType(null);
            throw new ConfigException("LDAP discovery returned no default context");
        }
        arrayList = (ArrayList)hashMap.get(DiscoveryHelper.DIR_SERVERS);
        if (trace) {
            out.println("Config: discoverLdapConfig: Directory Servers: " + arrayList);
        }
        if (!(arrayList != null && arrayList.size() != 0 || this.getDirectoryType().equalsIgnoreCase("AD"))) {
            this.setDirectoryType(null);
            throw new ConfigException("LDAP discovery returned no server address");
        }
        discoveryHelper.setProperty("3", "1");
        int n2 = discoveryHelper.discover(hashMap);
        if (trace) {
            out.println("Config: discoverLdapConfig: discover SSL ret code :" + n2);
        }
        if (n2 != 0) {
            if (trace) {
                out.println("Config: discoverLdapConfig: discovery failed");
            }
            return;
        }
        ArrayList arrayList2 = (ArrayList)hashMap.get(DiscoveryHelper.DIR_SERVERS);
        if (trace) {
            out.println("Config: discoverLdapConfig: Directory Servers SSL: " + arrayList2);
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            throw new ConfigException("LDAP discovery returned no server address");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
            if (!stringArray[i].equals(stringArray2[i])) {
                stringArray[i] = stringArray[i] + stringArray2[i].substring(stringArray2[i].lastIndexOf(":"));
            }
            if (!trace) continue;
            out.println("Config: discoverLdapConfig: Directory Address: " + stringArray[i]);
        }
        this.setDirectoryServers(stringArray);
        if (trace) {
            out.println("Config: discoverLdapConfig: (exit)");
        }
    }

    public boolean isLdapAvailable() {
        return this.ldapAvailable;
    }

    public static String detectDSType(String string) {
        if (Config.hostExists("OID", string)) {
            return "OID";
        }
        if (Config.hostExists("LDAP.TCP", string)) {
            return "AD";
        }
        if (Config.hostExists("NDS", string)) {
            return "NDS";
        }
        return null;
    }

    public static String[] getNamingContexts(String string, String string2) {
        try {
            String[] stringArray;
            Config config = new Config(".", 1, null);
            DirectoryService directoryService = config.getDS();
            if (string != null) {
                stringArray = new String[]{string};
                config.setDirectoryServers(stringArray);
            }
            if (string2 != null) {
                config.setDirectoryType(string2);
            }
            config.bind(1, null);
            stringArray = null;
            if (string2 != null && string2.equalsIgnoreCase("AD")) {
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                stringArray2 = directoryService.query(config, "", "objectclass=*", "defaultNamingContext");
                stringArray3 = directoryService.query(config, "", "objectclass=*", "configurationNamingContext");
                stringArray = new String[(stringArray2 == null ? 0 : stringArray2.length) + (stringArray3 == null ? 0 : stringArray3.length)];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray2 == null || i >= stringArray2.length ? stringArray3[i - stringArray3.length] : stringArray2[i];
                }
            } else {
                stringArray = directoryService.query(config, "", "objectclass=*", "namingcontexts");
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        catch (ConfigException configException) {
            return new String[0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public String[] getOracleContexts(String string) {
        try {
            String[] stringArray;
            if (trace) {
                out.println("Config: getOracleContexts(namectx) (entry)");
            }
            if ((stringArray = this.ds.enumDNs(this, string, "objectclass=orclContext", true)) == null) {
                stringArray = new String[]{};
            }
            if (trace) {
                out.println("Config: getOracleContexts(namectx)" + stringArray[0]);
            }
            return stringArray;
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public static String[] getOracleSoftware(int n, String[] stringArray, String string, String string2) {
        try {
            Object[] objectArray;
            String[] stringArray2;
            Config config = new Config(".", 1, null);
            DirectoryService directoryService = config.getDS();
            if (string != null) {
                stringArray2 = new String[]{string};
                config.setDirectoryServers(stringArray2);
            }
            if (string2 != null) {
                config.setDirectoryType(string2);
            }
            config.bind(n, stringArray);
            stringArray2 = Config.getNamingContexts(string, string2);
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < stringArray2.length; ++i) {
                objectArray = directoryService.enumDNs(config, stringArray2[i], "objectclass=orclContext", true);
                for (int j = 0; j < objectArray.length; ++j) {
                    vector.addElement(objectArray[j]);
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (ConfigException configException) {
            return new String[0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public static String[] getOracleSoftware(String string, int n, String[] stringArray, String string2, String string3) {
        try {
            String[] stringArray2;
            Config config = new Config(".", 1, null);
            DirectoryService directoryService = config.getDS();
            if (string2 != null) {
                stringArray2 = new String[]{string2};
                config.setDirectoryServers(stringArray2);
            }
            if (string3 != null) {
                config.setDirectoryType(string3);
            }
            config.bind(n, stringArray);
            stringArray2 = directoryService.enumDNs(config, string, "objectclass=orclContext", true);
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            return stringArray2;
        }
        catch (ConfigException configException) {
            return new String[0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public static String[] getAlternateServers(String string, String string2) {
        try {
            String[] stringArray;
            Config config = new Config(".", 1, null);
            DirectoryService directoryService = config.getDS();
            if (string != null) {
                stringArray = new String[]{string};
                config.setDirectoryServers(stringArray);
            }
            if (string2 != null) {
                config.setDirectoryType(string2);
            }
            config.bind(1, null);
            stringArray = directoryService.query(config, "", "objectclass=*", "altServer");
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        catch (ConfigException configException) {
            return new String[0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public static String[] getSubContexts(String string, String string2, String string3) {
        try {
            String[] stringArray;
            Config config = new Config(".", 1, null);
            DirectoryService directoryService = config.getDS();
            if (string != null) {
                stringArray = new String[]{string};
                config.setDirectoryServers(stringArray);
            }
            if (string2 != null) {
                config.setDirectoryType(string2);
            }
            config.bind(1, null);
            stringArray = directoryService.enumDNs(config, string3, "objectclass=organizationalUnit", true);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        catch (ConfigException configException) {
            return new String[0];
        }
        catch (DirectoryServiceException directoryServiceException) {
            return new String[0];
        }
    }

    public static void init(String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2, String string6, int n, String[] stringArray) throws ConfigException {
        Config config = new Config(string, 1, null);
        config.createLDAPOra(bl, string4, string5, string6);
        if (bl2) {
            Config.initSchemaOnly(string5, string4, null, string, n, stringArray);
        }
        if (bl) {
            config.bind(n, stringArray);
            config.initLDIF(string5, string4, n, stringArray);
        }
    }

    public void createLDAPOra(boolean bl, String string, String string2, String string3) throws ConfigException {
        String[] stringArray = Config.getAlternateServers(string2, string);
        this.netConfigUsesLDAP(bl);
        if (string != null) {
            this.setDirectoryType(string);
        }
        if (string2 != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = string2;
            for (int i = 1; i <= stringArray.length; ++i) {
                stringArray2[i] = stringArray[i - 1];
            }
            this.setDirectoryServers(stringArray2);
        }
        if (string3 != null) {
            this.namingContext(string3);
        }
        this.save();
    }

    public void createContainers(String string, String string2) throws ConfigException {
        String string3;
        String string4;
        if (!this.netConfigUsesLDAP()) {
            throw new ConfigException(21);
        }
        String string5 = this.determineSystemName(false);
        string5 = "cn=" + string5 + ", " + this.oracleContext();
        this.systemName(string5);
        String string6 = this.determineHomeID(this.OraHomeDir, string, string2, false);
        this.homeID(string6);
        String string7 = " ";
        String string8 = System.getProperty("os.name");
        if (string8.startsWith("Windows")) {
            string4 = NetGetEnv.getNTDomainName();
            string3 = NetGetEnv.getComputerName();
            if (string4 != null && string3 != null) {
                string7 = string4 + "/" + string3;
            }
        }
        try {
            NNFLUpdateParam[] nNFLUpdateParamArray;
            string4 = this.oracleContext();
            string3 = this.systemName();
            String string9 = "cn=" + this.homeID() + ", " + string3;
            if (!this.ds.exists(this, string4, false)) {
                nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("cn", "OracleContext"), new NNFLUpdateParam("objectclass", "orclContext")};
                this.ds.update(this, string4, false, nNFLUpdateParamArray, null, false);
            }
            if (!this.ds.exists(this, string3, false)) {
                nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("cn", this.ds.getCN(string3)), new NNFLUpdateParam("objectclass", "orclContainer"), new NNFLUpdateParam("objectclass", "OrclNetContainer"), new NNFLUpdateParam("OrclComputerName", string7)};
                this.ds.update(this, string3, false, nNFLUpdateParamArray, null, false);
            }
            if (!this.ds.exists(this, string9, false)) {
                nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("cn", this.ds.getCN(string9)), new NNFLUpdateParam("orclOracleHome", this.OraHomeDir), new NNFLUpdateParam("objectclass", "orclContainer"), new NNFLUpdateParam("objectclass", "OrclNetContainer"), new NNFLUpdateParam("OrclComputerName", string7)};
                this.ds.update(this, string9, false, nNFLUpdateParamArray, null, false);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        this.save();
    }

    public void initLDIF(String string, String string2, int n, String[] stringArray) throws ConfigException {
        Object object;
        try {
            if (this.ds.exists(this, this.oracleContext(), false)) {
                return;
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        String string3 = this.getSbsFile(string2, "ctx");
        String string4 = this.getLdifFile(string2, "ctx");
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (string2 != null) {
            object = this.ds.getUsername();
            if (object == null) {
                throw new ConfigException(1);
            }
            if (string2.equalsIgnoreCase("AD")) {
                try {
                    String[] stringArray4 = this.ds.query(this, "", "objectclass=*", "defaultNamingContext");
                    if (stringArray4 == null || stringArray4.length < 1) {
                        throw new ConfigException(1);
                    }
                    stringArray2 = new String[3];
                    stringArray3 = new String[3];
                    stringArray2[0] = "cn=OracleContext,dc=AdminCtxDomain";
                    stringArray3[0] = this.oracleContext();
                    stringArray2[1] = "cn=Users,dc=UsersDomain";
                    stringArray3[1] = "cn=Users," + stringArray4[0];
                    stringArray2[2] = "cn=Current User";
                    stringArray3[2] = object;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
            } else {
                stringArray2 = new String[2];
                stringArray3 = new String[2];
                stringArray2[0] = "%s_OracleContextDN%";
                stringArray3[0] = this.oracleContext();
                stringArray2[1] = "%s_OracleContextCreatorUserDN%";
                stringArray3[1] = object;
            }
        }
        Config.instantiateFile(string3, string4, stringArray2, stringArray3);
        this.loadLDIF(string, string2, n, stringArray, false, string4);
        object = new File(string4);
        ((File)object).delete();
        if (string2 != null && string2.equalsIgnoreCase("AD")) {
            try {
                object = this.getNTBinding();
                NTSecurityDescriptor.InitializeContainers((NTBinding)object, this.oracleContext());
            }
            catch (NTBindingException nTBindingException) {
                throw new ConfigException(1);
            }
            catch (NTSDException nTSDException) {
                throw new ConfigException(1);
            }
        }
    }

    public void createDB(String string, String string2, String string3, String string4, String string5, int n, String[] stringArray) throws ConfigException {
        String string6 = this.getSbsFile(string2, "db");
        String string7 = this.getLdifFile(string2, "db");
        String[] stringArray2 = new String[]{"cn=server1"};
        String[] stringArray3 = new String[]{"cn=" + string3 + ","};
        Config.instantiateFile(string6, string7, stringArray2, stringArray3);
        stringArray2[0] = "cn=OracleContext,OU=Americas,O=oracle,C=US";
        stringArray3[0] = "cn=OracleContext," + string4;
        Config.instantiateFile(string6, string7, stringArray2, stringArray3);
        Config config = new Config(string5, 1, null);
        config.loadLDIF(string, string2, n, stringArray, false, string7);
    }

    public void addDBtoSD(String string, String string2, String string3, String string4, String string5, String string6, int n, String[] stringArray) throws ConfigException {
        String string7 = this.getSbsFile(string2, "dom");
        String string8 = this.getLdifFile(string2, "dom");
        String[] stringArray2 = new String[]{"cn=server1"};
        String[] stringArray3 = new String[]{"cn=" + string3 + ","};
        Config.instantiateFile(string7, string8, stringArray2, stringArray3);
        stringArray2[0] = "dn=myDomain";
        stringArray3[0] = "dn=" + string4;
        Config.instantiateFile(string7, string8, stringArray2, stringArray3);
        stringArray2[0] = "cn=OracleContext,OU=Americas,O=oracle,C=US";
        stringArray3[0] = "cn=OracleContext," + string5;
        Config.instantiateFile(string7, string8, stringArray2, stringArray3);
        Config config = new Config(string6, 1, null);
        config.loadLDIF(string, string2, n, stringArray, false, string8);
    }

    public static void initSchemaOnly(String string, String string2, String string3, String string4, int n, String[] stringArray) throws ConfigException {
        Object object;
        Config config = new Config(string4, 1, null);
        if (string != null) {
            object = new String[]{string};
            config.setDirectoryServers((String[])object);
        }
        if (string2 != null) {
            config.setDirectoryType(string2);
        }
        config.bind(n, stringArray);
        if (!config.schemaExists()) {
            object = config.getSbsFile(string2, "schema");
            String string5 = config.getLdifFile(string2, "schema");
            if (string2 != null && string2.equalsIgnoreCase("AD")) {
                try {
                    DirectoryService directoryService = config.getDS();
                    String[] stringArray2 = new String[1];
                    String[] stringArray3 = new String[1];
                    String[] stringArray4 = directoryService.query(config, "", "objectclass=*", "defaultNamingContext");
                    if (stringArray4 == null || stringArray4.length < 1) {
                        throw new ConfigException(1);
                    }
                    stringArray2[0] = "dc=domain";
                    stringArray3[0] = stringArray4[0];
                    Config.instantiateFile((String)object, string5, stringArray2, stringArray3);
                    config.loadLDIF(string, string2, n, stringArray, false, string5);
                    File file = new File(string5);
                    file.delete();
                    try {
                        directoryService.updateSchema(config);
                    }
                    catch (DirectoryServiceException directoryServiceException) {
                        throw new ConfigException(directoryServiceException);
                    }
                    stringArray2[0] = "dc=domain";
                    stringArray3[0] = stringArray4[0];
                    String[] stringArray5 = new String[]{"disus", "disja", "disd", "disf", "dise", "disi", "disptb", "diszhs", "disko", "disoth"};
                    String string6 = null;
                    for (int i = 0; i < stringArray5.length; ++i) {
                        String string7 = config.getSbsFile(string2, stringArray5[i]);
                        string6 = config.getLdifFile(string2, stringArray5[i]);
                        Config.instantiateFile(string7, string6, stringArray2, stringArray3);
                        config.loadLDIF(string, string2, n, stringArray, true, string6);
                        file = new File(string6);
                        file.delete();
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new ConfigException(directoryServiceException);
                }
                catch (ConfigException configException) {
                    throw configException;
                }
            }
            config.loadLDIF(string, string2, n, stringArray, false, string5);
            if (!config.schemaExists()) {
                throw new ConfigException(1);
            }
        }
    }

    public static void destroyLDAP(String string, int n, String[] stringArray) throws ConfigException {
        Object object;
        Config config = new Config(string, 1, null);
        if (!config.netConfigUsesLDAP()) {
            return;
        }
        config.bind(n, stringArray);
        String[] stringArray2 = config.getDirectoryServers(true);
        String string2 = stringArray2 != null && stringArray2.length > 0 ? stringArray2[0] : null;
        String string3 = config.getDirectoryType();
        try {
            object = config.getDS();
            ((DirectoryService)object).delete(config, config.oracleContext(), false, true);
            if (string3 != null && string3.equalsIgnoreCase("AD")) {
                String[] stringArray3 = ((DirectoryService)object).query(config, "", "objectclass=*", "defaultNamingContext");
                if (stringArray3 == null || stringArray3.length < 1) {
                    throw new ConfigException(1);
                }
                ((DirectoryService)object).delete(config, "cn=OracleDBSecurityAdmins,cn=Users," + stringArray3[0], false, true);
                ((DirectoryService)object).delete(config, "cn=OracleDBCreators,cn=Users," + stringArray3[0], false, true);
                ((DirectoryService)object).delete(config, "cn=OracleNetAdmins,cn=Users," + stringArray3[0], false, true);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        if ((string3 == null || !string3.equalsIgnoreCase("AD")) && config.schemaExists()) {
            object = config.getLdifFile(string3, "remschema");
            config.loadLDIF(string2, string3, n, stringArray, false, (String)object);
            if (config.schemaExists()) {
                throw new ConfigException(1);
            }
        }
        if (((File)(object = new File(config.getFilename(4)))).exists()) {
            ((File)object).delete();
        }
    }

    public void bind(int n, String[] stringArray) throws ConfigException {
        if (trace) {
            out.println("Config: bind: (entry)");
        }
        if (trace) {
            out.println("Config: bind: authMethod = " + n);
        }
        try {
            this.ds.bind(this, n, stringArray);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        try {
            if (trace) {
                out.println("Config: bind: try NTBinding");
            }
            String string = this.getDirectoryType();
            String string2 = System.getProperty("os.name");
            if (string != null && string.equalsIgnoreCase("AD") && string2.startsWith("Windows")) {
                String string3 = null;
                Integer n2 = new Integer(0);
                String[] stringArray2 = this.getDirectoryServers(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    string3 = DirectoryService.getHostFromDSAddr(stringArray2[0]);
                    n2 = new Integer(DirectoryService.getPortFromDSAddr(stringArray2[0], false));
                }
                if (trace) {
                    if (stringArray == null) {
                        out.println("Config: bind: null credentials");
                    } else {
                        out.println("Config: bind: create NTBinding with " + (stringArray[0] != null ? stringArray[0] : "NULL") + "/" + (stringArray[1] != null ? stringArray[1] : "NULL"));
                    }
                }
                this.ntbinding = new NTBinding(n, stringArray, string3, n2);
                if (trace) {
                    out.println("Config: bind: NTBinding created");
                }
            }
        }
        catch (NTBindingException nTBindingException) {
            throw new ConfigException(1);
        }
        if (trace) {
            out.println("Config: bind: (exit)");
        }
    }

    public void unbind() {
        this.ds.unbind(this);
    }

    public DirectoryService getDS() {
        return this.ds;
    }

    public NTBinding getNTBinding() throws NTBindingException {
        String string = this.getDirectoryType();
        String string2 = System.getProperty("os.name");
        if (string == null || !string.equalsIgnoreCase("AD") || !string2.startsWith("Windows")) {
            throw new NTBindingException();
        }
        if (this.ntbinding == null) {
            int n = 0;
            String[] stringArray = null;
            String string3 = null;
            Integer n2 = new Integer(0);
            n = this.ds.getAuthMethod();
            stringArray = this.ds.getCredentials();
            String[] stringArray2 = this.getDirectoryServers(true);
            if (stringArray2 != null && stringArray2.length > 0) {
                string3 = DirectoryService.getHostFromDSAddr(stringArray2[0]);
                n2 = new Integer(DirectoryService.getPortFromDSAddr(stringArray2[0], false));
            }
            this.ntbinding = new NTBinding(n, stringArray, string3, n2);
        }
        return this.ntbinding;
    }

    public boolean netConfigUsesLDAP() {
        String string = this.get("NET_CONFIG_METHOD");
        return string != null && string.equalsIgnoreCase("LDAP");
    }

    public void netConfigUsesLDAP(boolean bl) {
        if (bl) {
            this.set("NET_CONFIG_METHOD", "LDAP");
        } else {
            this.set("NET_CONFIG_METHOD", "LOCAL");
        }
    }

    public String systemName() {
        String string = this.get("SYSTEMNAME_IN_DIR");
        if (string != null && string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string == null) {
            string = NetGetEnv.getLocalHostName();
        }
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = null;
            }
        }
        return string;
    }

    public void systemName(String string) {
        this.set("SYSTEMNAME_IN_DIR", "\"" + string + "\"");
    }

    public String namingContext() {
        return this.getDefaultAdminContext();
    }

    public String namingContext(boolean bl) {
        NNFLWrapper nNFLWrapper;
        String string;
        String string2;
        String string3 = this.namingContext();
        if (string3 == null && bl && (string2 = System.getProperty("os.name")).startsWith("Windows") && (string = this.getDirectoryType()) != null && string.equalsIgnoreCase("AD") && (nNFLWrapper = new NNFLWrapper()).getBaseAdminCtx() == 0) {
            string3 = nNFLWrapper.adminCtx;
        }
        return string3;
    }

    public void namingContext(String string) {
        this.setDefaultAdminContext(string);
    }

    public String getDefaultOracleContext(boolean bl) {
        NNFLWrapper nNFLWrapper;
        String string;
        String string2;
        String string3 = this.getDefaultAdminContext();
        if (!bl && string3 == null && (string2 = System.getProperty("os.name")).startsWith("Windows") && (string = this.getDirectoryType()) != null && string.equalsIgnoreCase("AD") && (nNFLWrapper = new NNFLWrapper()).getBaseAdminCtx() == 0) {
            string3 = nNFLWrapper.adminCtx;
        }
        string2 = "cn=OracleContext";
        if (string3 == null) {
            return string2;
        }
        if (!string3.equals("")) {
            string2 = string2 + "," + string3;
        }
        return string2;
    }

    private String getDefaultAdminContext() {
        String string = this.get("DEFAULT_ADMIN_CONTEXT");
        if (string != null && string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        string = this.unescapeQuotes(string);
        return string;
    }

    private String unescapeQuotes(String string) {
        int n = 0;
        if (string == null) {
            return string;
        }
        String string2 = string;
        while ((n = string2.indexOf("\\\"", n)) != -1) {
            string2 = string2.substring(0, ++n - 1) + string2.substring(n);
        }
        return string2;
    }

    public void setDefaultOracleContext(String string) {
        String string2 = DirectoryService.getParent(string);
        this.setDefaultAdminContext(string2);
    }

    public void setCurrentOracleContext(String string) {
        this.m_currentOracleContext = string;
    }

    public String getCurrentOracleContext() {
        return this.m_currentOracleContext;
    }

    public void setDefaultAdminContext(String string) {
        if (trace) {
            out.println("Config: setDefaultAdminContext: (entry)");
        }
        if (string == null) {
            this.set("DEFAULT_ADMIN_CONTEXT", null);
            if (trace) {
                out.println("Config: setDefaultAdminContext: Set to null");
            }
        } else {
            String string2 = this._escapeQuotes(string);
            this.set("DEFAULT_ADMIN_CONTEXT", "\"" + string2 + "\"");
            if (trace) {
                out.println("Config: setDefaultAdminContext: Set to: " + string2);
            }
        }
        if (trace) {
            out.println("Config: setDefaultAdminContext: (exit)");
        }
    }

    private String _escapeQuotes(String string) {
        int n = -1;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf(34, n2)) != -1) {
            if (string.charAt(n - 1) != '\\') {
                string2 = string2 + string.substring(n2, n) + "\\\"";
            }
            n2 = n + 1;
        }
        string2 = string2 + string.substring(n2);
        return string2;
    }

    public String oracleContext() {
        String string = this.namingContext(true);
        if (string.equals("")) {
            return "cn=OracleContext";
        }
        return "cn=OracleContext," + string;
    }

    public String homeID() {
        return this.get("HOMEID");
    }

    public void homeID(String string) {
        this.set("HOMEID", string);
    }

    public String[] getDirectoryServers() {
        return this.getList("DIRECTORY_SERVERS");
    }

    public void setDirectoryServers(String[] stringArray) {
        if (trace) {
            out.println("Config: setDirectoryServers: (entry)");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].indexOf(LDAP_PORT_SEP) != -1) continue;
                int n = i;
                stringArray[n] = stringArray[n] + LDAP_PORT_SEP + DEFAULT_LDAP_PORT;
            }
        }
        this.setList("DIRECTORY_SERVERS", stringArray);
        if (trace) {
            out.println("Config: setDirectoryServers: (exit)");
        }
    }

    public String[] getDirectoryServers(boolean bl) {
        String string;
        String string2;
        String[] stringArray = this.getDirectoryServers();
        if ((stringArray == null || stringArray.length == 0) && bl && (string2 = System.getProperty("os.name")).startsWith("Windows") && (string = this.getDirectoryType()) != null && string.equalsIgnoreCase("AD")) {
            NNFLWrapper nNFLWrapper = new NNFLWrapper();
            stringArray = nNFLWrapper.getDirectoryServers();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getDirectoryType() {
        return this.get("DIRECTORY_SERVER_TYPE");
    }

    public void setDirectoryType(String string) {
        if (trace) {
            out.println("Config: setDirectoryType: (entry)");
        }
        this.set("DIRECTORY_SERVER_TYPE", string);
        if (trace) {
            out.println("Config: setDirectoryType: Set to: " + string);
        }
        if (trace) {
            out.println("Config: setDirectoryType: (exit)");
        }
    }

    public String getConnectionTimeout() {
        return this.get("DIR_IDLE_CONNTIMEOUT");
    }

    public void setConnectionTimeout(String string) {
        this.set("DIR_IDLE_CONNTIMEOUT", string);
    }

    public String get(String string) {
        NVPair nVPair = null;
        try {
            nVPair = this.m_configs[4].getNlpa().getNLPListElement(string);
        }
        catch (NLException nLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nVPair != null) {
            return nVPair.getAtom();
        }
        return null;
    }

    public String[] getList(String string) {
        NVPair nVPair = null;
        try {
            nVPair = this.m_configs[4].getNlpa().getNLPListElement(string);
        }
        catch (NLException nLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nVPair != null) {
            String[] stringArray = new String[nVPair.getListSize()];
            for (int i = 0; i < nVPair.getListSize(); ++i) {
                stringArray[i] = nVPair.getListElement(i).getAtom();
            }
            return stringArray;
        }
        out.println("get value: null");
        return null;
    }

    public void set(String string, String string2) {
        try {
            if (string2 == null) {
                this.m_configs[4].getNlpa().removeNLPListElement(string);
                if (this.m_configs[4].getNlpa().getNLPListSize() < 1) {
                    this.m_configs[4].configExists(false);
                }
            } else {
                this.m_configs[4].getNlpa().addNLPListElement(string + "=" + string2);
                this.m_configs[4].configExists(true);
            }
        }
        catch (NLException nLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setList(String string, String[] stringArray) {
        int n = 0;
        String string2 = "(";
        if (trace) {
            out.println("Config: setList: (entry)");
        }
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    if (n > 0) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + stringArray[i];
                    ++n;
                }
                string2 = string2 + ")";
            }
            if (n == 0) {
                this.m_configs[4].getNlpa().removeNLPListElement(string);
                if (this.m_configs[4].getNlpa().getNLPListSize() < 1) {
                    this.m_configs[4].configExists(false);
                }
                if (trace) {
                    out.println("Config: setList: Not set");
                }
            } else {
                this.m_configs[4].getNlpa().addNLPListElement(string + "=" + string2);
                this.m_configs[4].configExists(true);
                if (trace) {
                    out.println("Config: setList: Set to: " + string2);
                }
            }
        }
        catch (NLException nLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (trace) {
            out.println("Config: setList: (exit)");
        }
    }

    public void save() throws ConfigException {
        try {
            this.writeToFile(4);
        }
        catch (NLException nLException) {
            throw new ConfigException(nLException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    public String getNetDir() {
        String string;
        String string2 = NetGetEnv.get("TNS_ADMIN");
        String string3 = System.getProperty("os.name");
        if (string2 != null) {
            string = string2;
            if (string3.startsWith("Windows")) {
                if (!string.endsWith("\\")) {
                    string = string + "\\";
                }
            } else if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else {
            string = string3.startsWith("Windows") ? this.OraHomeDir + "\\network\\admin\\" : this.OraHomeDir + "/network/admin/";
        }
        return string;
    }

    private static boolean hostExists(String string, String string2) {
        String string3 = string2 == null ? string : string + "." + string2;
        try {
            InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    private String determineSystemName(boolean bl) throws ConfigException {
        String[] stringArray;
        Object object;
        String string = NetGetEnv.getDNSDomain();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            object = InetAddress.getAllByName(inetAddress.getHostName());
            stringArray = new String[((InetAddress[])object).length];
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                stringArray[i] = object[i].getHostName();
                if (stringArray[i].indexOf(".") != -1 || string == null) continue;
                stringArray[i] = stringArray[i] + "." + string;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConfigException(unknownHostException);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = "cn=" + stringArray[i] + ", " + this.oracleContext();
            try {
                if (!this.ds.exists(this, (String)object, false)) continue;
                return stringArray[i];
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
        }
        if (bl) {
            throw new ConfigException(19);
        }
        return stringArray[0];
    }

    private String determineHomeID(String string, String string2, String string3, boolean bl) throws ConfigException {
        String string4 = this.systemName();
        if (string4 == null) {
            throw new ConfigException(17);
        }
        try {
            String[] stringArray = this.ds.enumDNs(this, string4, "objectclass=OrclNetContainer", false);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = this.ds.read(this, stringArray[i], false, "orclOracleHome");
                if (stringArray2 == null || stringArray2.length <= 0 || !string.equalsIgnoreCase(stringArray2[0])) continue;
                return this.ds.getCN(stringArray[i]);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        if (bl) {
            throw new ConfigException(17);
        }
        try {
            if (string2 != null && !this.ds.exists(this, "cn=" + string2 + ", " + string4, false)) {
                return string2;
            }
            if (string3 != null && !this.ds.exists(this, "cn=home" + string3 + ", " + string4, false)) {
                return "home" + string3;
            }
            for (int i = 0; i < 1000; ++i) {
                if (this.ds.exists(this, "cn=home" + i + ", " + string4, false)) continue;
                return "home" + i;
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
        throw new ConfigException(17);
    }

    void traceOut() throws ConfigException {
    }

    public boolean schemaExists() throws ConfigException {
        String string = null;
        String string2 = this.getDirectoryType();
        if (string2 != null && string2.equalsIgnoreCase("AD")) {
            try {
                Object object;
                String[] stringArray = null;
                stringArray = this.ds.query(this, "", "objectclass=*", "defaultNamingContext");
                if (stringArray == null || stringArray.length < 1) {
                    throw new ConfigException(1);
                }
                String string3 = stringArray[0];
                String[] stringArray2 = this.ds.enumDNs(this, string3, "objectclass=orclContext", true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    return true;
                }
                stringArray = this.ds.query(this, "", "objectclass=*", "subschemaSubentry");
                if (stringArray == null || stringArray.length < 1) {
                    throw new ConfigException(1);
                }
                string = stringArray[0];
                if (this.ds.exists(this, string, false)) {
                    object = this.ds.query(this, string, "objectclass=*", "objectclasses");
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (object[i].toLowerCase().indexOf("orclContext".toLowerCase()) == -1) continue;
                        return true;
                    }
                }
                object = null;
                try {
                    NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam("cn", "OracleTestEntry"), new NNFLUpdateParam("objectclass", "orclContainer")};
                    String string4 = "cn=OracleTestEntry," + string3;
                    object = this.ds.update(this, string4, false, nNFLUpdateParamArray, null, false);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    return false;
                }
                this.ds.delete(this, (String)object, false, true);
                return true;
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(directoryServiceException);
            }
        }
        string = string2 != null && string2.equalsIgnoreCase("OID") ? "cn=subschemasubentry" : (string2 != null && string2.equalsIgnoreCase("NDS") ? "" : (string2 != null && string2.equalsIgnoreCase("NETSCAPE") ? "cn=schema" : "cn=subschemasubentry"));
        try {
            if (string2 != null && string2.equalsIgnoreCase("NDS")) {
                String string5 = "orclSchemaVersion";
                String string6 = "objectclass=" + string5.toLowerCase();
                String[] stringArray = this.ds.ndsquery(this, string, string6, "objectClass");
                if (stringArray == null) {
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].toLowerCase().indexOf(string5.toLowerCase()) == -1) continue;
                    return true;
                }
                return false;
            }
            String[] stringArray = this.ds.query(this, string, "objectclass=*", "objectclasses");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toLowerCase().indexOf("orclContext".toLowerCase()) == -1) continue;
                return true;
            }
            return false;
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new ConfigException(directoryServiceException);
        }
    }

    private void loadLDIF(String string, String string2, int n, String[] stringArray, boolean bl, String string3) throws ConfigException {
        String[] stringArray2;
        String string4;
        Object object;
        String string5 = null;
        String string6 = null;
        if (string2 == null) {
            throw new ConfigException(2);
        }
        if (string == null && string2 == "AD" && n == 8 && (object = this.getDirectoryServers(true)) != null && ((String[])object).length > 0) {
            string = object[0];
        }
        if (string == null) {
            throw new ConfigException(2);
        }
        this.getDS();
        string5 = DirectoryService.getHostFromDSAddr(string);
        this.getDS();
        string6 = DirectoryService.getPortFromDSAddr(string, false);
        if (n == 1) {
            String[] stringArray3;
            String string7;
            object = "";
            string4 = "";
            if (stringArray != null && stringArray.length > 1) {
                if (stringArray[0] != null) {
                    object = stringArray[0];
                }
                if (stringArray[1] != null) {
                    string4 = stringArray[1];
                }
            }
            if ((string7 = System.getProperty("os.name")).startsWith("Windows")) {
                object = "\"" + (String)object + "\"";
                string4 = "\"" + string4 + "\"";
            }
            if (bl) {
                stringArray3 = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-D", object, "-w", string4, "-c", "-E utf8", "-f", string3};
                stringArray2 = stringArray3;
            } else {
                stringArray3 = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-D", object, "-w", string4, "-c", "-f", string3};
                stringArray2 = stringArray3;
            }
        } else if (n == 8) {
            if (bl) {
                object = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-Z", "-c", "-E utf8", "-f", string3};
                stringArray2 = object;
            } else {
                object = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-Z", "-c", "-f", string3};
                stringArray2 = object;
            }
        } else if (bl) {
            object = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-c", "-E utf8", "-f", string3};
            stringArray2 = object;
        } else {
            object = new String[]{"ldapmodify", "-h", string5, "-p", string6, "-c", "-f", string3};
            stringArray2 = object;
        }
        if (!this.runUtility(stringArray2)) {
            object = string3.substring(0, string3.lastIndexOf(File.separator)) + File.separator + "loadLDIF.err";
            string4 = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                string4 = string4 + " " + stringArray2[i];
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)object));
                bufferedWriter.write("Error returned from ldapmodify program while loading LDIF file.");
                bufferedWriter.newLine();
                bufferedWriter.write("The ldapmodify command line was:");
                bufferedWriter.newLine();
                bufferedWriter.write(string4);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConfigException(16);
        }
    }

    private boolean runUtility(String[] stringArray) {
        int n = 0;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
                BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
                boolean bl = false;
                while (!bl) {
                    while (bufferedInputStream.available() > 0) {
                        bufferedInputStream.read();
                    }
                    while (bufferedInputStream2.available() > 0) {
                        bufferedInputStream2.read();
                    }
                    bl = true;
                    try {
                        n = process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = false;
                    }
                }
                bufferedInputStream.close();
                bufferedInputStream2.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            n = process.waitFor();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return n == 0;
    }

    private static void instantiateFile(String string, String string2, String[] stringArray, String[] stringArray2) throws ConfigException {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = -1;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2 = 0;
                    while ((n = string3.indexOf(stringArray[i], n2)) != -1) {
                        string3 = string3.substring(0, n) + stringArray2[i] + string3.substring(n + stringArray[i].length());
                        n2 = n + stringArray2[i].length();
                    }
                }
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
    }

    private String getLdifFile(String string, String string2) throws ConfigException {
        String string3 = string != null && string.equalsIgnoreCase("AD") ? "ad" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("OID") ? "oid" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("NETSCAPE") ? "ns" + string2 + ".ldif" : (string != null && string.equalsIgnoreCase("NDS") ? "nds" + string2 + ".ldif" : "oid" + string2 + ".ldif")));
        string3 = this.OraHomeDir + File.separator + "network" + File.separator + "tools" + File.separator + "config" + File.separator + string3;
        return string3;
    }

    private String getSbsFile(String string, String string2) throws ConfigException {
        String string3 = string != null && string.equalsIgnoreCase("AD") ? "ad" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("OID") ? "oid" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("NETSCAPE") ? "ns" + string2 + ".sbs" : (string != null && string.equalsIgnoreCase("NDS") ? "nds" + string2 + ".sbs" : "oid" + string2 + ".sbs")));
        string3 = this.OraHomeDir + File.separator + "network" + File.separator + "tools" + File.separator + "config" + File.separator + string3;
        return string3;
    }

    public NLParamParser getNlpaObject() throws ConfigException {
        return this.getNlpa(0);
    }

    public NLParamParser getNlpa(int n) throws ConfigException {
        try {
            return this.m_configs[n].getNlpa();
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException);
        }
        catch (NLException nLException) {
            throw new ConfigException(nLException);
        }
    }

    public void setFilename(int n, String string) {
        this.m_configs[n].setFilename(string);
    }

    public String getFilename(int n) {
        return this.m_configs[n].getFilename();
    }

    public void readFromFile(int n, String string) throws NLException, IOException {
        this.m_configs[n].readFromFile(string);
    }

    public void writeToFile(int n, String string) throws NLException, IOException {
        if (n == 4) {
            this.m_configs[4].file = string;
            if (this.m_configs[4].getNlpa().getNLPListSize() > 0) {
                String string2 = this.get("NET_CONFIG_METHOD");
                this.set("NET_CONFIG_METHOD", null);
                this.m_configs[4].writeToFile();
                this.ds.reloadParams();
                this.set("NET_CONFIG_METHOD", string2);
            } else {
                File file = new File(this.getFilename(4));
                if (file.exists()) {
                    file.delete();
                    this.ds.reloadParams();
                }
            }
        } else {
            this.m_configs[n].writeToFile(string);
        }
    }

    public void writeToFile(int n) throws NLException, IOException {
        this.writeToFile(n, this.m_configs[n].getFilename());
    }

    public void setStream(int n, Reader reader) throws IOException, NLException {
        this.setStream(n, reader, (byte)0);
    }

    public void setStream(int n, Reader reader, byte by) throws IOException, NLException {
        this.m_configs[n].readFromStream(reader, by);
    }

    public void readFromStream(int n, Reader reader) throws IOException, NLException {
        this.readFromStream(n, reader, (byte)0);
    }

    public void readFromStream(int n, Reader reader, byte by) throws IOException, NLException {
        this.m_configs[n].readFromStream(reader, by);
    }

    public void writeToStream(int n, Writer writer) throws NLException, IOException {
        this.m_configs[n].writeToStream(writer);
    }

    public void deleteNlpa(int n) {
        this.m_configs[n].configExists(false);
    }

    private static class CharArrayWriterWithPublicData
    extends CharArrayWriter {
        public char[] buf;
        public int count;

        private CharArrayWriterWithPublicData() {
        }
    }

    private static class ConfigStruct {
        String file = null;
        private String defaultFile = null;
        private NLParamParser nlpa = null;
        private boolean exists = false;
        private int filePermissions = 0;

        ConfigStruct(String string, String string2, int n) {
            this.defaultFile = string;
            this.file = string2 + string;
            this.filePermissions = n;
        }

        public void setNlpa(NLParamParser nLParamParser) {
            this.nlpa = nLParamParser;
            this.exists = true;
        }

        public NLParamParser getNlpa() throws NLException, IOException {
            if (this.nlpa == null) {
                this.readFromFile(this.file);
            }
            return this.nlpa;
        }

        public void readFromStream(Reader reader, byte by) throws NLException, IOException {
            this.exists = false;
            this.setNlpa(new NLParamParser(reader, by));
            this.exists = true;
        }

        public void writeToStream(Writer writer) throws NLException, IOException {
            if (this.exists) {
                this.getNlpa().writeToStream(writer, this.defaultFile, this.file);
            }
        }

        public String getFilename() {
            return this.file;
        }

        public void setFilename(String string) {
            this.file = string;
            this.setNlpa(null);
            this.exists = false;
        }

        public void readFromFile(String string) throws NLException, IOException {
            this.exists = false;
            this.setNlpa(new NLParamParser(string));
            this.exists = true;
            this.file = string;
        }

        public void writeToFile(String string) throws NLException, IOException {
            if (this.exists) {
                this.nlpa.saveNLParams(string);
            }
            this.file = string;
        }

        public void writeToFile() throws NLException, IOException {
            this.writeToFile(this.file);
        }

        public boolean exists() {
            return this.exists;
        }

        public void configExists(boolean bl) {
            this.exists = bl;
        }
    }
}

