/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.config.AddressListConfig;
import oracle.net.config.CMANException;
import oracle.net.config.Config;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.ParameterSource;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class CMAN
extends ParameterSource {
    private Vector addrs = new Vector();
    public Vector rules = new Vector();

    public static boolean exists(Config config) {
        block4: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, "cman", true)) {
                        return true;
                    }
                    break block4;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    return false;
                }
            }
            File file = new File(config.getFilename(1));
            return file.exists();
        }
        return false;
    }

    public static void delete(Config config) throws CMANException {
        if (CMAN.exists(config)) {
            if (config.netConfigUsesLDAP()) {
                try {
                    config.getDS().delete(config, "cman", true, true);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new CMANException(directoryServiceException);
                }
            } else {
                File file = new File(config.getFilename(1));
                if (!file.delete()) {
                    throw new CMANException(new IOException());
                }
            }
        }
    }

    public void migrateToLDAP(Config config, boolean bl, boolean bl2) throws CMANException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(true);
            String string = this.name;
            this.name = this.name.replace('.', '_');
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(false);
            if (bl2) {
                CMAN.delete(config);
            }
        }
        catch (CMANException cMANException) {
            config.netConfigUsesLDAP(bl3);
            throw cMANException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    public void migrateToFILE(Config config, boolean bl, boolean bl2) throws CMANException {
        boolean bl3 = config.netConfigUsesLDAP();
        try {
            config.netConfigUsesLDAP(false);
            String string = this.name;
            this.name = config.getDS().getCN(this.name);
            this.save(config, bl);
            this.name = string;
            config.netConfigUsesLDAP(true);
            if (bl2) {
                CMAN.delete(config);
            }
        }
        catch (CMANException cMANException) {
            config.netConfigUsesLDAP(bl3);
            throw cMANException;
        }
        config.netConfigUsesLDAP(bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CMAN(Config config) throws CMANException {
        super("cman");
        DirectoryService directoryService = config.getDS();
        this.qname = directoryService.qualifyObjectName(config, this.name, true);
        if (config.netConfigUsesLDAP()) {
            try {
                Hashtable hashtable = directoryService.read(config, this.name, true, this.getSupportedAttributes());
                String string = ((String[])hashtable.get("dn"))[0];
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object object2;
                    String string2 = (String)enumeration.nextElement();
                    String[] stringArray = (String[])hashtable.get(string2);
                    if (string2.equalsIgnoreCase("OrclNetEndPointList")) {
                        object2 = new SchemaObjectConfigFactory();
                        this.addrs = ((SchemaObjectConfigFactory)object2).create(config, stringArray, string, null);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("OrclRule")) {
                        try {
                            object2 = new Vector();
                            for (int i = 1; i <= 32; ++i) {
                                ((Vector)object2).addElement("OrclRule" + i);
                            }
                            object = directoryService.read(config, stringArray[0] + ", " + string, false, (Vector)object2);
                            for (int i = 1; i <= 32; ++i) {
                                String[] stringArray2 = (String[])((Hashtable)object).get("OrclRule" + i);
                                if (stringArray2 == null) continue;
                                this.rules.addElement(stringArray2[0]);
                            }
                            continue;
                        }
                        catch (DirectoryServiceException directoryServiceException) {
                            continue;
                        }
                    }
                    if (string2.equalsIgnoreCase("OrclNetParamList")) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n = stringArray[i].indexOf("=");
                            if (n == -1) continue;
                            object = stringArray[i].substring(0, n).trim();
                            String string3 = stringArray[i].substring(n + 1).trim();
                            this.setParameter((String)object, string3);
                        }
                        continue;
                    }
                    if (this.mapping.parameter(string2) == null) continue;
                    this.setParameter(this.mapping.parameter(string2), stringArray[0]);
                }
                return;
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) return;
                throw new CMANException(directoryServiceException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new CMANException(sOExceptionConfig);
            }
        }
        try {
            int n;
            Object object;
            this.nlpa = new NLParamParser(config.getFilename(1));
            NVPair nVPair = this.nlpa.getNLPListElement("CMAN");
            if (nVPair == null) {
                try {
                    nVPair = new NVFactory().createNVPair("(CMAN=(ADDRESS=(PROTOCOL=tcp)(HOST=localhost)(PORT=1600)))");
                }
                catch (NLException nLException) {
                    throw new CMANException(nLException);
                }
            }
            nVPair = nVPair.getListElement(0);
            try {
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                object = schemaObjectConfigFactory.create(nVPair, null, null);
                this.addrs.addElement(object);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new CMANException(sOExceptionConfig);
            }
            nVPair = this.nlpa.getNLPListElement("CMAN_PROFILE");
            if (nVPair != null) {
                nVPair = nVPair.getListElement(0);
                int n2 = nVPair.getListSize();
                for (int i = 0; i < n2; ++i) {
                    object = nVPair.getListElement(i);
                    this.setParameter(((NVPair)object).getName(), this.rhsToString((NVPair)object));
                }
            }
            if ((nVPair = this.nlpa.getNLPListElement("CMAN_RULES")) == null || (n = (nVPair = nVPair.getListElement(0)).getListSize()) == 0) return;
            for (int i = 0; i < n; ++i) {
                this.rules.addElement(nVPair.getListElement(i).toString());
            }
            return;
        }
        catch (NLException nLException) {
            throw new CMANException(nLException);
        }
        catch (IOException iOException) {
            throw new CMANException(iOException);
        }
    }

    public Enumeration enumEndpoints() {
        return this.addrs.elements();
    }

    public void setEndpoints(Vector vector) throws CMANException {
        this.checkEndpoints(vector);
        this.addrs = vector;
    }

    public void remEndpoints() {
        this.addrs.removeAllElements();
    }

    public int numOfEndpoints() {
        return this.addrs.size();
    }

    public void save(Config config, boolean bl) throws CMANException {
        if (CMAN.exists(config) && !bl) {
            throw new CMANException(3);
        }
        if (config.netConfigUsesLDAP()) {
            String string;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            Vector<String> vector = new Vector<String>();
            String[] stringArray = new String[]{"OrclConnectionManager", "applicationProcess"};
            Vector<NNFLUpdateParam> vector2 = new Vector<NNFLUpdateParam>();
            vector2.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector2.addElement(new NNFLUpdateParam("objectclass", stringArray));
            Object[] objectArray = this.hashtable.keys();
            while (objectArray.hasMoreElements()) {
                string = (String)objectArray.nextElement();
                String string2 = (String)this.hashtable.get(string);
                String string3 = this.mapping.attribute(string);
                if (string3 == null) {
                    vector.addElement(string + "=" + string2);
                    continue;
                }
                vector2.addElement(new NNFLUpdateParam(string3, string2));
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                vector2.addElement(new NNFLUpdateParam("OrclNetParamList", (String[])objectArray));
            }
            if (this.addrs.size() > 0) {
                objectArray = schemaObjectConfigFactory.getEndpointNames(this.addrs);
                vector2.addElement(new NNFLUpdateParam("OrclNetEndPointList", (String[])objectArray));
            }
            if (this.rules.size() > 0) {
                vector2.addElement(new NNFLUpdateParam("OrclRule", "cn=CMANRULES"));
            }
            objectArray = new NNFLUpdateParam[vector2.size()];
            vector2.copyInto(objectArray);
            string = null;
            try {
                string = directoryService.update(config, this.name, true, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new CMANException(directoryServiceException);
            }
            try {
                schemaObjectConfigFactory.save(config, this.addrs, string);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new CMANException(sOExceptionConfig);
            }
            if (this.rules.size() > 0) {
                vector2 = new Vector();
                vector2.addElement(new NNFLUpdateParam("cn", "CMANRULES"));
                vector2.addElement(new NNFLUpdateParam("objectclass", "OrclNetRule"));
                for (int i = 1; i <= this.rules.size(); ++i) {
                    vector2.addElement(new NNFLUpdateParam("OrclRule" + i, (String)this.rules.elementAt(i - 1)));
                }
                objectArray = new NNFLUpdateParam[vector2.size()];
                vector2.copyInto(objectArray);
                try {
                    directoryService.update(config, "cn=CMANRULES, " + string, false, (NNFLUpdateParam[])objectArray, null, false);
                }
                catch (DirectoryServiceException directoryServiceException) {
                    throw new CMANException(directoryServiceException);
                }
            }
        } else {
            try {
                Object object;
                if (this.nlpa == null) {
                    this.nlpa = new NLParamParser(config.getFilename(1), 2);
                }
                this.nlpa.removeNLPAllElements();
                if (this.addrs.size() > 0) {
                    object = (SchemaObjectConfig)this.addrs.elementAt(0);
                    this.nlpa.addNLPListElement("CMAN=" + object.toString());
                }
                object = new String("");
                Enumeration enumeration = this.hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string4 = (String)this.hashtable.get(string);
                    object = (String)object + "(" + string + "=" + string4 + ")";
                }
                if (((String)object).length() > 0) {
                    this.nlpa.addNLPListElement("CMAN_PROFILE=(PARAMETER_LIST=" + (String)object + ")");
                }
                if (this.rules.size() > 0) {
                    object = "CMAN_RULES=(RULES_LIST=";
                    for (int i = 0; i < this.rules.size(); ++i) {
                        object = (String)object + (String)this.rules.elementAt(i);
                    }
                    object = (String)object + ")";
                    this.nlpa.addNLPListElement((String)object);
                }
                this.nlpa.saveNLParams();
            }
            catch (NLException nLException) {
                throw new CMANException(nLException);
            }
            catch (IOException iOException) {
                throw new CMANException(iOException);
            }
        }
    }

    @Override
    protected void constructMapping() {
        this.mapping.set("OrclTraceLevel", "TRACING");
        this.mapping.set("OrclTraceFile", "TRACE_FILE");
        this.mapping.set("OrclTraceDirectory", "TRACE_DIRECTORY");
        this.mapping.set("OrclRelayStatistics", "RELAY_STATISTICS");
        this.mapping.set("OrclShowTnsInfo", "SHOW_TNS_INFO");
        this.mapping.set("OrclUseAsyncCall", "USE_ASYNC_CALL");
        this.mapping.set("OrclMaximumRelays", "MAXIMUM_RELAYS");
        this.mapping.set("OrclLogLevel", "LOG_LEVEL");
        this.mapping.set("OrclLogFile", "LOG_FILE");
        this.mapping.set("OrclLogDirectory", "LOG_DIRECTORY");
        this.mapping.set("OrclAuthenticationLevel", "AUTHENTICATION_LEVEL");
        this.mapping.set("OrclMaximumConnectData", "MAXIMUM_CONNECT_DATA");
        this.mapping.set("OrclAnswerTimeout", "ANSWER_TIMEOUT");
        this.mapping.set("OrclTraceFilelen", "TRACE_FILELEN");
        this.mapping.set("OrclTraceTimeStamp", "TRACE_TIMESTAMP");
        this.mapping.set("OrclTracePercentFree", "TRACE_PERCENT_FREE");
        this.mapping.set("OrclTraceFileno", "TRACE_FILENO");
    }

    private void checkEndpoints(Vector vector) throws CMANException {
        DirectoryService directoryService = new DirectoryService();
        for (int i = 0; i < vector.size(); ++i) {
            SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)vector.elementAt(i);
            if (schemaObjectConfig.getShared() && directoryService.inSubtree(this.qname, schemaObjectConfig.getName())) {
                throw new CMANException(9);
            }
            if (schemaObjectConfig.isA() == 3) {
                this.checkEndpoints(((DescriptionListConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() == 2) {
                this.checkEndpoints(((DescriptionConfig)schemaObjectConfig).children);
                continue;
            }
            if (schemaObjectConfig.isA() != 1) continue;
            this.checkEndpoints(((AddressListConfig)schemaObjectConfig).children);
        }
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("OrclNetEndPointList");
        vector.addElement("OrclRule");
        vector.addElement("OrclNetParamList");
        Enumeration enumeration = this.mapping.enumAttrs();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector;
    }
}

