/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.ldap.NNFLUpdateParam;

public class AuthInfo {
    private String type = null;
    private Hashtable parameters = new Hashtable();

    public AuthInfo() {
    }

    public AuthInfo(Config config, String string) throws DirectoryServiceException {
        if (config.netConfigUsesLDAP()) {
            DirectoryService directoryService = config.getDS();
            Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
            String string2 = ((String[])hashtable.get("dn"))[0];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string3);
                if (string3.equalsIgnoreCase("orclNetAuthenticationType")) {
                    this.setType(stringArray[0]);
                    continue;
                }
                if (!string3.equalsIgnoreCase("orclNetAuthParams")) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    String string4 = stringArray[i].substring(0, n).trim();
                    String string5 = stringArray[i].substring(n + 1).trim();
                    this.setParameter(string4, string5);
                }
            }
        }
    }

    public void save(Config config, String string) throws DirectoryServiceException {
        if (config.netConfigUsesLDAP()) {
            DirectoryService directoryService = config.getDS();
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            vector.addElement(new NNFLUpdateParam("cn", directoryService.getCN(string)));
            vector.addElement(new NNFLUpdateParam("objectclass", "OrclNetAuthInfo"));
            vector.addElement(new NNFLUpdateParam("orclNetAuthenticationType", this.getType()));
            Object[] objectArray = this.enumParams();
            while (objectArray.hasMoreElements()) {
                String string2 = (String)objectArray.nextElement();
                String string3 = this.getParameter(string2);
                vector.addElement(new NNFLUpdateParam("orclNetAuthParams", string2 + "=" + string3));
            }
            objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            directoryService.update(config, string, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), true);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getParameter(String string) {
        return (String)this.parameters.get(string.toUpperCase());
    }

    public void setParameter(String string, String string2) {
        this.parameters.put(string.toUpperCase(), string2);
    }

    public void remParameter(String string) {
        this.parameters.remove(string.toUpperCase());
    }

    public int getCount() {
        return this.parameters.size();
    }

    public Enumeration enumParams() {
        return this.parameters.keys();
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("orclNetAuthenticationType");
        vector.addElement("orclNetAuthParams");
        return vector;
    }
}

