/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.net.common.NetStrings;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.ServiceAlias;
import oracle.net.ldap.NNFLUpdateParam;

public class Alias {
    private String m_aliasName = null;
    private String m_aliasedName = null;
    private String m_oracleContext = null;
    private ServiceAlias m_aliasedObj = null;
    public static final String COMMON_FILTER = "objectclass=";
    public static final String CN_ATTR = "cn";
    public static final String OBJCLASS_ATTR = "objectclass";
    public static final String ALIASEDNAME_ATTR = "aliasedObjectName";
    private static NetStrings ns = new NetStrings("oracle.net.config.mesg.NetApiSR", Locale.getDefault());

    public Alias(String string, String string2, String string3) {
        this.m_aliasName = string;
        this.m_aliasedName = string2;
        this.m_oracleContext = string3;
    }

    public static Alias load(Config config, String string) throws ConfigException {
        if (config == null || string == null) {
            throw new NullPointerException();
        }
        if (config.netConfigUsesLDAP()) {
            try {
                DirectoryService directoryService = config.getDS();
                String string2 = directoryService.qualifyObjectName(config, string, false);
                Hashtable hashtable = directoryService.query(config, string2, "objectclass=*", Alias.getSupportedAttributes());
                String string3 = ((String[])hashtable.get(ALIASEDNAME_ATTR))[0];
                String string4 = config.getDS().getCN(string3);
                config.getDS();
                String string5 = DirectoryService.getParent(string3);
                Alias alias = new Alias(string, string4, string5);
                return alias;
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno != 207) {
                    throw new ConfigException(ns.getString("AliasLoad-04402", new Object[]{string, new Integer(directoryServiceException.errno)}));
                }
                return null;
            }
        }
        throw new ConfigException(ns.getString("OnlyLdap-4401"));
    }

    public String getAliasName() {
        return this.m_aliasName;
    }

    public String getAliasedName() {
        return this.m_aliasedName;
    }

    public String getOracleContextDN() {
        return this.m_oracleContext;
    }

    public static String[] enumAliases(Config config) throws ConfigException {
        if (config.netConfigUsesLDAP()) {
            try {
                DirectoryService directoryService = config.getDS();
                return directoryService.enumDNs(config, config.oracleContext(), COMMON_FILTER + Alias.getObjectClasses(false)[0], false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(ns.getString("AliasEnum-04403", new Object[]{new Integer(directoryServiceException.errno)}));
            }
        }
        throw new ConfigException(ns.getString("OnlyLdap-4401"));
    }

    public static String[] enumAliases(Config config, String string) throws ConfigException {
        if (config.netConfigUsesLDAP()) {
            try {
                DirectoryService directoryService = config.getDS();
                if (string == null) {
                    string = directoryService.getDomainObjectPath(config);
                }
                return directoryService.enumDNs(config, string, COMMON_FILTER + Alias.getObjectClasses(false)[1], false);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new ConfigException(ns.getString("AliasEnum-04403", new Object[]{new Integer(directoryServiceException.errno)}));
            }
        }
        throw new ConfigException(ns.getString("OnlyLdap-4401"));
    }

    public void save(Config config) throws DirectoryServiceException, ConfigException {
        if (config.netConfigUsesLDAP()) {
            DirectoryService directoryService = config.getDS();
            String string = null;
            String string2 = config.getCurrentOracleContext();
            string = string2 == null ? directoryService.qualifyObjectName(config, this.m_aliasName, false) : "cn=" + this.m_aliasName + "," + string2;
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[Alias.getSupportedAttributes().size()];
            nNFLUpdateParamArray[0] = new NNFLUpdateParam(CN_ATTR, this.m_aliasName);
            nNFLUpdateParamArray[1] = new NNFLUpdateParam(OBJCLASS_ATTR, Alias.getObjectClasses(false));
            String string3 = null;
            string3 = this.m_oracleContext != null ? "cn=" + this.m_aliasedName + "," + this.m_oracleContext : directoryService.qualifyObjectName(config, this.m_aliasedName, false);
            nNFLUpdateParamArray[2] = new NNFLUpdateParam(ALIASEDNAME_ATTR, string3);
            directoryService.update(config, string, false, nNFLUpdateParamArray, Alias.getSupportedAttributes(), false);
        } else {
            throw new ConfigException(ns.getString("OnlyLdap-4401"));
        }
    }

    public static void delete(Config config, String string) throws DirectoryServiceException, ConfigException {
        if (config.getDS().dnExists(config, string, false)) {
            if (config.netConfigUsesLDAP()) {
                config.getDS().delete(config, string, false, true);
            } else {
                throw new ConfigException("Aliases are supported only in LDAP");
            }
        }
    }

    public String toString() {
        return this.m_aliasName;
    }

    private static String[] getObjectClasses(boolean bl) {
        if (bl) {
            return new String[]{"top", "alias", "orclNetServiceAlias"};
        }
        return new String[]{"alias", "orclNetServiceAlias"};
    }

    private static Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(CN_ATTR);
        vector.addElement(OBJCLASS_ATTR);
        vector.addElement(ALIASEDNAME_ATTR);
        return vector;
    }
}

