/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.TNSAddress.AddressList;
import oracle.net.TNSAddress.SOException;
import oracle.net.config.Config;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NVPair;

public class AddressListConfig
extends AddressList
implements SchemaObjectConfig {
    public String name = null;
    public String description = null;
    public String version = "v0.0";
    private boolean shared = false;

    public static boolean exists(Config config, String string) throws SOExceptionConfig {
        block5: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, false)) {
                        return true;
                    }
                    break block5;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (directoryServiceException.errno != 207) {
                        throw new SOExceptionConfig(directoryServiceException);
                    }
                    break block5;
                }
            }
            throw new SOExceptionConfig(12);
        }
        return false;
    }

    public static void delete(Config config, String string) throws SOExceptionConfig {
        if (config.netConfigUsesLDAP()) {
            try {
                config.getDS().delete(config, string, false, true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new SOExceptionConfig(directoryServiceException);
            }
        } else {
            throw new SOExceptionConfig(12);
        }
    }

    public AddressListConfig() {
        super(new SchemaObjectConfigFactory());
    }

    public AddressListConfig(String string, String string2) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string2;
        try {
            this.initFromString(string);
        }
        catch (NLException nLException) {
            throw new SOExceptionConfig(9);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public AddressListConfig(NVPair nVPair, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        try {
            this.initFromNVPair(nVPair);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public AddressListConfig(Config config, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        this.initFromLDAP(config, this.name);
    }

    @Override
    public boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(boolean bl) {
        if (bl) {
            if (this.name != null && this.name.length() > 0) {
                this.shared = bl;
            }
        } else {
            this.shared = bl;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void initFromLDAP(Config config, String string) throws SOExceptionConfig {
        block11: {
            try {
                this.init();
                this.name = string;
                DirectoryService directoryService = config.getDS();
                Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                String string2 = ((String[])hashtable.get("dn"))[0];
                boolean bl = false;
                String[] stringArray = (String[])hashtable.get("objectclass");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("orclNetAddressList")) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new SOExceptionConfig(4);
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String[] stringArray2 = (String[])hashtable.get(string3);
                    if (string3.equalsIgnoreCase("orclNetAddrList")) {
                        SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                        int[] nArray = new int[]{1, 0};
                        this.children = schemaObjectConfigFactory.create(config, stringArray2, string2, nArray);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetShared")) {
                        this.shared = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclVersion")) {
                        this.version = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("description")) {
                        this.description = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetSourceRoute")) {
                        this.sourceRoute = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetLoadBalance")) {
                        this.loadBalance = stringArray2[0].equalsIgnoreCase("YES");
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("orclNetFailover")) continue;
                    this.failover = stringArray2[0].equalsIgnoreCase("YES");
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) break block11;
                throw new SOExceptionConfig(directoryServiceException);
            }
        }
    }

    @Override
    public void saveToLDAP(Config config, boolean bl) throws SOExceptionConfig {
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        if (this.name == null || this.children.size() == 0) {
            throw new SOExceptionConfig(2);
        }
        if (!bl && AddressListConfig.exists(config, this.name)) {
            throw new SOExceptionConfig(3);
        }
        try {
            Object[] objectArray;
            DirectoryService directoryService = config.getDS();
            SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
            String[] stringArray = new String[]{"orclNetAddressList"};
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            vector.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector.addElement(new NNFLUpdateParam("objectclass", stringArray));
            vector.addElement(new NNFLUpdateParam("orclVersion", this.version));
            if (this.description != null) {
                vector.addElement(new NNFLUpdateParam("description", this.description));
            }
            if (this.children.size() > 0) {
                objectArray = schemaObjectConfigFactory.getEndpointNames(this.children);
                vector.addElement(new NNFLUpdateParam("orclNetAddrList", (String[])objectArray));
            }
            vector.addElement(new NNFLUpdateParam("orclNetShared", this.shared ? "YES" : "NO"));
            if (this.sourceRoute) {
                vector.addElement(new NNFLUpdateParam("orclNetSourceRoute", "YES"));
            } else {
                vector.addElement(new NNFLUpdateParam("orclNetSourceRoute", "NO"));
            }
            if (!this.loadBalance) {
                vector.addElement(new NNFLUpdateParam("orclNetLoadBalance", "NO"));
            } else {
                vector.addElement(new NNFLUpdateParam("orclNetLoadBalance", "YES"));
            }
            if (!this.failover) {
                vector.addElement(new NNFLUpdateParam("orclNetFailover", "NO"));
            } else {
                vector.addElement(new NNFLUpdateParam("orclNetFailover", "YES"));
            }
            objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            String string = directoryService.update(config, this.name, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), this.shared);
            schemaObjectConfigFactory.save(config, this.children, string);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new SOExceptionConfig(directoryServiceException);
        }
    }

    @Override
    public void deleteFromLDAP(Config config) throws SOExceptionConfig {
        AddressListConfig.delete(config, this.name);
    }

    @Override
    public void addChild(SchemaObjectConfig schemaObjectConfig) {
        boolean bl = false;
        for (int i = 0; i < this.children.size() && !bl; ++i) {
            if (!this.children.elementAt(i).equals(schemaObjectConfig)) continue;
            bl = true;
        }
        if (!bl) {
            this.children.addElement(schemaObjectConfig);
        }
    }

    @Override
    public void delChild(SchemaObjectConfig schemaObjectConfig) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.elementAt(i).equals(schemaObjectConfig)) continue;
            this.children.removeElementAt(i);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !object.getClass().getName().endsWith("AddressListConfig")) {
            return false;
        }
        AddressListConfig addressListConfig = (AddressListConfig)object;
        if (this.children.size() != addressListConfig.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            boolean bl = false;
            for (int j = 0; j < this.children.size() && !bl; ++j) {
                if (!this.children.elementAt(i).equals(addressListConfig.children.elementAt(j))) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.description = null;
        this.version = "v0.0";
        this.shared = false;
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("orclVersion");
        vector.addElement("description");
        vector.addElement("orclNetAddrList");
        vector.addElement("orclNetShared");
        vector.addElement("orclNetSourceRoute");
        vector.addElement("orclNetLoadBalance");
        vector.addElement("orclNetFailover");
        return vector;
    }
}

