/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.TNSAddress.Address;
import oracle.net.TNSAddress.SOException;
import oracle.net.config.Config;
import oracle.net.config.DirectoryService;
import oracle.net.config.DirectoryServiceException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AddressConfig
extends Address
implements SchemaObjectConfig {
    public String name = null;
    public String description = null;
    public String version = "v0.0";
    private boolean shared = false;

    public static boolean exists(Config config, String string) throws SOExceptionConfig {
        block5: {
            if (config.netConfigUsesLDAP()) {
                try {
                    if (config.getDS().exists(config, string, false)) {
                        return true;
                    }
                    break block5;
                }
                catch (DirectoryServiceException directoryServiceException) {
                    if (directoryServiceException.errno != 207) {
                        throw new SOExceptionConfig(directoryServiceException);
                    }
                    break block5;
                }
            }
            throw new SOExceptionConfig(12);
        }
        return false;
    }

    public static void delete(Config config, String string) throws SOExceptionConfig {
        if (config.netConfigUsesLDAP()) {
            try {
                config.getDS().delete(config, string, false, true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                throw new SOExceptionConfig(directoryServiceException);
            }
        } else {
            throw new SOExceptionConfig(12);
        }
    }

    public AddressConfig() {
        super(new SchemaObjectConfigFactory());
    }

    public AddressConfig(String string, String string2) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string2;
        try {
            this.initFromString(string);
        }
        catch (NLException nLException) {
            throw new SOExceptionConfig(9);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public AddressConfig(NVPair nVPair, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        try {
            this.initFromNVPair(nVPair);
        }
        catch (SOException sOException) {
            throw new SOExceptionConfig(9);
        }
    }

    public AddressConfig(Config config, String string) throws SOExceptionConfig {
        super(new SchemaObjectConfigFactory());
        this.name = string;
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        this.initFromLDAP(config, this.name);
    }

    @Override
    public boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(boolean bl) {
        if (bl) {
            if (this.name != null && this.name.length() > 0) {
                this.shared = bl;
            }
        } else {
            this.shared = bl;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void initFromLDAP(Config config, String string) throws SOExceptionConfig {
        block9: {
            try {
                this.init();
                this.name = string;
                DirectoryService directoryService = config.getDS();
                Hashtable hashtable = directoryService.read(config, string, false, this.getSupportedAttributes());
                String string2 = ((String[])hashtable.get("dn"))[0];
                boolean bl = false;
                String[] stringArray = (String[])hashtable.get("objectclass");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("orclNetAddress")) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new SOExceptionConfig(4);
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String[] stringArray2 = (String[])hashtable.get(string3);
                    if (string3.equalsIgnoreCase("orclVersion")) {
                        this.version = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("description")) {
                        this.description = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetProtocol")) {
                        this.prot = stringArray2[0];
                        continue;
                    }
                    if (string3.equalsIgnoreCase("orclNetAddressString")) {
                        this.addr = stringArray2[0];
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("orclNetShared")) continue;
                    this.shared = stringArray2[0].equalsIgnoreCase("YES");
                }
            }
            catch (DirectoryServiceException directoryServiceException) {
                if (directoryServiceException.errno == 207) break block9;
                throw new SOExceptionConfig(directoryServiceException);
            }
        }
    }

    @Override
    public void saveToLDAP(Config config, boolean bl) throws SOExceptionConfig {
        if (!config.netConfigUsesLDAP()) {
            throw new SOExceptionConfig(12);
        }
        if (this.name == null) {
            throw new SOExceptionConfig(2);
        }
        if (!bl && AddressConfig.exists(config, this.name)) {
            throw new SOExceptionConfig(3);
        }
        try {
            DirectoryService directoryService = config.getDS();
            String[] stringArray = new String[]{"orclNetAddress"};
            Vector<NNFLUpdateParam> vector = new Vector<NNFLUpdateParam>();
            vector.addElement(new NNFLUpdateParam("cn", directoryService.getCN(this.name)));
            vector.addElement(new NNFLUpdateParam("objectclass", stringArray));
            vector.addElement(new NNFLUpdateParam("orclVersion", this.version));
            if (this.description != null) {
                vector.addElement(new NNFLUpdateParam("description", this.description));
            }
            vector.addElement(new NNFLUpdateParam("orclNetProtocol", this.prot));
            vector.addElement(new NNFLUpdateParam("orclNetAddressString", this.addr));
            vector.addElement(new NNFLUpdateParam("orclNetShared", this.shared ? "YES" : "NO"));
            Object[] objectArray = new NNFLUpdateParam[vector.size()];
            vector.copyInto(objectArray);
            directoryService.update(config, this.name, false, (NNFLUpdateParam[])objectArray, this.getSupportedAttributes(), this.shared);
        }
        catch (DirectoryServiceException directoryServiceException) {
            throw new SOExceptionConfig(directoryServiceException);
        }
    }

    @Override
    public void deleteFromLDAP(Config config) throws SOExceptionConfig {
        AddressConfig.delete(config, this.name);
    }

    public String getProtocolParam(String string) {
        try {
            NVFactory nVFactory = new NVFactory();
            NVPair nVPair = nVFactory.createNVPair(this.addr);
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, string);
            return nVPair2.getAtom();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (NLException nLException) {
            return null;
        }
    }

    @Override
    public void addChild(SchemaObjectConfig schemaObjectConfig) {
    }

    @Override
    public void delChild(SchemaObjectConfig schemaObjectConfig) {
    }

    @Override
    public boolean equals(Object object) {
        int n;
        if (object == null || !object.getClass().getName().endsWith("AddressConfig")) {
            return false;
        }
        AddressConfig addressConfig = (AddressConfig)object;
        String string = "";
        String string2 = "";
        for (n = 0; n < this.addr.length(); ++n) {
            string = string + this.addr.substring(n, n + 1).trim();
        }
        for (n = 0; n < addressConfig.addr.length(); ++n) {
            string2 = string2 + addressConfig.addr.substring(n, n + 1).trim();
        }
        return string.equalsIgnoreCase(string2);
    }

    @Override
    protected void init() {
        super.init();
        this.description = null;
        this.version = "v0.0";
        this.shared = false;
    }

    private Vector getSupportedAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("objectclass");
        vector.addElement("orclVersion");
        vector.addElement("description");
        vector.addElement("orclNetProtocol");
        vector.addElement("orclNetAddressString");
        vector.addElement("orclNetShared");
        return vector;
    }
}

