/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import oracle.net.common.addr.Address;
import oracle.net.common.netObject.DList;
import oracle.net.common.netObject.Description;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class NetService
extends NetObject {
    protected NVPair nvp;
    protected NVFactory nvfactory = new NVFactory();
    protected DList dList = null;

    public NetService(String string, String string2, Address address, boolean bl) throws NetObjectException {
        this("(" + string + "=" + "(DESCRIPTION=" + "(ADDRESS_LIST=" + address.toString() + ")" + "(CONNECT_DATA=(" + (bl ? "SID=" : "SERVICE_NAME=") + string2 + ")" + ")" + ")" + ")");
    }

    public NetService(String string, String string2) throws NetObjectException {
        this("(" + string + "=" + string2 + ")");
    }

    public NetService(String string) throws NetObjectException {
        try {
            this.nvp = this.nvfactory.createNVPair(string);
        }
        catch (NLException nLException) {
            throw new NetObjectException(nLException.getMessage());
        }
        if (this.nvp.getRHSType() != NVPair.RHS_LIST) {
            throw new NetObjectException("nvString is missing the DESCRIPTION or DESCRIPTION_LIST section.");
        }
        this.setName(this.nvp.getName());
        this.dList = new DList(this.nvp);
    }

    public boolean isSupported() {
        return this.dList.isSupported();
    }

    public Description getFirstDescription() {
        if (this.dList.getListSize() != 0) {
            try {
                return this.dList.getElementAt(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public DList getDescriptionList() {
        return this.dList;
    }

    public String toFormattedString() {
        String string = null;
        try {
            string = this.nvfactory.createNVPair(this.toDescriptionString()).toString(0, true);
        }
        catch (NLException nLException) {
            // empty catch block
        }
        return string;
    }

    public String toDescriptionString() {
        return this.dList.toNVString();
    }
}

