/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import oracle.net.common.netObject.AddressList;
import oracle.net.common.netObject.AttributeException;
import oracle.net.common.netObject.AttributeList;
import oracle.net.common.netObject.ConnectData;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.common.netObject.NoConnectDataException;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class Description {
    private AddressList addressList = null;
    private ConnectData connectData = null;
    private NVNavigator nvnavigator = new NVNavigator();
    private AttributeList attribList = new AttributeList();

    public Description(NVPair nVPair) throws NetObjectException {
        this.validatePair(nVPair);
        this.addressList = new AddressList(nVPair);
        this.connectData = new ConnectData(nVPair);
        try {
            NVPair nVPair2 = this.attribList.findPair(nVPair, "SDU");
            if (nVPair2 != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "TYPE_OF_SERVICE")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "TDU")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "HS")) != null) {
                this.attribList.addAttrib(nVPair2);
                this.attribList.setValue("HS", "OK");
            }
        }
        catch (AttributeException attributeException) {
            throw new NetObjectException("AddressList.<init>: Unable to create addressList." + attributeException);
        }
    }

    public boolean isBackCompat() {
        return true;
    }

    public boolean isSupported() {
        return this.addressList.isSupported() && this.connectData.isSupported();
    }

    public void setAddressList(AddressList addressList) {
        this.addressList = addressList;
    }

    public AddressList getAddressList() {
        return this.addressList;
    }

    public void setConnectData(ConnectData connectData) {
        this.connectData = connectData;
    }

    public ConnectData getConnectData() {
        return this.connectData;
    }

    public void setSDU(String string) throws AttributeException {
        if (this.attribList.contains("SDU")) {
            this.attribList.setValue("SDU", string);
        } else {
            this.attribList.addAttrib("SDU", string);
        }
    }

    public String getSDU() {
        try {
            return this.attribList.getValue("SDU");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setTDU(String string) throws AttributeException {
        if (this.attribList.contains("TDU")) {
            this.attribList.setValue("TDU", string);
        } else {
            this.attribList.addAttrib("TDU", string);
        }
    }

    public String getTDU() {
        try {
            return this.attribList.getValue("TDU");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setHService(String string) throws AttributeException {
        if (this.attribList.contains("HS")) {
            this.attribList.setValue("HS", string);
        } else {
            this.attribList.addAttrib("HS", string);
        }
    }

    public void removeHService() throws AttributeException {
        if (this.attribList.contains("HS")) {
            this.attribList.removeAttrib("HS");
        }
    }

    public String getHService() {
        try {
            return this.attribList.getValue("HS");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setTYPE_OF_SERVICE(String string) throws AttributeException {
        if (this.attribList.contains("TYPE_OF_SERVICE")) {
            this.attribList.setValue("TYPE_OF_SERVICE", string);
        } else {
            this.attribList.addAttrib("TYPE_OF_SERVICE", string);
        }
    }

    public String getTYPE_OF_SERVICE() {
        try {
            return this.attribList.getValue("TYPE_OF_SERVICE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public String toNVString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(DESCRIPTION=");
        try {
            if (this.attribList.contains("SDU")) {
                stringBuffer.append(this.attribList.toNVString("SDU"));
            }
            if (this.attribList.contains("TDU")) {
                stringBuffer.append(this.attribList.toNVString("TDU"));
            }
            if (this.attribList.contains("HS")) {
                stringBuffer.append(this.attribList.toNVString("HS"));
            }
            if (this.attribList.contains("TYPE_OF_SERVICE")) {
                stringBuffer.append(this.attribList.toNVString("TYPE_OF_SERVICE"));
            }
        }
        catch (AttributeException attributeException) {
            System.err.println(attributeException);
        }
        stringBuffer.append(this.addressList.toNVString());
        stringBuffer.append(this.connectData.toNVString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void validatePair(NVPair nVPair) throws NetObjectException {
        if (this.attribList.findPair(nVPair, "Address") == null && this.attribList.findPair(nVPair, "Address_List") == null) {
            throw new NetObjectException("Description.Description(): No Address information in Description");
        }
        if (this.attribList.findPair(nVPair, "Connect_Data") == null) {
            throw new NoConnectDataException("No Connect_Data information in Description");
        }
    }
}

