/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import java.util.Vector;
import oracle.net.common.netObject.Description;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class DList {
    private NVNavigator nvnavigator = new NVNavigator();
    private Vector descVector = new Vector(2, 2);

    public DList(NVPair nVPair) throws NetObjectException {
        this.validatePair(nVPair);
        NVPair nVPair2 = this.nvnavigator.findNVPair(nVPair, "Description_List");
        if (nVPair2 == null) {
            nVPair2 = nVPair;
        }
        boolean bl = false;
        int n = nVPair2.getListSize();
        for (int i = 0; i < n; ++i) {
            NVPair nVPair3 = nVPair2.getListElement(i);
            if (!nVPair3.getName().equalsIgnoreCase("DESCRIPTION")) continue;
            this.descVector.addElement(new Description(nVPair3));
            bl = true;
        }
        if (!bl) {
            throw new NetObjectException("DList.DList(): No DESCRIPTION in TNSAddress");
        }
    }

    public int getListSize() {
        return this.descVector.size();
    }

    public Description getElementAt(int n) throws IndexOutOfBoundsException {
        if (n >= this.getListSize() || n < 0) {
            throw new IndexOutOfBoundsException("DList.getElementAt: Invalid index.");
        }
        return (Description)this.descVector.elementAt(n);
    }

    public void removeListElement(Description description) {
        if (this.descVector.contains(description)) {
            this.descVector.removeElement(description);
        }
    }

    public void addListElement(Description description) {
        if (!this.descVector.contains(description)) {
            this.descVector.addElement(description);
        }
    }

    public boolean isSupported() {
        boolean bl = true;
        int n = this.descVector.size();
        if (n > 1) {
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (((Description)this.descVector.elementAt(i)).isSupported()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String toNVString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.descVector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((Description)this.descVector.elementAt(i)).toNVString());
        }
        if (this.getListSize() > 1) {
            stringBuffer.insert(0, "(DESCRIPTION_LIST=");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected void validatePair(NVPair nVPair) {
    }
}

