/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.net.common.netObject.AttributeException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AttributeList {
    private NVNavigator nvnavigator = new NVNavigator();
    private NVFactory nvfactory = new NVFactory();
    private Hashtable table;

    public AttributeList() {
        this.nvnavigator = new NVNavigator();
        this.table = new Hashtable(10, 0.75f);
    }

    public boolean contains(String string) {
        return this.table.containsKey(string.toUpperCase());
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return this.table.size();
    }

    public Enumeration enumerate() {
        return this.table.keys();
    }

    public void addAttrib(String string, String string2) throws AttributeException {
        if (string == null || string.equals("") || string2 == null) {
            throw new AttributeException("AttributeList.addAttrib: Null name or value");
        }
        try {
            this.table.put(string.toUpperCase(), string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addAttrib(NVPair nVPair) throws AttributeException {
        try {
            this.addAttrib(nVPair.getName().toUpperCase(), nVPair.getAtom());
        }
        catch (Exception exception) {
            throw new AttributeException("AttributeList.addAttrib(nvpair): invalid pair." + exception);
        }
    }

    public void removeAttrib(String string) {
        this.table.remove(string.toUpperCase());
    }

    public void removeAllAttribs() {
        this.table.clear();
    }

    public void setValue(String string, String string2) throws AttributeException {
        if (this.table.containsKey(string.toUpperCase())) {
            if (string.equals("SRVR")) {
                string = "SERVER";
            }
        } else {
            throw new AttributeException("AttributeList.setValue(): attrib not found.");
        }
        this.table.put(string.toUpperCase(), string2);
    }

    public String getValue(String string) throws AttributeException {
        Object v = this.table.get(string.toUpperCase());
        if (v == null) {
            throw new AttributeException("AttributeList.getValue(): attrib not found.");
        }
        if (v == null) {
            return null;
        }
        return (String)v;
    }

    public String toString() {
        return "AttributeList: " + this.table.toString();
    }

    public String toNVString(String string) throws AttributeException {
        return "(" + string.toUpperCase() + "=" + this.getValue(string) + ")";
    }

    public NVPair findPair(NVPair nVPair, String string) {
        try {
            return this.nvnavigator.findNVPair(nVPair, string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

