/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import java.util.Vector;
import oracle.net.common.addr.Address;
import oracle.net.common.addr.AddressFactory;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.common.netObject.AttributeException;
import oracle.net.common.netObject.AttributeList;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NVPair;

public final class AddressList {
    private Vector addrVector;
    private Vector addrListVector;
    private AddressFactory addressFactory;
    private NVPair originalNVP = null;
    private String nestLevel;
    private boolean dLevelSOURCE_ROUTE;
    private boolean backCompat;
    private int aCount = 0;
    private int aListCount = 0;
    private AttributeList attribList;

    public AddressList(NVPair nVPair) throws NetObjectException {
        this(nVPair, "TOP");
    }

    private AddressList(NVPair nVPair, String string) throws NetObjectException {
        try {
            int n;
            this.originalNVP = nVPair;
            this.nestLevel = string;
            this.attribList = new AttributeList();
            this.addrVector = new Vector(5, 5);
            this.addrListVector = new Vector(5, 5);
            this.addressFactory = AddressFactory.getFactory();
            this.validatePair(nVPair);
            NVPair nVPair2 = null;
            String string2 = null;
            if (string.equalsIgnoreCase("TOP")) {
                for (n = 0; n < nVPair.getListSize(); ++n) {
                    nVPair2 = nVPair.getListElement(n);
                    string2 = nVPair2.getName().toUpperCase();
                    if (string2.equals("ADDRESS")) {
                        ++this.aCount;
                        continue;
                    }
                    if (!string2.equals("ADDRESS_LIST")) continue;
                    ++this.aListCount;
                }
                if (this.aListCount == 1 && this.aCount == 0) {
                    this.dLevelSOURCE_ROUTE = this.attribList.findPair(nVPair, "SOURCE_ROUTE") != null;
                    if (this.attribList.findPair(nVPair = this.attribList.findPair(nVPair, "ADDRESS_LIST"), "SOURCE_ROUTE") != null) {
                        this.dLevelSOURCE_ROUTE = false;
                    }
                }
            }
            for (n = 0; n < nVPair.getListSize(); ++n) {
                nVPair2 = nVPair.getListElement(n);
                string2 = nVPair2.getName().toUpperCase();
                if (string2.equals("ADDRESS")) {
                    try {
                        this.addrVector.addElement(this.addressFactory.createAddress(nVPair2));
                        continue;
                    }
                    catch (CreateAddressException createAddressException) {
                        throw new NetObjectException(createAddressException);
                    }
                }
                if (!string2.equals("ADDRESS_LIST")) continue;
                this.addrListVector.addElement(new AddressList(nVPair2, "NESTED"));
            }
            NVPair nVPair3 = this.attribList.findPair(nVPair, "FAILOVER");
            if (nVPair3 != null) {
                this.attribList.addAttrib(nVPair3);
            }
            if ((nVPair3 = this.attribList.findPair(nVPair, "LOAD_BALANCE")) != null) {
                this.attribList.addAttrib(nVPair3);
            }
            if ((nVPair3 = this.dLevelSOURCE_ROUTE ? this.attribList.findPair(this.originalNVP, "SOURCE_ROUTE") : this.attribList.findPair(nVPair, "SOURCE_ROUTE")) != null) {
                this.attribList.addAttrib(nVPair3);
            }
            nVPair3 = null;
            this.backCompat = this.checkBackCompat();
        }
        catch (AttributeException attributeException) {
            throw new NetObjectException("AddressList.<init>: Unable to create addressList." + attributeException);
        }
    }

    public String toNVString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object var2_2 = null;
        Object var3_3 = null;
        if (this.isBackCompat()) {
            try {
                if (this.isSupported() && this.nestLevel.equals("TOP") && this.attribList.contains("SOURCE_ROUTE")) {
                    stringBuffer.append(this.attribList.toNVString("SOURCE_ROUTE"));
                }
                stringBuffer.append("(ADDRESS_LIST=");
                int n = this.addrVector.size();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(((Address)this.addrVector.elementAt(i)).toNVString());
                }
                stringBuffer.append(")");
            }
            catch (AttributeException attributeException) {
                System.err.println(attributeException);
            }
        } else {
            int n;
            stringBuffer.append("(ADDRESS_LIST=");
            try {
                if (this.attribList.contains("SOURCE_ROUTE")) {
                    stringBuffer.append(this.attribList.toNVString("SOURCE_ROUTE"));
                }
                if (this.attribList.contains("LOAD_BALANCE")) {
                    stringBuffer.append(this.attribList.toNVString("LOAD_BALANCE"));
                }
                if (this.attribList.contains("FAILOVER")) {
                    stringBuffer.append(this.attribList.toNVString("FAILOVER"));
                }
            }
            catch (AttributeException attributeException) {
                System.err.println(attributeException);
            }
            int n2 = this.addrVector.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(((Address)this.addrVector.elementAt(n)).toNVString());
            }
            n2 = this.addrListVector.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(((AddressList)this.addrListVector.elementAt(n)).toNVString());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isBackCompat() {
        return this.backCompat;
    }

    public void setBackCompat(boolean bl) {
        this.backCompat = bl;
        for (int i = this.addrListVector.size() - 1; i >= 0; --i) {
            ((AddressList)this.addrListVector.elementAt(i)).setBackCompat(bl);
        }
    }

    public void setSOURCE_ROUTE(String string) throws AttributeException {
        if (this.attribList.contains("SOURCE_ROUTE")) {
            this.attribList.setValue("SOURCE_ROUTE", string);
        } else {
            this.attribList.addAttrib("SOURCE_ROUTE", string);
        }
    }

    public String getSOURCE_ROUTE() {
        try {
            return this.attribList.getValue("SOURCE_ROUTE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setLOAD_BALANCE(String string) throws AttributeException {
        if (this.attribList.contains("LOAD_BALANCE")) {
            this.attribList.setValue("LOAD_BALANCE", string);
        } else {
            this.attribList.addAttrib("LOAD_BALANCE", string);
        }
    }

    public String getLOAD_BALANCE() {
        try {
            return this.attribList.getValue("LOAD_BALANCE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setFAILOVER(String string) throws AttributeException {
        if (this.attribList.contains("FAILOVER")) {
            this.attribList.setValue("FAILOVER", string);
        } else {
            this.attribList.addAttrib("FAILOVER", string);
        }
    }

    public String getFAILOVER() {
        try {
            return this.attribList.getValue("FAILOVER");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public boolean isSupported() {
        if (this.addrVector.size() > 0 && this.addrListVector.size() == 0) {
            return true;
        }
        if (this.addrListVector.size() == 1 && this.addrVector.size() == 0) {
            return ((AddressList)this.addrListVector.elementAt(0)).isSupported();
        }
        return false;
    }

    public int getNumAddresses() {
        return this.addrVector.size();
    }

    public int getNumAddressLists() {
        return this.addrListVector.size();
    }

    public Address getAddressAt(int n) {
        if (n > this.addrVector.size() - 1 || n < 0) {
            throw new IllegalArgumentException("AddressList.getAddressAt(): pos (" + n + ") is out of range.");
        }
        return (Address)this.addrVector.elementAt(n);
    }

    public AddressList getAddressListAt(int n) {
        if (n > this.addrListVector.size() - 1 || n < 0) {
            throw new IllegalArgumentException("AddressList.getAdddressAT(): pos (" + n + ") is out of range.");
        }
        return (AddressList)this.addrListVector.elementAt(n);
    }

    public void insertAddressListAt(AddressList addressList, int n) {
        if (addressList == null) {
            throw new IllegalArgumentException("AddressList.insertAddressListAt(): addrList to be added is null.");
        }
        this.addrListVector.insertElementAt(addressList, n);
    }

    public void insertAddressAt(Address address, int n) {
        if (address == null) {
            throw new IllegalArgumentException("AddressList.insertAddressAt(): addr to be added is null.");
        }
        this.addrVector.insertElementAt(address, n);
    }

    public void addAddressList(AddressList addressList) {
        if (addressList == null) {
            throw new IllegalArgumentException("AddressList.addAddressList(): addrList to be added is null.");
        }
        this.addrListVector.addElement(addressList);
    }

    public void addAddress(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("AddressList.addAddress(): addr to be added is null.");
        }
        this.addrVector.addElement(address);
    }

    public void removeAddress(Address address) {
        if (this.addrVector.contains(address)) {
            this.addrVector.removeElement(address);
        }
    }

    public void removeAddressList(AddressList addressList) {
        if (this.addrListVector.contains(addressList)) {
            this.addrListVector.removeElement(addressList);
        }
    }

    public void removeAddressAt(int n) {
        if (n > this.addrVector.size() - 1 || n < 0) {
            throw new IllegalArgumentException("AddressList.removeAddressAt(): pos (" + n + ") is out of range.");
        }
        this.addrVector.removeElementAt(n);
    }

    public void removeAddressListAt(int n) {
        if (n > this.addrListVector.size() - 1 || n < 0) {
            throw new IllegalArgumentException("AddressList.removeAddressListAt(): pos (" + n + ") is out of range.");
        }
        this.addrListVector.removeElementAt(n);
    }

    public void removeAllAddresses() {
        this.addrVector.removeAllElements();
    }

    public void removeAllAddressLists() {
        this.addrListVector.removeAllElements();
    }

    public void removeAllAttributes() {
        this.attribList.removeAllAttribs();
    }

    private boolean checkBackCompat() {
        if (!this.isSupported()) {
            return false;
        }
        if (this.attribList.contains("FAILOVER") || this.attribList.contains("LOAD_BALANCE")) {
            return false;
        }
        return this.dLevelSOURCE_ROUTE || !this.attribList.contains("SOURCE_ROUTE");
    }

    private void validatePair(NVPair nVPair) throws NetObjectException {
        if (this.attribList.findPair(nVPair, "ADDRESS") == null && this.attribList.findPair(nVPair, "ADDRESS_LIST") == null) {
            throw new NetObjectException("AddressList.validatePair(): No ADDRESS information found.");
        }
    }
}

