/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.help;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.Help;
import oracle.help.common.util.Canonicalizer;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.navigator.Navigator;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.net.common.help.HelpSystem;

public class KomodoHelp
implements HelpSystem {
    private Help help;
    private Book book;
    private boolean helpInitialized = false;
    private Frame callerFrame;
    private String title = "Help";
    private Point TOPIC_LOC = new Point(0, 0);
    private Dimension TOPIC_DIM = new Dimension(500, 500);

    public KomodoHelp(Frame frame, String string, String string2, Class clazz, String string3) throws InstantiationException {
        this.callerFrame = frame;
        this.title = string3;
        try {
            this.help = new Help(Class.forName("oracle.help.htmlBrowser.ICEBrowser"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstantiationException("Failed to initialize Help browser.");
        }
        HelpSet helpSet = this.createHelpSet(string, string2);
        if (helpSet != null) {
            this.book = helpSet;
            this.help.addBook((Book)helpSet);
            this.help.setDefaultBook((Book)helpSet);
        }
        this.helpInitialized = true;
    }

    private HelpSet createHelpSet(String string, String string2) {
        String string3 = string + File.separator + string2;
        File file = new File(string3);
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string3 = string3.charAt(0) == '/' ? "file:" + string3 : "file:/" + string3;
        string3 = Canonicalizer.fixSeparators((String)string3);
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(new URL(string3));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (HelpSetParseException helpSetParseException) {
            // empty catch block
        }
        return helpSet;
    }

    public KomodoHelp(Frame frame, String string, String string2, Class clazz, String string3, Dimension dimension, Point point) throws InstantiationException {
        this(frame, string, string2, clazz, string3);
        this.TOPIC_LOC = point;
        this.TOPIC_DIM = dimension;
    }

    @Override
    public void showTopic(String string) {
        if (this.helpInitialized) {
            this.callerFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.help.showTopic(this.book, string, false, this.TOPIC_LOC, this.TOPIC_DIM);
            }
            catch (TopicDisplayException topicDisplayException) {
                System.err.println(topicDisplayException.getMessage());
            }
            this.callerFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void showContents() {
        Navigator navigator = this.getNavigator("oracle.help.navigator.tocNavigator.TOCNavigator");
        if (this.helpInitialized) {
            this.help.showNavigatorWindow(navigator);
        }
    }

    @Override
    public void showIndex() {
        Navigator navigator = this.getNavigator("oracle.help.navigator.keywordNavigator.KeywordNavigator");
        if (this.helpInitialized) {
            this.help.showNavigatorWindow(navigator);
        }
    }

    @Override
    public void showSearch() {
        Navigator navigator = this.getNavigator("oracle.help.navigator.searchNavigator.SearchNavigator");
        if (this.helpInitialized) {
            this.help.showNavigatorWindow(navigator);
        }
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.TOPIC_DIM = dimension;
    }

    @Override
    public Dimension getSize() {
        return this.TOPIC_DIM;
    }

    @Override
    public void setLocation(Point point) {
        this.TOPIC_LOC = point;
    }

    @Override
    public Point getLocation() {
        return this.TOPIC_LOC;
    }

    private Navigator getNavigator(Object object) {
        Navigator[] navigatorArray = this.help.getAllNavigators();
        for (int i = 0; i < navigatorArray.length; ++i) {
            if (!navigatorArray[i].getType().equals(object)) continue;
            return navigatorArray[i];
        }
        return null;
    }
}

