/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.ServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.common.netObject.Service;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAliasException;

public class LDAPServiceHandler
extends ServiceHandler {
    private LDAPDataStore lds;

    LDAPServiceHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.lds = lDAPDataStore;
    }

    @Override
    public void save() throws DataStoreException {
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                for (int i = 0; i < n; ++i) {
                    oracle.net.config.Service.delete(this.lds.config, this.removeLog.elementAt(i).toString());
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while removing Service from LDAP" + this.lds, exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                oracle.net.config.Service service = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[2];
                nArray[0] = 2;
                nArray[1] = 3;
                int[] nArray2 = nArray;
                Service service2 = null;
                int n = this.changeLog.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.changeLog.elementAt(i).toString();
                    Object v = this.table.get(string);
                    if (!(v instanceof Service)) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + service2);
                    }
                    service2 = (Service)v;
                    service = new oracle.net.config.Service(this.lds.config, string);
                    vector.removeAllElements();
                    NetService netService = service2.getNetService();
                    if (netService != null) {
                        vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray2));
                    }
                    if (vector.size() == 0) {
                        service.remEndpoints();
                    } else {
                        service.setEndpoints(vector);
                    }
                    service.systemName = service2.getSystemName();
                    service.serviceType = service2.getServiceType();
                    service.oracleHome = service2.getOracleHome();
                    service.sid = service2.getSID();
                    service.save(this.lds.config, true);
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
            }
            catch (ServiceAliasException serviceAliasException) {
                throw new DataStoreException("error writing ServiceAlias to: " + this.lds, serviceAliasException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new DataStoreException("error saving to: " + this.lds, sOExceptionConfig);
            }
        }
    }

    @Override
    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = oracle.net.config.Service.enumServiceAliases(this.lds.config, null, true);
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.lds.config.getDS().getCN(stringArray[i], true);
                this.table.put(string, "NOT_LOADED");
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        String string2 = null;
        NetService netService = null;
        oracle.net.config.Service service = null;
        try {
            service = new oracle.net.config.Service(this.lds.config, string);
            string2 = service.toString();
            if (string2 != null) {
                netService = new NetService("(" + string + "=" + service.toString() + ")");
            }
            return new Service(string, service.systemName, service.serviceType, service.oracleHome, service.sid, netService);
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }
}

